/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common;

import java.io.IOException;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.Serializer;
import org.junit.Assert;
import org.junit.Test;

public class TopicPartitionTest {
    private String topicName = "mytopic";
    private String fileName = "serializedData/topicPartitionSerializedfile";
    private int partNum = 5;

    private void checkValues(TopicPartition deSerTP) {
        Assert.assertEquals((String)("partition number should be " + this.partNum + " but got " + deSerTP.partition()), (long)this.partNum, (long)deSerTP.partition());
        Assert.assertEquals((String)("topic should be " + this.topicName + " but got " + deSerTP.topic()), (Object)this.topicName, (Object)deSerTP.topic());
    }

    @Test
    public void testSerializationRoundtrip() throws IOException, ClassNotFoundException {
        TopicPartition origTp = new TopicPartition(this.topicName, this.partNum);
        byte[] byteArray = Serializer.serialize(origTp);
        Object deserializedObject = Serializer.deserialize(byteArray);
        Assert.assertTrue((boolean)(deserializedObject instanceof TopicPartition));
        this.checkValues((TopicPartition)deserializedObject);
    }

    @Test
    public void testTopiPartitionSerializationCompatibility() throws IOException, ClassNotFoundException {
        Object deserializedObject = Serializer.deserialize(this.fileName);
        Assert.assertTrue((boolean)(deserializedObject instanceof TopicPartition));
        this.checkValues((TopicPartition)deserializedObject);
    }
}

