/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.message;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.protocol.ApiMessage;
import org.apache.kafka.common.protocol.Message;
import org.apache.kafka.common.protocol.MessageUtil;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.protocol.Writable;
import org.apache.kafka.common.protocol.types.ArrayOf;
import org.apache.kafka.common.protocol.types.Field;
import org.apache.kafka.common.protocol.types.Schema;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.protocol.types.Type;

public class DeleteRecordsRequestData
implements ApiMessage {
    private List<DeleteRecordsTopic> topics = new ArrayList<DeleteRecordsTopic>();
    private int timeoutMs;
    public static final Schema SCHEMA_0;
    public static final Schema SCHEMA_1;
    public static final Schema[] SCHEMAS;

    public DeleteRecordsRequestData(Readable readable, short version) {
        this.read(readable, version);
    }

    public DeleteRecordsRequestData(Struct struct, short version) {
        this.fromStruct(struct, version);
    }

    public DeleteRecordsRequestData() {
        this.timeoutMs = 0;
    }

    public short apiKey() {
        return 21;
    }

    public short lowestSupportedVersion() {
        return 0;
    }

    public short highestSupportedVersion() {
        return 1;
    }

    public void read(Readable readable, short version) {
        int arrayLength = readable.readInt();
        if (arrayLength < 0) {
            this.topics = null;
        } else {
            this.topics.clear();
            for (int i = 0; i < arrayLength; ++i) {
                this.topics.add(new DeleteRecordsTopic(readable, version));
            }
        }
        this.timeoutMs = readable.readInt();
    }

    public void write(Writable writable, short version) {
        writable.writeInt(this.topics.size());
        for (DeleteRecordsTopic element : this.topics) {
            element.write(writable, version);
        }
        writable.writeInt(this.timeoutMs);
    }

    public void fromStruct(Struct struct, short version) {
        Object[] nestedObjects = struct.getArray("topics");
        this.topics = new ArrayList<DeleteRecordsTopic>(nestedObjects.length);
        for (Object nestedObject : nestedObjects) {
            this.topics.add(new DeleteRecordsTopic((Struct)nestedObject, version));
        }
        this.timeoutMs = struct.getInt("timeout_ms");
    }

    public Struct toStruct(short version) {
        Struct struct = new Struct(SCHEMAS[version]);
        Struct[] nestedObjects = new Struct[this.topics.size()];
        int i = 0;
        for (DeleteRecordsTopic element : this.topics) {
            nestedObjects[i++] = element.toStruct(version);
        }
        struct.set("topics", (Object)nestedObjects);
        struct.set("timeout_ms", (Object)this.timeoutMs);
        return struct;
    }

    public int size(short version) {
        int size = 0;
        size += 4;
        for (DeleteRecordsTopic element : this.topics) {
            size += element.size(version);
        }
        return size += 4;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DeleteRecordsRequestData)) {
            return false;
        }
        DeleteRecordsRequestData other = (DeleteRecordsRequestData)obj;
        if (this.topics == null ? other.topics != null : !this.topics.equals(other.topics)) {
            return false;
        }
        return this.timeoutMs == other.timeoutMs;
    }

    public int hashCode() {
        int hashCode = 0;
        hashCode = 31 * hashCode + (this.topics == null ? 0 : this.topics.hashCode());
        hashCode = 31 * hashCode + this.timeoutMs;
        return hashCode;
    }

    public String toString() {
        return "DeleteRecordsRequestData(topics=" + MessageUtil.deepToString(this.topics.iterator()) + ", timeoutMs=" + this.timeoutMs + ")";
    }

    public List<DeleteRecordsTopic> topics() {
        return this.topics;
    }

    public int timeoutMs() {
        return this.timeoutMs;
    }

    public DeleteRecordsRequestData setTopics(List<DeleteRecordsTopic> v) {
        this.topics = v;
        return this;
    }

    public DeleteRecordsRequestData setTimeoutMs(int v) {
        this.timeoutMs = v;
        return this;
    }

    static {
        SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("topics", (Type)new ArrayOf((Type)DeleteRecordsTopic.SCHEMA_0), "Each topic that we want to delete records from."), new Field("timeout_ms", (Type)Type.INT32, "How long to wait for the deletion to complete, in milliseconds.")});
        SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
    }

    public static class DeleteRecordsPartition
    implements Message {
        private int partitionIndex;
        private long offset;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public DeleteRecordsPartition(Readable readable, short version) {
            this.read(readable, version);
        }

        public DeleteRecordsPartition(Struct struct, short version) {
            this.fromStruct(struct, version);
        }

        public DeleteRecordsPartition() {
            this.partitionIndex = 0;
            this.offset = 0L;
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 1;
        }

        public void read(Readable readable, short version) {
            this.partitionIndex = readable.readInt();
            this.offset = readable.readLong();
        }

        public void write(Writable writable, short version) {
            writable.writeInt(this.partitionIndex);
            writable.writeLong(this.offset);
        }

        public void fromStruct(Struct struct, short version) {
            this.partitionIndex = struct.getInt("partition_index");
            this.offset = struct.getLong("offset");
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("partition_index", (Object)this.partitionIndex);
            struct.set("offset", (Object)this.offset);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            size += 4;
            return size += 8;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeleteRecordsPartition)) {
                return false;
            }
            DeleteRecordsPartition other = (DeleteRecordsPartition)obj;
            if (this.partitionIndex != other.partitionIndex) {
                return false;
            }
            return this.offset == other.offset;
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + this.partitionIndex;
            hashCode = 31 * hashCode + ((int)(this.offset >> 32) ^ (int)this.offset);
            return hashCode;
        }

        public String toString() {
            return "DeleteRecordsPartition(partitionIndex=" + this.partitionIndex + ", offset=" + this.offset + ")";
        }

        public int partitionIndex() {
            return this.partitionIndex;
        }

        public long offset() {
            return this.offset;
        }

        public DeleteRecordsPartition setPartitionIndex(int v) {
            this.partitionIndex = v;
            return this;
        }

        public DeleteRecordsPartition setOffset(long v) {
            this.offset = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("partition_index", (Type)Type.INT32, "The partition index."), new Field("offset", (Type)Type.INT64, "The deletion offset.")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }

    public static class DeleteRecordsTopic
    implements Message {
        private String name;
        private List<DeleteRecordsPartition> partitions;
        public static final Schema SCHEMA_0;
        public static final Schema SCHEMA_1;
        public static final Schema[] SCHEMAS;

        public DeleteRecordsTopic(Readable readable, short version) {
            this.partitions = new ArrayList<DeleteRecordsPartition>();
            this.read(readable, version);
        }

        public DeleteRecordsTopic(Struct struct, short version) {
            this.partitions = new ArrayList<DeleteRecordsPartition>();
            this.fromStruct(struct, version);
        }

        public DeleteRecordsTopic() {
            this.name = "";
            this.partitions = new ArrayList<DeleteRecordsPartition>();
        }

        public short lowestSupportedVersion() {
            return 0;
        }

        public short highestSupportedVersion() {
            return 1;
        }

        public void read(Readable readable, short version) {
            this.name = readable.readNullableString();
            int arrayLength = readable.readInt();
            if (arrayLength < 0) {
                this.partitions = null;
            } else {
                this.partitions.clear();
                for (int i = 0; i < arrayLength; ++i) {
                    this.partitions.add(new DeleteRecordsPartition(readable, version));
                }
            }
        }

        public void write(Writable writable, short version) {
            writable.writeString(this.name);
            writable.writeInt(this.partitions.size());
            for (DeleteRecordsPartition element : this.partitions) {
                element.write(writable, version);
            }
        }

        public void fromStruct(Struct struct, short version) {
            this.name = struct.getString("name");
            Object[] nestedObjects = struct.getArray("partitions");
            this.partitions = new ArrayList<DeleteRecordsPartition>(nestedObjects.length);
            for (Object nestedObject : nestedObjects) {
                this.partitions.add(new DeleteRecordsPartition((Struct)nestedObject, version));
            }
        }

        public Struct toStruct(short version) {
            Struct struct = new Struct(SCHEMAS[version]);
            struct.set("name", (Object)this.name);
            Struct[] nestedObjects = new Struct[this.partitions.size()];
            int i = 0;
            for (DeleteRecordsPartition element : this.partitions) {
                nestedObjects[i++] = element.toStruct(version);
            }
            struct.set("partitions", (Object)nestedObjects);
            return struct;
        }

        public int size(short version) {
            int size = 0;
            size += 2;
            size += MessageUtil.serializedUtf8Length((CharSequence)this.name);
            size += 4;
            for (DeleteRecordsPartition element : this.partitions) {
                size += element.size(version);
            }
            return size;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DeleteRecordsTopic)) {
                return false;
            }
            DeleteRecordsTopic other = (DeleteRecordsTopic)obj;
            if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
                return false;
            }
            return !(this.partitions == null ? other.partitions != null : !this.partitions.equals(other.partitions));
        }

        public int hashCode() {
            int hashCode = 0;
            hashCode = 31 * hashCode + (this.name == null ? 0 : this.name.hashCode());
            hashCode = 31 * hashCode + (this.partitions == null ? 0 : this.partitions.hashCode());
            return hashCode;
        }

        public String toString() {
            return "DeleteRecordsTopic(name='" + this.name + "', partitions=" + MessageUtil.deepToString(this.partitions.iterator()) + ")";
        }

        public String name() {
            return this.name;
        }

        public List<DeleteRecordsPartition> partitions() {
            return this.partitions;
        }

        public DeleteRecordsTopic setName(String v) {
            this.name = v;
            return this;
        }

        public DeleteRecordsTopic setPartitions(List<DeleteRecordsPartition> v) {
            this.partitions = v;
            return this;
        }

        static {
            SCHEMA_1 = SCHEMA_0 = new Schema(new Field[]{new Field("name", (Type)Type.STRING, "The topic name."), new Field("partitions", (Type)new ArrayOf((Type)DeleteRecordsPartition.SCHEMA_0), "Each partition that we want to delete records from.")});
            SCHEMAS = new Schema[]{SCHEMA_0, SCHEMA_1};
        }
    }
}

