/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.message.LeaderAndIsrRequestData;
import org.apache.kafka.common.message.LeaderAndIsrResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.LeaderAndIsrResponse;
import org.junit.Assert;
import org.junit.Test;

public class LeaderAndIsrResponseTest {
    @Test
    public void testErrorCountsFromGetErrorResponse() {
        ArrayList<LeaderAndIsrRequestData.LeaderAndIsrPartitionState> partitionStates = new ArrayList<LeaderAndIsrRequestData.LeaderAndIsrPartitionState>();
        partitionStates.add(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("foo").setPartitionIndex(0).setControllerEpoch(15).setLeader(1).setLeaderEpoch(10).setIsr(Collections.singletonList(10)).setZkVersion(20).setReplicas(Collections.singletonList(10)).setIsNew(false));
        partitionStates.add(new LeaderAndIsrRequestData.LeaderAndIsrPartitionState().setTopicName("foo").setPartitionIndex(1).setControllerEpoch(15).setLeader(1).setLeaderEpoch(10).setIsr(Collections.singletonList(10)).setZkVersion(20).setReplicas(Collections.singletonList(10)).setIsNew(false));
        LeaderAndIsrRequest request = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 15, 20, 0L, partitionStates, Collections.emptySet()).build();
        LeaderAndIsrResponse response = request.getErrorResponse(0, (Throwable)Errors.CLUSTER_AUTHORIZATION_FAILED.exception());
        Assert.assertEquals(Collections.singletonMap(Errors.CLUSTER_AUTHORIZATION_FAILED, 2), (Object)response.errorCounts());
    }

    @Test
    public void testErrorCountsWithTopLevelError() {
        List<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> partitions = this.createPartitions("foo", Arrays.asList(Errors.NONE, Errors.NOT_LEADER_OR_FOLLOWER));
        LeaderAndIsrResponse response = new LeaderAndIsrResponse(new LeaderAndIsrResponseData().setErrorCode(Errors.UNKNOWN_SERVER_ERROR.code()).setPartitionErrors(partitions));
        Assert.assertEquals(Collections.singletonMap(Errors.UNKNOWN_SERVER_ERROR, 2), (Object)response.errorCounts());
    }

    @Test
    public void testErrorCountsNoTopLevelError() {
        List<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> partitions = this.createPartitions("foo", Arrays.asList(Errors.NONE, Errors.CLUSTER_AUTHORIZATION_FAILED));
        LeaderAndIsrResponse response = new LeaderAndIsrResponse(new LeaderAndIsrResponseData().setErrorCode(Errors.NONE.code()).setPartitionErrors(partitions));
        Map errorCounts = response.errorCounts();
        Assert.assertEquals((long)2L, (long)errorCounts.size());
        Assert.assertEquals((long)1L, (long)((Integer)errorCounts.get(Errors.NONE)).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)errorCounts.get(Errors.CLUSTER_AUTHORIZATION_FAILED)).intValue());
    }

    @Test
    public void testToString() {
        List<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> partitions = this.createPartitions("foo", Arrays.asList(Errors.NONE, Errors.CLUSTER_AUTHORIZATION_FAILED));
        LeaderAndIsrResponse response = new LeaderAndIsrResponse(new LeaderAndIsrResponseData().setErrorCode(Errors.NONE.code()).setPartitionErrors(partitions));
        String responseStr = response.toString();
        Assert.assertTrue((boolean)responseStr.contains(LeaderAndIsrResponse.class.getSimpleName()));
        Assert.assertTrue((boolean)responseStr.contains(partitions.toString()));
        Assert.assertTrue((boolean)responseStr.contains("errorCode=" + Errors.NONE.code()));
    }

    private List<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> createPartitions(String topicName, List<Errors> errors) {
        ArrayList<LeaderAndIsrResponseData.LeaderAndIsrPartitionError> partitions = new ArrayList<LeaderAndIsrResponseData.LeaderAndIsrPartitionError>();
        int partitionIndex = 0;
        for (Errors error : errors) {
            partitions.add(new LeaderAndIsrResponseData.LeaderAndIsrPartitionError().setTopicName(topicName).setPartitionIndex(partitionIndex++).setErrorCode(error.code()));
        }
        return partitions;
    }
}

