/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.streams.kstream.internals.Change;
import org.apache.kafka.streams.kstream.internals.WrappingNullableDeserializer;

public class ChangedDeserializer<T>
implements Deserializer<Change<T>>,
WrappingNullableDeserializer<Change<T>, T> {
    private static final int NEWFLAG_SIZE = 1;
    private Deserializer<T> inner;

    public ChangedDeserializer(Deserializer<T> inner) {
        this.inner = inner;
    }

    public Deserializer<T> inner() {
        return this.inner;
    }

    @Override
    public void setIfUnset(Deserializer<T> defaultDeserializer) {
        if (this.inner == null) {
            this.inner = Objects.requireNonNull(defaultDeserializer, "defaultDeserializer cannot be null");
        }
    }

    public Change<T> deserialize(String topic, Headers headers, byte[] data) {
        byte[] bytes = new byte[data.length - 1];
        System.arraycopy(data, 0, bytes, 0, bytes.length);
        if (ByteBuffer.wrap(data).get(data.length - 1) != 0) {
            return new Change<Object>(this.inner.deserialize(topic, headers, bytes), null);
        }
        return new Change<Object>(null, this.inner.deserialize(topic, headers, bytes));
    }

    public Change<T> deserialize(String topic, byte[] data) {
        return this.deserialize(topic, null, data);
    }

    public void close() {
        this.inner.close();
    }
}

