/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.common.internals.Topic;

public abstract class InternalTopicConfig {
    final String name;
    final Map<String, String> topicConfigs;
    private Optional<Integer> numberOfPartitions = Optional.empty();

    InternalTopicConfig(String name, Map<String, String> topicConfigs) {
        Objects.requireNonNull(name, "name can't be null");
        Topic.validate((String)name);
        this.name = name;
        this.topicConfigs = topicConfigs;
    }

    public abstract Map<String, String> getProperties(Map<String, String> var1, long var2);

    public String name() {
        return this.name;
    }

    public Optional<Integer> numberOfPartitions() {
        return this.numberOfPartitions;
    }

    public void setNumberOfPartitions(int numberOfPartitions) {
        if (numberOfPartitions < 1) {
            throw new IllegalArgumentException("Number of partitions must be at least 1.");
        }
        this.numberOfPartitions = Optional.of(numberOfPartitions);
    }

    public String toString() {
        return "InternalTopicConfig(name=" + this.name + ", topicConfigs=" + this.topicConfigs + ")";
    }
}

