/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.IOException;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.InvalidOffsetException;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.errors.LockException;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.StateRestoreListener;
import org.apache.kafka.streams.processor.internals.GlobalProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.GlobalStateMaintainer;
import org.apache.kafka.streams.processor.internals.GlobalStateManagerImpl;
import org.apache.kafka.streams.processor.internals.GlobalStateUpdateTask;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StreamThread;
import org.apache.kafka.streams.processor.internals.ThreadStateTransitionValidator;
import org.apache.kafka.streams.processor.internals.metrics.StreamsMetricsImpl;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.slf4j.Logger;

public class GlobalStreamThread
extends Thread {
    private final Logger log;
    private final LogContext logContext;
    private final StreamsConfig config;
    private final Consumer<byte[], byte[]> globalConsumer;
    private final StateDirectory stateDirectory;
    private final Time time;
    private final ThreadCache cache;
    private final StreamsMetricsImpl streamsMetrics;
    private final ProcessorTopology topology;
    private volatile StreamsException startupException;
    private volatile State state = State.CREATED;
    private final Object stateLock = new Object();
    private StreamThread.StateListener stateListener = null;
    private final String logPrefix;
    private final StateRestoreListener stateRestoreListener;

    public void setStateListener(StreamThread.StateListener listener) {
        this.stateListener = listener;
    }

    public State state() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(State newState) {
        State oldState = this.state;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.PENDING_SHUTDOWN && newState == State.PENDING_SHUTDOWN) {
                return;
            }
            if (this.state == State.DEAD) {
                return;
            }
            if (!this.state.isValidTransition(newState)) {
                this.log.error("Unexpected state transition from {} to {}", (Object)oldState, (Object)newState);
                throw new StreamsException(this.logPrefix + "Unexpected state transition from " + oldState + " to " + newState);
            }
            this.log.info("State transition from {} to {}", (Object)oldState, (Object)newState);
            this.state = newState;
        }
        if (this.stateListener != null) {
            this.stateListener.onChange(this, this.state, oldState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stillRunning() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state.isRunning();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inErrorState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state.inErrorState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stillInitializing() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state.equals(State.CREATED);
        }
    }

    public GlobalStreamThread(ProcessorTopology topology, StreamsConfig config, Consumer<byte[], byte[]> globalConsumer, StateDirectory stateDirectory, long cacheSizeBytes, StreamsMetricsImpl streamsMetrics, Time time, String threadClientId, StateRestoreListener stateRestoreListener) {
        super(threadClientId);
        this.time = time;
        this.config = config;
        this.topology = topology;
        this.globalConsumer = globalConsumer;
        this.stateDirectory = stateDirectory;
        this.streamsMetrics = streamsMetrics;
        this.logPrefix = String.format("global-stream-thread [%s] ", threadClientId);
        this.logContext = new LogContext(this.logPrefix);
        this.log = this.logContext.logger(this.getClass());
        this.cache = new ThreadCache(this.logContext, cacheSizeBytes, this.streamsMetrics);
        this.stateRestoreListener = stateRestoreListener;
    }

    @Override
    public void run() {
        StateConsumer stateConsumer = this.initialize();
        if (stateConsumer == null) {
            this.setState(State.PENDING_SHUTDOWN);
            this.setState(State.DEAD);
            this.log.warn("Error happened during initialization of the global state store; this thread has shutdown");
            this.streamsMetrics.removeAllThreadLevelSensors(this.getName());
            return;
        }
        this.setState(State.RUNNING);
        boolean wipeStateStore = false;
        try {
            while (this.stillRunning()) {
                stateConsumer.pollAndUpdate();
            }
        }
        catch (InvalidOffsetException recoverableException) {
            wipeStateStore = true;
            this.log.error("Updating global state failed due to inconsistent local state. Will attempt to clean up the local state. You can restart KafkaStreams to recover from this error.", (Throwable)recoverableException);
            throw new StreamsException("Updating global state failed. You can restart KafkaStreams to recover from this error.", recoverableException);
        }
        finally {
            this.setState(State.PENDING_SHUTDOWN);
            this.log.info("Shutting down");
            try {
                stateConsumer.close(wipeStateStore);
            }
            catch (IOException e) {
                this.log.error("Failed to close state maintainer due to the following error:", (Throwable)e);
            }
            this.streamsMetrics.removeAllThreadLevelSensors(this.getName());
            this.setState(State.DEAD);
            this.log.info("Shutdown complete");
        }
    }

    private StateConsumer initialize() {
        try {
            GlobalStateManagerImpl stateMgr = new GlobalStateManagerImpl(this.logContext, this.time, this.topology, this.globalConsumer, this.stateDirectory, this.stateRestoreListener, this.config);
            GlobalProcessorContextImpl globalProcessorContext = new GlobalProcessorContextImpl(this.config, stateMgr, this.streamsMetrics, this.cache);
            stateMgr.setGlobalProcessorContext(globalProcessorContext);
            StateConsumer stateConsumer = new StateConsumer(this.logContext, this.globalConsumer, new GlobalStateUpdateTask(this.logContext, this.topology, globalProcessorContext, stateMgr, this.config.defaultDeserializationExceptionHandler()), this.time, Duration.ofMillis(this.config.getLong("poll.ms")), this.config.getLong("commit.interval.ms"));
            try {
                stateConsumer.initialize();
            }
            catch (InvalidOffsetException recoverableException) {
                this.log.error("Bootstrapping global state failed due to inconsistent local state. Will attempt to clean up the local state. You can restart KafkaStreams to recover from this error.", (Throwable)recoverableException);
                try {
                    stateConsumer.close(true);
                }
                catch (IOException e) {
                    this.log.error("Failed to close state consumer due to the following error:", (Throwable)e);
                }
                throw new StreamsException("Bootstrapping global state failed. You can restart KafkaStreams to recover from this error.", recoverableException);
            }
            return stateConsumer;
        }
        catch (LockException fatalException) {
            String errorMsg = "Could not lock global state directory. This could happen if multiple KafkaStreams instances are running on the same host using the same state directory.";
            this.log.error("Could not lock global state directory. This could happen if multiple KafkaStreams instances are running on the same host using the same state directory.", (Throwable)((Object)fatalException));
            this.startupException = new StreamsException("Could not lock global state directory. This could happen if multiple KafkaStreams instances are running on the same host using the same state directory.", (Throwable)((Object)fatalException));
        }
        catch (StreamsException fatalException) {
            this.startupException = fatalException;
        }
        catch (Exception fatalException) {
            this.startupException = new StreamsException("Exception caught during initialization of GlobalStreamThread", fatalException);
        }
        return null;
    }

    @Override
    public synchronized void start() {
        super.start();
        while (this.stillInitializing()) {
            Utils.sleep((long)1L);
            if (this.startupException == null) continue;
            throw this.startupException;
        }
        if (this.inErrorState()) {
            throw new IllegalStateException("Initialization for the global stream thread failed");
        }
    }

    public void shutdown() {
        this.setState(State.PENDING_SHUTDOWN);
    }

    public Map<MetricName, Metric> consumerMetrics() {
        return Collections.unmodifiableMap(this.globalConsumer.metrics());
    }

    static class StateConsumer {
        private final Consumer<byte[], byte[]> globalConsumer;
        private final GlobalStateMaintainer stateMaintainer;
        private final Time time;
        private final Duration pollTime;
        private final long flushInterval;
        private final Logger log;
        private long lastFlush;

        StateConsumer(LogContext logContext, Consumer<byte[], byte[]> globalConsumer, GlobalStateMaintainer stateMaintainer, Time time, Duration pollTime, long flushInterval) {
            this.log = logContext.logger(this.getClass());
            this.globalConsumer = globalConsumer;
            this.stateMaintainer = stateMaintainer;
            this.time = time;
            this.pollTime = pollTime;
            this.flushInterval = flushInterval;
        }

        void initialize() {
            Map<TopicPartition, Long> partitionOffsets = this.stateMaintainer.initialize();
            this.globalConsumer.assign(partitionOffsets.keySet());
            for (Map.Entry<TopicPartition, Long> entry : partitionOffsets.entrySet()) {
                this.globalConsumer.seek(entry.getKey(), entry.getValue().longValue());
            }
            this.lastFlush = this.time.milliseconds();
        }

        void pollAndUpdate() {
            ConsumerRecords received = this.globalConsumer.poll(this.pollTime);
            for (ConsumerRecord record : received) {
                this.stateMaintainer.update((ConsumerRecord<byte[], byte[]>)record);
            }
            long now = this.time.milliseconds();
            if (now >= this.lastFlush + this.flushInterval) {
                this.stateMaintainer.flushState();
                this.lastFlush = now;
            }
        }

        public void close(boolean wipeStateStore) throws IOException {
            try {
                this.globalConsumer.close();
            }
            catch (RuntimeException e) {
                this.log.error("Failed to close global consumer due to the following error:", (Throwable)e);
            }
            this.stateMaintainer.close(wipeStateStore);
        }
    }

    public static enum State implements ThreadStateTransitionValidator
    {
        CREATED(1, 2),
        RUNNING(2),
        PENDING_SHUTDOWN(3),
        DEAD(new Integer[0]);

        private final Set<Integer> validTransitions = new HashSet<Integer>();

        private State(Integer ... validTransitions) {
            this.validTransitions.addAll(Arrays.asList(validTransitions));
        }

        public boolean isRunning() {
            return this.equals(RUNNING);
        }

        public boolean inErrorState() {
            return this.equals(DEAD) || this.equals(PENDING_SHUTDOWN);
        }

        @Override
        public boolean isValidTransition(ThreadStateTransitionValidator newState) {
            State tmpState = (State)newState;
            return this.validTransitions.contains(tmpState.ordinal());
        }
    }
}

