/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import kafka.admin.AdminUtils$;
import kafka.admin.ReplicationQuotaUtils$;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.server.DynamicConfig;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class ReplicationQuotaUtils$ {
    public static final ReplicationQuotaUtils$ MODULE$;

    static {
        new ReplicationQuotaUtils$();
    }

    public boolean checkThrottleConfigRemovedFromZK(String topic, Seq<KafkaServer> servers) {
        return TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(topic, servers){
            public static final long serialVersionUID = 0L;
            private final String topic$2;
            private final Seq servers$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                boolean hasRateProp = this.servers$2.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(KafkaServer server) {
                        Properties brokerConfig = AdminUtils$.MODULE$.fetchEntityConfig(server.zkUtils(), ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)server.config().brokerId())).toString());
                        return brokerConfig.contains(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp()) || brokerConfig.contains(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp());
                    }
                });
                Properties topicConfig = AdminUtils$.MODULE$.fetchEntityConfig(((KafkaServer)this.servers$2.apply(0)).zkUtils(), ConfigType$.MODULE$.Topic(), this.topic$2);
                boolean hasReplicasProp = topicConfig.contains(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp()) || topicConfig.contains(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp());
                return !hasRateProp && !hasReplicasProp;
            }
            {
                this.topic$2 = topic$2;
                this.servers$2 = servers$2;
            }
        }, "Throttle limit/replicas was not unset", TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    public boolean checkThrottleConfigAddedToZK(long expectedThrottleRate, Seq<KafkaServer> servers, String topic, String throttledLeaders, String throttledFollowers) {
        return TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(expectedThrottleRate, servers, topic, throttledLeaders, throttledFollowers){
            public static final long serialVersionUID = 0L;
            public final long expectedThrottleRate$1;
            private final Seq servers$1;
            private final String topic$1;
            private final String throttledLeaders$1;
            private final String throttledFollowers$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            /*
             * Unable to fully structure code
             */
            public boolean apply$mcZ$sp() {
                brokerConfigAvailable = this.servers$1.forall((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.checkThrottleConfigAddedToZK.1 $outer;

                    public final boolean apply(KafkaServer server) {
                        Properties configInZk = AdminUtils$.MODULE$.fetchEntityConfig(server.zkUtils(), ConfigType$.MODULE$.Broker(), ((Object)BoxesRunTime.boxToInteger((int)server.config().brokerId())).toString());
                        String zkLeaderRate = configInZk.getProperty(DynamicConfig.Broker$.MODULE$.LeaderReplicationThrottledRateProp());
                        String zkFollowerRate = configInZk.getProperty(DynamicConfig.Broker$.MODULE$.FollowerReplicationThrottledRateProp());
                        return zkLeaderRate != null && this.$outer.expectedThrottleRate$1 == new StringOps(Predef$.MODULE$.augmentString(zkLeaderRate)).toLong() && zkFollowerRate != null && this.$outer.expectedThrottleRate$1 == new StringOps(Predef$.MODULE$.augmentString(zkFollowerRate)).toLong();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                topicConfig = AdminUtils$.MODULE$.fetchEntityConfig(((KafkaServer)this.servers$1.apply(0)).zkUtils(), ConfigType$.MODULE$.Topic(), this.topic$1);
                leader = topicConfig.getProperty(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp());
                follower = topicConfig.getProperty(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp());
                v0 = leader;
                var6_5 = this.throttledLeaders$1;
                if (v0 != null ? v0.equals(var6_5) == false : var6_5 != null) ** GOTO lbl-1000
                v1 = follower;
                var7_6 = this.throttledFollowers$1;
                if (!(v1 != null ? v1.equals(var7_6) == false : var7_6 != null)) {
                    v2 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
                topicConfigAvailable = v2;
                return brokerConfigAvailable != false && topicConfigAvailable != false;
            }
            {
                this.expectedThrottleRate$1 = expectedThrottleRate$1;
                this.servers$1 = servers$1;
                this.topic$1 = topic$1;
                this.throttledLeaders$1 = throttledLeaders$1;
                this.throttledFollowers$1 = throttledFollowers$1;
            }
        }, "throttle limit/replicas was not set", TestUtils$.MODULE$.waitUntilTrue$default$3());
    }

    private ReplicationQuotaUtils$() {
        MODULE$ = this;
    }
}

