/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.File;
import java.util.Collection;
import java.util.Properties;
import kafka.api.IntegrationTestHarness;
import kafka.api.IntegrationTestHarness$class;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.server.DynamicConfig;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.QuotaFactory;
import kafka.server.QuotaId;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.internals.ErrorLoggingCallback;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.JavaConversions$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Eg!B\u0001\u0003\u0003\u00039!!\u0004\"bg\u0016\fVo\u001c;b)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019\u0011\r]5\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0011I\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007CA\n\u0015\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005YIe\u000e^3he\u0006$\u0018n\u001c8UKN$\b*\u0019:oKN\u001c\b\"B\f\u0001\t\u0003A\u0012A\u0002\u001fj]&$h\bF\u0001\u001a!\t\u0019\u0002\u0001C\u0003\u001c\u0001\u0019\u0005A$A\u0007vg\u0016\u0014\bK]5oG&\u0004\u0018\r\\\u000b\u0002;A\u0011a\u0004\n\b\u0003?\tj\u0011\u0001\t\u0006\u0002C\u0005)1oY1mC&\u00111\u0005I\u0001\u0007!J,G-\u001a4\n\u0005\u00152#AB*ue&twM\u0003\u0002$A!)\u0001\u0006\u0001D\u0001S\u0005y\u0001O]8ek\u000e,'/U;pi\u0006LE-F\u0001+!\tYc&D\u0001-\u0015\tiC!\u0001\u0004tKJ4XM]\u0005\u0003_1\u0012q!U;pi\u0006LE\rC\u00032\u0001\u0019\u0005\u0011&A\bd_:\u001cX/\\3s#V|G/Y%e\u0011\u0015\u0019\u0004A\"\u00015\u00039yg/\u001a:sS\u0012,\u0017+^8uCN$2!\u000e\u001d>!\tyb'\u0003\u00028A\t!QK\\5u\u0011\u0015I$\u00071\u0001;\u00035\u0001(o\u001c3vG\u0016\u0014\u0018+^8uCB\u0011qdO\u0005\u0003y\u0001\u0012A\u0001T8oO\")aH\ra\u0001u\u0005i1m\u001c8tk6,'/U;pi\u0006DQ\u0001\u0011\u0001\u0007\u0002\u0005\u000bAC]3n_Z,\u0017+^8uC>3XM\u001d:jI\u0016\u001cH#A\u001b\t\u000f\r\u0003!\u0019!C!\t\u0006Y1/\u001a:wKJ\u001cu.\u001e8u+\u0005)\u0005CA\u0010G\u0013\t9\u0005EA\u0002J]RDa!\u0013\u0001!\u0002\u0013)\u0015\u0001D:feZ,'oQ8v]R\u0004\u0003bB&\u0001\u0005\u0004%\t\u0001R\u0001\u000eaJ|G-^2fe\u000e{WO\u001c;\t\r5\u0003\u0001\u0015!\u0003F\u00039\u0001(o\u001c3vG\u0016\u00148i\\;oi\u0002Bqa\u0014\u0001C\u0002\u0013\u0005A)A\u0007d_:\u001cX/\\3s\u0007>,h\u000e\u001e\u0005\u0007#\u0002\u0001\u000b\u0011B#\u0002\u001d\r|gn];nKJ\u001cu.\u001e8uA!91\u000b\u0001b\u0001\n\u0013!\u0015A\u00059s_\u0012,8-\u001a:Ck\u001a4WM]*ju\u0016Da!\u0016\u0001!\u0002\u0013)\u0015a\u00059s_\u0012,8-\u001a:Ck\u001a4WM]*ju\u0016\u0004\u0003bB,\u0001\u0005\u0004%\t\u0002W\u0001\u0011aJ|G-^2fe\u000ec\u0017.\u001a8u\u0013\u0012,\u0012!\u0017\t\u00035~k\u0011a\u0017\u0006\u00039v\u000bA\u0001\\1oO*\ta,\u0001\u0003kCZ\f\u0017BA\u0013\\\u0011\u0019\t\u0007\u0001)A\u00053\u0006\t\u0002O]8ek\u000e,'o\u00117jK:$\u0018\n\u001a\u0011\t\u000f\r\u0004!\u0019!C\t1\u0006\u00012m\u001c8tk6,'o\u00117jK:$\u0018\n\u001a\u0005\u0007K\u0002\u0001\u000b\u0011B-\u0002#\r|gn];nKJ\u001cE.[3oi&#\u0007\u0005C\u0004h\u0001\t\u0007I\u0011\u0001#\u0002)\u0011,g-Y;miB\u0013x\u000eZ;dKJ\fVo\u001c;b\u0011\u0019I\u0007\u0001)A\u0005\u000b\u0006)B-\u001a4bk2$\bK]8ek\u000e,'/U;pi\u0006\u0004\u0003bB6\u0001\u0005\u0004%\t\u0001R\u0001\u0015I\u00164\u0017-\u001e7u\u0007>t7/^7feF+x\u000e^1\t\r5\u0004\u0001\u0015!\u0003F\u0003U!WMZ1vYR\u001cuN\\:v[\u0016\u0014\u0018+^8uC\u0002Bqa\u001c\u0001A\u0002\u0013\u0005\u0001/\u0001\u0006mK\u0006$WM\u001d(pI\u0016,\u0012!\u001d\t\u0003WIL!a\u001d\u0017\u0003\u0017-\u000bgm[1TKJ4XM\u001d\u0005\bk\u0002\u0001\r\u0011\"\u0001w\u00039aW-\u00193fe:{G-Z0%KF$\"!N<\t\u000fa$\u0018\u0011!a\u0001c\u0006\u0019\u0001\u0010J\u0019\t\ri\u0004\u0001\u0015)\u0003r\u0003-aW-\u00193fe:{G-\u001a\u0011\t\u000fq\u0004\u0001\u0019!C\u0001a\u0006aam\u001c7m_^,'OT8eK\"9a\u0010\u0001a\u0001\n\u0003y\u0018\u0001\u00054pY2|w/\u001a:O_\u0012,w\fJ3r)\r)\u0014\u0011\u0001\u0005\bqv\f\t\u00111\u0001r\u0011\u001d\t)\u0001\u0001Q!\nE\fQBZ8mY><XM\u001d(pI\u0016\u0004\u0003\u0002CA\u0005\u0001\t\u0007I\u0011\u0002-\u0002\rQ|\u0007/[22\u0011\u001d\ti\u0001\u0001Q\u0001\ne\u000bq\u0001^8qS\u000e\f\u0004\u0005\u0003\u0004\u0002\u0012\u0001!\t%Q\u0001\u0006g\u0016$X\u000b\u001d\u0015\u0005\u0003\u001f\t)\u0002\u0005\u0003\u0002\u0018\u0005mQBAA\r\u0015\tYa\"\u0003\u0003\u0002\u001e\u0005e!A\u0002\"fM>\u0014X\r\u0003\u0004\u0002\"\u0001!\t%Q\u0001\ti\u0016\f'\u000fR8x]\"\"\u0011qDA\u0013!\u0011\t9\"a\n\n\t\u0005%\u0012\u0011\u0004\u0002\u0006\u0003\u001a$XM\u001d\u0005\u0007\u0003[\u0001A\u0011A!\u0002;Q,7\u000f\u001e+ie>$H\u000f\\3e!J|G-^2fe\u000e{gn];nKJDC!a\u000b\u00022A!\u0011qCA\u001a\u0013\u0011\t)$!\u0007\u0003\tQ+7\u000f\u001e\u0005\u0007\u0003s\u0001A\u0011A!\u0002OQ,7\u000f\u001e)s_\u0012,8-\u001a:D_:\u001cX/\\3s\u001fZ,'O]5eKVsG\u000f\u001b:piRdW\r\u001a\u0015\u0005\u0003o\t\t\u0004\u0003\u0004\u0002@\u0001!\t!Q\u0001\u0018i\u0016\u001cH/U;pi\u0006|e/\u001a:sS\u0012,G)\u001a7fi\u0016DC!!\u0010\u00022!9\u0011Q\t\u0001\u0005\u0002\u0005\u001d\u0013a\u00029s_\u0012,8-\u001a\u000b\u0006\u000b\u0006%\u0013q\u000e\u0005\t\u0003\u0017\n\u0019\u00051\u0001\u0002N\u0005\t\u0001\u000f\u0005\u0005\u0002P\u0005}\u00131MA2\u001b\t\t\tF\u0003\u0003\u0002T\u0005U\u0013\u0001\u00039s_\u0012,8-\u001a:\u000b\t\u0005]\u0013\u0011L\u0001\bG2LWM\u001c;t\u0015\r)\u00111\f\u0006\u0004\u0003;r\u0011AB1qC\u000eDW-\u0003\u0003\u0002b\u0005E#!D&bM.\f\u0007K]8ek\u000e,'\u000fE\u0003 \u0003K\nI'C\u0002\u0002h\u0001\u0012Q!\u0011:sCf\u00042aHA6\u0013\r\ti\u0007\t\u0002\u0005\u0005f$X\rC\u0004\u0002r\u0005\r\u0003\u0019A#\u0002\u000b\r|WO\u001c;\t\u000f\u0005U\u0004\u0001\"\u0001\u0002x\u000591m\u001c8tk6,G#B\u001b\u0002z\u0005\u001d\u0005\u0002CA>\u0003g\u0002\r!! \u0002\u0011\r|gn];nKJ\u0004\u0002\"a \u0002\u0004\u0006\r\u00141M\u0007\u0003\u0003\u0003SA!a\u001f\u0002V%!\u0011QQAA\u00055Y\u0015MZ6b\u0007>t7/^7fe\"9\u0011\u0011RA:\u0001\u0004)\u0015A\u00038v[J+7m\u001c:eg\"9\u0011Q\u0012\u0001\u0005\u0002\u0005=\u0015AE<bSR4uN])v_R\fW\u000b\u001d3bi\u0016$R!NAI\u0003'Ca!OAF\u0001\u0004Q\u0004B\u0002 \u0002\f\u0002\u0007!\bC\u0004\u0002\u0018\u0002!I!!'\u0002%QD'o\u001c;uY\u0016lU\r\u001e:jG:\u000bW.\u001a\u000b\u0007\u00037\u000b9+a.\u0011\t\u0005u\u00151U\u0007\u0003\u0003?SA!!)\u0002Z\u000511m\\7n_:LA!!*\u0002 \nQQ*\u001a;sS\u000et\u0015-\\3\t\u0011\u0005%\u0016Q\u0013a\u0001\u0003W\u000ba!\u00199j\u0017\u0016L\b\u0003BAW\u0003gk!!a,\u000b\t\u0005E\u0016qT\u0001\taJ|Go\\2pY&!\u0011QWAX\u0005\u001d\t\u0005/[&fsNDq!!/\u0002\u0016\u0002\u0007!&A\u0004rk>$\u0018-\u00133\t\u000f\u0005u\u0006\u0001\"\u0001\u0002@\u0006y\u0011/^8uCB\u0013x\u000e]3si&,7\u000f\u0006\u0004\u0002B\u00065\u0017q\u001a\t\u0005\u0003\u0007\fI-\u0004\u0002\u0002F*\u0019\u0011qY/\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0017\f)M\u0001\u0006Qe>\u0004XM\u001d;jKNDa!OA^\u0001\u0004Q\u0004B\u0002 \u0002<\u0002\u0007!\b")
public abstract class BaseQuotaTest
extends JUnitSuite
implements IntegrationTestHarness {
    private final int serverCount;
    private final int producerCount;
    private final int consumerCount;
    private final int producerBufferSize;
    private final String producerClientId;
    private final String consumerClientId;
    private final int defaultProducerQuota;
    private final int defaultConsumerQuota;
    private KafkaServer leaderNode;
    private KafkaServer followerNode;
    private final String kafka$api$BaseQuotaTest$$topic1;
    private final Properties producerConfig;
    private final Properties consumerConfig;
    private final Properties serverConfig;
    private final Buffer<KafkaConsumer<byte[], byte[]>> consumers;
    private final Buffer<KafkaProducer<byte[], byte[]>> producers;
    private Seq<KafkaConfig> instanceConfigs;
    private Buffer<KafkaServer> servers;
    private String brokerList;
    private boolean[] alive;
    private final String kafkaPrincipalType;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private ZkUtils zkUtils;
    private EmbeddedZookeeper zookeeper;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile byte bitmap$0;

    private Properties producerConfig$lzycompute() {
        BaseQuotaTest baseQuotaTest = this;
        synchronized (baseQuotaTest) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.producerConfig = IntegrationTestHarness$class.producerConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.producerConfig;
        }
    }

    @Override
    public Properties producerConfig() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.producerConfig$lzycompute() : this.producerConfig;
    }

    private Properties consumerConfig$lzycompute() {
        BaseQuotaTest baseQuotaTest = this;
        synchronized (baseQuotaTest) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.consumerConfig = IntegrationTestHarness$class.consumerConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.consumerConfig;
        }
    }

    @Override
    public Properties consumerConfig() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.consumerConfig$lzycompute() : this.consumerConfig;
    }

    private Properties serverConfig$lzycompute() {
        BaseQuotaTest baseQuotaTest = this;
        synchronized (baseQuotaTest) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.serverConfig = IntegrationTestHarness$class.serverConfig(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.serverConfig;
        }
    }

    @Override
    public Properties serverConfig() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.serverConfig$lzycompute() : this.serverConfig;
    }

    @Override
    public Buffer<KafkaConsumer<byte[], byte[]>> consumers() {
        return this.consumers;
    }

    @Override
    public Buffer<KafkaProducer<byte[], byte[]>> producers() {
        return this.producers;
    }

    @Override
    public /* synthetic */ void kafka$api$IntegrationTestHarness$$super$setUp() {
        KafkaServerTestHarness$class.setUp(this);
    }

    @Override
    public /* synthetic */ void kafka$api$IntegrationTestHarness$$super$tearDown() {
        KafkaServerTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$api$IntegrationTestHarness$_setter_$consumers_$eq(Buffer x$1) {
        this.consumers = x$1;
    }

    @Override
    public void kafka$api$IntegrationTestHarness$_setter_$producers_$eq(Buffer x$1) {
        this.producers = x$1;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return IntegrationTestHarness$class.generateConfigs(this);
    }

    @Override
    public KafkaProducer<byte[], byte[]> createNewProducer() {
        return IntegrationTestHarness$class.createNewProducer(this);
    }

    @Override
    public KafkaConsumer<byte[], byte[]> createNewConsumer() {
        return IntegrationTestHarness$class.createNewConsumer(this);
    }

    @Override
    public Seq<KafkaConfig> instanceConfigs() {
        return this.instanceConfigs;
    }

    @Override
    public void instanceConfigs_$eq(Seq<KafkaConfig> x$1) {
        this.instanceConfigs = x$1;
    }

    @Override
    public Buffer<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(Buffer<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public String brokerList() {
        return this.brokerList;
    }

    @Override
    public void brokerList_$eq(String x$1) {
        this.brokerList = x$1;
    }

    @Override
    public boolean[] alive() {
        return this.alive;
    }

    @Override
    public void alive_$eq(boolean[] x$1) {
        this.alive = x$1;
    }

    @Override
    public String kafkaPrincipalType() {
        return this.kafkaPrincipalType;
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public /* synthetic */ void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$_setter_$kafkaPrincipalType_$eq(String x$1) {
        this.kafkaPrincipalType = x$1;
    }

    @Override
    public void setAclsBeforeServersStart() {
        KafkaServerTestHarness$class.setAclsBeforeServersStart(this);
    }

    @Override
    public Seq<KafkaConfig> configs() {
        return KafkaServerTestHarness$class.configs(this);
    }

    @Override
    public Option<KafkaServer> serverForId(int id) {
        return KafkaServerTestHarness$class.serverForId(this, id);
    }

    @Override
    public SecurityProtocol securityProtocol() {
        return KafkaServerTestHarness$class.securityProtocol(this);
    }

    @Override
    public Option<File> trustStoreFile() {
        return KafkaServerTestHarness$class.trustStoreFile(this);
    }

    @Override
    public Option<Properties> saslProperties() {
        return KafkaServerTestHarness$class.saslProperties(this);
    }

    @Override
    public int killRandomBroker() {
        return KafkaServerTestHarness$class.killRandomBroker(this);
    }

    @Override
    public void restartDeadBrokers() {
        KafkaServerTestHarness$class.restartDeadBrokers(this);
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    @Override
    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    @Override
    public int zkPort() {
        return ZooKeeperTestHarness$class.zkPort(this);
    }

    @Override
    public String zkConnect() {
        return ZooKeeperTestHarness$class.zkConnect(this);
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        BaseQuotaTest baseQuotaTest = this;
        synchronized (baseQuotaTest) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.logger$lzycompute() : this.logger;
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public abstract String userPrincipal();

    public abstract QuotaId producerQuotaId();

    public abstract QuotaId consumerQuotaId();

    public abstract void overrideQuotas(long var1, long var3);

    public abstract void removeQuotaOverrides();

    @Override
    public int serverCount() {
        return this.serverCount;
    }

    @Override
    public int producerCount() {
        return this.producerCount;
    }

    @Override
    public int consumerCount() {
        return this.consumerCount;
    }

    private int producerBufferSize() {
        return this.producerBufferSize;
    }

    public String producerClientId() {
        return this.producerClientId;
    }

    public String consumerClientId() {
        return this.consumerClientId;
    }

    public int defaultProducerQuota() {
        return this.defaultProducerQuota;
    }

    public int defaultConsumerQuota() {
        return this.defaultConsumerQuota;
    }

    public KafkaServer leaderNode() {
        return this.leaderNode;
    }

    public void leaderNode_$eq(KafkaServer x$1) {
        this.leaderNode = x$1;
    }

    public KafkaServer followerNode() {
        return this.followerNode;
    }

    public void followerNode_$eq(KafkaServer x$1) {
        this.followerNode = x$1;
    }

    public String kafka$api$BaseQuotaTest$$topic1() {
        return this.kafka$api$BaseQuotaTest$$topic1;
    }

    @Override
    @Before
    public void setUp() {
        IntegrationTestHarness$class.setUp(this);
        int numPartitions = 1;
        Map<Object, Option<Object>> leaders = TestUtils$.MODULE$.createTopic(this.zkUtils(), this.kafka$api$BaseQuotaTest$$topic1(), numPartitions, this.serverCount(), (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.leaderNode_$eq(BoxesRunTime.unboxToInt((Object)((Option)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))).get()) == ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
        this.followerNode_$eq(BoxesRunTime.unboxToInt((Object)((Option)leaders.apply((Object)BoxesRunTime.boxToInteger((int)0))).get()) != ((KafkaServer)this.servers().head()).config().brokerId() ? (KafkaServer)this.servers().head() : (KafkaServer)this.servers().apply(1));
        Assert.assertTrue((String)"Leader of all partitions of the topic should exist", (boolean)leaders.values().forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Option<Object> leader) {
                return leader.isDefined();
            }
        }));
    }

    @Override
    @After
    public void tearDown() {
        IntegrationTestHarness$class.tearDown(this);
    }

    @Test
    public void testThrottledProducerConsumer() {
        scala.collection.mutable.Map allMetrics = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.leaderNode().metrics().metrics()).asScala();
        int numRecords = 1000;
        this.produce((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), numRecords);
        MetricName producerMetricName = this.throttleMetricName(ApiKeys.PRODUCE, this.producerQuotaId());
        Assert.assertTrue((String)"Should have been throttled", (((KafkaMetric)allMetrics.apply((Object)producerMetricName)).value() > 0.0 ? 1 : 0) != 0);
        this.consume((KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()), numRecords);
        MetricName consumerMetricName = this.throttleMetricName(ApiKeys.FETCH, this.consumerQuotaId());
        Assert.assertTrue((String)"Should have been throttled", (((KafkaMetric)allMetrics.apply((Object)consumerMetricName)).value() > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testProducerConsumerOverrideUnthrottled() {
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)Long.MAX_VALUE)).toString());
        this.overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE);
        this.waitForQuotaUpdate(Long.MAX_VALUE, Long.MAX_VALUE);
        scala.collection.mutable.Map allMetrics = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.leaderNode().metrics().metrics()).asScala();
        int numRecords = 1000;
        this.produce((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), numRecords);
        MetricName producerMetricName = this.throttleMetricName(ApiKeys.PRODUCE, this.producerQuotaId());
        Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)((KafkaMetric)allMetrics.apply((Object)producerMetricName)).value(), (double)0.0);
        this.consume((KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()), numRecords);
        MetricName consumerMetricName = this.throttleMetricName(ApiKeys.FETCH, this.consumerQuotaId());
        Assert.assertEquals((String)"Should not have been throttled", (double)0.0, (double)((KafkaMetric)allMetrics.apply((Object)consumerMetricName)).value(), (double)0.0);
    }

    @Test
    public void testQuotaOverrideDelete() {
        this.overrideQuotas(Long.MAX_VALUE, Long.MAX_VALUE);
        scala.collection.mutable.Map allMetrics = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(this.leaderNode().metrics().metrics()).asScala();
        int numRecords = 1000;
        this.produce((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), numRecords);
        Assert.assertTrue((String)"Should not have been throttled", (((KafkaMetric)allMetrics.apply((Object)this.throttleMetricName(ApiKeys.PRODUCE, this.producerQuotaId()))).value() == 0.0 ? 1 : 0) != 0);
        this.consume((KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()), numRecords);
        Assert.assertTrue((String)"Should not have been throttled", (((KafkaMetric)allMetrics.apply((Object)this.throttleMetricName(ApiKeys.FETCH, this.consumerQuotaId()))).value() == 0.0 ? 1 : 0) != 0);
        this.removeQuotaOverrides();
        this.produce((KafkaProducer<byte[], byte[]>)((KafkaProducer)this.producers().head()), numRecords);
        Assert.assertTrue((String)"Should have been throttled", (((KafkaMetric)allMetrics.apply((Object)this.throttleMetricName(ApiKeys.PRODUCE, this.producerQuotaId()))).value() > 0.0 ? 1 : 0) != 0);
        this.consume((KafkaConsumer<byte[], byte[]>)((KafkaConsumer)this.consumers().head()), numRecords);
        Assert.assertTrue((String)"Should have been throttled", (((KafkaMetric)allMetrics.apply((Object)this.throttleMetricName(ApiKeys.FETCH, this.consumerQuotaId()))).value() > 0.0 ? 1 : 0) != 0);
    }

    public int produce(KafkaProducer<byte[], byte[]> p, int count) {
        IntRef numBytesProduced = IntRef.create((int)0);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), count).foreach$mVc$sp((Function1)new Serializable(this, p, numBytesProduced){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseQuotaTest $outer;
            private final KafkaProducer p$1;
            private final IntRef numBytesProduced$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                byte[] payload = ((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes();
                this.numBytesProduced$1.elem += payload.length;
                this.p$1.send(new ProducerRecord(this.$outer.kafka$api$BaseQuotaTest$$topic1(), null, null, (Object)payload), (Callback)new ErrorLoggingCallback(this.$outer.kafka$api$BaseQuotaTest$$topic1(), null, null, true)).get();
                Thread.sleep(1L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.p$1 = p$1;
                this.numBytesProduced$1 = numBytesProduced$1;
            }
        });
        return numBytesProduced.elem;
    }

    public void consume(KafkaConsumer<byte[], byte[]> consumer, int numRecords) {
        consumer.subscribe((Collection)JavaConversions$.MODULE$.seqAsJavaList((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.kafka$api$BaseQuotaTest$$topic1()}))));
        IntRef numConsumed = IntRef.create((int)0);
        while (numConsumed.elem < numRecords) {
            JavaConversions$.MODULE$.iterableAsScalaIterable((Iterable)consumer.poll(100L)).foreach((Function1)new Serializable(this, numConsumed){
                public static final long serialVersionUID = 0L;
                private final IntRef numConsumed$1;

                public final void apply(ConsumerRecord<byte[], byte[]> cr) {
                    ++this.numConsumed$1.elem;
                }
                {
                    this.numConsumed$1 = numConsumed$1;
                }
            });
        }
    }

    public void waitForQuotaUpdate(long producerQuota, long consumerQuota) {
        TestUtils$.MODULE$.retry(10000L, (Function0<BoxedUnit>)new Serializable(this, producerQuota, consumerQuota){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ BaseQuotaTest $outer;
            private final long producerQuota$1;
            private final long consumerQuota$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                QuotaFactory.QuotaManagers quotaManagers = this.$outer.leaderNode().apis().quotas();
                Quota overrideProducerQuota = quotaManagers.produce().quota(this.$outer.userPrincipal(), this.$outer.producerClientId());
                Quota overrideConsumerQuota = quotaManagers.fetch().quota(this.$outer.userPrincipal(), this.$outer.consumerClientId());
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ClientId ", " of user ", " must have producer quota"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.producerClientId(), this.$outer.userPrincipal()})), (Object)Quota.upperBound((double)this.producerQuota$1), (Object)overrideProducerQuota);
                Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ClientId ", " of user ", " must have consumer quota"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.consumerClientId(), this.$outer.userPrincipal()})), (Object)Quota.upperBound((double)this.consumerQuota$1), (Object)overrideConsumerQuota);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.producerQuota$1 = producerQuota$1;
                this.consumerQuota$1 = consumerQuota$1;
            }
        });
    }

    private MetricName throttleMetricName(ApiKeys apiKey, QuotaId quotaId) {
        return this.leaderNode().metrics().metricName("throttle-time", apiKey.name, "Tracking throttle-time per user/client-id", new String[]{"user", (String)quotaId.sanitizedUser().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        }), "client-id", (String)quotaId.clientId().getOrElse((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })});
    }

    public Properties quotaProperties(long producerQuota, long consumerQuota) {
        Properties props = new Properties();
        props.put(DynamicConfig.Client$.MODULE$.ProducerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)producerQuota)).toString());
        props.put(DynamicConfig.Client$.MODULE$.ConsumerByteRateOverrideProp(), ((Object)BoxesRunTime.boxToLong((long)consumerQuota)).toString());
        return props;
    }

    public BaseQuotaTest() {
        Logging.class.$init$((Logging)this);
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        IntegrationTestHarness$class.$init$(this);
        this.serverCount = 2;
        this.producerCount = 1;
        this.consumerCount = 1;
        this.producerBufferSize = 300000;
        this.producerClientId = "QuotasTestProducer-1";
        this.consumerClientId = "QuotasTestConsumer-1";
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.ControlledShutdownEnableProp(), "false");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "2");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "100");
        this.serverConfig().setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), "30000");
        this.producerConfig().setProperty("acks", "0");
        this.producerConfig().setProperty("buffer.memory", ((Object)BoxesRunTime.boxToInteger((int)this.producerBufferSize())).toString());
        this.producerConfig().setProperty("client.id", this.producerClientId());
        this.consumerConfig().setProperty("group.id", "QuotasTest");
        this.consumerConfig().setProperty("max.partition.fetch.bytes", ((Object)BoxesRunTime.boxToInteger((int)4096)).toString());
        this.consumerConfig().setProperty("auto.offset.reset", "earliest");
        this.consumerConfig().setProperty("client.id", this.consumerClientId());
        this.defaultProducerQuota = 8000;
        this.defaultConsumerQuota = 2500;
        this.leaderNode = null;
        this.followerNode = null;
        this.kafka$api$BaseQuotaTest$$topic1 = "topic-1";
    }
}

