/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.util.Properties;
import java.util.concurrent.ExecutionException;
import kafka.api.BaseProducerSendTest;
import kafka.log.LogConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.InvalidTimestampException;
import org.apache.kafka.common.errors.SerializationException;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.serialization.ByteArraySerializer;
import org.apache.kafka.common.serialization.Serializer;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Y3A!\u0001\u0002\u0001\u000f\tI\u0002\u000b\\1j]R,\u0007\u0010\u001e)s_\u0012,8-\u001a:TK:$G+Z:u\u0015\t\u0019A!A\u0002ba&T\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0002\u0005\u0002\n\u00155\t!!\u0003\u0002\f\u0005\t!\")Y:f!J|G-^2feN+g\u000e\u001a+fgRDQ!\u0004\u0001\u0005\u00029\ta\u0001P5oSRtD#A\b\u0011\u0005%\u0001\u0001\"B\t\u0001\t\u0003\u0011\u0012A\u0007;fgR\u001cVM]5bY&TXM]\"p]N$(/^2u_J\u001cH#A\n\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\tUs\u0017\u000e\u001e\u0015\u0003!i\u0001\"a\u0007\u0011\u000e\u0003qQ!!\b\u0010\u0002\u000b),h.\u001b;\u000b\u0003}\t1a\u001c:h\u0013\t\tCD\u0001\u0003UKN$\b\"B\u0012\u0001\t\u0013!\u0013!I2sK\u0006$XMT3x!J|G-^2fe^KG\u000f\u001b(p'\u0016\u0014\u0018.\u00197ju\u0016\u0014HCA\u00137!\u00111c\u0006\r\u0019\u000e\u0003\u001dR!\u0001K\u0015\u0002\u0011A\u0014x\u000eZ;dKJT!AK\u0016\u0002\u000f\rd\u0017.\u001a8ug*\u0011Q\u0001\f\u0006\u0003[y\ta!\u00199bG\",\u0017BA\u0018(\u00055Y\u0015MZ6b!J|G-^2feB\u0019A#M\u001a\n\u0005I*\"!B!se\u0006L\bC\u0001\u000b5\u0013\t)TC\u0001\u0003CsR,\u0007\"B\u001c#\u0001\u0004A\u0014A\u00032s_.,'\u000fT5tiB\u0011\u0011\b\u0010\b\u0003)iJ!aO\u000b\u0002\rA\u0013X\rZ3g\u0013\tidH\u0001\u0004TiJLgn\u001a\u0006\u0003wUAQ\u0001\u0011\u0001\u0005\n\u0005\u000bqe\u0019:fCR,g*Z<Qe>$WoY3s/&$\b.\u0012=qY&\u001c\u0017\u000e^*fe&\fG.\u001b>feR\u0011QE\u0011\u0005\u0006o}\u0002\r\u0001\u000f\u0005\u0006\t\u0002!\tAE\u0001\u0014i\u0016\u001cHo\u0016:p]\u001e\u001cVM]5bY&TXM\u001d\u0015\u0003\u0007jAQa\u0012\u0001\u0005\u0002I\t!\u0006^3tiN+g\u000eZ\"p[B\u0014Xm]:fI6+7o]1hK^KG\u000f\u001b'pO\u0006\u0003\b/\u001a8e)&lW\r\u000b\u0002G5!)!\n\u0001C\u0001%\u0005iC/Z:u'\u0016tGMT8o\u0007>l\u0007O]3tg\u0016$W*Z:tC\u001e,w+\u001b;i\u0019><\u0017\t\u001d9f]\u0012$\u0016.\\3)\u0005%S\u0002\"B'\u0001\t\u0003\u0011\u0012a\u0005;fgR\fU\u000f^8De\u0016\fG/\u001a+pa&\u001c\u0007F\u0001'\u001b\u0011\u0015\u0001\u0006\u0001\"\u0001\u0013\u0003u!Xm\u001d;TK:$w+\u001b;i\u0013:4\u0018\r\\5e\u0007J,\u0017\r^3US6,\u0007FA(\u001b\u0011\u0015\u0019\u0006\u0001\"\u0003U\u0003\u0005\u001a'/Z1uKB\u0013x\u000eZ;dKJ<\u0016\u000e\u001e5Xe>twmU3sS\u0006d\u0017N_3s)\t)S\u000bC\u00038%\u0002\u0007\u0001\b")
public class PlaintextProducerSendTest
extends BaseProducerSendTest {
    @Test
    public void testSerializerConstructors() {
        try {
            this.createNewProducerWithNoSerializer(this.brokerList());
            throw this.fail("Instantiating a producer without specifying a serializer should cause a ConfigException", new Position("PlaintextProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 40));
        }
        catch (ConfigException configException) {
            this.createNewProducerWithExplicitSerializer(this.brokerList());
            return;
        }
    }

    private KafkaProducer<byte[], byte[]> createNewProducerWithNoSerializer(String brokerList) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", brokerList);
        return this.registerProducer((KafkaProducer<byte[], byte[]>)new KafkaProducer(producerProps));
    }

    private KafkaProducer<byte[], byte[]> createNewProducerWithExplicitSerializer(String brokerList) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", brokerList);
        return this.registerProducer((KafkaProducer<byte[], byte[]>)new KafkaProducer(producerProps, (Serializer)new ByteArraySerializer(), (Serializer)new ByteArraySerializer()));
    }

    @Test
    public void testWrongSerializer() {
        try {
            KafkaProducer<byte[], byte[]> producer = this.createProducerWithWrongSerializer(this.brokerList());
            ProducerRecord record5 = new ProducerRecord(this.topic(), new Integer(0), (Object)"key".getBytes(), (Object)"value".getBytes());
            producer.send(record5);
            throw this.fail("Should have gotten a SerializationException", new Position("PlaintextProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 68));
        }
        catch (SerializationException serializationException) {
            return;
        }
    }

    @Test
    public void testSendCompressedMessageWithLogAppendTime() {
        Properties producerProps = new Properties();
        producerProps.setProperty("compression.type", "gzip");
        String x$1 = this.brokerList();
        long x$2 = Long.MAX_VALUE;
        Some x$3 = new Some((Object)producerProps);
        int x$4 = this.createProducer$default$2();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$1, x$4, x$2, (Option<Properties>)x$3);
        this.sendAndVerifyTimestamp(producer, TimestampType.LOG_APPEND_TIME);
    }

    @Test
    public void testSendNonCompressedMessageWithLogAppendTime() {
        String x$5 = this.brokerList();
        long x$6 = Long.MAX_VALUE;
        int x$7 = this.createProducer$default$2();
        Option<Properties> x$8 = this.createProducer$default$4();
        KafkaProducer<byte[], byte[]> producer = this.createProducer(x$5, x$7, x$6, x$8);
        this.sendAndVerifyTimestamp(producer, TimestampType.LOG_APPEND_TIME);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testAutoCreateTopic() {
        KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), 5, this.createProducer$default$3(), this.createProducer$default$4());
        try {
            ProducerRecord record = new ProducerRecord(this.topic(), null, (Object)"key".getBytes(), (Object)"value".getBytes());
            Assert.assertEquals((String)"Should have offset 0", (long)0L, (long)((RecordMetadata)producer.send(record).get()).offset());
            TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkUtils(), this.topic(), 0, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        }
        catch (Throwable throwable) {
            void var1_1;
            var1_1.close();
            throw throwable;
        }
        producer.close();
    }

    @Test
    public void testSendWithInvalidCreateTime() {
        Properties topicProps = new Properties();
        topicProps.setProperty(LogConfig$.MODULE$.MessageTimestampDifferenceMaxMsProp(), "1000");
        TestUtils$.MODULE$.createTopic(this.zkUtils(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), topicProps);
        try (KafkaProducer<byte[], byte[]> producer = this.createProducer(this.brokerList(), this.createProducer$default$2(), this.createProducer$default$3(), this.createProducer$default$4());){
            try {
                producer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(System.currentTimeMillis() - 1001L), (Object)"key".getBytes(), (Object)"value".getBytes())).get();
                throw this.fail("Should throw CorruptedRecordException", new Position("PlaintextProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 119));
            }
            catch (ExecutionException executionException) {
                Assert.assertTrue((boolean)(executionException.getCause() instanceof InvalidTimestampException));
            }
        }
        Properties producerProps = new Properties();
        producerProps.setProperty("compression.type", "gzip");
        String x$9 = this.brokerList();
        Some x$10 = new Some((Object)producerProps);
        int x$11 = this.createProducer$default$2();
        long x$12 = this.createProducer$default$3();
        try (KafkaProducer<byte[], byte[]> compressedProducer = this.createProducer(x$9, x$11, x$12, (Option<Properties>)x$10);){
            try {
                compressedProducer.send(new ProducerRecord(this.topic(), Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.long2Long(System.currentTimeMillis() - 1001L), (Object)"key".getBytes(), (Object)"value".getBytes())).get();
                throw this.fail("Should throw CorruptedRecordException", new Position("PlaintextProducerSendTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 132));
            }
            catch (ExecutionException executionException) {
                Assert.assertTrue((boolean)(executionException.getCause() instanceof InvalidTimestampException));
            }
        }
    }

    private KafkaProducer<byte[], byte[]> createProducerWithWrongSerializer(String brokerList) {
        Properties producerProps = new Properties();
        producerProps.put("bootstrap.servers", brokerList);
        producerProps.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        producerProps.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        return this.registerProducer((KafkaProducer<byte[], byte[]>)new KafkaProducer(producerProps));
    }
}

