/*
 * Decompiled with CFR 0.152.
 */
package kafka.common;

import kafka.common.Topic$;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001!2A!\u0001\u0002\u0001\u000f\tIAk\u001c9jGR+7\u000f\u001e\u0006\u0003\u0007\u0011\taaY8n[>t'\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u00131i\u0011A\u0003\u0006\u0002\u0017\u0005)1oY1mC&\u0011QB\u0003\u0002\u0007\u0003:L(+\u001a4\t\u000b=\u0001A\u0011\u0001\t\u0002\rqJg.\u001b;?)\u0005\t\u0002C\u0001\n\u0001\u001b\u0005\u0011\u0001\"\u0002\u000b\u0001\t\u0003)\u0012!\u0006;fgRLeN^1mS\u0012$v\u000e]5d\u001d\u0006lWm\u001d\u000b\u0002-A\u0011\u0011bF\u0005\u00031)\u0011A!\u00168ji\"\u00121C\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\tQA[;oSRT\u0011aH\u0001\u0004_J<\u0017BA\u0011\u001d\u0005\u0011!Vm\u001d;\t\u000b\r\u0002A\u0011A\u000b\u00025Q,7\u000f\u001e+pa&\u001c\u0007*Y:D_2d\u0017n]5p]\u000eC\u0017M]:)\u0005\tR\u0002\"\u0002\u0014\u0001\t\u0003)\u0012!\u0006;fgR$v\u000e]5d\u0011\u0006\u001c8i\u001c7mSNLwN\u001c\u0015\u0003Ki\u0001")
public class TopicTest {
    @Test
    public void testInvalidTopicNames() {
        ArrayBuffer invalidTopicNames = new ArrayBuffer();
        invalidTopicNames.$plus$eq((Object)"", (Object)".", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".."}));
        ObjectRef longName = ObjectRef.create((Object)"ATCG");
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 6).foreach$mVc$sp((Function1)new Serializable(this, longName){
            public static final long serialVersionUID = 0L;
            private final ObjectRef longName$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.longName$1.elem = new StringBuilder().append((Object)((String)this.longName$1.elem)).append((Object)((String)this.longName$1.elem)).toString();
            }
            {
                this.longName$1 = longName$1;
            }
        });
        invalidTopicNames.$plus$eq((Object)((String)longName.elem));
        invalidTopicNames.$plus$eq(new StringOps(Predef$.MODULE$.augmentString((String)longName.elem)).drop(6));
        Object[] badChars = (Object[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)'/'), BoxesRunTime.boxToCharacter((char)'\\'), BoxesRunTime.boxToCharacter((char)','), BoxesRunTime.boxToCharacter((char)'\u0000'), BoxesRunTime.boxToCharacter((char)':'), "\"", BoxesRunTime.boxToCharacter((char)'\''), BoxesRunTime.boxToCharacter((char)';'), BoxesRunTime.boxToCharacter((char)'*'), BoxesRunTime.boxToCharacter((char)'?'), BoxesRunTime.boxToCharacter((char)' '), BoxesRunTime.boxToCharacter((char)'\t'), BoxesRunTime.boxToCharacter((char)'\r'), BoxesRunTime.boxToCharacter((char)'\n'), BoxesRunTime.boxToCharacter((char)'=')}), ClassTag$.MODULE$.Any());
        Predef$.MODULE$.genericArrayOps((Object)badChars).foreach((Function1)new Serializable(this, invalidTopicNames){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer invalidTopicNames$1;

            public final ArrayBuffer<String> apply(Object weirdChar) {
                return this.invalidTopicNames$1.$plus$eq((Object)new StringBuilder().append((Object)"Is").append(weirdChar).append((Object)"illegal").toString());
            }
            {
                this.invalidTopicNames$1 = invalidTopicNames$1;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), invalidTopicNames.size()).foreach$mVc$sp((Function1)new Serializable(this, invalidTopicNames){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer invalidTopicNames$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                try {
                    Topic$.MODULE$.validate((String)this.invalidTopicNames$1.apply(i));
                    Assert.fail((String)"Should throw InvalidTopicException.");
                }
                catch (InvalidTopicException invalidTopicException) {
                    // empty catch block
                }
            }
            {
                this.invalidTopicNames$1 = invalidTopicNames$1;
            }
        });
        ArrayBuffer validTopicNames = new ArrayBuffer();
        validTopicNames.$plus$eq((Object)"valid", (Object)"TOPIC", (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"nAmEs", "ar6", "VaL1d", "_0-9_.", (String)new StringOps(Predef$.MODULE$.augmentString((String)longName.elem)).drop(7)}));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), validTopicNames.size()).foreach$mVc$sp((Function1)new Serializable(this, validTopicNames){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer validTopicNames$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                try {
                    Topic$.MODULE$.validate((String)this.validTopicNames$1.apply(i));
                }
                catch (Exception exception) {
                    Assert.fail((String)"Should not throw exception.");
                }
            }
            {
                this.validTopicNames$1 = validTopicNames$1;
            }
        });
    }

    @Test
    public void testTopicHasCollisionChars() {
        List falseTopics = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"start", "end", "middle", "many"}));
        List trueTopics = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".start", "end.", "mid.dle", ".ma.ny.", "_start", "end_", "mid_dle", "_ma_ny."}));
        falseTopics.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String t) {
                Assert.assertFalse((boolean)Topic$.MODULE$.hasCollisionChars(t));
            }
        });
        trueTopics.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String t) {
                Assert.assertTrue((boolean)Topic$.MODULE$.hasCollisionChars(t));
            }
        });
    }

    @Test
    public void testTopicHasCollision() {
        List periodFirstMiddleLastNone = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{".topic", "to.pic", "topic.", "topic"}));
        List underscoreFirstMiddleLastNone = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_topic", "to_pic", "topic_", "topic"}));
        periodFirstMiddleLastNone.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String t) {
                Assert.assertTrue((boolean)Topic$.MODULE$.hasCollision(t, t));
            }
        });
        underscoreFirstMiddleLastNone.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(String t) {
                Assert.assertTrue((boolean)Topic$.MODULE$.hasCollision(t, t));
            }
        });
        ((List)periodFirstMiddleLastNone.zip((GenIterable)underscoreFirstMiddleLastNone, List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, String> x0$1) {
                Tuple2<String, String> tuple2 = x0$1;
                if (tuple2 != null) {
                    String t1 = (String)tuple2._1();
                    String t2 = (String)tuple2._2();
                    Assert.assertTrue((boolean)Topic$.MODULE$.hasCollision(t1, t2));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
        ((List)periodFirstMiddleLastNone.zip((GenIterable)underscoreFirstMiddleLastNone.reverse(), List$.MODULE$.canBuildFrom())).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Tuple2<String, String> x0$2) {
                Tuple2<String, String> tuple2 = x0$2;
                if (tuple2 != null) {
                    String t1 = (String)tuple2._1();
                    String t2 = (String)tuple2._2();
                    Assert.assertFalse((boolean)Topic$.MODULE$.hasCollision(t1, t2));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
        });
    }
}

