/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import kafka.common.OffsetAndMetadata;
import kafka.common.OffsetAndMetadata$;
import kafka.common.Topic$;
import kafka.common.TopicAndPartition;
import kafka.coordinator.AwaitingSync$;
import kafka.coordinator.GroupCoordinator;
import kafka.coordinator.GroupCoordinator$;
import kafka.coordinator.GroupOverview;
import kafka.coordinator.GroupSummary;
import kafka.coordinator.JoinGroupResult;
import kafka.coordinator.MemberSummary;
import kafka.message.Message$;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.ReplicaManager;
import kafka.utils.KafkaScheduler;
import kafka.utils.TestUtils$;
import kafka.utils.ZkUtils;
import kafka.utils.timer.MockTimer;
import kafka.utils.timer.Timer;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0011\u001dd\u0001B\u0001\u0003\u0001\u001d\u0011Ad\u0012:pkB\u001cun\u001c:eS:\fGo\u001c:SKN\u0004xN\\:f)\u0016\u001cHO\u0003\u0002\u0004\t\u0005Y1m\\8sI&t\u0017\r^8s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007\"B\n\u0001\t\u0003!\u0012A\u0002\u001fj]&$h\bF\u0001\u0016!\t1\u0002!D\u0001\u0003\u000b\u0011A\u0002\u0001A\r\u0003#){\u0017N\\$s_V\u00048)\u00197mE\u0006\u001c7\u000e\u0005\u0003\u001b;}\u0011S\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001\f!\u0013\t\t#AA\bK_&twI]8vaJ+7/\u001e7u!\tQ2%\u0003\u0002%7\t!QK\\5u\u000b\u00111\u0003\u0001A\u0014\u0003/MKhnY$s_V\u00048)\u00197mE\u0006\u001c7\u000eU1sC6\u001c\b\u0003\u0002\u000e)UAJ!!K\u000e\u0003\rQ+\b\u000f\\33!\rQ2&L\u0005\u0003Ym\u0011Q!\u0011:sCf\u0004\"A\u0007\u0018\n\u0005=Z\"\u0001\u0002\"zi\u0016\u0004\"AG\u0019\n\u0005IZ\"!B*i_J$X\u0001\u0002\u001b\u0001\u0001U\u0012\u0011cU=oG\u001e\u0013x.\u001e9DC2d'-Y2l!\u0015QbG\u000b\u0019#\u0013\t94DA\u0005Gk:\u001cG/[8oe\u0015!\u0011\b\u0001\u00011\u0005]AU-\u0019:uE\u0016\fGoQ1mY\n\f7m\u001b)be\u0006l7/\u0002\u0003<\u0001\u0001a$!\u0005%fCJ$(-Z1u\u0007\u0006dGNY1dWB!!$\b\u0019#\u000b\u0011q\u0004\u0001A \u00035\r{W.\\5u\u001f\u001a47/\u001a;DC2d'-Y2l!\u0006\u0014\u0018-\\:\u0011\t\u0001\u001bU\tM\u0007\u0002\u0003*\u0011!iG\u0001\u000bG>dG.Z2uS>t\u0017B\u0001#B\u0005\ri\u0015\r\u001d\t\u0003\r2k\u0011a\u0012\u0006\u0003\u0011&\u000baaY8n[>t'BA\u0003K\u0015\tYe\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003\u001b\u001e\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0002\u0003P\u0001\u0001\u0001&\u0001F\"p[6LGo\u00144gg\u0016$8)\u00197mE\u0006\u001c7\u000e\u0005\u0003\u001b;}\u0012S\u0001\u0002*\u0001\u0001A\u0012\u0001\u0004T3bm\u0016<%o\\;q\u0007\u0006dGNY1dWB\u000b'/Y7t\u000b\u0011!\u0006\u0001\u0001\u001f\u0003%1+\u0017M^3He>,\boQ1mY\n\f7m\u001b\u0005\b-\u0002\u0011\r\u0011\"\u0001X\u0003!\u0019E.[3oi&#W#\u0001-\u0011\u0005esV\"\u0001.\u000b\u0005mc\u0016\u0001\u00027b]\u001eT\u0011!X\u0001\u0005U\u00064\u0018-\u0003\u0002`5\n11\u000b\u001e:j]\u001eDa!\u0019\u0001!\u0002\u0013A\u0016!C\"mS\u0016tG/\u00133!\u0011\u001d\u0019\u0007A1A\u0005\u0002]\u000b!b\u00117jK:$\bj\\:u\u0011\u0019)\u0007\u0001)A\u00051\u0006Y1\t\\5f]RDun\u001d;!\u0011\u001d9\u0007A1A\u0005\u0002!\f\u0011dQ8ogVlWM]'j]N+7o]5p]RKW.Z8viV\t\u0011\u000e\u0005\u0002\u001bU&\u00111n\u0007\u0002\u0004\u0013:$\bBB7\u0001A\u0003%\u0011.\u0001\u000eD_:\u001cX/\\3s\u001b&t7+Z:tS>tG+[7f_V$\b\u0005C\u0004p\u0001\t\u0007I\u0011\u00015\u00023\r{gn];nKJl\u0015\r_*fgNLwN\u001c+j[\u0016|W\u000f\u001e\u0005\u0007c\u0002\u0001\u000b\u0011B5\u00025\r{gn];nKJl\u0015\r_*fgNLwN\u001c+j[\u0016|W\u000f\u001e\u0011\t\u000fM\u0004!\u0019!C\u0001Q\u00069B)\u001a4bk2$(+\u001a2bY\u0006t7-\u001a+j[\u0016|W\u000f\u001e\u0005\u0007k\u0002\u0001\u000b\u0011B5\u00021\u0011+g-Y;miJ+'-\u00197b]\u000e,G+[7f_V$\b\u0005C\u0004x\u0001\t\u0007I\u0011\u00015\u0002+\u0011+g-Y;miN+7o]5p]RKW.Z8vi\"1\u0011\u0010\u0001Q\u0001\n%\fa\u0003R3gCVdGoU3tg&|g\u000eV5nK>,H\u000f\t\u0005\bw\u0002\u0001\r\u0011\"\u0001}\u0003\u0015!\u0018.\\3s+\u0005i\bc\u0001@\u0002\u00065\tqPC\u0002|\u0003\u0003Q1!a\u0001\u0005\u0003\u0015)H/\u001b7t\u0013\r\t9a \u0002\n\u001b>\u001c7\u000eV5nKJD\u0011\"a\u0003\u0001\u0001\u0004%\t!!\u0004\u0002\u0013QLW.\u001a:`I\u0015\fHc\u0001\u0012\u0002\u0010!I\u0011\u0011CA\u0005\u0003\u0003\u0005\r!`\u0001\u0004q\u0012\n\u0004bBA\u000b\u0001\u0001\u0006K!`\u0001\u0007i&lWM\u001d\u0011\t\u0013\u0005e\u0001\u00011A\u0005\u0002\u0005m\u0011\u0001E4s_V\u00048i\\8sI&t\u0017\r^8s+\t\ti\u0002E\u0002\u0017\u0003?I1!!\t\u0003\u0005A9%o\\;q\u0007>|'\u000fZ5oCR|'\u000fC\u0005\u0002&\u0001\u0001\r\u0011\"\u0001\u0002(\u0005!rM]8va\u000e{wN\u001d3j]\u0006$xN]0%KF$2AIA\u0015\u0011)\t\t\"a\t\u0002\u0002\u0003\u0007\u0011Q\u0004\u0005\t\u0003[\u0001\u0001\u0015)\u0003\u0002\u001e\u0005\trM]8va\u000e{wN\u001d3j]\u0006$xN\u001d\u0011\t\u0013\u0005E\u0002\u00011A\u0005\u0002\u0005M\u0012A\u0004:fa2L7-Y'b]\u0006<WM]\u000b\u0003\u0003k\u0001B!a\u000e\u0002>5\u0011\u0011\u0011\b\u0006\u0004\u0003w!\u0011AB:feZ,'/\u0003\u0003\u0002@\u0005e\"A\u0004*fa2L7-Y'b]\u0006<WM\u001d\u0005\n\u0003\u0007\u0002\u0001\u0019!C\u0001\u0003\u000b\n!C]3qY&\u001c\u0017-T1oC\u001e,'o\u0018\u0013fcR\u0019!%a\u0012\t\u0015\u0005E\u0011\u0011IA\u0001\u0002\u0004\t)\u0004\u0003\u0005\u0002L\u0001\u0001\u000b\u0015BA\u001b\u0003=\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004\u0003\"CA(\u0001\u0001\u0007I\u0011AA)\u0003%\u00198\r[3ek2,'/\u0006\u0002\u0002TA!\u0011QKA,\u001b\t\t\t!\u0003\u0003\u0002Z\u0005\u0005!AD&bM.\f7k\u00195fIVdWM\u001d\u0005\n\u0003;\u0002\u0001\u0019!C\u0001\u0003?\nQb]2iK\u0012,H.\u001a:`I\u0015\fHc\u0001\u0012\u0002b!Q\u0011\u0011CA.\u0003\u0003\u0005\r!a\u0015\t\u0011\u0005\u0015\u0004\u0001)Q\u0005\u0003'\n!b]2iK\u0012,H.\u001a:!\u0011%\tI\u0007\u0001a\u0001\n\u0003\tY'A\u0004{WV#\u0018\u000e\\:\u0016\u0005\u00055\u0004\u0003BA+\u0003_JA!!\u001d\u0002\u0002\t9!l[+uS2\u001c\b\"CA;\u0001\u0001\u0007I\u0011AA<\u0003-Q8.\u0016;jYN|F%Z9\u0015\u0007\t\nI\b\u0003\u0006\u0002\u0012\u0005M\u0014\u0011!a\u0001\u0003[B\u0001\"! \u0001A\u0003&\u0011QN\u0001\tu.,F/\u001b7tA!A\u0011\u0011\u0011\u0001C\u0002\u0013%q+A\u0004he>,\b/\u00133\t\u000f\u0005\u0015\u0005\u0001)A\u00051\u0006AqM]8va&#\u0007\u0005\u0003\u0005\u0002\n\u0002\u0011\r\u0011\"\u0003X\u00031\u0001(o\u001c;pG>dG+\u001f9f\u0011\u001d\ti\t\u0001Q\u0001\na\u000bQ\u0002\u001d:pi>\u001cw\u000e\u001c+za\u0016\u0004\u0003\u0002CAI\u0001\t\u0007I\u0011B,\u0002\u00115,WNY3s\u0013\u0012Dq!!&\u0001A\u0003%\u0001,A\u0005nK6\u0014WM]%eA!I\u0011\u0011\u0014\u0001C\u0002\u0013%\u00111T\u0001\t[\u0016$\u0018\rZ1uCV\t!\u0006C\u0004\u0002 \u0002\u0001\u000b\u0011\u0002\u0016\u0002\u00135,G/\u00193bi\u0006\u0004\u0003\"CAR\u0001\t\u0007I\u0011BAS\u0003%\u0001(o\u001c;pG>d7/\u0006\u0002\u0002(B1\u0011\u0011VAX\u0003gk!!a+\u000b\u0007\u00055\u0016)A\u0005j[6,H/\u00192mK&!\u0011\u0011WAV\u0005\u0011a\u0015n\u001d;\u0011\tiA\u0003L\u000b\u0005\t\u0003o\u0003\u0001\u0015!\u0003\u0002(\u0006Q\u0001O]8u_\u000e|Gn\u001d\u0011\t\u0011\u0005m\u0006\u00011A\u0005\n!\f\u0001c\u001a:pkB\u0004\u0016M\u001d;ji&|g.\u00133\t\u0013\u0005}\u0006\u00011A\u0005\n\u0005\u0005\u0017\u0001F4s_V\u0004\b+\u0019:uSRLwN\\%e?\u0012*\u0017\u000fF\u0002#\u0003\u0007D\u0011\"!\u0005\u0002>\u0006\u0005\t\u0019A5\t\u000f\u0005\u001d\u0007\u0001)Q\u0005S\u0006\trM]8vaB\u000b'\u000f^5uS>t\u0017\n\u001a\u0011\t\u0011\u0005-\u0007A1A\u0005\n]\u000bAb\u001c;iKJ<%o\\;q\u0013\u0012Dq!a4\u0001A\u0003%\u0001,A\u0007pi\",'o\u0012:pkBLE\r\t\u0005\b\u0003'\u0004A\u0011AAk\u0003\u0015\u0019X\r^+q)\u0005\u0011\u0003\u0006BAi\u00033\u0004B!a7\u0002`6\u0011\u0011Q\u001c\u0006\u0003\u00179IA!!9\u0002^\n1!)\u001a4pe\u0016Dq!!:\u0001\t\u0003\t).\u0001\u0005uK\u0006\u0014Hi\\<oQ\u0011\t\u0019/!;\u0011\t\u0005m\u00171^\u0005\u0005\u0003[\fiNA\u0003BMR,'\u000fC\u0004\u0002r\u0002!\t!!6\u0002;Q,7\u000f\u001e&pS:<%o\\;q/J|gnZ\"p_J$\u0017N\\1u_JDC!a<\u0002vB!\u00111\\A|\u0013\u0011\tI0!8\u0003\tQ+7\u000f\u001e\u0005\b\u0003{\u0004A\u0011AAk\u0003\r\"Xm\u001d;K_&twI]8vaN+7o]5p]RKW.Z8viR{wnU7bY2DC!a?\u0002v\"9!1\u0001\u0001\u0005\u0002\u0005U\u0017a\t;fgRTu.\u001b8He>,\boU3tg&|g\u000eV5nK>,H\u000fV8p\u0019\u0006\u0014x-\u001a\u0015\u0005\u0005\u0003\t)\u0010C\u0004\u0003\n\u0001!\t!!6\u0002IQ,7\u000f\u001e&pS:<%o\\;q+:\\gn\\<o\u0007>t7/^7fe:+wo\u0012:pkBDCAa\u0002\u0002v\"9!q\u0002\u0001\u0005\u0002\u0005U\u0017A\u0005;fgRLeN^1mS\u0012<%o\\;q\u0013\u0012DCA!\u0004\u0002v\"9!Q\u0003\u0001\u0005\u0002\u0005U\u0017A\u0005;fgR4\u0016\r\\5e\u0015>Lgn\u0012:pkBDCAa\u0005\u0002v\"9!1\u0004\u0001\u0005\u0002\u0005U\u0017!\n;fgRTu.\u001b8He>,\b/\u00138d_:\u001c\u0018n\u001d;f]R\u0004&o\u001c;pG>dG+\u001f9fQ\u0011\u0011I\"!>\t\u000f\t\u0005\u0002\u0001\"\u0001\u0002V\u00061C/Z:u\u0015>Lgn\u0012:pkBLenY8og&\u001cH/\u001a8u\u000fJ|W\u000f\u001d)s_R|7m\u001c7)\t\t}\u0011Q\u001f\u0005\b\u0005O\u0001A\u0011AAk\u0003%\"Xm\u001d;K_&twI]8vaVs7N\\8x]\u000e{gn];nKJ,\u00050[:uS:<wI]8va\"\"!QEA{\u0011\u001d\u0011i\u0003\u0001C\u0001\u0003+\fQ\u0004^3ti\"+\u0017M\u001d;cK\u0006$xK]8oO\u000e{wN\u001d3j]\u0006$xN\u001d\u0015\u0005\u0005W\t)\u0010C\u0004\u00034\u0001!\t!!6\u00023Q,7\u000f\u001e%fCJ$(-Z1u+:\\gn\\<o\u000fJ|W\u000f\u001d\u0015\u0005\u0005c\t)\u0010C\u0004\u0003:\u0001!\t!!6\u0002SQ,7\u000f\u001e%fCJ$(-Z1u+:\\gn\\<o\u0007>t7/^7fe\u0016C\u0018n\u001d;j]\u001e<%o\\;qQ\u0011\u00119$!>\t\u000f\t}\u0002\u0001\"\u0001\u0002V\u0006\u0001C/Z:u\u0011\u0016\f'\u000f\u001e2fCR\u0014VMY1mC:\u001cW-\u00138Qe><'/Z:tQ\u0011\u0011i$!>\t\u000f\t\u0015\u0003\u0001\"\u0001\u0002V\u0006qB/Z:u\u0011\u0016\f'\u000f\u001e2fCRLE\u000e\\3hC2<UM\\3sCRLwN\u001c\u0015\u0005\u0005\u0007\n)\u0010C\u0004\u0003L\u0001!\t!!6\u0002%Q,7\u000f\u001e,bY&$\u0007*Z1si\n,\u0017\r\u001e\u0015\u0005\u0005\u0013\n)\u0010C\u0004\u0003R\u0001!\t!!6\u0002%Q,7\u000f^*fgNLwN\u001c+j[\u0016|W\u000f\u001e\u0015\u0005\u0005\u001f\n)\u0010C\u0004\u0003X\u0001!\t!!6\u0002;Q,7\u000f\u001e%fCJ$(-Z1u\u001b\u0006Lg\u000e^1j]N\u001cVm]:j_:DCA!\u0016\u0002v\"9!Q\f\u0001\u0005\u0002\u0005U\u0017A\u0007;fgR\u001cu.\\7ji6\u000b\u0017N\u001c;bS:\u001c8+Z:tS>t\u0007\u0006\u0002B.\u0003kDqAa\u0019\u0001\t\u0003\t).A\u0011uKN$8+Z:tS>tG+[7f_V$H)\u001e:j]\u001e\u0014VMY1mC:\u001cW\r\u000b\u0003\u0003b\u0005U\bb\u0002B5\u0001\u0011\u0005\u0011Q[\u0001(i\u0016\u001cHOU3cC2\fgnY3D_6\u0004H.\u001a;fg\n+gm\u001c:f\u001b\u0016l'-\u001a:K_&t7\u000f\u000b\u0003\u0003h\u0005U\bb\u0002B8\u0001\u0011\u0005\u0011Q[\u0001\u001di\u0016\u001cHoU=oG\u001e\u0013x.\u001e9F[B$\u00180Q:tS\u001etW.\u001a8uQ\u0011\u0011i'!>\t\u000f\tU\u0004\u0001\"\u0001\u0002V\u0006YB/Z:u'ft7m\u0012:pkBtu\u000e^\"p_J$\u0017N\\1u_JDCAa\u001d\u0002v\"9!1\u0010\u0001\u0005\u0002\u0005U\u0017!\b;fgR\u001c\u0016P\\2He>,\bO\u0012:p[Vs7N\\8x]\u001e\u0013x.\u001e9)\t\te\u0014Q\u001f\u0005\b\u0005\u0003\u0003A\u0011AAk\u0003y!Xm\u001d;Ts:\u001cwI]8va\u001a\u0013x.\\+oW:|wO\\'f[\n,'\u000f\u000b\u0003\u0003\u0000\u0005U\bb\u0002BD\u0001\u0011\u0005\u0011Q[\u0001#i\u0016\u001cHoU=oG\u001e\u0013x.\u001e9Ge>l\u0017\n\u001c7fO\u0006dw)\u001a8fe\u0006$\u0018n\u001c8)\t\t\u0015\u0015Q\u001f\u0005\b\u0005\u001b\u0003A\u0011AAk\u0003I\"Xm\u001d;K_&twI]8va\u001a\u0013x.\\+oG\"\fgnZ3e\r>dGn\\<fe\u0012{Wm\u001d(piJ+'-\u00197b]\u000e,\u0007\u0006\u0002BF\u0003kDqAa%\u0001\t\u0003\t).A\u0018uKN$(j\\5o\u000fJ|W\u000f\u001d$s_6,fn\u00195b]\u001e,G\rT3bI\u0016\u00148\u000b[8vY\u0012\u0014VMY1mC:\u001cW\r\u000b\u0003\u0003\u0012\u0006U\bb\u0002BM\u0001\u0011\u0005\u0011Q[\u0001\u001di\u0016\u001cH\u000fT3bI\u0016\u0014h)Y5mkJ,\u0017J\\*z]\u000e<%o\\;qQ\u0011\u00119*!>\t\u000f\t}\u0005\u0001\"\u0001\u0002V\u0006\u0001C/Z:u'ft7m\u0012:pkB4u\u000e\u001c7po\u0016\u0014\u0018I\u001a;fe2+\u0017\rZ3sQ\u0011\u0011i*!>\t\u000f\t\u0015\u0006\u0001\"\u0001\u0002V\u0006\u0001C/Z:u'ft7m\u0012:pkBdU-\u00193fe\u00063G/\u001a:G_2dwn^3sQ\u0011\u0011\u0019+!>\t\u000f\t-\u0006\u0001\"\u0001\u0002V\u0006\u0001C/Z:u\u0007>lW.\u001b;PM\u001a\u001cX\r\u001e$s_6,fn\u001b8po:<%o\\;qQ\u0011\u0011I+!>\t\u000f\tE\u0006\u0001\"\u0001\u0002V\u0006)C/Z:u\u0007>lW.\u001b;PM\u001a\u001cX\r^,ji\"$UMZ1vYR<UM\\3sCRLwN\u001c\u0015\u0005\u0005_\u000b)\u0010C\u0004\u00038\u0002!\t!!6\u0002=Q,7\u000f^\"p[6LGo\u00144gg\u0016$\u0018J\\!xC&$\u0018N\\4Ts:\u001c\u0007\u0006\u0002B[\u0003kDqA!0\u0001\t\u0003\t).A\u001buKN$\b*Z1si\n,\u0017\r\u001e#ve&twMU3cC2\fgnY3DCV\u001cXm\u001d*fE\u0006d\u0017M\\2f\u0013:\u0004&o\\4sKN\u001c\b\u0006\u0002B^\u0003kDqAa1\u0001\t\u0003\t).A\u0013uKN$x)\u001a8fe\u0006$\u0018n\u001c8JI&s7M]3nK:$8o\u00148SK\n\fG.\u00198dK\"\"!\u0011YA{\u0011\u001d\u0011I\r\u0001C\u0001\u0003+\fa\u0004^3ti2+\u0017M^3He>,\bo\u0016:p]\u001e\u001cun\u001c:eS:\fGo\u001c:)\t\t\u001d\u0017Q\u001f\u0005\b\u0005\u001f\u0004A\u0011AAk\u0003i!Xm\u001d;MK\u00064Xm\u0012:pkB,fn\u001b8po:<%o\\;qQ\u0011\u0011i-!>\t\u000f\tU\u0007\u0001\"\u0001\u0002V\u0006QC/Z:u\u0019\u0016\fg/Z$s_V\u0004XK\\6o_^t7i\u001c8tk6,'/\u0012=jgRLgnZ$s_V\u0004\b\u0006\u0002Bj\u0003kDqAa7\u0001\t\u0003\t).A\nuKN$h+\u00197jI2+\u0017M^3He>,\b\u000f\u000b\u0003\u0003Z\u0006U\bb\u0002Bq\u0001\u0011\u0005\u0011Q[\u0001#i\u0016\u001cH\u000fT5ti\u001e\u0013x.\u001e9t\u0013:\u001cG.\u001e3fgN#\u0018M\u00197f\u000fJ|W\u000f]:)\t\t}\u0017Q\u001f\u0005\b\u0005O\u0004A\u0011AAk\u0003\u001d\"Xm\u001d;MSN$xI]8vaNLen\u00197vI\u0016\u001c(+\u001a2bY\u0006t7-\u001b8h\u000fJ|W\u000f]:)\t\t\u0015\u0018Q\u001f\u0005\b\u0005[\u0004A\u0011AAk\u0003\u0005\"Xm\u001d;EKN\u001c'/\u001b2f\u000fJ|W\u000f],s_:<7i\\8sI&t\u0017\r^8sQ\u0011\u0011Y/!>\t\u000f\tM\b\u0001\"\u0001\u0002V\u0006qB/Z:u\t\u0016\u001c8M]5cK\u001e\u0013x.\u001e9J]\u0006\u001cG/\u001b<f\u000fJ|W\u000f\u001d\u0015\u0005\u0005c\f)\u0010C\u0004\u0003z\u0002!\t!!6\u0002/Q,7\u000f\u001e#fg\u000e\u0014\u0018NY3He>,\bo\u0015;bE2,\u0007\u0006\u0002B|\u0003kDqAa@\u0001\t\u0003\t).\u0001\u000fuKN$H)Z:de&\u0014Wm\u0012:pkB\u0014VMY1mC:\u001c\u0017N\\4)\t\tu\u0018Q\u001f\u0005\b\u0007\u000b\u0001A\u0011BB\u0004\u0003Y\u0019X\r^;q\u0015>Lgn\u0012:pkB\u001c\u0015\r\u001c7cC\u000e\\WCAB\u0005!\u0019Q\u0002fa\u0003\u0004\u0018A)1QBB\n?5\u00111q\u0002\u0006\u0004\u0007#Y\u0012AC2p]\u000e,(O]3oi&!1QCB\b\u0005\u00191U\u000f^;sKB\u00191\u0011D\f\u000e\u0003\u0001Aqa!\b\u0001\t\u0013\u0019y\"\u0001\ftKR,\boU=oG\u001e\u0013x.\u001e9DC2d'-Y2l+\t\u0019\t\u0003\u0005\u0004\u001bQ\r\r2q\u0005\t\u0007\u0007\u001b\u0019\u0019b!\n\u0011\u0007\reQ\u0005E\u0002\u0004\u001aMBqaa\u000b\u0001\t\u0013\u0019i#\u0001\ftKR,\b\u000fS3beR\u0014W-\u0019;DC2d'-Y2l+\t\u0019y\u0003\u0005\u0004\u001bQ\rE2Q\u0007\t\u0007\u0007\u001b\u0019\u0019ba\r\u0011\u0007\re\u0001\bE\u0002\u0004\u001aiBqa!\u000f\u0001\t\u0013\u0019Y$\u0001\u000etKR,\boQ8n[&$xJ\u001a4tKR\u001c8)\u00197mE\u0006\u001c7.\u0006\u0002\u0004>A1!\u0004KB \u0007\u0007\u0002ba!\u0004\u0004\u0014\r\u0005\u0003cAB\r{A\u00191\u0011\u0004(\t\u000f\r\u001d\u0003\u0001\"\u0003\u0004J\u0005i1/\u001a8e\u0015>Lgn\u0012:pkB$bba\u0003\u0004L\re31LB/\u0007o\u001aY\b\u0003\u0005\u0002\u0002\u000e\u0015\u0003\u0019AB'!\u0011\u0019ye!\u0016\u000f\u0007i\u0019\t&C\u0002\u0004Tm\ta\u0001\u0015:fI\u00164\u0017bA0\u0004X)\u001911K\u000e\t\u0011\u0005E5Q\ta\u0001\u0007\u001bB\u0001\"!#\u0004F\u0001\u00071Q\n\u0005\t\u0003G\u001b)\u00051\u0001\u0004`A11\u0011MB9\u0007krAaa\u0019\u0004n9!1QMB6\u001b\t\u00199GC\u0002\u0004j\u0019\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000f\n\u0007\r=4$A\u0004qC\u000e\\\u0017mZ3\n\t\u0005E61\u000f\u0006\u0004\u0007_Z\u0002#\u0002\u000e)\u0007\u001bR\u0003\"CB=\u0007\u000b\u0002\n\u00111\u0001j\u0003A\u0011XMY1mC:\u001cW\rV5nK>,H\u000fC\u0005\u0004~\r\u0015\u0003\u0013!a\u0001S\u0006q1/Z:tS>tG+[7f_V$\bbBBA\u0001\u0011%11Q\u0001\u0014g\u0016tGmU=oG\u001e\u0013x.\u001e9MK\u0006$WM\u001d\u000b\u000b\u0007G\u0019)ia\"\u0004\f\u000e=\u0005\u0002CAA\u0007\u007f\u0002\ra!\u0014\t\u000f\r%5q\u0010a\u0001S\u0006Qq-\u001a8fe\u0006$\u0018n\u001c8\t\u0011\r55q\u0010a\u0001\u0007\u001b\n\u0001\u0002\\3bI\u0016\u0014\u0018\n\u001a\u0005\t\u0007#\u001by\b1\u0001\u0004\u0014\u0006Q\u0011m]:jO:lWM\u001c;\u0011\u000b\u0001\u001b5Q\n\u0016\t\u000f\r]\u0005\u0001\"\u0003\u0004\u001a\u0006)2/\u001a8e'ft7m\u0012:pkB4u\u000e\u001c7po\u0016\u0014H\u0003CB\u0012\u00077\u001bija(\t\u0011\u0005\u00055Q\u0013a\u0001\u0007\u001bBqa!#\u0004\u0016\u0002\u0007\u0011\u000e\u0003\u0005\u0002\u0012\u000eU\u0005\u0019AB'\u0011\u001d\u0019\u0019\u000b\u0001C\u0005\u0007K\u000b\u0011B[8j]\u001e\u0013x.\u001e9\u0015\u001b}\u00199k!+\u0004,\u000e56qVBY\u0011!\t\ti!)A\u0002\r5\u0003\u0002CAI\u0007C\u0003\ra!\u0014\t\u0011\u0005%5\u0011\u0015a\u0001\u0007\u001bB\u0001\"a)\u0004\"\u0002\u00071q\f\u0005\n\u0007{\u001a\t\u000b%AA\u0002%D\u0011b!\u001f\u0004\"B\u0005\t\u0019A5\t\u000f\rU\u0006\u0001\"\u0003\u00048\u0006\t2/\u001f8d\u000fJ|W\u000f\u001d$pY2|w/\u001a:\u0015\u0015\r\u00152\u0011XB^\u0007\u007f\u001b\t\r\u0003\u0005\u0002\u0002\u000eM\u0006\u0019AB'\u0011\u001d\u0019ila-A\u0002%\fAbZ3oKJ\fG/[8o\u0013\u0012D\u0001\"!%\u00044\u0002\u00071Q\n\u0005\n\u0007{\u001a\u0019\f%AA\u0002%Dqa!2\u0001\t\u0013\u00199-A\bts:\u001cwI]8va2+\u0017\rZ3s)1\u0019)c!3\u0004L\u000e57qZBi\u0011!\t\tia1A\u0002\r5\u0003bBB_\u0007\u0007\u0004\r!\u001b\u0005\t\u0003#\u001b\u0019\r1\u0001\u0004N!A1\u0011SBb\u0001\u0004\u0019\u0019\nC\u0005\u0004~\r\r\u0007\u0013!a\u0001S\"91Q\u001b\u0001\u0005\n\r]\u0017!\u00035fCJ$(-Z1u)!\u0019\u0019d!7\u0004\\\u000e}\u0007\u0002CAA\u0007'\u0004\ra!\u0014\t\u0011\ru71\u001ba\u0001\u0007\u001b\n!bY8ogVlWM]%e\u0011\u001d\u0019ila5A\u0002%Dqaa9\u0001\t\u0013\u0019)/A\u0003bo\u0006LG/\u0006\u0003\u0004h\u000e5HCBBu\u0007\u007f$)\u0001\u0005\u0003\u0004l\u000e5H\u0002\u0001\u0003\t\u0007_\u001c\tO1\u0001\u0004r\n\tA+\u0005\u0003\u0004t\u000ee\bc\u0001\u000e\u0004v&\u00191q_\u000e\u0003\u000f9{G\u000f[5oOB\u0019!da?\n\u0007\ru8DA\u0002B]fD\u0001\u0002\"\u0001\u0004b\u0002\u0007A1A\u0001\u0007MV$XO]3\u0011\r\r511CBu\u0011!!9a!9A\u0002\u0011%\u0011AB7jY2L7\u000fE\u0002\u001b\t\u0017I1\u0001\"\u0004\u001c\u0005\u0011auN\\4\t\u000f\u0011E\u0001\u0001\"\u0003\u0005\u0014\u0005i1m\\7nSR|eMZ:fiN$\"b!\u0011\u0005\u0016\u0011]A\u0011\u0004C\u000e\u0011!\t\t\tb\u0004A\u0002\r5\u0003\u0002CBo\t\u001f\u0001\ra!\u0014\t\u000f\ruFq\u0002a\u0001S\"AAQ\u0004C\b\u0001\u0004!y\"A\u0004pM\u001a\u001cX\r^:\u0011\u000f\u0005%F\u0011E#\u0005$%\u0019A)a+\u0011\t\u0011\u0015B\u0011F\u0007\u0003\tOQ!\u0001\u0013\u0003\n\t\u0011-Bq\u0005\u0002\u0012\u001f\u001a47/\u001a;B]\u0012lU\r^1eCR\f\u0007b\u0002C\u0018\u0001\u0011%A\u0011G\u0001\u000bY\u0016\fg/Z$s_V\u0004HC\u0002C\u001a\tk!9\u0004E\u0002\u0004\u001aEC\u0001\"!!\u0005.\u0001\u00071Q\n\u0005\t\u0007;$i\u00031\u0001\u0004N!IA1\b\u0001\u0012\u0002\u0013%AQH\u0001\u0014U>Lgn\u0012:pkB$C-\u001a4bk2$H%N\u000b\u0003\t\u007fQ3!\u001bC!W\t!\u0019\u0005\u0005\u0003\u0005F\u0011=SB\u0001C$\u0015\u0011!I\u0005b\u0013\u0002\u0013Ut7\r[3dW\u0016$'b\u0001C'7\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0011ECq\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003C+\u0001E\u0005I\u0011\u0002C\u001f\u0003MQw.\u001b8He>,\b\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0011%!I\u0006AI\u0001\n\u0013!i$A\rts:\u001cwI]8va2+\u0017\rZ3sI\u0011,g-Y;mi\u0012*\u0004\"\u0003C/\u0001E\u0005I\u0011\u0002C\u001f\u0003]\u0019XM\u001c3K_&twI]8va\u0012\"WMZ1vYR$S\u0007C\u0005\u0005b\u0001\t\n\u0011\"\u0003\u0005>\u000592/\u001a8e\u0015>Lgn\u0012:pkB$C-\u001a4bk2$HE\u000e\u0005\n\tK\u0002\u0011\u0013!C\u0005\t{\t1d]=oG\u001e\u0013x.\u001e9G_2dwn^3sI\u0011,g-Y;mi\u0012\"\u0004")
public class GroupCoordinatorResponseTest
extends JUnitSuite {
    private final String ClientId;
    private final String ClientHost;
    private final int ConsumerMinSessionTimeout;
    private final int ConsumerMaxSessionTimeout;
    private final int DefaultRebalanceTimeout;
    private final int DefaultSessionTimeout;
    private MockTimer timer = null;
    private GroupCoordinator groupCoordinator = null;
    private ReplicaManager replicaManager = null;
    private KafkaScheduler scheduler = null;
    private ZkUtils zkUtils = null;
    private final String groupId;
    private final String protocolType;
    private final String memberId;
    private final byte[] metadata = (byte[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte());
    private final List<Tuple2<String, byte[]>> protocols = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", (Object)this.metadata())}));
    private int kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId = -1;
    private final String otherGroupId;

    public String ClientId() {
        return this.ClientId;
    }

    public String ClientHost() {
        return this.ClientHost;
    }

    public int ConsumerMinSessionTimeout() {
        return this.ConsumerMinSessionTimeout;
    }

    public int ConsumerMaxSessionTimeout() {
        return this.ConsumerMaxSessionTimeout;
    }

    public int DefaultRebalanceTimeout() {
        return this.DefaultRebalanceTimeout;
    }

    public int DefaultSessionTimeout() {
        return this.DefaultSessionTimeout;
    }

    public MockTimer timer() {
        return this.timer;
    }

    public void timer_$eq(MockTimer x$1) {
        this.timer = x$1;
    }

    public GroupCoordinator groupCoordinator() {
        return this.groupCoordinator;
    }

    public void groupCoordinator_$eq(GroupCoordinator x$1) {
        this.groupCoordinator = x$1;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    public KafkaScheduler scheduler() {
        return this.scheduler;
    }

    public void scheduler_$eq(KafkaScheduler x$1) {
        this.scheduler = x$1;
    }

    public ZkUtils zkUtils() {
        return this.zkUtils;
    }

    public void zkUtils_$eq(ZkUtils x$1) {
        this.zkUtils = x$1;
    }

    private String groupId() {
        return this.groupId;
    }

    private String protocolType() {
        return this.protocolType;
    }

    private String memberId() {
        return this.memberId;
    }

    private byte[] metadata() {
        return this.metadata;
    }

    private List<Tuple2<String, byte[]>> protocols() {
        return this.protocols;
    }

    public int kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId() {
        return this.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId;
    }

    private void kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId_$eq(int x$1) {
        this.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId = x$1;
    }

    private String otherGroupId() {
        return this.otherGroupId;
    }

    @Before
    public void setUp() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, "", TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16());
        props.setProperty(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.ConsumerMinSessionTimeout())).toString());
        props.setProperty(KafkaConfig$.MODULE$.GroupMaxSessionTimeoutMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.ConsumerMaxSessionTimeout())).toString());
        scala.collection.mutable.Map ret = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        ret.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Topic$.MODULE$.GroupMetadataTopicName()), (Object)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})))}))));
        this.replicaManager_$eq((ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class));
        this.zkUtils_$eq((ZkUtils)EasyMock.createNiceMock(ZkUtils.class));
        EasyMock.expect((Object)this.zkUtils().getPartitionAssignmentForTopics((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{Topic$.MODULE$.GroupMetadataTopicName()})))).andReturn((Object)ret);
        EasyMock.replay((Object[])new Object[]{this.zkUtils()});
        this.timer_$eq(new MockTimer());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        String x$17 = "Heartbeat";
        MockTimer x$18 = this.timer();
        int x$19 = config.brokerId();
        boolean x$20 = false;
        int x$21 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        DelayedOperationPurgatory heartbeatPurgatory = new DelayedOperationPurgatory(x$17, (Timer)x$18, x$19, x$21, x$20);
        String x$22 = "Rebalance";
        MockTimer x$23 = this.timer();
        int x$24 = config.brokerId();
        boolean x$25 = false;
        int x$26 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        DelayedOperationPurgatory joinPurgatory = new DelayedOperationPurgatory(x$22, (Timer)x$23, x$24, x$26, x$25);
        this.groupCoordinator_$eq(GroupCoordinator$.MODULE$.apply(config, this.zkUtils(), this.replicaManager(), heartbeatPurgatory, joinPurgatory, (Time)this.timer().time()));
        this.groupCoordinator().startup(false);
        this.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId_$eq(this.groupCoordinator().partitionFor(this.groupId()));
        this.groupCoordinator().groupManager().addPartitionOwnership(this.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId());
    }

    @After
    public void tearDown() {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        if (this.groupCoordinator() != null) {
            this.groupCoordinator().shutdown();
        }
    }

    @Test
    public void testJoinGroupWrongCoordinator() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.otherGroupId(), memberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NOT_COORDINATOR_FOR_GROUP.code(), (long)joinGroupErrorCode);
    }

    @Test
    public void testJoinGroupSessionTimeoutTooSmall() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.protocolType(), this.protocols(), this.ConsumerMinSessionTimeout() - 1, this.joinGroup$default$6());
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.INVALID_SESSION_TIMEOUT.code(), (long)joinGroupErrorCode);
    }

    @Test
    public void testJoinGroupSessionTimeoutTooLarge() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.protocolType(), this.protocols(), this.ConsumerMaxSessionTimeout() + 1, this.joinGroup$default$6());
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.INVALID_SESSION_TIMEOUT.code(), (long)joinGroupErrorCode);
    }

    @Test
    public void testJoinGroupUnknownConsumerNewGroup() {
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), this.memberId(), this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)joinGroupErrorCode);
    }

    @Test
    public void testInvalidGroupId() {
        String groupId = "";
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(groupId, memberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        Assert.assertEquals((long)Errors.INVALID_GROUP_ID.code(), (long)joinGroupResult.errorCode());
    }

    @Test
    public void testValidJoinGroup() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
    }

    @Test
    public void testJoinGroupInconsistentProtocolType() {
        String memberId = "";
        String otherMemberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        JoinGroupResult otherJoinGroupResult = this.joinGroup(this.groupId(), otherMemberId, "connect", this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        Assert.assertEquals((long)Errors.INCONSISTENT_GROUP_PROTOCOL.code(), (long)otherJoinGroupResult.errorCode());
    }

    @Test
    public void testJoinGroupInconsistentGroupProtocol() {
        String memberId = "";
        String otherMemberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.protocolType(), (List<Tuple2<String, byte[]>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"range", (Object)this.metadata())})), this.joinGroup$default$5(), this.joinGroup$default$6());
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        JoinGroupResult otherJoinGroupResult = this.joinGroup(this.groupId(), otherMemberId, this.protocolType(), (List<Tuple2<String, byte[]>>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"roundrobin", (Object)this.metadata())})), this.joinGroup$default$5(), this.joinGroup$default$6());
        Assert.assertEquals((long)Errors.INCONSISTENT_GROUP_PROTOCOL.code(), (long)otherJoinGroupResult.errorCode());
    }

    @Test
    public void testJoinGroupUnknownConsumerExistingGroup() {
        String memberId = "";
        String otherMemberId = "memberId";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        JoinGroupResult otherJoinGroupResult = this.joinGroup(this.groupId(), otherMemberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)otherJoinGroupResult.errorCode());
    }

    @Test
    public void testHeartbeatWrongCoordinator() {
        short heartbeatResult = this.heartbeat(this.otherGroupId(), this.memberId(), -1);
        Assert.assertEquals((long)Errors.NOT_COORDINATOR_FOR_GROUP.code(), (long)heartbeatResult);
    }

    @Test
    public void testHeartbeatUnknownGroup() {
        short heartbeatResult = this.heartbeat(this.groupId(), this.memberId(), -1);
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)heartbeatResult);
    }

    @Test
    public void testHeartbeatUnknownConsumerExistingGroup() {
        String memberId = "";
        String otherMemberId = "memberId";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        String assignedMemberId = joinGroupResult.memberId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), joinGroupResult.generationId(), assignedMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignedMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))), this.syncGroupLeader$default$5());
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short heartbeatResult = this.heartbeat(this.groupId(), otherMemberId, 1);
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)heartbeatResult);
    }

    @Test
    public void testHeartbeatRebalanceInProgress() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        String assignedMemberId = joinGroupResult.memberId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short heartbeatResult = this.heartbeat(this.groupId(), assignedMemberId, 2);
        Assert.assertEquals((long)Errors.REBALANCE_IN_PROGRESS.code(), (long)heartbeatResult);
    }

    @Test
    public void testHeartbeatIllegalGeneration() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        String assignedMemberId = joinGroupResult.memberId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), joinGroupResult.generationId(), assignedMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignedMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))), this.syncGroupLeader$default$5());
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short heartbeatResult = this.heartbeat(this.groupId(), assignedMemberId, 2);
        Assert.assertEquals((long)Errors.ILLEGAL_GENERATION.code(), (long)heartbeatResult);
    }

    @Test
    public void testValidHeartbeat() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        String assignedConsumerId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), generationId, assignedConsumerId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignedConsumerId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))), this.syncGroupLeader$default$5());
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short heartbeatResult = this.heartbeat(this.groupId(), assignedConsumerId, 1);
        Assert.assertEquals((long)Errors.NONE.code(), (long)heartbeatResult);
    }

    @Test
    public void testSessionTimeout() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        String assignedConsumerId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> tuple2 = this.syncGroupLeader(this.groupId(), generationId, assignedConsumerId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignedConsumerId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))), this.syncGroupLeader$default$5());
        if (tuple2 != null) {
            short syncGroupErrorCode;
            short s;
            short syncGroupErrorCode2 = s = (syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)tuple2._2()));
            Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode2);
            EasyMock.reset((Object[])new Object[]{this.replicaManager()});
            EasyMock.expect((Object)this.replicaManager().getPartition(Topic$.MODULE$.GroupMetadataTopicName(), this.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId())).andReturn((Object)None$.MODULE$);
            EasyMock.expect((Object)this.replicaManager().getMessageFormatVersion((TopicAndPartition)EasyMock.anyObject())).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)Message$.MODULE$.MagicValue_V1()))).anyTimes();
            EasyMock.replay((Object[])new Object[]{this.replicaManager()});
            this.timer().advanceClock(this.DefaultSessionTimeout() + 100);
            EasyMock.reset((Object[])new Object[]{this.replicaManager()});
            short heartbeatResult = this.heartbeat(this.groupId(), assignedConsumerId, 1);
            Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)heartbeatResult);
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testHeartbeatMaintainsSession() {
        String memberId = "";
        int sessionTimeout = 1000;
        String x$27 = this.groupId();
        String x$28 = memberId;
        String x$29 = this.protocolType();
        List<Tuple2<String, byte[]>> x$30 = this.protocols();
        int x$31 = sessionTimeout;
        int x$32 = sessionTimeout;
        JoinGroupResult joinGroupResult = this.joinGroup(x$27, x$28, x$29, x$30, x$32, x$31);
        String assignedConsumerId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> tuple2 = this.syncGroupLeader(this.groupId(), generationId, assignedConsumerId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignedConsumerId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))), this.syncGroupLeader$default$5());
        if (tuple2 != null) {
            short syncGroupErrorCode;
            short s;
            short syncGroupErrorCode2 = s = (syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)tuple2._2()));
            Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode2);
            this.timer().advanceClock(sessionTimeout / 2);
            EasyMock.reset((Object[])new Object[]{this.replicaManager()});
            short heartbeatResult = this.heartbeat(this.groupId(), assignedConsumerId, 1);
            Assert.assertEquals((long)Errors.NONE.code(), (long)heartbeatResult);
            this.timer().advanceClock(sessionTimeout / 2 + 100);
            EasyMock.reset((Object[])new Object[]{this.replicaManager()});
            heartbeatResult = this.heartbeat(this.groupId(), assignedConsumerId, 1);
            Assert.assertEquals((long)Errors.NONE.code(), (long)heartbeatResult);
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testCommitMaintainsSession() {
        int sessionTimeout = 1000;
        String memberId = "";
        TopicPartition tp = new TopicPartition("topic", 0);
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(0L);
        String x$33 = this.groupId();
        String x$34 = memberId;
        String x$35 = this.protocolType();
        List<Tuple2<String, byte[]>> x$36 = this.protocols();
        int x$37 = sessionTimeout;
        int x$38 = sessionTimeout;
        JoinGroupResult joinGroupResult = this.joinGroup(x$33, x$34, x$35, x$36, x$38, x$37);
        String assignedConsumerId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> tuple2 = this.syncGroupLeader(this.groupId(), generationId, assignedConsumerId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignedConsumerId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))), this.syncGroupLeader$default$5());
        if (tuple2 != null) {
            short syncGroupErrorCode;
            short s;
            short syncGroupErrorCode2 = s = (syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)tuple2._2()));
            Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode2);
            this.timer().advanceClock(sessionTimeout / 2);
            EasyMock.reset((Object[])new Object[]{this.replicaManager()});
            Map<TopicPartition, Object> commitOffsetResult = this.commitOffsets(this.groupId(), assignedConsumerId, generationId, (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)offset)}))));
            Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)commitOffsetResult.apply((Object)tp)));
            this.timer().advanceClock(sessionTimeout / 2 + 100);
            EasyMock.reset((Object[])new Object[]{this.replicaManager()});
            short heartbeatResult = this.heartbeat(this.groupId(), assignedConsumerId, 1);
            Assert.assertEquals((long)Errors.NONE.code(), (long)heartbeatResult);
            return;
        }
        throw new MatchError(tuple2);
    }

    @Test
    public void testSessionTimeoutDuringRebalance() {
        String x$39 = this.groupId();
        String x$40 = "";
        String x$41 = this.protocolType();
        List<Tuple2<String, byte[]>> x$42 = this.protocols();
        int x$43 = 2000;
        int x$44 = 1000;
        JoinGroupResult firstJoinResult = this.joinGroup(x$39, x$40, x$41, x$42, x$44, x$43);
        String firstMemberId = firstJoinResult.memberId();
        int firstGenerationId = firstJoinResult.generationId();
        Assert.assertEquals((Object)firstMemberId, (Object)firstJoinResult.leaderId());
        Assert.assertEquals((long)Errors.NONE.code(), (long)firstJoinResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> firstSyncResult = this.syncGroupLeader(this.groupId(), firstGenerationId, firstMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)firstMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))), this.syncGroupLeader$default$5());
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)firstSyncResult._2()));
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> otherJoinFuture = this.sendJoinGroup(this.groupId(), "", this.protocolType(), this.protocols(), this.sendJoinGroup$default$5(), this.sendJoinGroup$default$6());
        this.timer().advanceClock(500L);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short heartbeatResult = this.heartbeat(this.groupId(), firstMemberId, firstGenerationId);
        Assert.assertEquals((long)Errors.REBALANCE_IN_PROGRESS.code(), (long)heartbeatResult);
        this.timer().advanceClock(1100L);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        heartbeatResult = this.heartbeat(this.groupId(), firstMemberId, firstGenerationId);
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)heartbeatResult);
        JoinGroupResult otherJoinResult = this.await(otherJoinFuture, this.DefaultSessionTimeout() + 100);
        Assert.assertEquals((long)Errors.NONE.code(), (long)otherJoinResult.errorCode());
    }

    @Test
    public void testRebalanceCompletesBeforeMemberJoins() {
        String x$45 = this.groupId();
        String x$46 = "";
        String x$47 = this.protocolType();
        List<Tuple2<String, byte[]>> x$48 = this.protocols();
        int x$49 = 1200;
        int x$50 = 1000;
        JoinGroupResult firstJoinResult = this.joinGroup(x$45, x$46, x$47, x$48, x$50, x$49);
        String firstMemberId = firstJoinResult.memberId();
        int firstGenerationId = firstJoinResult.generationId();
        Assert.assertEquals((Object)firstMemberId, (Object)firstJoinResult.leaderId());
        Assert.assertEquals((long)Errors.NONE.code(), (long)firstJoinResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> firstSyncResult = this.syncGroupLeader(this.groupId(), firstGenerationId, firstMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)firstMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))), this.syncGroupLeader$default$5());
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)firstSyncResult._2()));
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> otherJoinFuture = this.sendJoinGroup(this.groupId(), "", this.protocolType(), this.protocols(), this.sendJoinGroup$default$5(), this.sendJoinGroup$default$6());
        this.timer().advanceClock(500L);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short heartbeatResult = this.heartbeat(this.groupId(), firstMemberId, firstGenerationId);
        Assert.assertEquals((long)Errors.REBALANCE_IN_PROGRESS.code(), (long)heartbeatResult);
        this.timer().advanceClock(500L);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        heartbeatResult = this.heartbeat(this.groupId(), firstMemberId, firstGenerationId);
        Assert.assertEquals((long)Errors.REBALANCE_IN_PROGRESS.code(), (long)heartbeatResult);
        this.timer().advanceClock(500L);
        JoinGroupResult otherJoinResult = this.await(otherJoinFuture, this.DefaultSessionTimeout() + 100);
        Assert.assertEquals((long)Errors.NONE.code(), (long)otherJoinResult.errorCode());
    }

    @Test
    public void testSyncGroupEmptyAssignment() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        String assignedConsumerId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), generationId, assignedConsumerId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Nil$.MODULE$)), this.syncGroupLeader$default$5());
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        Assert.assertTrue((boolean)Predef$.MODULE$.byteArrayOps((byte[])syncGroupResult._1()).isEmpty());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short heartbeatResult = this.heartbeat(this.groupId(), assignedConsumerId, 1);
        Assert.assertEquals((long)Errors.NONE.code(), (long)heartbeatResult);
    }

    @Test
    public void testSyncGroupNotCoordinator() {
        int generation = 1;
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupFollower(this.otherGroupId(), generation, this.memberId(), this.syncGroupFollower$default$4());
        Assert.assertEquals((long)Errors.NOT_COORDINATOR_FOR_GROUP.code(), (long)BoxesRunTime.unboxToShort((Object)syncGroupResult._2()));
    }

    @Test
    public void testSyncGroupFromUnknownGroup() {
        int generation = 1;
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupFollower(this.groupId(), generation, this.memberId(), this.syncGroupFollower$default$4());
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)BoxesRunTime.unboxToShort((Object)syncGroupResult._2()));
    }

    @Test
    public void testSyncGroupFromUnknownMember() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        String assignedConsumerId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), generationId, assignedConsumerId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignedConsumerId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))), this.syncGroupLeader$default$5());
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        String unknownMemberId = "blah";
        Tuple2<byte[], Object> unknownMemberSyncResult = this.syncGroupFollower(this.groupId(), generationId, unknownMemberId, this.syncGroupFollower$default$4());
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)BoxesRunTime.unboxToShort((Object)unknownMemberSyncResult._2()));
    }

    @Test
    public void testSyncGroupFromIllegalGeneration() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        String assignedConsumerId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), generationId + 1, assignedConsumerId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignedConsumerId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))), this.syncGroupLeader$default$5());
        Assert.assertEquals((long)Errors.ILLEGAL_GENERATION.code(), (long)BoxesRunTime.unboxToShort((Object)syncGroupResult._2()));
    }

    @Test
    public void testJoinGroupFromUnchangedFollowerDoesNotRebalance() {
        JoinGroupResult firstJoinResult = this.joinGroup(this.groupId(), "", this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        String firstMemberId = firstJoinResult.memberId();
        int firstGenerationId = firstJoinResult.generationId();
        Assert.assertEquals((Object)firstMemberId, (Object)firstJoinResult.leaderId());
        Assert.assertEquals((long)Errors.NONE.code(), (long)firstJoinResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> firstSyncResult = this.syncGroupLeader(this.groupId(), firstGenerationId, firstMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)firstMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))), this.syncGroupLeader$default$5());
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)firstSyncResult._2()));
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> otherJoinFuture = this.sendJoinGroup(this.groupId(), "", this.protocolType(), this.protocols(), this.sendJoinGroup$default$5(), this.sendJoinGroup$default$6());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> joinFuture = this.sendJoinGroup(this.groupId(), firstMemberId, this.protocolType(), this.protocols(), this.sendJoinGroup$default$5(), this.sendJoinGroup$default$6());
        JoinGroupResult joinResult = this.await(joinFuture, this.DefaultSessionTimeout() + 100);
        JoinGroupResult otherJoinResult = this.await(otherJoinFuture, this.DefaultSessionTimeout() + 100);
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinResult.errorCode());
        Assert.assertEquals((long)Errors.NONE.code(), (long)otherJoinResult.errorCode());
        Assert.assertTrue((joinResult.generationId() == otherJoinResult.generationId() ? 1 : 0) != 0);
        Assert.assertEquals((Object)firstMemberId, (Object)joinResult.leaderId());
        Assert.assertEquals((Object)firstMemberId, (Object)otherJoinResult.leaderId());
        int nextGenerationId = joinResult.generationId();
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        JoinGroupResult followerJoinResult = this.joinGroup(this.groupId(), otherJoinResult.memberId(), this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        Assert.assertEquals((long)Errors.NONE.code(), (long)followerJoinResult.errorCode());
        Assert.assertEquals((long)nextGenerationId, (long)followerJoinResult.generationId());
    }

    @Test
    public void testJoinGroupFromUnchangedLeaderShouldRebalance() {
        JoinGroupResult firstJoinResult = this.joinGroup(this.groupId(), "", this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        String firstMemberId = firstJoinResult.memberId();
        int firstGenerationId = firstJoinResult.generationId();
        Assert.assertEquals((Object)firstMemberId, (Object)firstJoinResult.leaderId());
        Assert.assertEquals((long)Errors.NONE.code(), (long)firstJoinResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> firstSyncResult = this.syncGroupLeader(this.groupId(), firstGenerationId, firstMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)firstMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))), this.syncGroupLeader$default$5());
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)firstSyncResult._2()));
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        JoinGroupResult secondJoinResult = this.joinGroup(this.groupId(), firstMemberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        Assert.assertEquals((long)Errors.NONE.code(), (long)secondJoinResult.errorCode());
        Assert.assertNotEquals((long)firstGenerationId, (long)secondJoinResult.generationId());
    }

    @Test
    public void testLeaderFailureInSyncGroup() {
        JoinGroupResult firstJoinResult = this.joinGroup(this.groupId(), "", this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        String firstMemberId = firstJoinResult.memberId();
        int firstGenerationId = firstJoinResult.generationId();
        Assert.assertEquals((Object)firstMemberId, (Object)firstJoinResult.leaderId());
        Assert.assertEquals((long)Errors.NONE.code(), (long)firstJoinResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> firstSyncResult = this.syncGroupLeader(this.groupId(), firstGenerationId, firstMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)firstMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))), this.syncGroupLeader$default$5());
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)firstSyncResult._2()));
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> otherJoinFuture = this.sendJoinGroup(this.groupId(), "", this.protocolType(), this.protocols(), this.sendJoinGroup$default$5(), this.sendJoinGroup$default$6());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> joinFuture = this.sendJoinGroup(this.groupId(), firstMemberId, this.protocolType(), this.protocols(), this.sendJoinGroup$default$5(), this.sendJoinGroup$default$6());
        JoinGroupResult joinResult = this.await(joinFuture, this.DefaultSessionTimeout() + 100);
        JoinGroupResult otherJoinResult = this.await(otherJoinFuture, this.DefaultSessionTimeout() + 100);
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinResult.errorCode());
        Assert.assertEquals((long)Errors.NONE.code(), (long)otherJoinResult.errorCode());
        Assert.assertTrue((joinResult.generationId() == otherJoinResult.generationId() ? 1 : 0) != 0);
        Assert.assertEquals((Object)firstMemberId, (Object)joinResult.leaderId());
        Assert.assertEquals((Object)firstMemberId, (Object)otherJoinResult.leaderId());
        int nextGenerationId = joinResult.generationId();
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<Tuple2<byte[], Object>> followerSyncFuture = this.sendSyncGroupFollower(this.groupId(), nextGenerationId, otherJoinResult.memberId());
        this.timer().advanceClock(this.DefaultSessionTimeout() + 100);
        Tuple2<byte[], Object> followerSyncResult = this.await(followerSyncFuture, this.DefaultSessionTimeout() + 100);
        Assert.assertEquals((long)Errors.REBALANCE_IN_PROGRESS.code(), (long)BoxesRunTime.unboxToShort((Object)followerSyncResult._2()));
    }

    @Test
    public void testSyncGroupFollowerAfterLeader() {
        JoinGroupResult firstJoinResult = this.joinGroup(this.groupId(), "", this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        String firstMemberId = firstJoinResult.memberId();
        int firstGenerationId = firstJoinResult.generationId();
        Assert.assertEquals((Object)firstMemberId, (Object)firstJoinResult.leaderId());
        Assert.assertEquals((long)Errors.NONE.code(), (long)firstJoinResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> firstSyncResult = this.syncGroupLeader(this.groupId(), firstGenerationId, firstMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)firstMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))), this.syncGroupLeader$default$5());
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)firstSyncResult._2()));
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> otherJoinFuture = this.sendJoinGroup(this.groupId(), "", this.protocolType(), this.protocols(), this.sendJoinGroup$default$5(), this.sendJoinGroup$default$6());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> joinFuture = this.sendJoinGroup(this.groupId(), firstMemberId, this.protocolType(), this.protocols(), this.sendJoinGroup$default$5(), this.sendJoinGroup$default$6());
        JoinGroupResult joinResult = this.await(joinFuture, this.DefaultSessionTimeout() + 100);
        JoinGroupResult otherJoinResult = this.await(otherJoinFuture, this.DefaultSessionTimeout() + 100);
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinResult.errorCode());
        Assert.assertEquals((long)Errors.NONE.code(), (long)otherJoinResult.errorCode());
        Assert.assertTrue((joinResult.generationId() == otherJoinResult.generationId() ? 1 : 0) != 0);
        Assert.assertEquals((Object)firstMemberId, (Object)joinResult.leaderId());
        Assert.assertEquals((Object)firstMemberId, (Object)otherJoinResult.leaderId());
        int nextGenerationId = joinResult.generationId();
        String leaderId = firstMemberId;
        byte[] leaderAssignment = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte());
        String followerId = otherJoinResult.memberId();
        byte[] followerAssignment = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1}), ClassTag$.MODULE$.Byte());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> leaderSyncResult = this.syncGroupLeader(this.groupId(), nextGenerationId, leaderId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)leaderId), (Object)leaderAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)followerId), (Object)followerAssignment)}))), this.syncGroupLeader$default$5());
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)leaderSyncResult._2()));
        Assert.assertEquals((Object)leaderAssignment, (Object)leaderSyncResult._1());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> followerSyncResult = this.syncGroupFollower(this.groupId(), nextGenerationId, otherJoinResult.memberId(), this.syncGroupFollower$default$4());
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)followerSyncResult._2()));
        Assert.assertEquals((Object)followerAssignment, (Object)followerSyncResult._1());
    }

    @Test
    public void testSyncGroupLeaderAfterFollower() {
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), "", this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        String firstMemberId = joinGroupResult.memberId();
        int firstGenerationId = joinGroupResult.generationId();
        Assert.assertEquals((Object)firstMemberId, (Object)joinGroupResult.leaderId());
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), firstGenerationId, firstMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)firstMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))), this.syncGroupLeader$default$5());
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> otherJoinFuture = this.sendJoinGroup(this.groupId(), "", this.protocolType(), this.protocols(), this.sendJoinGroup$default$5(), this.sendJoinGroup$default$6());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<JoinGroupResult> joinFuture = this.sendJoinGroup(this.groupId(), firstMemberId, this.protocolType(), this.protocols(), this.sendJoinGroup$default$5(), this.sendJoinGroup$default$6());
        JoinGroupResult joinResult = this.await(joinFuture, this.DefaultSessionTimeout() + 100);
        JoinGroupResult otherJoinResult = this.await(otherJoinFuture, this.DefaultSessionTimeout() + 100);
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinResult.errorCode());
        Assert.assertEquals((long)Errors.NONE.code(), (long)otherJoinResult.errorCode());
        Assert.assertTrue((joinResult.generationId() == otherJoinResult.generationId() ? 1 : 0) != 0);
        int nextGenerationId = joinResult.generationId();
        String leaderId = joinResult.leaderId();
        byte[] leaderAssignment = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{0}), ClassTag$.MODULE$.Byte());
        String followerId = otherJoinResult.memberId();
        byte[] followerAssignment = (byte[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapByteArray(new byte[]{1}), ClassTag$.MODULE$.Byte());
        Assert.assertEquals((Object)firstMemberId, (Object)joinResult.leaderId());
        Assert.assertEquals((Object)firstMemberId, (Object)otherJoinResult.leaderId());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Future<Tuple2<byte[], Object>> followerSyncFuture = this.sendSyncGroupFollower(this.groupId(), nextGenerationId, followerId);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> leaderSyncResult = this.syncGroupLeader(this.groupId(), nextGenerationId, leaderId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)leaderId), (Object)leaderAssignment), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)followerId), (Object)followerAssignment)}))), this.syncGroupLeader$default$5());
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)leaderSyncResult._2()));
        Assert.assertEquals((Object)leaderAssignment, (Object)leaderSyncResult._1());
        Tuple2<byte[], Object> followerSyncResult = this.await(followerSyncFuture, this.DefaultSessionTimeout() + 100);
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)followerSyncResult._2()));
        Assert.assertEquals((Object)followerAssignment, (Object)followerSyncResult._1());
    }

    @Test
    public void testCommitOffsetFromUnknownGroup() {
        int generationId = 1;
        TopicPartition tp = new TopicPartition("topic", 0);
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(0L);
        Map<TopicPartition, Object> commitOffsetResult = this.commitOffsets(this.groupId(), this.memberId(), generationId, (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)offset)}))));
        Assert.assertEquals((long)Errors.ILLEGAL_GENERATION.code(), (long)BoxesRunTime.unboxToShort((Object)commitOffsetResult.apply((Object)tp)));
    }

    @Test
    public void testCommitOffsetWithDefaultGeneration() {
        TopicPartition tp = new TopicPartition("topic", 0);
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(0L);
        Map<TopicPartition, Object> commitOffsetResult = this.commitOffsets(this.groupId(), "", -1, (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)offset)}))));
        Assert.assertEquals((long)Errors.NONE.code(), (long)BoxesRunTime.unboxToShort((Object)commitOffsetResult.apply((Object)tp)));
    }

    @Test
    public void testCommitOffsetInAwaitingSync() {
        String memberId = "";
        TopicPartition tp = new TopicPartition("topic", 0);
        OffsetAndMetadata offset = OffsetAndMetadata$.MODULE$.apply(0L);
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        String assignedMemberId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Map<TopicPartition, Object> commitOffsetResult = this.commitOffsets(this.groupId(), assignedMemberId, generationId, (scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata>)((scala.collection.immutable.Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp), (Object)offset)}))));
        Assert.assertEquals((long)Errors.REBALANCE_IN_PROGRESS.code(), (long)BoxesRunTime.unboxToShort((Object)commitOffsetResult.apply((Object)tp)));
    }

    @Test
    public void testHeartbeatDuringRebalanceCausesRebalanceInProgress() {
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), "", this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        String assignedConsumerId = joinGroupResult.memberId();
        int initialGenerationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        this.sendJoinGroup(this.groupId(), "", this.protocolType(), this.protocols(), this.sendJoinGroup$default$5(), this.sendJoinGroup$default$6());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short heartbeatResult = this.heartbeat(this.groupId(), assignedConsumerId, initialGenerationId);
        Assert.assertEquals((long)Errors.REBALANCE_IN_PROGRESS.code(), (long)heartbeatResult);
    }

    @Test
    public void testGenerationIdIncrementsOnRebalance() {
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), "", this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        int initialGenerationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        String memberId = joinGroupResult.memberId();
        Assert.assertEquals((long)1L, (long)initialGenerationId);
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), initialGenerationId, memberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)memberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))), this.syncGroupLeader$default$5());
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        JoinGroupResult otherJoinGroupResult = this.joinGroup(this.groupId(), memberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        int nextGenerationId = otherJoinGroupResult.generationId();
        short otherJoinGroupErrorCode = otherJoinGroupResult.errorCode();
        Assert.assertEquals((long)2L, (long)nextGenerationId);
        Assert.assertEquals((long)Errors.NONE.code(), (long)otherJoinGroupErrorCode);
    }

    @Test
    public void testLeaveGroupWrongCoordinator() {
        String memberId = "";
        short leaveGroupResult = this.leaveGroup(this.otherGroupId(), memberId);
        Assert.assertEquals((long)Errors.NOT_COORDINATOR_FOR_GROUP.code(), (long)leaveGroupResult);
    }

    @Test
    public void testLeaveGroupUnknownGroup() {
        short leaveGroupResult = this.leaveGroup(this.groupId(), this.memberId());
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)leaveGroupResult);
    }

    @Test
    public void testLeaveGroupUnknownConsumerExistingGroup() {
        String memberId = "";
        String otherMemberId = "consumerId";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short leaveGroupResult = this.leaveGroup(this.groupId(), otherMemberId);
        Assert.assertEquals((long)Errors.UNKNOWN_MEMBER_ID.code(), (long)leaveGroupResult);
    }

    @Test
    public void testValidLeaveGroup() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        String assignedMemberId = joinGroupResult.memberId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        short leaveGroupResult = this.leaveGroup(this.groupId(), assignedMemberId);
        Assert.assertEquals((long)Errors.NONE.code(), (long)leaveGroupResult);
    }

    @Test
    public void testListGroupsIncludesStableGroups() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        String assignedMemberId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), generationId, assignedMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignedMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))), this.syncGroupLeader$default$5());
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        Tuple2 tuple2 = this.groupCoordinator().handleListGroups();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Errors error = (Errors)tuple2._1();
            List groups = (List)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)error, (Object)groups);
            Errors error2 = (Errors)tuple23._1();
            List groups2 = (List)tuple23._2();
            Assert.assertEquals((Object)Errors.NONE, (Object)error2);
            Assert.assertEquals((long)1L, (long)groups2.size());
            Assert.assertEquals((Object)new GroupOverview("groupId", "consumer"), (Object)groups2.head());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testListGroupsIncludesRebalancingGroups() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupResult.errorCode());
        Tuple2 tuple2 = this.groupCoordinator().handleListGroups();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Errors error = (Errors)tuple2._1();
            List groups = (List)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)error, (Object)groups);
            Errors error2 = (Errors)tuple23._1();
            List groups2 = (List)tuple23._2();
            Assert.assertEquals((Object)Errors.NONE, (Object)error2);
            Assert.assertEquals((long)1L, (long)groups2.size());
            Assert.assertEquals((Object)new GroupOverview("groupId", "consumer"), (Object)groups2.head());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testDescribeGroupWrongCoordinator() {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2 tuple2 = this.groupCoordinator().handleDescribeGroup(this.otherGroupId());
        if (tuple2 != null) {
            Errors error;
            Errors errors;
            Errors error2 = errors = (error = (Errors)tuple2._1());
            Assert.assertEquals((Object)Errors.NOT_COORDINATOR_FOR_GROUP, (Object)error2);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testDescribeGroupInactiveGroup() {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2 tuple2 = this.groupCoordinator().handleDescribeGroup(this.groupId());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Errors error = (Errors)tuple2._1();
            GroupSummary summary = (GroupSummary)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)error, (Object)summary);
            Errors error2 = (Errors)tuple23._1();
            GroupSummary summary2 = (GroupSummary)tuple23._2();
            Assert.assertEquals((Object)Errors.NONE, (Object)error2);
            Assert.assertEquals((Object)GroupCoordinator$.MODULE$.DeadGroup(), (Object)summary2);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testDescribeGroupStable() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        String assignedMemberId = joinGroupResult.memberId();
        int generationId = joinGroupResult.generationId();
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2<byte[], Object> syncGroupResult = this.syncGroupLeader(this.groupId(), generationId, assignedMemberId, (Map<String, byte[]>)((Map)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)assignedMemberId), Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()))}))), this.syncGroupLeader$default$5());
        short syncGroupErrorCode = BoxesRunTime.unboxToShort((Object)syncGroupResult._2());
        Assert.assertEquals((long)Errors.NONE.code(), (long)syncGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2 tuple2 = this.groupCoordinator().handleDescribeGroup(this.groupId());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Errors error = (Errors)tuple2._1();
            GroupSummary summary = (GroupSummary)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)error, (Object)summary);
            Errors error2 = (Errors)tuple23._1();
            GroupSummary summary2 = (GroupSummary)tuple23._2();
            Assert.assertEquals((Object)Errors.NONE, (Object)error2);
            Assert.assertEquals((Object)this.protocolType(), (Object)summary2.protocolType());
            Assert.assertEquals((Object)"range", (Object)summary2.protocol());
            Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{assignedMemberId})), (Object)summary2.members().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(MemberSummary x$5) {
                    return x$5.memberId();
                }
            }, List$.MODULE$.canBuildFrom()));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testDescribeGroupRebalancing() {
        String memberId = "";
        JoinGroupResult joinGroupResult = this.joinGroup(this.groupId(), memberId, this.protocolType(), this.protocols(), this.joinGroup$default$5(), this.joinGroup$default$6());
        short joinGroupErrorCode = joinGroupResult.errorCode();
        Assert.assertEquals((long)Errors.NONE.code(), (long)joinGroupErrorCode);
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Tuple2 tuple2 = this.groupCoordinator().handleDescribeGroup(this.groupId());
        if (tuple2 != null) {
            Tuple2 tuple22;
            Errors error = (Errors)tuple2._1();
            GroupSummary summary = (GroupSummary)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)error, (Object)summary);
            Errors error2 = (Errors)tuple23._1();
            GroupSummary summary2 = (GroupSummary)tuple23._2();
            Assert.assertEquals((Object)Errors.NONE, (Object)error2);
            Assert.assertEquals((Object)this.protocolType(), (Object)summary2.protocolType());
            Assert.assertEquals((Object)GroupCoordinator$.MODULE$.NoProtocol(), (Object)summary2.protocol());
            Assert.assertEquals((Object)AwaitingSync$.MODULE$.toString(), (Object)summary2.state());
            Assert.assertTrue((boolean)((LinearSeqOptimized)summary2.members().map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(MemberSummary x$7) {
                    return x$7.memberId();
                }
            }, List$.MODULE$.canBuildFrom())).contains((Object)joinGroupResult.memberId()));
            Assert.assertTrue((boolean)summary2.members().forall((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(MemberSummary x$8) {
                    return Predef$.MODULE$.byteArrayOps(x$8.metadata()).isEmpty();
                }
            }));
            Assert.assertTrue((boolean)summary2.members().forall((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(MemberSummary x$9) {
                    return Predef$.MODULE$.byteArrayOps(x$9.assignment()).isEmpty();
                }
            }));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    private Tuple2<Future<JoinGroupResult>, Function1<JoinGroupResult, BoxedUnit>> setupJoinGroupCallback() {
        Promise responsePromise = Promise$.MODULE$.apply();
        Future responseFuture = responsePromise.future();
        Serializable responseCallback = new Serializable(this, responsePromise){
            public static final long serialVersionUID = 0L;
            private final Promise responsePromise$1;

            public final void apply(JoinGroupResult x$10) {
                this.responsePromise$1.success((Object)x$10);
            }
            {
                this.responsePromise$1 = responsePromise$1;
            }
        };
        return new Tuple2((Object)responseFuture, (Object)responseCallback);
    }

    private Tuple2<Future<Tuple2<byte[], Object>>, Function2<byte[], Object, BoxedUnit>> setupSyncGroupCallback() {
        Promise responsePromise = Promise$.MODULE$.apply();
        Future responseFuture = responsePromise.future();
        Serializable responseCallback = new Serializable(this, responsePromise){
            public static final long serialVersionUID = 0L;
            private final Promise responsePromise$2;

            public final void apply(byte[] assignment, short errorCode) {
                this.responsePromise$2.success((Object)new Tuple2((Object)assignment, (Object)BoxesRunTime.boxToShort((short)errorCode)));
            }
            {
                this.responsePromise$2 = responsePromise$2;
            }
        };
        return new Tuple2((Object)responseFuture, (Object)responseCallback);
    }

    private Tuple2<Future<Object>, Function1<Object, BoxedUnit>> setupHeartbeatCallback() {
        Promise responsePromise = Promise$.MODULE$.apply();
        Future responseFuture = responsePromise.future();
        Serializable responseCallback = new Serializable(this, responsePromise){
            public static final long serialVersionUID = 0L;
            private final Promise responsePromise$3;

            public final void apply(short errorCode) {
                this.responsePromise$3.success((Object)BoxesRunTime.boxToShort((short)errorCode));
            }
            {
                this.responsePromise$3 = responsePromise$3;
            }
        };
        return new Tuple2((Object)responseFuture, (Object)responseCallback);
    }

    private Tuple2<Future<Map<TopicPartition, Object>>, Function1<Map<TopicPartition, Object>, BoxedUnit>> setupCommitOffsetsCallback() {
        Promise responsePromise = Promise$.MODULE$.apply();
        Future responseFuture = responsePromise.future();
        Serializable responseCallback = new Serializable(this, responsePromise){
            public static final long serialVersionUID = 0L;
            private final Promise responsePromise$4;

            public final void apply(Map<TopicPartition, Object> offsets) {
                this.responsePromise$4.success(offsets);
            }
            {
                this.responsePromise$4 = responsePromise$4;
            }
        };
        return new Tuple2((Object)responseFuture, (Object)responseCallback);
    }

    private Future<JoinGroupResult> sendJoinGroup(String groupId, String memberId, String protocolType, List<Tuple2<String, byte[]>> protocols, int rebalanceTimeout, int sessionTimeout) {
        Tuple2<Future<JoinGroupResult>, Function1<JoinGroupResult, BoxedUnit>> tuple2 = this.setupJoinGroupCallback();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Future responseFuture = (Future)tuple2._1();
            Function1 responseCallback = (Function1)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)responseFuture, (Object)responseCallback);
            Future responseFuture2 = (Future)tuple23._1();
            Function1 responseCallback2 = (Function1)tuple23._2();
            EasyMock.replay((Object[])new Object[]{this.replicaManager()});
            this.groupCoordinator().handleJoinGroup(groupId, memberId, "clientId", "clientHost", rebalanceTimeout, sessionTimeout, protocolType, protocols, responseCallback2);
            return responseFuture2;
        }
        throw new MatchError(tuple2);
    }

    private int sendJoinGroup$default$5() {
        return this.DefaultRebalanceTimeout();
    }

    private int sendJoinGroup$default$6() {
        return this.DefaultSessionTimeout();
    }

    private Future<Tuple2<byte[], Object>> sendSyncGroupLeader(String groupId, int generation, String leaderId, Map<String, byte[]> assignment) {
        Tuple2<Future<Tuple2<byte[], Object>>, Function2<byte[], Object, BoxedUnit>> tuple2 = this.setupSyncGroupCallback();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Future responseFuture = (Future)tuple2._1();
            Function2 responseCallback = (Function2)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)responseFuture, (Object)responseCallback);
            Future responseFuture2 = (Future)tuple23._1();
            Function2 responseCallback2 = (Function2)tuple23._2();
            Capture capturedArgument = EasyMock.newCapture();
            this.replicaManager().appendMessages(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.anyBoolean(), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)capturedArgument));
            EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, capturedArgument){
                private final /* synthetic */ GroupCoordinatorResponseTest $outer;
                private final Capture capturedArgument$1;

                public void answer() {
                    ((Function1)this.capturedArgument$1.getValue()).apply((Object)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(Topic$.MODULE$.GroupMetadataTopicName(), this.$outer.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId())), (Object)new ProduceResponse.PartitionResponse(Errors.NONE.code(), 0L, -1L))})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.capturedArgument$1 = capturedArgument$1;
                }
            });
            EasyMock.expect((Object)this.replicaManager().getMessageFormatVersion((TopicAndPartition)EasyMock.anyObject())).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)Message$.MODULE$.MagicValue_V1()))).anyTimes();
            EasyMock.replay((Object[])new Object[]{this.replicaManager()});
            this.groupCoordinator().handleSyncGroup(groupId, generation, leaderId, assignment, responseCallback2);
            return responseFuture2;
        }
        throw new MatchError(tuple2);
    }

    private Future<Tuple2<byte[], Object>> sendSyncGroupFollower(String groupId, int generation, String memberId) {
        Tuple2<Future<Tuple2<byte[], Object>>, Function2<byte[], Object, BoxedUnit>> tuple2 = this.setupSyncGroupCallback();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Future responseFuture = (Future)tuple2._1();
            Function2 responseCallback = (Function2)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)responseFuture, (Object)responseCallback);
            Future responseFuture2 = (Future)tuple23._1();
            Function2 responseCallback2 = (Function2)tuple23._2();
            EasyMock.replay((Object[])new Object[]{this.replicaManager()});
            this.groupCoordinator().handleSyncGroup(groupId, generation, memberId, (Map)scala.collection.Map$.MODULE$.empty(), responseCallback2);
            return responseFuture2;
        }
        throw new MatchError(tuple2);
    }

    private JoinGroupResult joinGroup(String groupId, String memberId, String protocolType, List<Tuple2<String, byte[]>> protocols, int sessionTimeout, int rebalanceTimeout) {
        Future<JoinGroupResult> responseFuture = this.sendJoinGroup(groupId, memberId, protocolType, protocols, rebalanceTimeout, sessionTimeout);
        this.timer().advanceClock(10L);
        return (JoinGroupResult)Await$.MODULE$.result(responseFuture, (Duration)Duration$.MODULE$.apply((long)(rebalanceTimeout + 100), TimeUnit.MILLISECONDS));
    }

    private int joinGroup$default$5() {
        return this.DefaultSessionTimeout();
    }

    private int joinGroup$default$6() {
        return this.DefaultRebalanceTimeout();
    }

    private Tuple2<byte[], Object> syncGroupFollower(String groupId, int generationId, String memberId, int sessionTimeout) {
        Future<Tuple2<byte[], Object>> responseFuture = this.sendSyncGroupFollower(groupId, generationId, memberId);
        return (Tuple2)Await$.MODULE$.result(responseFuture, (Duration)Duration$.MODULE$.apply((long)(sessionTimeout + 100), TimeUnit.MILLISECONDS));
    }

    private int syncGroupFollower$default$4() {
        return this.DefaultSessionTimeout();
    }

    private Tuple2<byte[], Object> syncGroupLeader(String groupId, int generationId, String memberId, Map<String, byte[]> assignment, int sessionTimeout) {
        Future<Tuple2<byte[], Object>> responseFuture = this.sendSyncGroupLeader(groupId, generationId, memberId, assignment);
        return (Tuple2)Await$.MODULE$.result(responseFuture, (Duration)Duration$.MODULE$.apply((long)(sessionTimeout + 100), TimeUnit.MILLISECONDS));
    }

    private int syncGroupLeader$default$5() {
        return this.DefaultSessionTimeout();
    }

    private short heartbeat(String groupId, String consumerId, int generationId) {
        Tuple2<Future<Object>, Function1<Object, BoxedUnit>> tuple2 = this.setupHeartbeatCallback();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Future responseFuture = (Future)tuple2._1();
            Function1 responseCallback = (Function1)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)responseFuture, (Object)responseCallback);
            Future responseFuture2 = (Future)tuple23._1();
            Function1 responseCallback2 = (Function1)tuple23._2();
            EasyMock.replay((Object[])new Object[]{this.replicaManager()});
            this.groupCoordinator().handleHeartbeat(groupId, consumerId, generationId, responseCallback2);
            return BoxesRunTime.unboxToShort((Object)Await$.MODULE$.result((Awaitable)responseFuture2, (Duration)Duration$.MODULE$.apply(40L, TimeUnit.MILLISECONDS)));
        }
        throw new MatchError(tuple2);
    }

    private <T> T await(Future<T> future, long millis) {
        return (T)Await$.MODULE$.result(future, (Duration)Duration$.MODULE$.apply(millis, TimeUnit.MILLISECONDS));
    }

    private Map<TopicPartition, Object> commitOffsets(String groupId, String consumerId, int generationId, scala.collection.immutable.Map<TopicPartition, OffsetAndMetadata> offsets) {
        Tuple2<Future<Map<TopicPartition, Object>>, Function1<Map<TopicPartition, Object>, BoxedUnit>> tuple2 = this.setupCommitOffsetsCallback();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Future responseFuture = (Future)tuple2._1();
            Function1 responseCallback = (Function1)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)responseFuture, (Object)responseCallback);
            Future responseFuture2 = (Future)tuple23._1();
            Function1 responseCallback2 = (Function1)tuple23._2();
            Capture capturedArgument = EasyMock.newCapture();
            this.replicaManager().appendMessages(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.anyBoolean(), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)capturedArgument));
            EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, capturedArgument){
                private final /* synthetic */ GroupCoordinatorResponseTest $outer;
                private final Capture capturedArgument$2;

                public void answer() {
                    ((Function1)this.capturedArgument$2.getValue()).apply((Object)scala.collection.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(Topic$.MODULE$.GroupMetadataTopicName(), this.$outer.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId())), (Object)new ProduceResponse.PartitionResponse(Errors.NONE.code(), 0L, -1L))})));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.capturedArgument$2 = capturedArgument$2;
                }
            });
            EasyMock.expect((Object)this.replicaManager().getMessageFormatVersion((TopicAndPartition)EasyMock.anyObject())).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)Message$.MODULE$.MagicValue_V1()))).anyTimes();
            EasyMock.replay((Object[])new Object[]{this.replicaManager()});
            this.groupCoordinator().handleCommitOffsets(groupId, consumerId, generationId, offsets, responseCallback2);
            return (Map)Await$.MODULE$.result((Awaitable)responseFuture2, (Duration)Duration$.MODULE$.apply(40L, TimeUnit.MILLISECONDS));
        }
        throw new MatchError(tuple2);
    }

    private short leaveGroup(String groupId, String consumerId) {
        Tuple2<Future<Object>, Function1<Object, BoxedUnit>> tuple2 = this.setupHeartbeatCallback();
        if (tuple2 != null) {
            Tuple2 tuple22;
            Future responseFuture = (Future)tuple2._1();
            Function1 responseCallback = (Function1)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)responseFuture, (Object)responseCallback);
            Future responseFuture2 = (Future)tuple23._1();
            Function1 responseCallback2 = (Function1)tuple23._2();
            EasyMock.expect((Object)this.replicaManager().getPartition(Topic$.MODULE$.GroupMetadataTopicName(), this.kafka$coordinator$GroupCoordinatorResponseTest$$groupPartitionId())).andReturn((Object)None$.MODULE$);
            EasyMock.expect((Object)this.replicaManager().getMessageFormatVersion((TopicAndPartition)EasyMock.anyObject())).andReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)Message$.MODULE$.MagicValue_V1()))).anyTimes();
            EasyMock.replay((Object[])new Object[]{this.replicaManager()});
            this.groupCoordinator().handleLeaveGroup(groupId, consumerId, responseCallback2);
            return BoxesRunTime.unboxToShort((Object)Await$.MODULE$.result((Awaitable)responseFuture2, (Duration)Duration$.MODULE$.apply(40L, TimeUnit.MILLISECONDS)));
        }
        throw new MatchError(tuple2);
    }

    public GroupCoordinatorResponseTest() {
        this.ClientId = "consumer-test";
        this.ClientHost = "localhost";
        this.ConsumerMinSessionTimeout = 10;
        this.ConsumerMaxSessionTimeout = 1000;
        this.DefaultRebalanceTimeout = 500;
        this.DefaultSessionTimeout = 500;
        this.groupId = "groupId";
        this.protocolType = "consumer";
        this.memberId = "memberId";
        this.otherGroupId = "otherGroup";
    }
}

