/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.Map;
import java.util.Properties;
import kafka.api.ApiVersion$;
import kafka.common.TopicAndPartition;
import kafka.log.FileMessageSet;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.LogTest$;
import kafka.log.TimestampOffset;
import kafka.message.ByteBufferMessageSet;
import kafka.message.ByteBufferMessageSet$;
import kafka.message.CompressionCodec;
import kafka.message.DefaultCompressionCodec$;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageAndOffset;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.message.NoCompressionCodec$;
import kafka.server.FetchDataInfo;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Time;
import org.apache.kafka.common.errors.CorruptRecordException;
import org.apache.kafka.common.errors.OffsetOutOfRangeException;
import org.apache.kafka.common.errors.RecordBatchTooLargeException;
import org.apache.kafka.common.errors.RecordTooLargeException;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\t\rd\u0001B\u0001\u0003\u0001\u001d\u0011q\u0001T8h)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001!\u0019!C\u00013\u00051A/\u001c9ESJ,\u0012A\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\t!![8\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0005\r&dW\r\u0003\u0004$\u0001\u0001\u0006IAG\u0001\bi6\u0004H)\u001b:!\u0011\u001d)\u0003A1A\u0005\u0002e\ta\u0001\\8h\t&\u0014\bBB\u0014\u0001A\u0003%!$A\u0004m_\u001e$\u0015N\u001d\u0011\t\u000f%\u0002!\u0019!C\u0001U\u0005!A/[7f+\u0005Y\u0003C\u0001\u00170\u001b\u0005i#B\u0001\u0018\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0001TF\u0001\u0005N_\u000e\\G+[7f\u0011\u0019\u0011\u0004\u0001)A\u0005W\u0005)A/[7fA!9A\u0007\u0001a\u0001\n\u0003)\u0014AB2p]\u001aLw-F\u00017!\t9$(D\u00019\u0015\tID!\u0001\u0004tKJ4XM]\u0005\u0003wa\u00121bS1gW\u0006\u001cuN\u001c4jO\"9Q\b\u0001a\u0001\n\u0003q\u0014AC2p]\u001aLwm\u0018\u0013fcR\u0011q(\u0012\t\u0003\u0001\u000ek\u0011!\u0011\u0006\u0002\u0005\u0006)1oY1mC&\u0011A)\u0011\u0002\u0005+:LG\u000fC\u0004Gy\u0005\u0005\t\u0019\u0001\u001c\u0002\u0007a$\u0013\u0007\u0003\u0004I\u0001\u0001\u0006KAN\u0001\bG>tg-[4!\u0011\u001dQ\u0005A1A\u0005\u0002-\u000b\u0011\u0002\\8h\u0007>tg-[4\u0016\u00031\u0003\"AF'\n\u00059\u0013!!\u0003'pO\u000e{gNZ5h\u0011\u0019\u0001\u0006\u0001)A\u0005\u0019\u0006QAn\\4D_:4\u0017n\u001a\u0011\t\u000bI\u0003A\u0011A*\u0002\u000bM,G/\u00169\u0015\u0003}B#!U+\u0011\u0005YCV\"A,\u000b\u0005-q\u0011BA-X\u0005\u0019\u0011UMZ8sK\")1\f\u0001C\u0001'\u0006AA/Z1s\t><h\u000e\u000b\u0002[;B\u0011aKX\u0005\u0003?^\u0013Q!\u00114uKJDQ!\u0019\u0001\u0005\u0002\t\fqb\u0019:fCR,W)\u001c9us2{wm\u001d\u000b\u0004\u007f\r,\u0007\"\u00023a\u0001\u0004Q\u0012a\u00013je\")a\r\u0019a\u0001O\u00069qN\u001a4tKR\u001c\bc\u0001!iU&\u0011\u0011.\u0011\u0002\u000byI,\u0007/Z1uK\u0012t\u0004C\u0001!l\u0013\ta\u0017IA\u0002J]RDQA\u001c\u0001\u0005\u0002M\u000bA\u0003^3tiRKW.\u001a\"bg\u0016$Gj\\4S_2d\u0007FA7q!\t1\u0016/\u0003\u0002s/\n!A+Z:u\u0011\u0015!\b\u0001\"\u0001T\u0003i!Xm\u001d;US6,')Y:fI2{wMU8mY*KG\u000f^3sQ\t\u0019\b\u000fC\u0003x\u0001\u0011\u00051+\u0001\u000buKN$8+\u001b>f\u0005\u0006\u001cX\r\u001a'pOJ{G\u000e\u001c\u0015\u0003mBDQA\u001f\u0001\u0005\u0002M\u000b\u0001\u0003^3ti2{\u0017\rZ#naRLHj\\4)\u0005e\u0004\b\"B?\u0001\t\u0003\u0019\u0016A\n;fgR\f\u0005\u000f]3oI\u0006sGMU3bI^KG\u000f[*fcV,g\u000e^5bY>3gm]3ug\"\u0012A\u0010\u001d\u0005\u0007\u0003\u0003\u0001A\u0011A*\u0002SQ,7\u000f^!qa\u0016tG-\u00118e%\u0016\fGmV5uQ:{gnU3rk\u0016tG/[1m\u001f\u001a47/\u001a;tQ\ty\b\u000f\u0003\u0004\u0002\b\u0001!\taU\u0001\u0011i\u0016\u001cHOU3bI\u0006#Hj\\4HCBD3!!\u0002q\u0011\u0019\ti\u0001\u0001C\u0001'\u00061B/Z:u%\u0016\fGmV5uQ6Kg.T3tg\u0006<W\rK\u0002\u0002\fADa!a\u0005\u0001\t\u0003\u0019\u0016!\b;fgR\u0014V-\u00193XSRDGk\\8T[\u0006dG.T1y\u0019\u0016tw\r\u001e5)\u0007\u0005E\u0001\u000f\u0003\u0004\u0002\u001a\u0001!\taU\u0001\u0013i\u0016\u001cHOU3bI>+Ho\u00144SC:<W\rK\u0002\u0002\u0018ADa!a\b\u0001\t\u0003\u0019\u0016\u0001\u0004;fgRdun\u001a*pY2\u001c\bfAA\u000fa\"1\u0011Q\u0005\u0001\u0005\u0002M\u000ba\u0003^3ti\u000e{W\u000e\u001d:fgN,G-T3tg\u0006<Wm\u001d\u0015\u0004\u0003G\u0001\bBBA\u0016\u0001\u0011\u00051+A\u001auKN$H\u000b[1u\u000f\u0006\u0014(-Y4f\u0007>dG.Z2uS:<7+Z4nK:$8\u000fR8fg:$8\t[1oO\u0016|eMZ:fi\"\u001a\u0011\u0011\u00069\t\r\u0005E\u0002\u0001\"\u0001T\u0003]!Xm\u001d;NKN\u001c\u0018mZ3TKR\u001c\u0016N_3DQ\u0016\u001c7\u000eK\u0002\u00020ADa!a\u000e\u0001\t\u0003\u0019\u0016!\b;fgR\u001cu.\u001c9bGR,G\rV8qS\u000e\u001cuN\\:ue\u0006Lg\u000e^:)\u0007\u0005U\u0002\u000f\u0003\u0004\u0002>\u0001!\taU\u0001\u0015i\u0016\u001cH/T3tg\u0006<WmU5{K\u000eCWmY6)\u0007\u0005m\u0002\u000f\u0003\u0004\u0002D\u0001!\taU\u0001\u001fi\u0016\u001cH\u000fT8h%\u0016\u001cwN^3sgR{7i\u001c:sK\u000e$xJ\u001a4tKRD3!!\u0011q\u0011\u0019\tI\u0005\u0001C\u0001'\u0006IC/Z:u\u0005VLG\u000e\u001a+j[\u0016Le\u000eZ3y/\",gNT8u\u0003N\u001c\u0018n\u001a8j]\u001e|eMZ:fiND3!a\u0012q\u0011\u0019\ty\u0005\u0001C\u0001'\u0006\u0001B/Z:u\u0013:$W\r\u001f*fEVLG\u000e\u001a\u0015\u0004\u0003\u001b\u0002\bBBA+\u0001\u0011\u00051+\u0001\u0012uKN$(+\u001a2vS2$G+[7f\u0013:$W\r\u001f$pe>cG-T3tg\u0006<Wm\u001d\u0015\u0004\u0003'\u0002\bBBA.\u0001\u0011\u00051+A\fuKN$8i\u001c:skB$\u0018J\u001c3fqJ+'-^5mI\"\u001a\u0011\u0011\f9\t\r\u0005\u0005\u0004\u0001\"\u0001T\u00039!Xm\u001d;UeVt7-\u0019;f)>D3!a\u0018q\u0011\u0019\t9\u0007\u0001C\u0001'\u0006iB/Z:u\u0013:$W\r\u001f*fg&T\u0018N\\4BiR\u0013XO\\2bi&|g\u000eK\u0002\u0002fADa!!\u001c\u0001\t\u0003\u0019\u0016\u0001\t;fgR\u0014unZ;t\u0013:$W\r_*fO6,g\u000e^:Be\u0016\u0014V-\\8wK\u0012D3!a\u001bq\u0011\u0019\t\u0019\b\u0001C\u0001'\u00061B/Z:u%\u0016|\u0007/\u001a8UQ\u0016tGK];oG\u0006$X\rK\u0002\u0002rADa!!\u001f\u0001\t\u0003\u0019\u0016a\u0004;fgR\f5/\u001f8d\t\u0016dW\r^3)\u0007\u0005]\u0004\u000f\u0003\u0004\u0002\u0000\u0001!\taU\u0001\u001di\u0016\u001cHo\u00149f]\u0012+G.\u001a;fg>\u00137o\u001c7fi\u00164\u0015\u000e\\3tQ\r\ti\b\u001d\u0005\u0007\u0003\u000b\u0003A\u0011A*\u0002AQ,7\u000f^!qa\u0016tG-T3tg\u0006<WmV5uQ:+H\u000e\u001c)bs2|\u0017\r\u001a\u0015\u0004\u0003\u0007\u0003\bBBAF\u0001\u0011\u00051+\u0001\u0018uKN$\u0018\t\u001d9f]\u0012<\u0016\u000e\u001e5PkR|em\u0014:eKJ|eMZ:fiN$\u0006N]8xg\u0016C8-\u001a9uS>t\u0007fBAEa\u0006=\u0015\u0011S\u0001\tKb\u0004Xm\u0019;fI\u000e\u0012\u00111\u0013\t\u0005\u0003+\u000b)K\u0004\u0003\u0002\u0018\u0006\u0005f\u0002BAM\u0003?k!!a'\u000b\u0007\u0005ue!\u0001\u0004=e>|GOP\u0005\u0002\u0005&\u0019\u00111U!\u0002\u000fA\f7m[1hK&!\u0011qUAU\u0005aIE\u000e\\3hC2\f%oZ;nK:$X\t_2faRLwN\u001c\u0006\u0004\u0003G\u000b\u0005BBAW\u0001\u0011\u00051+\u0001\buKN$8i\u001c:skB$Hj\\4)\u0007\u0005-\u0006\u000f\u0003\u0004\u00024\u0002!\taU\u0001\u0016i\u0016\u001cHo\u00117fC:\u001c\u0006.\u001e;e_^tg)\u001b7fQ\r\t\t\f\u001d\u0005\u0007\u0003s\u0003A\u0011A*\u00027Q,7\u000f\u001e)beN,Gk\u001c9jGB\u000b'\u000f^5uS>tg*Y7fQ\r\t9\f\u001d\u0005\u0007\u0003\u007f\u0003A\u0011A*\u0002OQ,7\u000f\u001e)beN,Gk\u001c9jGB\u000b'\u000f^5uS>tg*Y7f\r>\u0014X)\u001c9us:\u000bW.\u001a\u0015\u0004\u0003{\u0003\bBBAc\u0001\u0011\u00051+\u0001\u0012uKN$\b+\u0019:tKR{\u0007/[2QCJ$\u0018\u000e^5p]:\u000bW.\u001a$pe:+H\u000e\u001c\u0015\u0004\u0003\u0007\u0004\bBBAf\u0001\u0011\u00051+\u0001\u0018uKN$\b+\u0019:tKR{\u0007/[2QCJ$\u0018\u000e^5p]:\u000bW.\u001a$pe6K7o]5oON+\u0007/\u0019:bi>\u0014\bfAAea\"1\u0011\u0011\u001b\u0001\u0005\u0002M\u000b!\u0006^3tiB\u000b'o]3U_BL7\rU1si&$\u0018n\u001c8OC6,gi\u001c:NSN\u001c\u0018N\\4U_BL7\rK\u0002\u0002PBDa!a6\u0001\t\u0003\u0019\u0016A\f;fgR\u0004\u0016M]:f)>\u0004\u0018n\u0019)beRLG/[8o\u001d\u0006lWMR8s\u001b&\u001c8/\u001b8h!\u0006\u0014H/\u001b;j_:D3!!6q\u0011\u001d\ti\u000e\u0001C\u0001\u0003?\f!\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|gNT1nKR1\u0011\u0011]Ax\u0003g\u0004B!a9\u0002j:\u0019\u0001)!:\n\u0007\u0005\u001d\u0018)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003W\fiO\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003O\f\u0005\u0002CAy\u00037\u0004\r!!9\u0002\u000bQ|\u0007/[2\t\u0011\u0005U\u00181\u001ca\u0001\u0003C\f\u0011\u0002]1si&$\u0018n\u001c8\t\r\u0005e\b\u0001\"\u0001T\u0003m!Xm\u001d;EK2,G/Z(mIN+w-\\3oiNlU\r\u001e5pI\"\u001a\u0011q\u001f9\t\r\u0005}\b\u0001\"\u0001T\u0003u\u0019\bn\\;mI\u0012+G.\u001a;f'&TXMQ1tK\u0012\u001cVmZ7f]R\u001c\bfAA\u007fa\"1!Q\u0001\u0001\u0005\u0002M\u000bag\u001d5pk2$gj\u001c;EK2,G/Z*ju\u0016\u0014\u0015m]3e'\u0016<W.\u001a8ug^CWM\\+oI\u0016\u0014(+\u001a;f]RLwN\\*ju\u0016D3Aa\u0001q\u0011\u0019\u0011Y\u0001\u0001C\u0001'\u0006i3\u000f[8vY\u0012$U\r\\3uKRKW.\u001a\"bg\u0016$7+Z4nK:$8OU3bIf$vNQ3EK2,G/\u001a3)\u0007\t%\u0001\u000f\u0003\u0004\u0003\u0012\u0001!\taU\u00019g\"|W\u000f\u001c3O_R$U\r\\3uKRKW.\u001a\"bg\u0016$7+Z4nK:$8o\u00165f]:{g.\u001a*fC\u0012LHk\u001c\"f\t\u0016dW\r^3eQ\r\u0011y\u0001\u001d\u0005\u0007\u0005/\u0001A\u0011A*\u0002kMDw.\u001e7e\u001d>$H)\u001a7fi\u0016\u001cVmZ7f]R\u001cx\u000b[3o!>d\u0017nY=E_\u0016\u001chj\u001c;J]\u000edW\u000fZ3EK2,G/\u001a\u0015\u0004\u0005+\u0001\bB\u0002B\u000f\u0001\u0011\u00051+A$tQ>,H\u000e\u001a#fY\u0016$XmU3h[\u0016tGo\u001d*fC\u0012LHk\u001c\"f\t\u0016dW\r^3e/\",gn\u00117fC:,\b\u000fU8mS\u000eL\u0018j]\"p[B\f7\r^!oI\u0012+G.\u001a;fQ\r\u0011Y\u0002\u001d\u0005\b\u0005G\u0001A\u0011\u0001B\u0013\u0003%\u0019'/Z1uK2{w\r\u0006\u0006\u0003(\t5\"\u0011\u0007B\u001b\u0005s\u00012A\u0006B\u0015\u0013\r\u0011YC\u0001\u0002\u0004\u0019><\u0007b\u0002B\u0018\u0005C\u0001\rA[\u0001\u0013[\u0016\u001c8/Y4f'&TX-\u00138CsR,7\u000fC\u0005\u00034\t\u0005\u0002\u0013!a\u0001U\u0006Y!/\u001a;f]RLwN\\'t\u0011%\u00119D!\t\u0011\u0002\u0003\u0007!.\u0001\bsKR,g\u000e^5p]\nKH/Z:\t\u0015\tm\"\u0011\u0005I\u0001\u0002\u0004\t\t/A\u0007dY\u0016\fg.\u001e9Q_2L7-\u001f\u0005\n\u0005\u007f\u0001\u0011\u0013!C\u0001\u0005\u0003\n1c\u0019:fCR,Gj\\4%I\u00164\u0017-\u001e7uII*\"Aa\u0011+\u0007)\u0014)e\u000b\u0002\u0003HA!!\u0011\nB*\u001b\t\u0011YE\u0003\u0003\u0003N\t=\u0013!C;oG\",7m[3e\u0015\r\u0011\t&Q\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002B+\u0005\u0017\u0012\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\u0011I\u0006AI\u0001\n\u0003\u0011\t%A\nde\u0016\fG/\u001a'pO\u0012\"WMZ1vYR$3\u0007C\u0005\u0003^\u0001\t\n\u0011\"\u0001\u0003`\u0005\u00192M]3bi\u0016dun\u001a\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!\u0011\r\u0016\u0005\u0003C\u0014)\u0005")
public class LogTest
extends JUnitSuite {
    private final File tmpDir = TestUtils$.MODULE$.tempDir();
    private final File logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
    private final MockTime time = new MockTime();
    private KafkaConfig config = null;
    private final LogConfig logConfig = LogConfig$.MODULE$.apply();

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public MockTime time() {
        return this.time;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public void config_$eq(KafkaConfig x$1) {
        this.config = x$1;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    @Before
    public void setUp() {
        int x$29 = 0;
        String x$30 = "127.0.0.1:1";
        int x$31 = -1;
        boolean x$32 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$33 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$34 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$35 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$36 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$37 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$38 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$39 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$40 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$41 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$42 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$43 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$44 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$29, x$30, x$32, x$33, x$31, x$34, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44);
        this.config_$eq(KafkaConfig$.MODULE$.fromProps(props));
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    public void createEmptyLogs(File dir, Seq<Object> offsets) {
        offsets.foreach((Function1)new Serializable(this, dir){
            public static final long serialVersionUID = 0L;
            private final File dir$1;

            public final boolean apply(int offset) {
                return this.apply$mcZI$sp(offset);
            }

            public boolean apply$mcZI$sp(int offset) {
                Log$.MODULE$.logFilename(this.dir$1, (long)offset).createNewFile();
                return Log$.MODULE$.indexFilename(this.dir$1, (long)offset).createNewFile();
            }
            {
                this.dir$1 = dir$1;
            }
        });
    }

    @Test
    public void testTimeBasedLogRoll() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4(), TestUtils$.MODULE$.singleMessageSet$default$5());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentMsProp(), Predef$.MODULE$.long2Long(3600L));
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"Log begins with a single empty segment.", (long)1L, (long)log.numberOfSegments());
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().segmentMs()) + 1L);
        log.append(set, log.append$default$2());
        Assert.assertEquals((String)"Log doesn't roll if doing so creates an empty segment.", (long)1L, (long)log.numberOfSegments());
        log.append(set, log.append$default$2());
        Assert.assertEquals((String)"Log rolls on this append since time has expired.", (long)2L, (long)log.numberOfSegments());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3), 5).foreach$mVc$sp((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;
            private final ByteBufferMessageSet set$1;
            private final Log log$1;

            public final void apply(int numSegments) {
                this.apply$mcVI$sp(numSegments);
            }

            public void apply$mcVI$sp(int numSegments) {
                this.$outer.time().sleep(Predef$.MODULE$.Long2long(this.log$1.config().segmentMs()) + 1L);
                this.log$1.append(this.set$1, this.log$1.append$default$2());
                Assert.assertEquals((String)"Changing time beyond rollMs and appending should create a new segment.", (long)numSegments, (long)this.log$1.numberOfSegments());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.set$1 = set$1;
                this.log$1 = log$1;
            }
        });
        byte[] x$45 = "test".getBytes();
        long x$46 = this.time().milliseconds() + Predef$.MODULE$.Long2long(log.config().segmentMs()) + 1L;
        CompressionCodec x$47 = TestUtils$.MODULE$.singleMessageSet$default$2();
        byte[] x$48 = TestUtils$.MODULE$.singleMessageSet$default$3();
        byte x$49 = TestUtils$.MODULE$.singleMessageSet$default$5();
        ByteBufferMessageSet setWithTimestamp = TestUtils$.MODULE$.singleMessageSet(x$45, x$47, x$48, x$46, x$49);
        log.append(setWithTimestamp, log.append$default$2());
        Assert.assertEquals((String)"Segment should not have been rolled out because the log rolling should be based on wall clock.", (long)4L, (long)log.numberOfSegments());
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().segmentMs()) + 1L);
        log.append(setWithTimestamp, log.append$default$2());
        Assert.assertEquals((String)"A new segment should have been rolled out", (long)5L, (long)log.numberOfSegments());
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().segmentMs()) + 1L);
        log.append(setWithTimestamp, log.append$default$2());
        Assert.assertEquals((String)"Log should not roll because the roll should depend on timestamp of the first message.", (long)5L, (long)log.numberOfSegments());
        byte[] x$50 = "test".getBytes();
        long x$51 = this.time().milliseconds();
        CompressionCodec x$52 = TestUtils$.MODULE$.singleMessageSet$default$2();
        byte[] x$53 = TestUtils$.MODULE$.singleMessageSet$default$3();
        byte x$54 = TestUtils$.MODULE$.singleMessageSet$default$5();
        ByteBufferMessageSet setWithExpiredTimestamp = TestUtils$.MODULE$.singleMessageSet(x$50, x$52, x$53, x$51, x$54);
        log.append(setWithExpiredTimestamp, log.append$default$2());
        Assert.assertEquals((String)"Log should roll because the timestamp in the message should make the log segment expire.", (long)6L, (long)log.numberOfSegments());
        int numSegments = log.numberOfSegments();
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().segmentMs()) + 1L);
        log.append(new ByteBufferMessageSet((Seq)Nil$.MODULE$), log.append$default$2());
        Assert.assertEquals((String)"Appending an empty message set should not roll log even if succient time has passed.", (long)numSegments, (long)log.numberOfSegments());
    }

    @Test
    public void testTimeBasedLogRollJitter() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4(), TestUtils$.MODULE$.singleMessageSet$default$5());
        long maxJitter = 1200L;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentMsProp(), Predef$.MODULE$.long2Long(3600L));
        logProps.put(LogConfig$.MODULE$.SegmentJitterMsProp(), Predef$.MODULE$.long2Long(maxJitter));
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"Log begins with a single empty segment.", (long)1L, (long)log.numberOfSegments());
        log.append(set, log.append$default$2());
        this.time().sleep(Predef$.MODULE$.Long2long(log.config().segmentMs()) - maxJitter);
        log.append(set, log.append$default$2());
        Assert.assertEquals((String)"Log does not roll on this append because it occurs earlier than max jitter", (long)1L, (long)log.numberOfSegments());
        this.time().sleep(maxJitter - log.activeSegment().rollJitterMs() + 1L);
        log.append(set, log.append$default$2());
        Assert.assertEquals((String)"Log should roll after segmentMs adjusted by random jitter", (long)2L, (long)log.numberOfSegments());
    }

    @Test
    public void testSizeBasedLogRoll() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4(), TestUtils$.MODULE$.singleMessageSet$default$5());
        int setSize = set.sizeInBytes();
        int msgPerSeg = 10;
        int segmentSize = msgPerSeg * (setSize - 1);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), ApiVersion$.MODULE$.latestVersion().toString());
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"There should be exactly 1 segment.", (long)1L, (long)log.numberOfSegments());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg + 1).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$2;
            private final Log log$2;

            public final LogAppendInfo apply(int i) {
                return this.log$2.append(this.set$2, this.log$2.append$default$2());
            }
            {
                this.set$2 = set$2;
                this.log$2 = log$2;
            }
        });
        Assert.assertEquals((String)"There should be exactly 2 segments.", (long)2L, (long)log.numberOfSegments());
    }

    @Test
    public void testLoadEmptyLog() {
        this.createEmptyLogs(this.logDir(), (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{0}));
        Log log = new Log(this.logDir(), this.logConfig(), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        log.append(TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4(), TestUtils$.MODULE$.singleMessageSet$default$5()), log.append$default$2());
    }

    @Test
    public void testAppendAndReadWithSequentialOffsets() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(71));
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), ApiVersion$.MODULE$.latestVersion().toString());
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Message[] messages2 = (Message[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).by(2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(int id) {
                return new Message(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Message.class));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messages2.length).foreach((Function1)new Serializable(this, log, messages2){
            public static final long serialVersionUID = 0L;
            private final Log log$3;
            private final Message[] messages$1;

            public final LogAppendInfo apply(int i) {
                return this.log$3.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{this.messages$1[i]})), this.log$3.append$default$2());
            }
            {
                this.log$3 = log$3;
                this.messages$1 = messages$1;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messages2.length).foreach$mVc$sp((Function1)new Serializable(this, log, messages2){
            public static final long serialVersionUID = 0L;
            private final Log log$3;
            private final Message[] messages$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                MessageAndOffset read = (MessageAndOffset)this.log$3.read((long)i, 100, (Option)new Some((Object)BoxesRunTime.boxToLong((long)(i + 1))), this.log$3.read$default$4()).messageSet().head();
                Assert.assertEquals((String)"Offset read should match order appended.", (long)i, (long)read.offset());
                Assert.assertEquals((String)"Message should match appended.", (Object)this.messages$1[i], (Object)read.message());
            }
            {
                this.log$3 = log$3;
                this.messages$1 = messages$1;
            }
        });
        Assert.assertEquals((String)"Reading beyond the last message returns nothing.", (long)0L, (long)log.read((long)messages2.length, 100, (Option)None$.MODULE$, log.read$default$4()).messageSet().size());
    }

    @Test
    public void testAppendAndReadWithNonSequentialOffsets() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(71));
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        int[] messageIds = (int[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(50), 200).by(7), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        Message[] messages2 = (Message[])Predef$.MODULE$.intArrayOps(messageIds).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(int id) {
                return new Message(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Message.class)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messages2.length).foreach((Function1)new Serializable(this, log, messageIds, messages2){
            public static final long serialVersionUID = 0L;
            private final Log log$4;
            private final int[] messageIds$1;
            private final Message[] messages$2;

            public final LogAppendInfo apply(int i) {
                return this.log$4.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, new kafka.common.LongRef((long)this.messageIds$1[i]), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{this.messages$2[i]})), false);
            }
            {
                this.log$4 = log$4;
                this.messageIds$1 = messageIds$1;
                this.messages$2 = messages$2;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(50), BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(messageIds).max((Ordering)Ordering.Int$.MODULE$))).foreach$mVc$sp((Function1)new Serializable(this, log, messageIds, messages2){
            public static final long serialVersionUID = 0L;
            private final Log log$4;
            private final int[] messageIds$1;
            private final Message[] messages$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int idx = Predef$.MODULE$.intArrayOps(this.messageIds$1).indexWhere((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final int i$1;

                    public final boolean apply(int x$1) {
                        return this.apply$mcZI$sp(x$1);
                    }

                    public boolean apply$mcZI$sp(int x$1) {
                        return x$1 >= this.i$1;
                    }
                    {
                        this.i$1 = i$1;
                    }
                });
                MessageAndOffset read = (MessageAndOffset)this.log$4.read((long)i, 100, (Option)None$.MODULE$, this.log$4.read$default$4()).messageSet().head();
                Assert.assertEquals((String)"Offset read should match message id.", (long)this.messageIds$1[idx], (long)read.offset());
                Assert.assertEquals((String)"Message should match appended.", (Object)this.messages$2[idx], (Object)read.message());
            }
            {
                this.log$4 = log$4;
                this.messageIds$1 = messageIds$1;
                this.messages$2 = messages$2;
            }
        });
    }

    @Test
    public void testReadAtLogGap() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        while (log.numberOfSegments() == 1) {
            log.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("42".getBytes())})), log.append$default$2());
        }
        ((LogSegment)log.logSegments().head()).truncateTo(1L);
        Assert.assertEquals((String)"A read should now return the last message in the log", (long)(log.logEndOffset() - 1L), (long)((MessageAndOffset)log.read(1L, 200, (Option)None$.MODULE$, log.read$default$4()).messageSet().head()).offset());
    }

    @Test
    public void testReadWithMinMessage() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(71));
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        int[] messageIds = (int[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(50), 200).by(7), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        Message[] messages2 = (Message[])Predef$.MODULE$.intArrayOps(messageIds).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(int id) {
                return new Message(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Message.class)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messages2.length).foreach((Function1)new Serializable(this, log, messageIds, messages2){
            public static final long serialVersionUID = 0L;
            private final Log log$5;
            private final int[] messageIds$2;
            private final Message[] messages$3;

            public final LogAppendInfo apply(int i) {
                return this.log$5.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, new kafka.common.LongRef((long)this.messageIds$2[i]), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{this.messages$3[i]})), false);
            }
            {
                this.log$5 = log$5;
                this.messageIds$2 = messageIds$2;
                this.messages$3 = messages$3;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(50), BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(messageIds).max((Ordering)Ordering.Int$.MODULE$))).foreach$mVc$sp((Function1)new Serializable(this, log, messageIds, messages2){
            public static final long serialVersionUID = 0L;
            private final Log log$5;
            public final int[] messageIds$2;
            public final Message[] messages$3;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                int idx = Predef$.MODULE$.intArrayOps(this.messageIds$2).indexWhere((Function1)new Serializable(this, i){
                    public static final long serialVersionUID = 0L;
                    private final int i$2;

                    public final boolean apply(int x$2) {
                        return this.apply$mcZI$sp(x$2);
                    }

                    public boolean apply$mcZI$sp(int x$2) {
                        return x$2 >= this.i$2;
                    }
                    {
                        this.i$2 = i$2;
                    }
                });
                FetchDataInfo[] fetchDataInfoArray = new FetchDataInfo[3];
                long x$55 = i;
                int x$56 = 1;
                boolean x$57 = true;
                Option x$58 = this.log$5.read$default$3();
                fetchDataInfoArray[0] = this.log$5.read(x$55, x$56, x$58, x$57);
                long x$59 = i;
                int x$60 = 100;
                boolean x$61 = true;
                Option x$62 = this.log$5.read$default$3();
                fetchDataInfoArray[1] = this.log$5.read(x$59, x$60, x$62, x$61);
                fetchDataInfoArray[2] = this.log$5.read((long)i, 100, (Option)new Some((Object)BoxesRunTime.boxToLong((long)10000L)), true);
                Seq reads = (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])fetchDataInfoArray))).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final MessageAndOffset apply(FetchDataInfo x$3) {
                        return (MessageAndOffset)x$3.messageSet().head();
                    }
                }, Seq$.MODULE$.canBuildFrom());
                reads.foreach((Function1)new Serializable(this, idx){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testReadWithMinMessage$1 $outer;
                    private final int idx$1;

                    public final void apply(MessageAndOffset read) {
                        Assert.assertEquals((String)"Offset read should match message id.", (long)this.$outer.messageIds$2[this.idx$1], (long)read.offset());
                        Assert.assertEquals((String)"Message should match appended.", (Object)this.$outer.messages$3[this.idx$1], (Object)read.message());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.idx$1 = idx$1;
                    }
                });
                Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.log$5.read((long)i, 1, (Option)new Some((Object)BoxesRunTime.boxToLong((long)1L)), true).messageSet().toIndexedSeq());
            }
            {
                this.log$5 = log$5;
                this.messageIds$2 = messageIds$2;
                this.messages$3 = messages$3;
            }
        });
    }

    @Test
    public void testReadWithTooSmallMaxLength() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(71));
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        int[] messageIds = (int[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(50), 200).by(7), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Int());
        Message[] messages2 = (Message[])Predef$.MODULE$.intArrayOps(messageIds).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(int id) {
                return new Message(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Message.class)));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messages2.length).foreach((Function1)new Serializable(this, log, messageIds, messages2){
            public static final long serialVersionUID = 0L;
            private final Log log$6;
            private final int[] messageIds$3;
            private final Message[] messages$4;

            public final LogAppendInfo apply(int i) {
                return this.log$6.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, new kafka.common.LongRef((long)this.messageIds$3[i]), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{this.messages$4[i]})), false);
            }
            {
                this.log$6 = log$6;
                this.messageIds$3 = messageIds$3;
                this.messages$4 = messages$4;
            }
        });
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(50), BoxesRunTime.unboxToInt((Object)Predef$.MODULE$.intArrayOps(messageIds).max((Ordering)Ordering.Int$.MODULE$))).foreach$mVc$sp((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final Log log$6;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((Object)MessageSet$.MODULE$.Empty(), (Object)this.log$6.read((long)i, 0, this.log$6.read$default$3(), this.log$6.read$default$4()).messageSet());
                FetchDataInfo fetchInfo = this.log$6.read((long)i, 1, this.log$6.read$default$3(), this.log$6.read$default$4());
                Assert.assertTrue((boolean)fetchInfo.firstMessageSetIncomplete());
                Assert.assertTrue((boolean)(fetchInfo.messageSet() instanceof FileMessageSet));
                Assert.assertEquals((long)1L, (long)fetchInfo.messageSet().sizeInBytes());
            }
            {
                this.log$6 = log$6;
            }
        });
    }

    @Test
    public void testReadOutOfRange() {
        this.createEmptyLogs(this.logDir(), (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{1024}));
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        log.append(new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("42".getBytes())})), log.append$default$2());
        Assert.assertEquals((String)"Reading at the log end offset should produce 0 byte read.", (long)0L, (long)log.read(1025L, 1000, log.read$default$3(), log.read$default$4()).messageSet().sizeInBytes());
        try {
            log.read(0L, 1000, log.read$default$3(), log.read$default$4());
            throw this.fail("Reading below the log start offset should throw OffsetOutOfRangeException", new Position("LogTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 327));
        }
        catch (OffsetOutOfRangeException offsetOutOfRangeException) {
            try {
                log.read(1026L, 1000, log.read$default$3(), log.read$default$4());
                throw this.fail("Reading at beyond the log end offset should throw OffsetOutOfRangeException", new Position("LogTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 334));
            }
            catch (OffsetOutOfRangeException offsetOutOfRangeException2) {
                Assert.assertEquals((String)"Reading from below the specified maxOffset should produce 0 byte read.", (long)0L, (long)log.read(1025L, 1000, (Option)new Some((Object)BoxesRunTime.boxToLong((long)1024L)), log.read$default$4()).messageSet().sizeInBytes());
                return;
            }
        }
    }

    @Test
    public void testLogRolls() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        int numMessages = 100;
        IndexedSeq messageSets = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ByteBufferMessageSet apply(int i) {
                return TestUtils$.MODULE$.singleMessageSet(((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4(), TestUtils$.MODULE$.singleMessageSet$default$5());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        messageSets.foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final Log log$7;

            public final LogAppendInfo apply(ByteBufferMessageSet x$4) {
                return this.log$7.append(x$4, this.log$7.append$default$2());
            }
            {
                this.log$7 = log$7;
            }
        });
        log.flush();
        LongRef offset = LongRef.create((long)0L);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, log, messageSets, offset){
            public static final long serialVersionUID = 0L;
            private final Log log$7;
            private final IndexedSeq messageSets$1;
            private final LongRef offset$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                MessageSet messages2 = this.log$7.read(this.offset$1.elem, 0x100000, this.log$7.read$default$3(), this.log$7.read$default$4()).messageSet();
                Assert.assertEquals((String)"Offsets not equal", (long)this.offset$1.elem, (long)((MessageAndOffset)messages2.head()).offset());
                Assert.assertEquals((String)new StringBuilder().append((Object)"Messages not equal at offset ").append((Object)BoxesRunTime.boxToLong((long)this.offset$1.elem)).toString(), (Object)((MessageAndOffset)((IterableLike)this.messageSets$1.apply(i)).head()).message(), (Object)((MessageAndOffset)messages2.head()).message().toFormatVersion(((MessageAndOffset)((IterableLike)this.messageSets$1.apply(i)).head()).message().magic()));
                this.offset$1.elem = ((MessageAndOffset)messages2.head()).offset() + 1L;
            }
            {
                this.log$7 = log$7;
                this.messageSets$1 = messageSets$1;
                this.offset$1 = offset$1;
            }
        });
        MessageSet lastRead = log.read((long)numMessages, 0x100000, (Option)new Some((Object)BoxesRunTime.boxToLong((long)(numMessages + 1))), log.read$default$4()).messageSet();
        Assert.assertEquals((String)"Should be no more messages", (long)0L, (long)lastRead.size());
        TestUtils$.MODULE$.retry(1000L, (Function0<BoxedUnit>)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final Log log$7;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Assert.assertTrue((String)"Log role should have forced flush", (this.log$7.recoveryPoint() >= this.log$7.activeSegment().baseOffset() ? 1 : 0) != 0);
            }
            {
                this.log$7 = log$7;
            }
        });
    }

    @Test
    public void testCompressedMessages() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        log.append(new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("hello".getBytes()), new Message("there".getBytes())})), log.append$default$2());
        log.append(new ByteBufferMessageSet((CompressionCodec)DefaultCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("alpha".getBytes()), new Message("beta".getBytes())})), log.append$default$2());
        Assert.assertEquals((String)"Read at offset 0 should produce 0", (long)0L, (long)((MessageAndOffset)this.read$1(0, log).next()).offset());
        Assert.assertEquals((String)"Read at offset 1 should produce 0", (long)0L, (long)((MessageAndOffset)this.read$1(1, log).next()).offset());
        Assert.assertEquals((String)"Read at offset 2 should produce 2", (long)2L, (long)((MessageAndOffset)this.read$1(2, log).next()).offset());
        Assert.assertEquals((String)"Read at offset 3 should produce 2", (long)2L, (long)((MessageAndOffset)this.read$1(3, log).next()).offset());
    }

    @Test
    public void testThatGarbageCollectingSegmentsDoesntChangeOffset() {
        List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 25})).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;

            public final void apply(int messagesToAppend) {
                this.apply$mcVI$sp(messagesToAppend);
            }

            public void apply$mcVI$sp(int messagesToAppend) {
                this.$outer.logDir().mkdirs();
                Properties logProps = new Properties();
                logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
                logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(0));
                Log log = new Log(this.$outer.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.$outer.time().scheduler(), (Time)this.$outer.time());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), messagesToAppend).foreach((Function1)new Serializable(this, log){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testThatGarbageCollectingSegmentsDoesntChangeOffset$1 $outer;
                    private final Log log$9;

                    public final LogAppendInfo apply(int i) {
                        byte[] x$63 = ((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes();
                        long x$64 = this.$outer.kafka$log$LogTest$$anonfun$$$outer().time().milliseconds() - 10L;
                        CompressionCodec x$65 = TestUtils$.MODULE$.singleMessageSet$default$2();
                        byte[] x$66 = TestUtils$.MODULE$.singleMessageSet$default$3();
                        byte x$67 = TestUtils$.MODULE$.singleMessageSet$default$5();
                        return this.log$9.append(TestUtils$.MODULE$.singleMessageSet(x$63, x$65, x$66, x$64, x$67), this.log$9.append$default$2());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.log$9 = log$9;
                    }
                });
                long currOffset = log.logEndOffset();
                Assert.assertEquals((long)currOffset, (long)messagesToAppend);
                log.deleteOldSegments();
                Assert.assertEquals((String)"Deleting segments shouldn't have changed the logEndOffset", (long)currOffset, (long)log.logEndOffset());
                Assert.assertEquals((String)"We should still have one segment left", (long)1L, (long)log.numberOfSegments());
                Assert.assertEquals((String)"Further collection shouldn't delete anything", (long)0L, (long)log.deleteOldSegments());
                Assert.assertEquals((String)"Still no change in the logEndOffset", (long)currOffset, (long)log.logEndOffset());
                Assert.assertEquals((String)"Should still be able to append and should get the logEndOffset assigned to the new append", (long)currOffset, (long)log.append(TestUtils$.MODULE$.singleMessageSet("hello".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4(), TestUtils$.MODULE$.singleMessageSet$default$5()), log.append$default$2()).firstOffset());
                log.delete();
            }

            public /* synthetic */ LogTest kafka$log$LogTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testMessageSetSizeCheck() {
        ByteBufferMessageSet messageSet = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("You".getBytes()), new Message("bethe".getBytes())}));
        int configSegmentSize = messageSet.sizeInBytes() - 1;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(configSegmentSize));
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), ApiVersion$.MODULE$.latestVersion().toString());
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        try {
            log.append(messageSet, log.append$default$2());
            throw this.fail("message set should throw RecordBatchTooLargeException.", new Position("LogTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 449));
        }
        catch (RecordBatchTooLargeException recordBatchTooLargeException) {
            return;
        }
    }

    @Test
    public void testCompactedTopicConstraints() {
        Message keyedMessage = new Message("this message has a key".getBytes(), "and here it is".getBytes(), Message$.MODULE$.NoTimestamp(), Message$.MODULE$.CurrentMagicValue());
        Message anotherKeyedMessage = new Message("this message also has a key".getBytes(), "another key".getBytes(), Message$.MODULE$.NoTimestamp(), Message$.MODULE$.CurrentMagicValue());
        Message unkeyedMessage = new Message("this message does not have a key".getBytes());
        ByteBufferMessageSet messageSetWithUnkeyedMessage = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{unkeyedMessage, keyedMessage}));
        ByteBufferMessageSet messageSetWithOneUnkeyedMessage = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{unkeyedMessage}));
        ByteBufferMessageSet messageSetWithCompressedKeyedMessage = new ByteBufferMessageSet((CompressionCodec)GZIPCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{keyedMessage}));
        ByteBufferMessageSet messageSetWithCompressedUnkeyedMessage = new ByteBufferMessageSet((CompressionCodec)GZIPCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{keyedMessage, unkeyedMessage}));
        ByteBufferMessageSet messageSetWithKeyedMessage = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{keyedMessage}));
        ByteBufferMessageSet messageSetWithKeyedMessages = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{keyedMessage, anotherKeyedMessage}));
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        try {
            log.append(messageSetWithUnkeyedMessage, log.append$default$2());
            throw this.fail("Compacted topics cannot accept a message without a key.", new Position("LogTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 476));
        }
        catch (CorruptRecordException corruptRecordException) {
            try {
                log.append(messageSetWithOneUnkeyedMessage, log.append$default$2());
                throw this.fail("Compacted topics cannot accept a message without a key.", new Position("LogTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 482));
            }
            catch (CorruptRecordException corruptRecordException2) {
                try {
                    log.append(messageSetWithCompressedUnkeyedMessage, log.append$default$2());
                    throw this.fail("Compacted topics cannot accept a message without a key.", new Position("LogTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 488));
                }
                catch (CorruptRecordException corruptRecordException3) {
                    log.append(messageSetWithKeyedMessage, log.append$default$2());
                    log.append(messageSetWithKeyedMessages, log.append$default$2());
                    log.append(messageSetWithCompressedKeyedMessage, log.append$default$2());
                    return;
                }
            }
        }
    }

    @Test
    public void testMessageSizeCheck() {
        ByteBufferMessageSet first = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("You".getBytes()), new Message("bethe".getBytes())}));
        ByteBufferMessageSet second = new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message("change (I need more bytes)".getBytes())}));
        int maxMessageSize = second.sizeInBytes() - 1;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(maxMessageSize));
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        log.append(first, log.append$default$2());
        try {
            log.append(second, log.append$default$2());
            throw this.fail("Second message set should throw MessageSizeTooLargeException.", new Position("LogTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 519));
        }
        catch (RecordTooLargeException recordTooLargeException) {
            return;
        }
    }

    @Test
    public void testLogRecoversToCorrectOffset() {
        int numMessages = 100;
        int messageSize = 100;
        int segmentSize = 7 * messageSize;
        int indexInterval = 3 * messageSize;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(indexInterval));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(4096));
        LogConfig config = new LogConfig((Map)logProps);
        ObjectRef log = ObjectRef.create((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1)new Serializable(this, messageSize, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;
            private final int messageSize$1;
            private final ObjectRef log$10;

            public final LogAppendInfo apply(int i) {
                Log qual$1 = (Log)this.log$10.elem;
                byte[] x$68 = TestUtils$.MODULE$.randomBytes(this.messageSize$1);
                long x$69 = this.$outer.time().milliseconds() + (long)(i * 10);
                CompressionCodec x$70 = TestUtils$.MODULE$.singleMessageSet$default$2();
                byte[] x$71 = TestUtils$.MODULE$.singleMessageSet$default$3();
                byte x$72 = TestUtils$.MODULE$.singleMessageSet$default$5();
                ByteBufferMessageSet x$73 = TestUtils$.MODULE$.singleMessageSet(x$68, x$70, x$71, x$69, x$72);
                boolean x$74 = qual$1.append$default$2();
                return qual$1.append(x$73, x$74);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.messageSize$1 = messageSize$1;
                this.log$10 = log$10;
            }
        });
        Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("After appending %d messages to an empty log, the log end offset should be %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages), BoxesRunTime.boxToInteger((int)numMessages)})), (long)numMessages, (long)((Log)log.elem).logEndOffset());
        long lastIndexOffset = ((Log)log.elem).activeSegment().index().lastOffset();
        int numIndexEntries = ((Log)log.elem).activeSegment().index().entries();
        long lastOffset = ((Log)log.elem).logEndOffset();
        long lastTimeIndexOffset = ((Log)log.elem).logEndOffset() - 1L;
        long lastTimeIndexTimestamp = ((Log)log.elem).activeSegment().largestTimestamp();
        int numTimeIndexEntries = ((Log)log.elem).activeSegment().timeIndex().entries() + (((Log)log.elem).activeSegment().timeIndex().lastEntry().offset() == ((Log)log.elem).logEndOffset() - 1L ? 0 : 1);
        ((Log)log.elem).close();
        log.elem = new Log(this.logDir(), config, lastOffset, (Scheduler)this.time().scheduler(), (Time)this.time());
        this.verifyRecoveredLog$1((Log)log.elem, numMessages, lastIndexOffset, numIndexEntries, lastTimeIndexOffset, lastTimeIndexTimestamp, numTimeIndexEntries);
        ((Log)log.elem).close();
        log.elem = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        this.verifyRecoveredLog$1((Log)log.elem, numMessages, lastIndexOffset, numIndexEntries, lastTimeIndexOffset, lastTimeIndexTimestamp, numTimeIndexEntries);
        ((Log)log.elem).close();
    }

    @Test
    public void testBuildTimeIndexWhenNotAssigningOffsets() {
        int numMessages = 100;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(10000));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig config = new LogConfig((Map)logProps);
        Log log = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        IndexedSeq messages2 = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;

            public final ByteBufferMessageSet apply(int i) {
                return new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, new kafka.common.LongRef((long)(100 + i)), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(((Object)BoxesRunTime.boxToInteger((int)i)).toString().getBytes(), this.$outer.time().milliseconds() + (long)i, Message$.MODULE$.MagicValue_V1())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        messages2.foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final Log log$11;

            public final LogAppendInfo apply(ByteBufferMessageSet x$5) {
                return this.log$11.append(x$5, false);
            }
            {
                this.log$11 = log$11;
            }
        });
        int timeIndexEntries = BoxesRunTime.unboxToInt((Object)log.logSegments().foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(int entries, LogSegment segment) {
                return entries + segment.timeIndex().entries();
            }
        }));
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There should be ", " time index entries"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(numMessages - 1))})), (long)(numMessages - 1), (long)timeIndexEntries);
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The last time index entry should have timestamp ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)(this.time().milliseconds() + (long)numMessages - 1L))})), (long)(this.time().milliseconds() + (long)numMessages - 1L), (long)log.activeSegment().timeIndex().lastEntry().timestamp());
    }

    @Test
    public void testIndexRebuild() {
        int numMessages = 200;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(200));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig config = new LogConfig((Map)logProps);
        ObjectRef log = ObjectRef.create((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;
            private final ObjectRef log$12;

            public final LogAppendInfo apply(int i) {
                Log qual$2 = (Log)this.log$12.elem;
                byte[] x$75 = TestUtils$.MODULE$.randomBytes(10);
                long x$76 = this.$outer.time().milliseconds() + (long)(i * 10);
                CompressionCodec x$77 = TestUtils$.MODULE$.singleMessageSet$default$2();
                byte[] x$78 = TestUtils$.MODULE$.singleMessageSet$default$3();
                byte x$79 = TestUtils$.MODULE$.singleMessageSet$default$5();
                ByteBufferMessageSet x$80 = TestUtils$.MODULE$.singleMessageSet(x$75, x$77, x$78, x$76, x$79);
                boolean x$81 = qual$2.append$default$2();
                return qual$2.append(x$80, x$81);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$12 = log$12;
            }
        });
        Iterable indexFiles = (Iterable)((Log)log.elem).logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$6) {
                return x$6.index().file();
            }
        }, Iterable$.MODULE$.canBuildFrom());
        Iterable timeIndexFiles = (Iterable)((Log)log.elem).logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$7) {
                return x$7.timeIndex().file();
            }
        }, Iterable$.MODULE$.canBuildFrom());
        ((Log)log.elem).close();
        indexFiles.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$8) {
                return x$8.delete();
            }
        });
        timeIndexFiles.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$9) {
                return x$9.delete();
            }
        });
        log.elem = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("Should have %d messages when log is reopened")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages)})), (long)numMessages, (long)((Log)log.elem).logEndOffset());
        Assert.assertTrue((String)"The index should have been rebuilt", (((LogSegment)((Log)log.elem).logSegments().head()).index().entries() > 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)"The time index should have been rebuilt", (((LogSegment)((Log)log.elem).logSegments().head()).timeIndex().entries() > 0 ? 1 : 0) != 0);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;
            private final ObjectRef log$12;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Log qual$3 = (Log)this.log$12.elem;
                long x$82 = i;
                int x$83 = 100;
                None$ x$84 = None$.MODULE$;
                boolean x$85 = qual$3.read$default$4();
                Assert.assertEquals((long)i, (long)((MessageAndOffset)qual$3.read(x$82, x$83, (Option)x$84, x$85).messageSet().head()).offset());
                if (i == 0) {
                    Assert.assertEquals((long)((LogSegment)((Log)this.log$12.elem).logSegments().head()).baseOffset(), (long)((TimestampOffset)((Log)this.log$12.elem).fetchOffsetsByTimestamp(this.$outer.time().milliseconds() + (long)(i * 10)).get()).offset());
                } else {
                    Assert.assertEquals((long)i, (long)((TimestampOffset)((Log)this.log$12.elem).fetchOffsetsByTimestamp(this.$outer.time().milliseconds() + (long)(i * 10)).get()).offset());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$12 = log$12;
            }
        });
        ((Log)log.elem).close();
    }

    @Test
    public void testRebuildTimeIndexForOldMessages() {
        int numMessages = 200;
        int segmentSize = 200;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.MessageFormatVersionProp(), "0.9.0");
        LogConfig config = new LogConfig((Map)logProps);
        ObjectRef log = ObjectRef.create((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;
            private final ObjectRef log$13;

            public final LogAppendInfo apply(int i) {
                Log qual$4 = (Log)this.log$13.elem;
                byte[] x$86 = TestUtils$.MODULE$.randomBytes(10);
                long x$87 = this.$outer.time().milliseconds() + (long)(i * 10);
                CompressionCodec x$88 = TestUtils$.MODULE$.singleMessageSet$default$2();
                byte[] x$89 = TestUtils$.MODULE$.singleMessageSet$default$3();
                byte x$90 = TestUtils$.MODULE$.singleMessageSet$default$5();
                ByteBufferMessageSet x$91 = TestUtils$.MODULE$.singleMessageSet(x$86, x$88, x$89, x$87, x$90);
                boolean x$92 = qual$4.append$default$2();
                return qual$4.append(x$91, x$92);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$13 = log$13;
            }
        });
        Iterable timeIndexFiles = (Iterable)((Log)log.elem).logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$10) {
                return x$10.timeIndex().file();
            }
        }, Iterable$.MODULE$.canBuildFrom());
        ((Log)log.elem).close();
        timeIndexFiles.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$11) {
                return x$11.delete();
            }
        });
        log.elem = new Log(this.logDir(), config, (long)(numMessages + 1), (Scheduler)this.time().scheduler(), (Time)this.time());
        LogSegment[] segArray = (LogSegment[])((Log)log.elem).logSegments().toArray(ClassTag$.MODULE$.apply(LogSegment.class));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.refArrayOps((Object[])segArray).size() - 1).foreach$mVc$sp((Function1)new Serializable(this, segArray){
            public static final long serialVersionUID = 0L;
            private final LogSegment[] segArray$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((String)"The time index should be empty", (long)0L, (long)this.segArray$1[i].timeIndex().entries());
            }
            {
                this.segArray$1 = segArray$1;
            }
        });
    }

    @Test
    public void testCorruptIndexRebuild() {
        int numMessages = 200;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(200));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig config = new LogConfig((Map)logProps);
        ObjectRef log = ObjectRef.create((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;
            private final ObjectRef log$14;

            public final LogAppendInfo apply(int i) {
                Log qual$5 = (Log)this.log$14.elem;
                byte[] x$93 = TestUtils$.MODULE$.randomBytes(10);
                long x$94 = this.$outer.time().milliseconds() + (long)(i * 10);
                CompressionCodec x$95 = TestUtils$.MODULE$.singleMessageSet$default$2();
                byte[] x$96 = TestUtils$.MODULE$.singleMessageSet$default$3();
                byte x$97 = TestUtils$.MODULE$.singleMessageSet$default$5();
                ByteBufferMessageSet x$98 = TestUtils$.MODULE$.singleMessageSet(x$93, x$95, x$96, x$94, x$97);
                boolean x$99 = qual$5.append$default$2();
                return qual$5.append(x$98, x$99);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$14 = log$14;
            }
        });
        Iterable indexFiles = (Iterable)((Log)log.elem).logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$12) {
                return x$12.index().file();
            }
        }, Iterable$.MODULE$.canBuildFrom());
        Iterable timeIndexFiles = (Iterable)((Log)log.elem).logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$13) {
                return x$13.timeIndex().file();
            }
        }, Iterable$.MODULE$.canBuildFrom());
        ((Log)log.elem).close();
        indexFiles.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                BufferedWriter bw = new BufferedWriter(new FileWriter(file));
                bw.write("  ");
                bw.close();
            }
        });
        timeIndexFiles.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                BufferedWriter bw = new BufferedWriter(new FileWriter(file));
                bw.write("  ");
                bw.close();
            }
        });
        log.elem = new Log(this.logDir(), config, 200L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)new StringOps(Predef$.MODULE$.augmentString("Should have %d messages when log is reopened")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages)})), (long)numMessages, (long)((Log)log.elem).logEndOffset());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;
            private final ObjectRef log$14;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Log qual$6 = (Log)this.log$14.elem;
                long x$100 = i;
                int x$101 = 100;
                None$ x$102 = None$.MODULE$;
                boolean x$103 = qual$6.read$default$4();
                Assert.assertEquals((long)i, (long)((MessageAndOffset)qual$6.read(x$100, x$101, (Option)x$102, x$103).messageSet().head()).offset());
                if (i == 0) {
                    Assert.assertEquals((long)((LogSegment)((Log)this.log$14.elem).logSegments().head()).baseOffset(), (long)((TimestampOffset)((Log)this.log$14.elem).fetchOffsetsByTimestamp(this.$outer.time().milliseconds() + (long)(i * 10)).get()).offset());
                } else {
                    Assert.assertEquals((long)i, (long)((TimestampOffset)((Log)this.log$14.elem).fetchOffsetsByTimestamp(this.$outer.time().milliseconds() + (long)(i * 10)).get()).offset());
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$14 = log$14;
            }
        });
        ((Log)log.elem).close();
    }

    @Test
    public void testTruncateTo() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4(), TestUtils$.MODULE$.singleMessageSet$default$5());
        int setSize = set.sizeInBytes();
        int msgPerSeg = 10;
        int segmentSize = msgPerSeg * setSize;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"There should be exactly 1 segment.", (long)1L, (long)log.numberOfSegments());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$3;
            private final Log log$15;

            public final LogAppendInfo apply(int i) {
                return this.log$15.append(this.set$3, this.log$15.append$default$2());
            }
            {
                this.set$3 = set$3;
                this.log$15 = log$15;
            }
        });
        Assert.assertEquals((String)"There should be exactly 1 segments.", (long)1L, (long)log.numberOfSegments());
        Assert.assertEquals((String)"Log end offset should be equal to number of messages", (long)msgPerSeg, (long)log.logEndOffset());
        long lastOffset = log.logEndOffset();
        long size2 = log.size();
        log.truncateTo(log.logEndOffset());
        Assert.assertEquals((String)"Should not change offset", (long)lastOffset, (long)log.logEndOffset());
        Assert.assertEquals((String)"Should not change log size", (long)size2, (long)log.size());
        log.truncateTo(log.logEndOffset() + 1L);
        Assert.assertEquals((String)"Should not change offset but should log error", (long)lastOffset, (long)log.logEndOffset());
        Assert.assertEquals((String)"Should not change log size", (long)size2, (long)log.size());
        log.truncateTo((long)(msgPerSeg / 2));
        Assert.assertEquals((String)"Should change offset", (long)log.logEndOffset(), (long)(msgPerSeg / 2));
        Assert.assertTrue((String)"Should change log size", (log.size() < size2 ? 1 : 0) != 0);
        log.truncateTo(0L);
        Assert.assertEquals((String)"Should change offset", (long)0L, (long)log.logEndOffset());
        Assert.assertEquals((String)"Should change log size", (long)0L, (long)log.size());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$3;
            private final Log log$15;

            public final LogAppendInfo apply(int i) {
                return this.log$15.append(this.set$3, this.log$15.append$default$2());
            }
            {
                this.set$3 = set$3;
                this.log$15 = log$15;
            }
        });
        Assert.assertEquals((String)"Should be back to original offset", (long)log.logEndOffset(), (long)lastOffset);
        Assert.assertEquals((String)"Should be back to original size", (long)log.size(), (long)size2);
        log.truncateFullyAndStartAt(log.logEndOffset() - (long)(msgPerSeg - 1));
        Assert.assertEquals((String)"Should change offset", (long)log.logEndOffset(), (long)(lastOffset - (long)(msgPerSeg - 1)));
        Assert.assertEquals((String)"Should change log size", (long)log.size(), (long)0L);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$3;
            private final Log log$15;

            public final LogAppendInfo apply(int i) {
                return this.log$15.append(this.set$3, this.log$15.append$default$2());
            }
            {
                this.set$3 = set$3;
                this.log$15 = log$15;
            }
        });
        Assert.assertTrue((String)"Should be ahead of to original offset", (log.logEndOffset() > (long)msgPerSeg ? 1 : 0) != 0);
        Assert.assertEquals((String)"log size should be same as before", (long)size2, (long)log.size());
        log.truncateTo(0L);
        Assert.assertEquals((String)"Should change offset", (long)0L, (long)log.logEndOffset());
        Assert.assertEquals((String)"Should change log size", (long)log.size(), (long)0L);
    }

    @Test
    public void testIndexResizingAtTruncation() {
        int setSize = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4(), TestUtils$.MODULE$.singleMessageSet$default$5()).sizeInBytes();
        int msgPerSeg = 10;
        int segmentSize = msgPerSeg * setSize;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(setSize - 1));
        LogConfig config = new LogConfig((Map)logProps);
        Log log = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"There should be exactly 1 segment.", (long)1L, (long)log.numberOfSegments());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;
            private final Log log$16;

            public final LogAppendInfo apply(int i) {
                byte[] x$104 = "test".getBytes();
                long x$105 = this.$outer.time().milliseconds() + (long)i;
                CompressionCodec x$106 = TestUtils$.MODULE$.singleMessageSet$default$2();
                byte[] x$107 = TestUtils$.MODULE$.singleMessageSet$default$3();
                byte x$108 = TestUtils$.MODULE$.singleMessageSet$default$5();
                return this.log$16.append(TestUtils$.MODULE$.singleMessageSet(x$104, x$106, x$107, x$105, x$108), this.log$16.append$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$16 = log$16;
            }
        });
        Assert.assertEquals((String)"There should be exactly 1 segment.", (long)1L, (long)log.numberOfSegments());
        this.time().sleep(msgPerSeg);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;
            private final Log log$16;

            public final LogAppendInfo apply(int i) {
                byte[] x$109 = "test".getBytes();
                long x$110 = this.$outer.time().milliseconds() + (long)i;
                CompressionCodec x$111 = TestUtils$.MODULE$.singleMessageSet$default$2();
                byte[] x$112 = TestUtils$.MODULE$.singleMessageSet$default$3();
                byte x$113 = TestUtils$.MODULE$.singleMessageSet$default$5();
                return this.log$16.append(TestUtils$.MODULE$.singleMessageSet(x$109, x$111, x$112, x$110, x$113), this.log$16.append$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$16 = log$16;
            }
        });
        Assert.assertEquals((String)"There should be exactly 2 segment.", (long)2L, (long)log.numberOfSegments());
        int expectedEntries = msgPerSeg - 1;
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The index of the first segment should have ", " entries"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedEntries)})), (long)expectedEntries, (long)((LogSegment)log.logSegments().toList().head()).index().maxEntries());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The time index of the first segment should have ", " entries"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)expectedEntries)})), (long)expectedEntries, (long)((LogSegment)log.logSegments().toList().head()).timeIndex().maxEntries());
        log.truncateTo(0L);
        Assert.assertEquals((String)"There should be exactly 1 segment.", (long)1L, (long)log.numberOfSegments());
        Assert.assertEquals((String)"The index of segment 1 should be resized to maxIndexSize", (long)(Predef$.MODULE$.Integer2int(log.config().maxIndexSize()) / 8), (long)((LogSegment)log.logSegments().toList().head()).index().maxEntries());
        Assert.assertEquals((String)"The time index of segment 1 should be resized to maxIndexSize", (long)(Predef$.MODULE$.Integer2int(log.config().maxIndexSize()) / 12), (long)((LogSegment)log.logSegments().toList().head()).timeIndex().maxEntries());
        this.time().sleep(msgPerSeg);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), msgPerSeg).foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;
            private final Log log$16;

            public final LogAppendInfo apply(int i) {
                byte[] x$114 = "test".getBytes();
                long x$115 = this.$outer.time().milliseconds() + (long)i;
                CompressionCodec x$116 = TestUtils$.MODULE$.singleMessageSet$default$2();
                byte[] x$117 = TestUtils$.MODULE$.singleMessageSet$default$3();
                byte x$118 = TestUtils$.MODULE$.singleMessageSet$default$5();
                return this.log$16.append(TestUtils$.MODULE$.singleMessageSet(x$114, x$116, x$117, x$115, x$118), this.log$16.append$default$2());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.log$16 = log$16;
            }
        });
        Assert.assertEquals((String)"There should be exactly 1 segment.", (long)1L, (long)log.numberOfSegments());
    }

    @Test
    public void testBogusIndexSegmentsAreRemoved() {
        File bogusIndex1 = Log$.MODULE$.indexFilename(this.logDir(), 0L);
        File bogusTimeIndex1 = Log$.MODULE$.timeIndexFilename(this.logDir(), 0L);
        File bogusIndex2 = Log$.MODULE$.indexFilename(this.logDir(), 5L);
        File bogusTimeIndex2 = Log$.MODULE$.timeIndexFilename(this.logDir(), 5L);
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4(), TestUtils$.MODULE$.singleMessageSet$default$5());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(set.sizeInBytes() * 5));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        Log log = new Log(this.logDir(), new LogConfig((Map)logProps), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertTrue((String)"The first index file should have been replaced with a larger file", (bogusIndex1.length() > 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"The first time index file should have been replaced with a larger file", (bogusTimeIndex1.length() > 0L ? 1 : 0) != 0);
        Assert.assertFalse((String)"The second index file should have been deleted.", (boolean)bogusIndex2.exists());
        Assert.assertFalse((String)"The second time index file should have been deleted.", (boolean)bogusTimeIndex2.exists());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$4;
            private final Log log$17;

            public final LogAppendInfo apply(int i) {
                return this.log$17.append(this.set$4, this.log$17.append$default$2());
            }
            {
                this.set$4 = set$4;
                this.log$17 = log$17;
            }
        });
        log.delete();
    }

    @Test
    public void testReopenThenTruncate() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4(), TestUtils$.MODULE$.singleMessageSet$default$5());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(set.sizeInBytes() * 5));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(10000));
        LogConfig config = new LogConfig((Map)logProps);
        ObjectRef log = ObjectRef.create((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$5;
            private final ObjectRef log$18;

            public final LogAppendInfo apply(int i) {
                Log qual$7 = (Log)this.log$18.elem;
                ByteBufferMessageSet x$119 = this.set$5;
                boolean x$120 = qual$7.append$default$2();
                return qual$7.append(x$119, x$120);
            }
            {
                this.set$5 = set$5;
                this.log$18 = log$18;
            }
        });
        ((Log)log.elem).close();
        log.elem = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        ((Log)log.elem).truncateTo(3L);
        Assert.assertEquals((String)"All but one segment should be deleted.", (long)1L, (long)((Log)log.elem).numberOfSegments());
        Assert.assertEquals((String)"Log end offset should be 3.", (long)3L, (long)((Log)log.elem).logEndOffset());
    }

    @Test
    public void testAsyncDelete() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4(), TestUtils$.MODULE$.singleMessageSet$default$5());
        int asyncDeleteMs = 1000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(set.sizeInBytes() * 5));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(10000));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(asyncDeleteMs));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(0));
        LogConfig config = new LogConfig((Map)logProps);
        Log log = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$6;
            private final Log log$19;

            public final LogAppendInfo apply(int i) {
                return this.log$19.append(this.set$6, this.log$19.append$default$2());
            }
            {
                this.set$6 = set$6;
                this.log$19 = log$19;
            }
        });
        LogSegment[] segments = (LogSegment[])log.logSegments().toArray(ClassTag$.MODULE$.apply(LogSegment.class));
        File[] oldFiles = (File[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])segments).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$14) {
                return x$14.log().file();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])segments).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$15) {
                return x$15.index().file();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
        log.logSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;

            public final boolean apply(LogSegment x$16) {
                return x$16.lastModified_$eq(this.$outer.time().milliseconds() - 1000L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        log.deleteOldSegments();
        Assert.assertEquals((String)"Only one segment should remain.", (long)1L, (long)log.numberOfSegments());
        Assert.assertTrue((String)"All log and index files should end in .deleted", (Predef$.MODULE$.refArrayOps((Object[])segments).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment x$17) {
                return x$17.log().file().getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }) && Predef$.MODULE$.refArrayOps((Object[])segments).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment x$18) {
                return x$18.index().file().getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }) ? 1 : 0) != 0);
        Assert.assertTrue((String)"The .deleted files should still be there.", (Predef$.MODULE$.refArrayOps((Object[])segments).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment x$19) {
                return x$19.log().file().exists();
            }
        }) && Predef$.MODULE$.refArrayOps((Object[])segments).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(LogSegment x$20) {
                return x$20.index().file().exists();
            }
        }) ? 1 : 0) != 0);
        Assert.assertTrue((String)"The original file should be gone.", (boolean)Predef$.MODULE$.refArrayOps((Object[])oldFiles).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$21) {
                return !x$21.exists();
            }
        }));
        File[] deletedFiles = (File[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])segments).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$22) {
                return x$22.log().file();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])segments).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final File apply(LogSegment x$23) {
                return x$23.index().file();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(File.class)));
        this.time().sleep(asyncDeleteMs + 1);
        Assert.assertTrue((String)"Files should all be gone.", (boolean)Predef$.MODULE$.refArrayOps((Object[])deletedFiles).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$24) {
                return !x$24.exists();
            }
        }));
    }

    @Test
    public void testOpenDeletesObsoleteFiles() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4(), TestUtils$.MODULE$.singleMessageSet$default$5());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(set.sizeInBytes() * 5));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(0));
        LogConfig config = new LogConfig((Map)logProps);
        ObjectRef log = ObjectRef.create((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$7;
            private final ObjectRef log$20;

            public final LogAppendInfo apply(int i) {
                Log qual$8 = (Log)this.log$20.elem;
                ByteBufferMessageSet x$121 = this.set$7;
                boolean x$122 = qual$8.append$default$2();
                return qual$8.append(x$121, x$122);
            }
            {
                this.set$7 = set$7;
                this.log$20 = log$20;
            }
        });
        ((Log)log.elem).logSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;

            public final boolean apply(LogSegment x$25) {
                return x$25.lastModified_$eq(this.$outer.time().milliseconds() - 1000L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        ((Log)log.elem).deleteOldSegments();
        ((Log)log.elem).close();
        log.elem = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((String)"The deleted segments should be gone.", (long)1L, (long)((Log)log.elem).numberOfSegments());
    }

    @Test
    public void testAppendMessageWithNullPayload() {
        Log log = new Log(this.logDir(), LogConfig$.MODULE$.apply(), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        log.append(new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(null)})), log.append$default$2());
        MessageSet messageSet = log.read(0L, 4096, (Option)None$.MODULE$, log.read$default$4()).messageSet();
        Assert.assertEquals((long)0L, (long)((MessageAndOffset)messageSet.head()).offset());
        Assert.assertTrue((String)"Message payload should be null.", (boolean)((MessageAndOffset)messageSet.head()).message().isNull());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAppendWithOutOfOrderOffsetsThrowsException() {
        Log log = new Log(this.logDir(), LogConfig$.MODULE$.apply(), 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Message[] messages2 = (Message[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(int id) {
                return new Message(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Message.class));
        Predef$.MODULE$.refArrayOps((Object[])messages2).foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final Log log$21;

            public final LogAppendInfo apply(Message message) {
                return this.log$21.append(new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{message})), this.log$21.append$default$2());
            }
            {
                this.log$21 = log$21;
            }
        });
        ByteBufferMessageSet invalidMessage = new ByteBufferMessageSet((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(((Object)BoxesRunTime.boxToInteger((int)1)).toString().getBytes())}));
        log.append(invalidMessage, false);
    }

    @Test
    public void testCorruptLog() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(65536));
        LogConfig config = new LogConfig((Map)logProps);
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4(), TestUtils$.MODULE$.singleMessageSet$default$5());
        long recoveryPoint = 50L;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach$mVc$sp((Function1)new Serializable(this, config, set, recoveryPoint){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;
            private final LogConfig config$1;
            public final ByteBufferMessageSet set$8;
            private final long recoveryPoint$1;

            public final void apply(int iteration) {
                this.apply$mcVI$sp(iteration);
            }

            public void apply$mcVI$sp(int iteration) {
                this.$outer.logDir().mkdirs();
                ObjectRef log = ObjectRef.create((Object)new Log(this.$outer.logDir(), this.config$1, 0L, (Scheduler)this.$outer.time().scheduler(), (Time)this.$outer.time()));
                int numMessages = 50 + TestUtils$.MODULE$.random().nextInt(50);
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach((Function1)new Serializable(this, log){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testCorruptLog$1 $outer;
                    private final ObjectRef log$22;

                    public final LogAppendInfo apply(int i) {
                        Log qual$9 = (Log)this.log$22.elem;
                        ByteBufferMessageSet x$123 = this.$outer.set$8;
                        boolean x$124 = qual$9.append$default$2();
                        return qual$9.append(x$123, x$124);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.log$22 = log$22;
                    }
                });
                Iterable messages2 = (Iterable)((Log)log.elem).logSegments().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<MessageAndOffset> apply(LogSegment x$26) {
                        return x$26.log().iterator().toList();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
                ((Log)log.elem).close();
                TestUtils$.MODULE$.appendNonsenseToFile(((Log)log.elem).activeSegment().index().file(), TestUtils$.MODULE$.random().nextInt(1024) + 1);
                TestUtils$.MODULE$.appendNonsenseToFile(((Log)log.elem).activeSegment().log().file(), TestUtils$.MODULE$.random().nextInt(1024) + 1);
                log.elem = new Log(this.$outer.logDir(), this.config$1, this.recoveryPoint$1, (Scheduler)this.$outer.time().scheduler(), (Time)this.$outer.time());
                Assert.assertEquals((long)numMessages, (long)((Log)log.elem).logEndOffset());
                Assert.assertEquals((String)"Messages in the log after recovery should be the same.", (Object)messages2, (Object)((Log)log.elem).logSegments().flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final List<MessageAndOffset> apply(LogSegment x$27) {
                        return x$27.log().iterator().toList();
                    }
                }, Iterable$.MODULE$.canBuildFrom()));
                Utils.delete((File)this.$outer.logDir());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.config$1 = config$1;
                this.set$8 = set$8;
                this.recoveryPoint$1 = recoveryPoint$1;
            }
        });
    }

    @Test
    public void testCleanShutdownFile() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(65536));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig config = new LogConfig((Map)logProps);
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4(), TestUtils$.MODULE$.singleMessageSet$default$5());
        File parentLogDir = this.logDir().getParentFile();
        Assert.assertTrue((String)"Data directory %s must exist", (boolean)parentLogDir.isDirectory());
        File cleanShutdownFile = new File(parentLogDir, Log$.MODULE$.CleanShutdownFile());
        cleanShutdownFile.createNewFile();
        Assert.assertTrue((String)".kafka_cleanshutdown must exist", (boolean)cleanShutdownFile.exists());
        long recoveryPoint = 0L;
        ObjectRef log = ObjectRef.create((Object)new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$9;
            private final ObjectRef log$23;

            public final LogAppendInfo apply(int i) {
                Log qual$10 = (Log)this.log$23.elem;
                ByteBufferMessageSet x$125 = this.set$9;
                boolean x$126 = qual$10.append$default$2();
                return qual$10.append(x$125, x$126);
            }
            {
                this.set$9 = set$9;
                this.log$23 = log$23;
            }
        });
        ((Log)log.elem).close();
        recoveryPoint = ((Log)log.elem).logEndOffset();
        log.elem = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        Assert.assertEquals((long)recoveryPoint, (long)((Log)log.elem).logEndOffset());
        cleanShutdownFile.delete();
    }

    @Test
    public void testParseTopicPartitionName() {
        String topic = "test_topic";
        String partition = "143";
        File dir = new File(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.logDir()), this.topicPartitionName(topic, partition)));
        TopicAndPartition topicAndPartition = Log$.MODULE$.parseTopicPartitionName(dir);
        Assert.assertEquals((Object)topic, (Object)topicAndPartition.asTuple()._1());
        Assert.assertEquals((long)new StringOps(Predef$.MODULE$.augmentString(partition)).toInt(), (long)topicAndPartition.asTuple()._2$mcI$sp());
    }

    @Test
    public void testParseTopicPartitionNameForEmptyName() {
        try {
            File dir = new File("");
            Log$.MODULE$.parseTopicPartitionName(dir);
            throw this.fail(new StringBuilder().append((Object)"KafkaException should have been thrown for dir: ").append((Object)dir.getCanonicalPath()).toString(), new Position("LogTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1063));
        }
        catch (Exception exception) {
            return;
        }
    }

    @Test
    public void testParseTopicPartitionNameForNull() {
        try {
            File dir = null;
            Log$.MODULE$.parseTopicPartitionName(dir);
            throw this.fail(new StringBuilder().append((Object)"KafkaException should have been thrown for dir: ").append(dir).toString(), new Position("LogTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1074));
        }
        catch (Exception exception) {
            return;
        }
    }

    @Test
    public void testParseTopicPartitionNameForMissingSeparator() {
        String topic = "test_topic";
        String partition = "1999";
        File dir = new File(new StringBuilder().append((Object)Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.logDir()), File.separator)).append((Object)topic).append((Object)partition).toString());
        try {
            Log$.MODULE$.parseTopicPartitionName(dir);
            throw this.fail(new StringBuilder().append((Object)"KafkaException should have been thrown for dir: ").append((Object)dir.getCanonicalPath()).toString(), new Position("LogTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1087));
        }
        catch (Exception exception) {
            return;
        }
    }

    @Test
    public void testParseTopicPartitionNameForMissingTopic() {
        String topic = "";
        String partition = "1999";
        File dir = new File(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.logDir()), this.topicPartitionName(topic, partition)));
        try {
            Log$.MODULE$.parseTopicPartitionName(dir);
            throw this.fail(new StringBuilder().append((Object)"KafkaException should have been thrown for dir: ").append((Object)dir.getCanonicalPath()).toString(), new Position("LogTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1100));
        }
        catch (Exception exception) {
            return;
        }
    }

    @Test
    public void testParseTopicPartitionNameForMissingPartition() {
        String topic = "test_topic";
        String partition = "";
        File dir = new File(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)this.logDir()), this.topicPartitionName(topic, partition)));
        try {
            Log$.MODULE$.parseTopicPartitionName(dir);
            throw this.fail(new StringBuilder().append((Object)"KafkaException should have been thrown for dir: ").append((Object)dir.getCanonicalPath()).toString(), new Position("LogTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 1113));
        }
        catch (Exception exception) {
            return;
        }
    }

    public String topicPartitionName(String topic, String partition) {
        return new StringBuilder().append((Object)File.separator).append((Object)topic).append((Object)"-").append((Object)partition).toString();
    }

    @Test
    public void testDeleteOldSegmentsMethod() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4(), TestUtils$.MODULE$.singleMessageSet$default$5());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(set.sizeInBytes() * 5));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1000));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(0));
        LogConfig config = new LogConfig((Map)logProps);
        Log log = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$10;
            private final Log log$24;

            public final LogAppendInfo apply(int i) {
                return this.log$24.append(this.set$10, this.log$24.append$default$2());
            }
            {
                this.set$10 = set$10;
                this.log$24 = log$24;
            }
        });
        log.logSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogTest $outer;

            public final boolean apply(LogSegment x$28) {
                return x$28.lastModified_$eq(this.$outer.time().milliseconds() - 1000L);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        log.deleteOldSegments();
        Assert.assertEquals((String)"The deleted segments should be gone.", (long)1L, (long)log.numberOfSegments());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 100).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$10;
            private final Log log$24;

            public final LogAppendInfo apply(int i) {
                return this.log$24.append(this.set$10, this.log$24.append$default$2());
            }
            {
                this.set$10 = set$10;
                this.log$24 = log$24;
            }
        });
        log.delete();
        Assert.assertEquals((String)"The number of segments should be 0", (long)0L, (long)log.numberOfSegments());
        Assert.assertEquals((String)"The number of deleted segments should be zero.", (long)0L, (long)log.deleteOldSegments());
    }

    @Test
    public void shouldDeleteSizeBasedSegments() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4(), TestUtils$.MODULE$.singleMessageSet$default$5());
        int x$127 = set.sizeInBytes();
        int x$128 = set.sizeInBytes() * 10;
        int x$129 = this.createLog$default$2();
        String x$130 = this.createLog$default$4();
        Log log = this.createLog(x$127, x$129, x$128, x$130);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 15).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$11;
            private final Log log$25;

            public final LogAppendInfo apply(int i) {
                return this.log$25.append(this.set$11, this.log$25.append$default$2());
            }
            {
                this.set$11 = set$11;
                this.log$25 = log$25;
            }
        });
        log.deleteOldSegments();
        Assert.assertEquals((String)"should have 2 segments", (long)2L, (long)log.numberOfSegments());
    }

    @Test
    public void shouldNotDeleteSizeBasedSegmentsWhenUnderRetentionSize() {
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet("test".getBytes(), TestUtils$.MODULE$.singleMessageSet$default$2(), TestUtils$.MODULE$.singleMessageSet$default$3(), TestUtils$.MODULE$.singleMessageSet$default$4(), TestUtils$.MODULE$.singleMessageSet$default$5());
        int x$131 = set.sizeInBytes();
        int x$132 = set.sizeInBytes() * 15;
        int x$133 = this.createLog$default$2();
        String x$134 = this.createLog$default$4();
        Log log = this.createLog(x$131, x$133, x$132, x$134);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 15).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$12;
            private final Log log$26;

            public final LogAppendInfo apply(int i) {
                return this.log$26.append(this.set$12, this.log$26.append$default$2());
            }
            {
                this.set$12 = set$12;
                this.log$26 = log$26;
            }
        });
        log.deleteOldSegments();
        Assert.assertEquals((String)"should have 3 segments", (long)3L, (long)log.numberOfSegments());
    }

    @Test
    public void shouldDeleteTimeBasedSegmentsReadyToBeDeleted() {
        byte[] x$135 = "test".getBytes();
        long x$136 = 10L;
        CompressionCodec x$137 = TestUtils$.MODULE$.singleMessageSet$default$2();
        byte[] x$138 = TestUtils$.MODULE$.singleMessageSet$default$3();
        byte x$139 = TestUtils$.MODULE$.singleMessageSet$default$5();
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet(x$135, x$137, x$138, x$136, x$139);
        Log log = this.createLog(set.sizeInBytes(), 10000, this.createLog$default$3(), this.createLog$default$4());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 15).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$13;
            private final Log log$27;

            public final LogAppendInfo apply(int i) {
                return this.log$27.append(this.set$13, this.log$27.append$default$2());
            }
            {
                this.set$13 = set$13;
                this.log$27 = log$27;
            }
        });
        log.deleteOldSegments();
        Assert.assertEquals((String)"There should be 1 segment remaining", (long)1L, (long)log.numberOfSegments());
    }

    @Test
    public void shouldNotDeleteTimeBasedSegmentsWhenNoneReadyToBeDeleted() {
        byte[] x$140 = "test".getBytes();
        long x$141 = this.time().milliseconds();
        CompressionCodec x$142 = TestUtils$.MODULE$.singleMessageSet$default$2();
        byte[] x$143 = TestUtils$.MODULE$.singleMessageSet$default$3();
        byte x$144 = TestUtils$.MODULE$.singleMessageSet$default$5();
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet(x$140, x$142, x$143, x$141, x$144);
        Log log = this.createLog(set.sizeInBytes(), 10000000, this.createLog$default$3(), this.createLog$default$4());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 15).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$14;
            private final Log log$28;

            public final LogAppendInfo apply(int i) {
                return this.log$28.append(this.set$14, this.log$28.append$default$2());
            }
            {
                this.set$14 = set$14;
                this.log$28 = log$28;
            }
        });
        log.deleteOldSegments();
        Assert.assertEquals((String)"There should be 3 segments remaining", (long)3L, (long)log.numberOfSegments());
    }

    @Test
    public void shouldNotDeleteSegmentsWhenPolicyDoesNotIncludeDelete() {
        byte[] x$145 = "test".getBytes();
        byte[] x$146 = "test".getBytes();
        long x$147 = 10L;
        CompressionCodec x$148 = TestUtils$.MODULE$.singleMessageSet$default$2();
        byte x$149 = TestUtils$.MODULE$.singleMessageSet$default$5();
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet(x$145, x$148, x$146, x$147, x$149);
        int x$150 = set.sizeInBytes();
        int x$151 = 10000;
        String x$152 = "compact";
        int x$153 = this.createLog$default$3();
        Log log = this.createLog(x$150, x$151, x$153, x$152);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 15).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$15;
            private final Log log$29;

            public final LogAppendInfo apply(int i) {
                return this.log$29.append(this.set$15, this.log$29.append$default$2());
            }
            {
                this.set$15 = set$15;
                this.log$29 = log$29;
            }
        });
        ((LogSegment)log.logSegments().head()).lastModified_$eq(this.time().milliseconds() - 20000L);
        int segments = log.numberOfSegments();
        log.deleteOldSegments();
        Assert.assertEquals((String)"There should be 3 segments remaining", (long)segments, (long)log.numberOfSegments());
    }

    @Test
    public void shouldDeleteSegmentsReadyToBeDeletedWhenCleanupPolicyIsCompactAndDelete() {
        byte[] x$154 = "test".getBytes();
        byte[] x$155 = "test".getBytes();
        long x$156 = 10L;
        CompressionCodec x$157 = TestUtils$.MODULE$.singleMessageSet$default$2();
        byte x$158 = TestUtils$.MODULE$.singleMessageSet$default$5();
        ByteBufferMessageSet set = TestUtils$.MODULE$.singleMessageSet(x$154, x$157, x$155, x$156, x$158);
        int x$159 = set.sizeInBytes();
        int x$160 = 10000;
        String x$161 = "compact,delete";
        int x$162 = this.createLog$default$3();
        Log log = this.createLog(x$159, x$160, x$162, x$161);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 15).foreach((Function1)new Serializable(this, set, log){
            public static final long serialVersionUID = 0L;
            private final ByteBufferMessageSet set$16;
            private final Log log$30;

            public final LogAppendInfo apply(int i) {
                return this.log$30.append(this.set$16, this.log$30.append$default$2());
            }
            {
                this.set$16 = set$16;
                this.log$30 = log$30;
            }
        });
        log.deleteOldSegments();
        Assert.assertEquals((String)"There should be 1 segment remaining", (long)1L, (long)log.numberOfSegments());
    }

    public Log createLog(int messageSizeInBytes, int retentionMs, int retentionBytes, String cleanupPolicy) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(messageSizeInBytes * 5));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(retentionMs));
        logProps.put(LogConfig$.MODULE$.RetentionBytesProp(), Predef$.MODULE$.int2Integer(retentionBytes));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        LogConfig config = new LogConfig((Map)logProps);
        Log log = new Log(this.logDir(), config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        return log;
    }

    public int createLog$default$2() {
        return -1;
    }

    public int createLog$default$3() {
        return -1;
    }

    public String createLog$default$4() {
        return "delete";
    }

    private final Iterator read$1(int offset, Log log$8) {
        return ByteBufferMessageSet$.MODULE$.deepIterator((MessageAndOffset)log$8.read((long)offset, 4096, log$8.read$default$3(), log$8.read$default$4()).messageSet().head(), ByteBufferMessageSet$.MODULE$.deepIterator$default$2());
    }

    private final void verifyRecoveredLog$1(Log log, int numMessages$1, long lastIndexOffset$1, int numIndexEntries$1, long lastTimeIndexOffset$1, long lastTimeIndexTimestamp$1, int numTimeIndexEntries$1) {
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Should have ", " messages when log is reopened w/o recovery"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numMessages$1)})), (long)numMessages$1, (long)log.logEndOffset());
        Assert.assertEquals((String)"Should have same last index offset as before.", (long)lastIndexOffset$1, (long)log.activeSegment().index().lastOffset());
        Assert.assertEquals((String)"Should have same number of index entries as before.", (long)numIndexEntries$1, (long)log.activeSegment().index().entries());
        Assert.assertEquals((String)"Should have same last time index timestamp", (long)lastTimeIndexTimestamp$1, (long)log.activeSegment().timeIndex().lastEntry().timestamp());
        Assert.assertEquals((String)"Should have same last time index offset", (long)lastTimeIndexOffset$1, (long)log.activeSegment().timeIndex().lastEntry().offset());
        Assert.assertEquals((String)"Should have same number of time index entries as before.", (long)numTimeIndexEntries$1, (long)log.activeSegment().timeIndex().entries());
    }
}

