/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.Properties;
import kafka.common.Topic$;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.MetadataRequestTest$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.apache.kafka.test.TestUtils;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001q3A!\u0001\u0002\u0001\u000f\t\u0019R*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fV3ti*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0010\u0005\u0006\u001cXMU3rk\u0016\u001cH\u000fV3ti\")Q\u0002\u0001C\u0001\u001d\u00051A(\u001b8jiz\"\u0012a\u0004\t\u0003\u0013\u0001AQ!\u0005\u0001\u0005BI\t\u0011\u0003\u001d:pa\u0016\u0014H/_(wKJ\u0014\u0018\u000eZ3t)\t\u0019\u0012\u0004\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0003V]&$\b\"\u0002\u000e\u0011\u0001\u0004Y\u0012A\u00039s_B,'\u000f^5fgB\u0011A$I\u0007\u0002;)\u0011adH\u0001\u0005kRLGNC\u0001!\u0003\u0011Q\u0017M^1\n\u0005\tj\"A\u0003)s_B,'\u000f^5fg\")A\u0005\u0001C\u0001K\u0005\u0001C/Z:u\u00072,8\u000f^3s\u0013\u0012<\u0016\u000e\u001e5SKF,Xm\u001d;WKJ\u001c\u0018n\u001c82)\u0005\u0019\u0002FA\u0012(!\tAS&D\u0001*\u0015\tQ3&A\u0003kk:LGOC\u0001-\u0003\ry'oZ\u0005\u0003]%\u0012A\u0001V3ti\")\u0001\u0007\u0001C\u0001K\u0005!B/Z:u\u00072,8\u000f^3s\u0013\u0012L5OV1mS\u0012D#aL\u0014\t\u000bM\u0002A\u0011A\u0013\u0002!Q,7\u000f^\"p]R\u0014x\u000e\u001c7fe&#\u0007F\u0001\u001a(\u0011\u00151\u0004\u0001\"\u0001&\u0003!!Xm\u001d;SC\u000e\\\u0007FA\u001b(\u0011\u0015I\u0004\u0001\"\u0001&\u00039!Xm\u001d;Jg&sG/\u001a:oC2D#\u0001O\u0014\t\u000bq\u0002A\u0011A\u0013\u0002'Q,7\u000f\u001e(p)>\u0004\u0018nY:SKF,Xm\u001d;)\u0005m:\u0003\"B \u0001\t\u0003)\u0013\u0001\u0006;fgR\fE\u000e\u001c+pa&\u001c7OU3rk\u0016\u001cH\u000f\u000b\u0002?O!)!\t\u0001C\u0001K\u00059B/Z:u%\u0016\u0004H.[2b\t><hNU3ta>t7/\u001a\u0015\u0003\u0003\u001eBQ!\u0012\u0001\u0005\n\u0019\u000b1c]3oI6+G/\u00193bi\u0006\u0014V-];fgR$2a\u0012*X!\tA\u0005+D\u0001J\u0015\tQ5*\u0001\u0005sKF,Xm\u001d;t\u0015\taU*\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b9S!aT\u0016\u0002\r\u0005\u0004\u0018m\u00195f\u0013\t\t\u0016J\u0001\tNKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tK\")1\u000b\u0012a\u0001)\u00069!/Z9vKN$\bC\u0001%V\u0013\t1\u0016JA\bNKR\fG-\u0019;b%\u0016\fX/Z:u\u0011\u0015AF\t1\u0001Z\u0003\u001d1XM]:j_:\u0004\"\u0001\u0006.\n\u0005m+\"!B*i_J$\b")
public class MetadataRequestTest
extends BaseRequestTest {
    @Override
    public void propertyOverrides(Properties properties) {
        properties.setProperty(KafkaConfig$.MODULE$.RackProp(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rack/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{properties.getProperty(KafkaConfig$.MODULE$.BrokerIdProp())})));
    }

    @Test
    public void testClusterIdWithRequestVersion1() {
        MetadataResponse v1MetadataResponse = this.kafka$server$MetadataRequestTest$$sendMetadataRequest(MetadataRequest.allTopics(), (short)1);
        String v1ClusterId = v1MetadataResponse.clusterId();
        Assert.assertNull((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"v1 clusterId should be null"})).s((Seq)Nil$.MODULE$), (Object)v1ClusterId);
    }

    @Test
    public void testClusterIdIsValid() {
        MetadataResponse metadataResponse = this.kafka$server$MetadataRequestTest$$sendMetadataRequest(MetadataRequest.allTopics(), (short)2);
        TestUtils.isValidClusterId((String)metadataResponse.clusterId());
    }

    @Test
    public void testControllerId() {
        KafkaServer controllerServer = (KafkaServer)this.servers().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer x$1) {
                return x$1.kafkaController().isActive();
            }
        }).get();
        int controllerId = controllerServer.config().brokerId();
        MetadataResponse metadataResponse = this.kafka$server$MetadataRequestTest$$sendMetadataRequest(MetadataRequest.allTopics(), (short)1);
        Assert.assertEquals((String)"Controller id should match the active controller", (long)controllerId, (long)metadataResponse.controller().id());
        controllerServer.shutdown();
        controllerServer.startup();
        KafkaServer controllerServer2 = (KafkaServer)this.servers().find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(KafkaServer x$2) {
                return x$2.kafkaController().isActive();
            }
        }).get();
        int controllerId2 = controllerServer2.config().brokerId();
        Assert.assertNotEquals((String)"Controller id should switch to a new broker", (long)controllerId, (long)controllerId2);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, controllerServer2){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetadataRequestTest $outer;
            private final KafkaServer controllerServer2$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                MetadataResponse metadataResponse2 = this.$outer.kafka$server$MetadataRequestTest$$sendMetadataRequest(MetadataRequest.allTopics(), (short)1);
                return metadataResponse2.controller() != null && this.controllerServer2$1.apis().brokerId() == metadataResponse2.controller().id();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.controllerServer2$1 = controllerServer2$1;
            }
        }, "Controller id should match the active controller after failover", 5000L);
    }

    @Test
    public void testRack() {
        MetadataResponse metadataResponse = this.kafka$server$MetadataRequestTest$$sendMetadataRequest(MetadataRequest.allTopics(), (short)1);
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.brokers()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Node broker) {
                Assert.assertEquals((String)"Rack information should match config", (Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"rack/", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)broker.id())})), (Object)broker.rack());
            }
        });
    }

    @Test
    public void testIsInternal() {
        String internalTopic = Topic$.MODULE$.GroupMetadataTopicName();
        String notInternalTopic = "notInternal";
        TestUtils$.MODULE$.createTopic(this.zkUtils(), internalTopic, 3, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), notInternalTopic, 3, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        MetadataResponse metadataResponse = this.kafka$server$MetadataRequestTest$$sendMetadataRequest(MetadataRequest.allTopics(), (short)1);
        Assert.assertTrue((String)"Response should have no errors", (boolean)metadataResponse.errors().isEmpty());
        Iterable topicMetadata = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala();
        MetadataResponse.TopicMetadata internalTopicMetadata = (MetadataResponse.TopicMetadata)topicMetadata.find((Function1)new Serializable(this, internalTopic){
            public static final long serialVersionUID = 0L;
            private final String internalTopic$1;

            public final boolean apply(MetadataResponse.TopicMetadata x$3) {
                String string = x$3.topic();
                String string2 = this.internalTopic$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.internalTopic$1 = internalTopic$1;
            }
        }).get();
        MetadataResponse.TopicMetadata notInternalTopicMetadata = (MetadataResponse.TopicMetadata)topicMetadata.find((Function1)new Serializable(this, notInternalTopic){
            public static final long serialVersionUID = 0L;
            private final String notInternalTopic$1;

            public final boolean apply(MetadataResponse.TopicMetadata x$4) {
                String string = x$4.topic();
                String string2 = this.notInternalTopic$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.notInternalTopic$1 = notInternalTopic$1;
            }
        }).get();
        Assert.assertTrue((String)"internalTopic should show isInternal", (boolean)internalTopicMetadata.isInternal());
        Assert.assertFalse((String)"notInternalTopic topic not should show isInternal", (boolean)notInternalTopicMetadata.isInternal());
        Assert.assertEquals((Object)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{internalTopic}))).asJava(), (Object)metadataResponse.cluster().internalTopics());
    }

    @Test
    public void testNoTopicsRequest() {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "t1", 3, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "t2", 3, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        MetadataResponse metadataResponse = this.kafka$server$MetadataRequestTest$$sendMetadataRequest(new MetadataRequest((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava()), (short)1);
        Assert.assertTrue((String)"Response should have no errors", (boolean)metadataResponse.errors().isEmpty());
        Assert.assertTrue((String)"Response should have no topics", (boolean)metadataResponse.topicMetadata().isEmpty());
    }

    @Test
    public void testAllTopicsRequest() {
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "t1", 3, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "t2", 3, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        MetadataResponse metadataResponseV0 = this.kafka$server$MetadataRequestTest$$sendMetadataRequest(new MetadataRequest((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Nil$.MODULE$).asJava()), (short)0);
        Assert.assertTrue((String)"V0 Response should have no errors", (boolean)metadataResponseV0.errors().isEmpty());
        Assert.assertEquals((String)"V0 Response should have 2 (all) topics", (long)2L, (long)metadataResponseV0.topicMetadata().size());
        MetadataResponse metadataResponseV1 = this.kafka$server$MetadataRequestTest$$sendMetadataRequest(MetadataRequest.allTopics(), (short)1);
        Assert.assertTrue((String)"V1 Response should have no errors", (boolean)metadataResponseV1.errors().isEmpty());
        Assert.assertEquals((String)"V1 Response should have 2 (all) topics", (long)2L, (long)metadataResponseV1.topicMetadata().size());
    }

    @Test
    public void testReplicaDownResponse() {
        String replicaDownTopic = "replicaDown";
        int replicaCount = 3;
        TestUtils$.MODULE$.createTopic(this.zkUtils(), replicaDownTopic, 1, replicaCount, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        MetadataResponse metadataResponse = this.kafka$server$MetadataRequestTest$$sendMetadataRequest(new MetadataRequest((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{replicaDownTopic}))).asJava()), (short)1);
        MetadataResponse.PartitionMetadata partitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(metadataResponse.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).head();
        KafkaServer downNode = (KafkaServer)this.servers().find((Function1)new Serializable(this, partitionMetadata){
            public static final long serialVersionUID = 0L;
            private final MetadataResponse.PartitionMetadata partitionMetadata$1;

            public final boolean apply(KafkaServer server) {
                int serverId = server.apis().brokerId();
                int leaderId = this.partitionMetadata$1.leader().id();
                Buffer replicaIds = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.partitionMetadata$1.replicas()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(Node x$5) {
                        return x$5.id();
                    }
                }, Buffer$.MODULE$.canBuildFrom());
                return serverId != leaderId && replicaIds.contains((Object)BoxesRunTime.boxToInteger((int)serverId));
            }
            {
                this.partitionMetadata$1 = partitionMetadata$1;
            }
        }).get();
        downNode.shutdown();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, replicaDownTopic, downNode){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MetadataRequestTest $outer;
            private final String replicaDownTopic$1;
            public final KafkaServer downNode$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                MetadataResponse response = this.$outer.kafka$server$MetadataRequestTest$$sendMetadataRequest(new MetadataRequest((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.replicaDownTopic$1}))).asJava()), (short)1);
                MetadataResponse.PartitionMetadata metadata = (MetadataResponse.PartitionMetadata)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).head();
                Node replica = (Node)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(metadata.replicas()).asScala()).find((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$testReplicaDownResponse$1 $outer;

                    public final boolean apply(Node x$6) {
                        return x$6.id() == this.$outer.downNode$1.apis().brokerId();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }).get();
                String string = replica.host();
                String string2 = "";
                return !(string != null ? !string.equals(string2) : string2 != null) & replica.port() == -1;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicaDownTopic$1 = replicaDownTopic$1;
                this.downNode$1 = downNode$1;
            }
        }, "Replica was not found down", 5000L);
        MetadataResponse v0MetadataResponse = this.kafka$server$MetadataRequestTest$$sendMetadataRequest(new MetadataRequest((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{replicaDownTopic}))).asJava()), (short)0);
        Seq v0BrokerIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(v0MetadataResponse.brokers()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$7) {
                return x$7.id();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        Assert.assertTrue((String)"Response should have no errors", (boolean)v0MetadataResponse.errors().isEmpty());
        Assert.assertFalse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The downed broker should not be in the brokers list"})).s((Seq)Nil$.MODULE$), (boolean)v0BrokerIds.contains((Object)downNode));
        Assert.assertTrue((String)"Response should have one topic", (v0MetadataResponse.topicMetadata().size() == 1 ? 1 : 0) != 0);
        MetadataResponse.PartitionMetadata v0PartitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(v0MetadataResponse.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).head();
        Errors errors = v0PartitionMetadata.error();
        Errors errors2 = Errors.REPLICA_NOT_AVAILABLE;
        Assert.assertTrue((String)"PartitionMetadata should have an error", (!(errors != null ? !errors.equals(errors2) : errors2 != null) ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Response should have ", " replicas"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(replicaCount - 1))})), (v0PartitionMetadata.replicas().size() == replicaCount - 1 ? 1 : 0) != 0);
        MetadataResponse v1MetadataResponse = this.kafka$server$MetadataRequestTest$$sendMetadataRequest(new MetadataRequest((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{replicaDownTopic}))).asJava()), (short)1);
        Seq v1BrokerIds = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(v1MetadataResponse.brokers()).asScala()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Node x$8) {
                return x$8.id();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        Assert.assertTrue((String)"Response should have no errors", (boolean)v1MetadataResponse.errors().isEmpty());
        Assert.assertFalse((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The downed broker should not be in the brokers list"})).s((Seq)Nil$.MODULE$), (boolean)v1BrokerIds.contains((Object)downNode));
        Assert.assertEquals((String)"Response should have one topic", (long)1L, (long)v1MetadataResponse.topicMetadata().size());
        MetadataResponse.PartitionMetadata v1PartitionMetadata = (MetadataResponse.PartitionMetadata)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MetadataResponse.TopicMetadata)((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(v1MetadataResponse.topicMetadata()).asScala()).head()).partitionMetadata()).asScala()).head();
        Assert.assertEquals((String)"PartitionMetadata should have no errors", (Object)Errors.NONE, (Object)v1PartitionMetadata.error());
        Assert.assertEquals((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Response should have ", " replicas"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)replicaCount)})), (long)replicaCount, (long)v1PartitionMetadata.replicas().size());
    }

    public MetadataResponse kafka$server$MetadataRequestTest$$sendMetadataRequest(MetadataRequest request, short version) {
        ByteBuffer response = this.send((AbstractRequest)request, ApiKeys.METADATA, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)version)), this.send$default$4(), this.send$default$5());
        return MetadataResponse.parse((ByteBuffer)response, (int)version);
    }
}

