/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.Optional;
import java.util.Properties;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.IsolationLevel;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.ListOffsetRequestData;
import org.apache.kafka.common.message.ListOffsetResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ListOffsetRequest;
import org.apache.kafka.common.requests.ListOffsetResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\u0005Ma\u0001\u0002\b\u0010\u0001QAQ!\u0007\u0001\u0005\u0002iAq\u0001\b\u0001C\u0002\u0013\u0005Q\u0004\u0003\u0004'\u0001\u0001\u0006IA\b\u0005\bO\u0001\u0011\r\u0011\"\u0001)\u0011\u0019!\u0004\u0001)A\u0005S!)Q\u0007\u0001C\u0001m!)A\t\u0001C\u0001\u000b\")a\f\u0001C\u0001m!)\u0001\r\u0001C\u0001C\")\u0011\u000f\u0001C\u0001m!)1\u000f\u0001C\u0001m!)Q\u000f\u0001C\u0005m\"9\u00111\u0001\u0001\u0005\n\u0005\u0015!A\u0006'jgR|eMZ:fiN\u0014V-];fgR$Vm\u001d;\u000b\u0005A\t\u0012AB:feZ,'OC\u0001\u0013\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019\"\u0001A\u000b\u0011\u0005Y9R\"A\b\n\u0005ay!a\u0004\"bg\u0016\u0014V-];fgR$Vm\u001d;\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\f\u0001\u0003\u0015!x\u000e]5d+\u0005q\u0002CA\u0010%\u001b\u0005\u0001#BA\u0011#\u0003\u0011a\u0017M\\4\u000b\u0003\r\nAA[1wC&\u0011Q\u0005\t\u0002\u0007'R\u0014\u0018N\\4\u0002\rQ|\u0007/[2!\u0003%\u0001\u0018M\u001d;ji&|g.F\u0001*!\tQ#'D\u0001,\u0015\taS&\u0001\u0004d_6lwN\u001c\u0006\u0003%9R!a\f\u0019\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\t\u0014aA8sO&\u00111g\u000b\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0003)\u0001\u0018M\u001d;ji&|g\u000eI\u0001\u001ai\u0016\u001cH\u000fT5ti>3gm]3ug\u0016\u0013(o\u001c:D_\u0012,7\u000fF\u00018!\tA4(D\u0001:\u0015\u0005Q\u0014!B:dC2\f\u0017B\u0001\u001f:\u0005\u0011)f.\u001b;)\u0005\u0019q\u0004CA C\u001b\u0005\u0001%BA!1\u0003\u0015QWO\\5u\u0013\t\u0019\u0005I\u0001\u0003UKN$\u0018aG1tg\u0016\u0014HOU3ta>t7/Z#se>\u0014hi\u001c:Fa>\u001c\u0007\u000e\u0006\u00038\r:\u001b\u0006\"B$\b\u0001\u0004A\u0015!B3se>\u0014\bCA%M\u001b\u0005Q%BA&,\u0003!\u0001(o\u001c;pG>d\u0017BA'K\u0005\u0019)%O]8sg\")qj\u0002a\u0001!\u0006A!M]8lKJLE\r\u0005\u00029#&\u0011!+\u000f\u0002\u0004\u0013:$\b\"\u0002+\b\u0001\u0004)\u0016AE2veJ,g\u000e\u001e'fC\u0012,'/\u00129pG\"\u00042AV-\\\u001b\u00059&B\u0001-#\u0003\u0011)H/\u001b7\n\u0005i;&\u0001C(qi&|g.\u00197\u0011\u0005}a\u0016BA/!\u0005\u001dIe\u000e^3hKJ\f!\u0004^3ti\u000e+(O]3oi\u0016\u0003xn\u00195WC2LG-\u0019;j_:D#\u0001\u0003 \u0002'\u0019,Go\u00195PM\u001a\u001cX\r^!oI\u0016\u0003xn\u00195\u0015\t\tD'\u000e\u001c\t\u0005q\r,\u0007+\u0003\u0002es\t1A+\u001e9mKJ\u0002\"\u0001\u000f4\n\u0005\u001dL$\u0001\u0002'p]\u001eDQ![\u0005A\u0002A\u000b\u0001b]3sm\u0016\u0014\u0018\n\u001a\u0005\u0006W&\u0001\r!Z\u0001\ni&lWm\u001d;b[BDQ!\\\u0005A\u00029\fqA^3sg&|g\u000e\u0005\u00029_&\u0011\u0001/\u000f\u0002\u0006'\"|'\u000f^\u0001 i\u0016\u001cHOU3ta>t7/Z%oG2,H-Z:MK\u0006$WM]#q_\u000eD\u0007F\u0001\u0006?\u0003U\"Xm\u001d;SKN\u0004xN\\:f\t\u00164\u0017-\u001e7u\u001f\u001a47/\u001a;B]\u0012dU-\u00193fe\u0016\u0003xn\u00195G_J\fE\u000e\u001c,feNLwN\\:)\u0005-q\u0014aE1tg\u0016\u0014HOU3ta>t7/Z#se>\u0014H\u0003B\u001cxqfDQa\u0012\u0007A\u0002!CQa\u0014\u0007A\u0002ACQA\u001f\u0007A\u0002m\fqA]3rk\u0016\u001cH\u000f\u0005\u0002}\u007f6\tQP\u0003\u0002\u007fW\u0005A!/Z9vKN$8/C\u0002\u0002\u0002u\u0014\u0011\u0003T5ti>3gm]3u%\u0016\fX/Z:u\u0003-\u0019XM\u001c3SKF,Xm\u001d;\u0015\r\u0005\u001d\u0011QBA\t!\ra\u0018\u0011B\u0005\u0004\u0003\u0017i(A\u0005'jgR|eMZ:fiJ+7\u000f]8og\u0016Da!a\u0004\u000e\u0001\u0004\u0001\u0016\u0001\u00037fC\u0012,'/\u00133\t\u000bil\u0001\u0019A>")
public class ListOffsetsRequestTest
extends BaseRequestTest {
    private final String topic;
    private final TopicPartition partition = new TopicPartition(this.topic(), 0);

    public String topic() {
        return this.topic;
    }

    public TopicPartition partition() {
        return this.partition;
    }

    @Test
    public void testListOffsetsErrorCodes() {
        java.util.List targetTimes = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)new ListOffsetRequestData.ListOffsetTopic().setName(this.topic()).setPartitions(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)new ListOffsetRequestData.ListOffsetPartition().setPartitionIndex(this.partition().partition()).setTimestamp(-2L).setCurrentLeaderEpoch(0), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetRequest consumerRequest = (ListOffsetRequest)ListOffsetRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(targetTimes).build();
        ListOffsetRequest replicaRequest = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)((KafkaServer)this.servers().head()).config().brokerId()).setTargetTimes(targetTimes).build();
        ListOffsetRequest debugReplicaRequest = (ListOffsetRequest)ListOffsetRequest.Builder.forReplica((short)ApiKeys.LIST_OFFSETS.latestVersion(), (int)-2).setTargetTimes(targetTimes).build();
        int randomBrokerId = ((KafkaServer)this.servers().head()).config().brokerId();
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, consumerRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, replicaRequest);
        this.assertResponseError(Errors.UNKNOWN_TOPIC_OR_PARTITION, randomBrokerId, debugReplicaRequest);
        Map<Object, Object> partitionToLeader = TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), 1, 2, (Seq<KafkaServer>)this.servers(), new Properties());
        Set replicas = this.zkClient().getReplicasForPartition(this.partition()).toSet();
        int leader = BoxesRunTime.unboxToInt((Object)partitionToLeader.apply((Object)this.partition().partition()));
        int follower = BoxesRunTime.unboxToInt((Object)replicas.find((Function1)(JFunction1.mcZI.sp & Serializable)x$1 -> x$1 != leader).get());
        int nonReplica = BoxesRunTime.unboxToInt((Object)((IterableOnceOps)this.servers().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToInteger((int)ListOffsetsRequestTest.$anonfun$testListOffsetsErrorCodes$2(x$2)))).find((Function1)(JFunction1.mcZI.sp & Serializable)x$3 -> !replicas.contains((Object)x$3)).get());
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, follower, replicaRequest);
        this.assertResponseError(Errors.NONE, follower, debugReplicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, consumerRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, replicaRequest);
        this.assertResponseError(Errors.NOT_LEADER_OR_FOLLOWER, nonReplica, debugReplicaRequest);
    }

    public void assertResponseErrorForEpoch(Errors error, int brokerId, Optional<Integer> currentLeaderEpoch) {
        ListOffsetRequestData.ListOffsetPartition listOffsetPartition = new ListOffsetRequestData.ListOffsetPartition().setPartitionIndex(this.partition().partition()).setTimestamp(-2L);
        if (currentLeaderEpoch.isPresent()) {
            listOffsetPartition.setCurrentLeaderEpoch(BoxesRunTime.unboxToInt((Object)currentLeaderEpoch.get()));
        }
        java.util.List targetTimes = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)new ListOffsetRequestData.ListOffsetTopic().setName(this.topic()).setPartitions(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)listOffsetPartition, (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetRequest request = (ListOffsetRequest)ListOffsetRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(targetTimes).build();
        this.assertResponseError(error, brokerId, request);
    }

    @Test
    public void testCurrentEpochValidation() {
        String topic = "topic";
        TopicPartition topicPartition = new TopicPartition(topic, 0);
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), topic, 1, 3, (Seq<KafkaServer>)this.servers(), new Properties()).apply((Object)topicPartition.partition()));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), topicPartition, firstLeaderId, 15000L);
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch(Errors.NONE, secondLeaderId, Optional.empty());
        this.assertResponseErrorForEpoch(Errors.NONE, secondLeaderId, Optional.of(secondLeaderEpoch));
        this.assertResponseErrorForEpoch(Errors.FENCED_LEADER_EPOCH, secondLeaderId, Optional.of(secondLeaderEpoch - 1));
        this.assertResponseErrorForEpoch(Errors.UNKNOWN_LEADER_EPOCH, secondLeaderId, Optional.of(secondLeaderEpoch + 1));
        int followerId = TestUtils$.MODULE$.findFollowerId(topicPartition, (Iterable<KafkaServer>)this.servers());
        this.assertResponseErrorForEpoch(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.empty());
        this.assertResponseErrorForEpoch(Errors.NOT_LEADER_OR_FOLLOWER, followerId, Optional.of(secondLeaderEpoch));
        this.assertResponseErrorForEpoch(Errors.UNKNOWN_LEADER_EPOCH, followerId, Optional.of(secondLeaderEpoch + 1));
        this.assertResponseErrorForEpoch(Errors.FENCED_LEADER_EPOCH, followerId, Optional.of(secondLeaderEpoch - 1));
    }

    public Tuple2<Object, Object> fetchOffsetAndEpoch(int serverId, long timestamp, short version) {
        java.util.List targetTimes = AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)new ListOffsetRequestData.ListOffsetTopic().setName(this.topic()).setPartitions(AsJavaExtensions.SeqHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Seq)new .colon.colon((Object)new ListOffsetRequestData.ListOffsetPartition().setPartitionIndex(this.partition().partition()).setTimestamp(timestamp), (List)Nil$.MODULE$)).asJava()), (List)Nil$.MODULE$)).asJava();
        ListOffsetRequest.Builder builder = ListOffsetRequest.Builder.forConsumer((boolean)false, (IsolationLevel)IsolationLevel.READ_UNCOMMITTED).setTargetTimes(targetTimes);
        ListOffsetRequest request = version == -1 ? (ListOffsetRequest)builder.build() : builder.build(version);
        ListOffsetResponse response = this.sendRequest(serverId, request);
        ListOffsetResponseData.ListOffsetPartitionResponse partitionData = (ListOffsetResponseData.ListOffsetPartitionResponse)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)((ListOffsetResponseData.ListOffsetTopicResponse)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)response.topics()).asScala().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$fetchOffsetAndEpoch$1(this, x$4))).get()).partitions()).asScala().find((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ListOffsetsRequestTest.$anonfun$fetchOffsetAndEpoch$2(this, x$5))).get();
        if (version == 0) {
            if (partitionData.oldStyleOffsets().isEmpty()) {
                return new Tuple2.mcJI.sp(-1L, partitionData.leaderEpoch());
            }
            return new Tuple2.mcJI.sp(BoxesRunTime.unboxToLong((Object)((Long)AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)partitionData.oldStyleOffsets()).asScala().head())), partitionData.leaderEpoch());
        }
        return new Tuple2.mcJI.sp(partitionData.offset(), partitionData.leaderEpoch());
    }

    @Test
    public void testResponseIncludesLeaderEpoch() {
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), 1, 3, (Seq<KafkaServer>)this.servers(), new Properties()).apply((Object)this.partition().partition()));
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), this.topic(), 10, -1);
        Assert.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, 0L, (short)-1));
        Assert.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -2L, (short)-1));
        Assert.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), this.fetchOffsetAndEpoch(firstLeaderId, -1L, (short)-1));
        this.killBroker(firstLeaderId);
        int secondLeaderId = TestUtils$.MODULE$.awaitLeaderChange((Seq<KafkaServer>)this.servers(), this.partition(), firstLeaderId, 15000L);
        int secondLeaderEpoch = TestUtils$.MODULE$.findLeaderEpoch(secondLeaderId, this.partition(), (Iterable<KafkaServer>)this.servers());
        Assert.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assert.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, -2L, (short)-1));
        Assert.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, 0L, (short)-1));
        Assert.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), this.fetchOffsetAndEpoch(secondLeaderId, -2L, (short)-1));
        Assert.assertEquals((Object)new Tuple2.mcJI.sp(10L, secondLeaderEpoch), this.fetchOffsetAndEpoch(secondLeaderId, -1L, (short)-1));
    }

    @Test
    public void testResponseDefaultOffsetAndLeaderEpochForAllVersions() {
        int firstLeaderId = BoxesRunTime.unboxToInt((Object)TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), 1, 3, (Seq<KafkaServer>)this.servers(), new Properties()).apply((Object)this.partition().partition()));
        TestUtils$.MODULE$.generateAndProduceMessages((Seq<KafkaServer>)this.servers(), this.topic(), 10, -1);
        short s = ApiKeys.LIST_OFFSETS.oldestVersion();
        short to$extension_end = ApiKeys.LIST_OFFSETS.latestVersion();
        Range.Inclusive foreach$mVc$sp_this = new Range.Inclusive((int)s, (int)to$extension_end, 1);
        if (!foreach$mVc$sp_this.isEmpty()) {
            int foreach$mVc$sp_i = foreach$mVc$sp_this.start();
            while (true) {
                ListOffsetsRequestTest.$anonfun$testResponseDefaultOffsetAndLeaderEpochForAllVersions$1(this, firstLeaderId, foreach$mVc$sp_i);
                if (foreach$mVc$sp_i == foreach$mVc$sp_this.scala$collection$immutable$Range$$lastElement) break;
                foreach$mVc$sp_i += foreach$mVc$sp_this.step();
            }
        }
    }

    private void assertResponseError(Errors error, int brokerId, ListOffsetRequest request) {
        ListOffsetResponse response = this.sendRequest(brokerId, request);
        Assert.assertEquals((long)request.topics().size(), (long)response.topics().size());
        AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)response.topics()).asScala().foreach((Function1 & Serializable)topic -> {
            ListOffsetsRequestTest.$anonfun$assertResponseError$1(error, topic);
            return BoxedUnit.UNIT;
        });
    }

    private ListOffsetResponse sendRequest(int leaderId, ListOffsetRequest request) {
        return (ListOffsetResponse)this.connectAndReceive((AbstractRequest)request, this.brokerSocketServer(leaderId), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(ListOffsetResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
    }

    public static final /* synthetic */ int $anonfun$testListOffsetsErrorCodes$2(KafkaServer x$2) {
        return x$2.config().brokerId();
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffsetAndEpoch$1(ListOffsetsRequestTest $this, ListOffsetResponseData.ListOffsetTopicResponse x$4) {
        String string = x$4.name();
        String string2 = $this.topic();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$fetchOffsetAndEpoch$2(ListOffsetsRequestTest $this, ListOffsetResponseData.ListOffsetPartitionResponse x$5) {
        return x$5.partitionIndex() == $this.partition().partition();
    }

    public static final /* synthetic */ void $anonfun$testResponseDefaultOffsetAndLeaderEpochForAllVersions$1(ListOffsetsRequestTest $this, int firstLeaderId$1, int version) {
        if (version == 0) {
            Assert.assertEquals((Object)new Tuple2.mcJI.sp(-1L, -1), $this.fetchOffsetAndEpoch(firstLeaderId$1, 0L, (short)version));
            Assert.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), $this.fetchOffsetAndEpoch(firstLeaderId$1, -2L, (short)version));
            Assert.assertEquals((Object)new Tuple2.mcJI.sp(10L, -1), $this.fetchOffsetAndEpoch(firstLeaderId$1, -1L, (short)version));
            return;
        }
        if (version >= 1 && version <= 3) {
            Assert.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), $this.fetchOffsetAndEpoch(firstLeaderId$1, 0L, (short)version));
            Assert.assertEquals((Object)new Tuple2.mcJI.sp(0L, -1), $this.fetchOffsetAndEpoch(firstLeaderId$1, -2L, (short)version));
            Assert.assertEquals((Object)new Tuple2.mcJI.sp(10L, -1), $this.fetchOffsetAndEpoch(firstLeaderId$1, -1L, (short)version));
            return;
        }
        if (version >= 4) {
            Assert.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), $this.fetchOffsetAndEpoch(firstLeaderId$1, 0L, (short)version));
            Assert.assertEquals((Object)new Tuple2.mcJI.sp(0L, 0), $this.fetchOffsetAndEpoch(firstLeaderId$1, -2L, (short)version));
            Assert.assertEquals((Object)new Tuple2.mcJI.sp(10L, 0), $this.fetchOffsetAndEpoch(firstLeaderId$1, -1L, (short)version));
        }
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$2(Errors error$1, ListOffsetResponseData.ListOffsetPartitionResponse partition) {
        Assert.assertEquals((long)error$1.code(), (long)partition.errorCode());
    }

    public static final /* synthetic */ void $anonfun$assertResponseError$1(Errors error$1, ListOffsetResponseData.ListOffsetTopicResponse topic) {
        AsScalaExtensions.ListHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (java.util.List)topic.partitions()).asScala().foreach((Function1 & Serializable)partition -> {
            ListOffsetsRequestTest.$anonfun$assertResponseError$2(error$1, partition);
            return BoxedUnit.UNIT;
        });
    }

    public ListOffsetsRequestTest() {
        this.topic = "topic";
    }
}

