/*
 * Decompiled with CFR 0.152.
 */
package kafka.api;

import java.io.Serializable;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kafka.api.AbstractConsumerTest;
import kafka.api.FixedPortTestUtils$;
import kafka.log.Log;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.NotNothing$;
import kafka.utils.ShutdownableThread;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.GroupMaxSizeReachedException;
import org.apache.kafka.common.message.FindCoordinatorRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.FindCoordinatorRequest;
import org.apache.kafka.common.requests.FindCoordinatorResponse;
import org.apache.kafka.common.utils.Time;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\tUf\u0001\u0002\u00180\u0001QBQa\u0010\u0001\u0005\u0002\u0001CqA\u0011\u0001C\u0002\u0013\u00051\t\u0003\u0004K\u0001\u0001\u0006I\u0001\u0012\u0005\b\u0017\u0002\u0011\r\u0011\"\u0001M\u0011\u0019\u0019\u0006\u0001)A\u0005\u001b\"9A\u000b\u0001b\u0001\n\u0003)\u0006B\u00021\u0001A\u0003%a\u000bC\u0004b\u0001\t\u0007I\u0011\u00012\t\r=\u0004\u0001\u0015!\u0003d\u0011\u0015\u0001\b\u0001\"\u0011r\u0011\u0015a\b\u0001\"\u0003~\u0011%\t)\u0002AI\u0001\n\u0013\t9\u0002C\u0004\u0002.\u0001!\t%a\f\t\u000f\u0005=\u0003\u0001\"\u0001\u00020!9\u0011\u0011\r\u0001\u0005\u0002\u0005\r\u0004bBA5\u0001\u0011\u0005\u0011q\u0006\u0005\b\u0003[\u0002A\u0011AA8\u0011\u001d\t\u0019\b\u0001C\u0001\u0003_Aq!a\u001e\u0001\t\u0003\ty\u0003C\u0004\u0002|\u0001!I!! \t\u000f\u0005\u001d\u0005\u0001\"\u0003\u0002\n\"9\u0011Q\u0013\u0001\u0005\n\u0005]\u0005bBAO\u0001\u0011%\u0011q\u0014\u0005\b\u0003W\u0003A\u0011AA\u0018\u0011\u001d\ty\u000b\u0001C\u0001\u0003_Aq!a-\u0001\t\u0003\ty\u0003C\u0004\u00028\u0002!I!!/\t\u000f\u0005M\u0007\u0001\"\u0003\u0002V\"9!\u0011\u0001\u0001\u0005\n\t\r\u0001\"\u0003B\u0007\u0001E\u0005I\u0011\u0002B\b\u0011\u001d\u0011\u0019\u0002\u0001C\u0005\u0005+AqAa\u000e\u0001\t\u0013\u0011ID\u0002\u0004\u0003B\u0001!!1\t\u0005\n\u0003O\n#Q1A\u0005\u0002\rC\u0011Ba\u0013\"\u0005\u0003\u0005\u000b\u0011\u0002#\t\r}\nC\u0011\u0001B'\u0011!\u0011\u0019&\ta\u0001\n\u0003\u0019\u0005\"\u0003B+C\u0001\u0007I\u0011\u0001B,\u0011\u001d\u0011i&\tQ!\n\u0011CqAa\u0018\"\t\u0003\ny\u0003C\u0004\u0003b\u0001!IAa\u0019\t\u0013\t5\u0005!%A\u0005\n\t=\u0005b\u0002BJ\u0001\u0011%!Q\u0013\u0005\n\u0005[\u0003\u0011\u0013!C\u0005\u0003/A\u0011Ba,\u0001#\u0003%IA!-\u0003%\r{gn];nKJ\u0014u.\u001e8dKR+7\u000f\u001e\u0006\u0003aE\n1!\u00199j\u0015\u0005\u0011\u0014!B6bM.\f7\u0001A\n\u0004\u0001UJ\u0004C\u0001\u001c8\u001b\u0005y\u0013B\u0001\u001d0\u0005Q\t%m\u001d;sC\u000e$8i\u001c8tk6,'\u000fV3tiB\u0011!(P\u0007\u0002w)\u0011A(M\u0001\u0006kRLGn]\u0005\u0003}m\u0012q\u0001T8hO&tw-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0003B\u0011a\u0007A\u0001\r[\u0006DxI]8vaNK'0Z\u000b\u0002\tB\u0011Q\tS\u0007\u0002\r*\tq)A\u0003tG\u0006d\u0017-\u0003\u0002J\r\n\u0019\u0011J\u001c;\u0002\u001b5\f\u0007p\u0012:pkB\u001c\u0016N_3!\u0003M9'/Y2fMVd7\t\\8tKRKW.Z't+\u0005i\u0005cA#O!&\u0011qJ\u0012\u0002\u0005'>lW\r\u0005\u0002F#&\u0011!K\u0012\u0002\u0005\u0019>tw-\u0001\u000bhe\u0006\u001cWMZ;m\u00072|7/\u001a+j[\u0016l5\u000fI\u0001\tKb,7-\u001e;peV\ta\u000b\u0005\u0002X=6\t\u0001L\u0003\u0002Z5\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005mc\u0016\u0001B;uS2T\u0011!X\u0001\u0005U\u00064\u0018-\u0003\u0002`1\nA2k\u00195fIVdW\rZ#yK\u000e,Ho\u001c:TKJ4\u0018nY3\u0002\u0013\u0015DXmY;u_J\u0004\u0013aD2p]N,X.\u001a:Q_2dWM]:\u0016\u0003\r\u00042\u0001Z5l\u001b\u0005)'B\u00014h\u0003\u001diW\u000f^1cY\u0016T!\u0001\u001b$\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002kK\n1!)\u001e4gKJ\u0004\"\u0001\\7\u000e\u0003\u0001I!A\\\u001c\u00031\r{gn];nKJ\f5o]5h]6,g\u000e\u001e)pY2,'/\u0001\td_:\u001cX/\\3s!>dG.\u001a:tA\u0005yq-\u001a8fe\u0006$XmQ8oM&<7/F\u0001s!\r\u0019HO^\u0007\u0002O&\u0011Qo\u001a\u0002\u0004'\u0016\f\bCA<{\u001b\u0005A(BA=2\u0003\u0019\u0019XM\u001d<fe&\u00111\u0010\u001f\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u000bhK:,'/\u0019;f\u0017\u000647.Y\"p]\u001aLwm\u001d\u000b\u0003ezDqAQ\u0006\u0011\u0002\u0003\u0007q\u0010\u0005\u0003\u0002\u0002\u0005=a\u0002BA\u0002\u0003\u0017\u00012!!\u0002G\u001b\t\t9AC\u0002\u0002\nM\na\u0001\u0010:p_Rt\u0014bAA\u0007\r\u00061\u0001K]3eK\u001aLA!!\u0005\u0002\u0014\t11\u000b\u001e:j]\u001eT1!!\u0004G\u0003y9WM\\3sCR,7*\u00194lC\u000e{gNZ5hg\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u001a)\u001aq0a\u0007,\u0005\u0005u\u0001\u0003BA\u0010\u0003Si!!!\t\u000b\t\u0005\r\u0012QE\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a\nG\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003W\t\tCA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u000b\u0003\u0003c\u00012!RA\u001a\u0013\r\t)D\u0012\u0002\u0005+:LG\u000fK\u0002\u000e\u0003s\u0001B!a\u000f\u0002L5\u0011\u0011Q\b\u0006\u0004a\u0005}\"\u0002BA!\u0003\u0007\nqA[;qSR,'O\u0003\u0003\u0002F\u0005\u001d\u0013!\u00026v]&$(BAA%\u0003\ry'oZ\u0005\u0005\u0003\u001b\niDA\u0005BMR,'/R1dQ\u0006\tC/Z:u\u0007>t7/^7qi&|gnV5uQ\n\u0013xn[3s\r\u0006LG.\u001e:fg\"\u001aa\"a\u0015\u0011\t\u0005m\u0012QK\u0005\u0005\u0003/\niD\u0001\u0005ESN\f'\r\\3eQ\rq\u00111\f\t\u0005\u0003w\ti&\u0003\u0003\u0002`\u0005u\"\u0001\u0002+fgR\f\u0011dY8ogVlWmV5uQ\n\u0013xn[3s\r\u0006LG.\u001e:fgR!\u0011\u0011GA3\u0011\u0019\t9g\u0004a\u0001\t\u0006Aa.^7Ji\u0016\u00148/A\u0012uKN$8+Z3l\u0003:$7i\\7nSR<\u0016\u000e\u001e5Ce>\\WM\u001d$bS2,(/Z:)\u0007A\tY&A\u0010tK\u0016\\\u0017I\u001c3D_6l\u0017\u000e^,ji\"\u0014%o\\6fe\u001a\u000b\u0017\u000e\\;sKN$B!!\r\u0002r!1\u0011qM\tA\u0002\u0011\u000b\u0011\u0005^3tiN+(m]2sS\n,w\u000b[3o)>\u0004\u0018nY+oCZ\f\u0017\u000e\\1cY\u0016D3AEA.\u0003%!Xm\u001d;DY>\u001cX\rK\u0002\u0014\u00037\n!c\u00195fG.\u001cEn\\:f\u000f>|G\rU1uQR1\u0011\u0011GA@\u0003\u0007Ca!!!\u0015\u0001\u0004!\u0015A\u00038v[J+7m\u001c:eg\"1\u0011Q\u0011\u000bA\u0002}\fqa\u001a:pkBLE-\u0001\u0011dQ\u0016\u001c7n\u00117pg\u0016<\u0016\u000e\u001e5D_>\u0014H-\u001b8bi>\u0014h)Y5mkJ,G\u0003CA\u0019\u0003\u0017\u000bi)!%\t\r\u0005\u0005U\u00031\u0001E\u0011\u0019\ty)\u0006a\u0001\u007f\u0006aA-\u001f8b[&\u001cwI]8va\"1\u00111S\u000bA\u0002}\f1\"\\1ok\u0006dwI]8va\u0006ya-\u001b8e\u0007>|'\u000fZ5oCR|'\u000fF\u0002E\u00033Ca!a'\u0017\u0001\u0004y\u0018!B4s_V\u0004\u0018\u0001H2iK\u000e\\7\t\\8tK^KG\u000f[\"mkN$XM\u001d$bS2,(/\u001a\u000b\t\u0003c\t\t+a)\u0002(\"1\u0011\u0011Q\fA\u0002\u0011Ca!!*\u0018\u0001\u0004y\u0018AB4s_V\u0004\u0018\u0007\u0003\u0004\u0002*^\u0001\ra`\u0001\u0007OJ|W\u000f\u001d\u001a\u0002\rR,7\u000f\u001e*pY2Lgn\u001a\"s_.,'OU3ti\u0006\u0014Ho],ji\"\u001cV.\u00197mKJl\u0015\r_$s_V\u00048+\u001b>f\u0007>tg-[4ESN\u0014X\u000f\u001d;t\u0005&<wI]8va\"\u001a\u0001$a\u0017\u0002qQ,7\u000f^\"p]N,X.\u001a:SK\u000e,\u0017N^3t\r\u0006$\u0018\r\\#yG\u0016\u0004H/[8o/\",gn\u0012:pkB\u0004\u0016m]:fg6\u000b\u0007pU5{K\"\u001a\u0011$a\u0017\u00021Q,7\u000f^\"m_N,G)\u001e:j]\u001e\u0014VMY1mC:\u001cW\rK\u0002\u001b\u00037\n\u0011d\u00195fG.\u001cEn\\:f\tV\u0014\u0018N\\4SK\n\fG.\u00198dKRQ\u0011\u0011GA^\u0003{\u000b\t-!3\t\r\u0005\u00155\u00041\u0001\u0000\u0011\u0019\tyl\u0007a\u0001\u007f\u0006)Ao\u001c9jG\"1Ak\u0007a\u0001\u0003\u0007\u00042aVAc\u0013\r\t9\r\u0017\u0002\u0010\u000bb,7-\u001e;peN+'O^5dK\"9\u00111Z\u000eA\u0002\u00055\u0017a\u00072s_.,'o]!wC&d\u0017M\u00197f\tV\u0014\u0018N\\4DY>\u001cX\rE\u0002F\u0003\u001fL1!!5G\u0005\u001d\u0011un\u001c7fC:\f\u0001d\u0019:fCR,7i\u001c8tk6,'/\u00118e%\u0016\u001cW-\u001b<f)!\t9.!?\u0002|\u0006}\b\u0003CAm\u0003S\fi/!<\u000e\u0005\u0005m'\u0002BAo\u0003?\f\u0001bY8ogVlWM\u001d\u0006\u0005\u0003C\f\u0019/A\u0004dY&,g\u000e^:\u000b\u0007I\n)O\u0003\u0003\u0002h\u0006\u001d\u0013AB1qC\u000eDW-\u0003\u0003\u0002l\u0006m'!D&bM.\f7i\u001c8tk6,'\u000fE\u0003F\u0003_\f\u00190C\u0002\u0002r\u001a\u0013Q!\u0011:sCf\u00042!RA{\u0013\r\t9P\u0012\u0002\u0005\u0005f$X\r\u0003\u0004\u0002\u0006r\u0001\ra \u0005\b\u0003{d\u0002\u0019AAg\u00031i\u0017M\\;bY\u0006\u001b8/[4o\u0011\u0019\t\t\t\ba\u0001\t\u0006\u0019\"/Z2fSZ,W\t_1diJ+7m\u001c:egRA\u0011\u0011\u0007B\u0003\u0005\u000f\u0011I\u0001\u0003\u0004\u0002^v\u0001\ra\u001b\u0005\u0007\u0003\u0003k\u0002\u0019\u0001#\t\u0011\t-Q\u0004%AA\u0002A\u000b\u0011\u0002^5nK>,H/T:\u0002;I,7-Z5wK\u0016C\u0018m\u0019;SK\u000e|'\u000fZ:%I\u00164\u0017-\u001e7uIM*\"A!\u0005+\u0007A\u000bY\"\u0001\ftk\nl\u0017\u000e^\"m_N,\u0017I\u001c3WC2LG-\u0019;f))\u00119Ba\t\u0003&\t%\"1\u0007\t\u0006/\ne!QD\u0005\u0004\u00057A&A\u0002$viV\u0014X\rE\u0002F\u0005?I1A!\tG\u0005\r\te.\u001f\u0005\b\u0003;|\u0002\u0019AAl\u0011\u0019\u00119c\ba\u0001!\u0006q1\r\\8tKRKW.Z8vi6\u001b\bb\u0002B\u0016?\u0001\u0007!QF\u0001\u000f[&t7\t\\8tKRKW.Z't!\u0011)%q\u0006)\n\u0007\tEbI\u0001\u0004PaRLwN\u001c\u0005\b\u0005ky\u0002\u0019\u0001B\u0017\u00039i\u0017\r_\"m_N,G+[7f\u001bN\f\u0001c\u00195fG.\u001cEn\\:fIN#\u0018\r^3\u0015\r\u0005E\"1\bB\u001f\u0011\u0019\t)\t\ta\u0001\u007f\"1!q\b\u0011A\u0002\u0011\u000b\u0001cY8n[&$H/\u001a3SK\u000e|'\u000fZ:\u0003+\t{WO\\2f\u0005J|7.\u001a:TG\",G-\u001e7feN\u0019\u0011E!\u0012\u0011\u0007i\u00129%C\u0002\u0003Jm\u0012!c\u00155vi\u0012|wO\\1cY\u0016$\u0006N]3bI\u0006Ia.^7Ji\u0016\u00148\u000f\t\u000b\u0005\u0005\u001f\u0012\t\u0006\u0005\u0002mC!1\u0011q\r\u0013A\u0002\u0011\u000bA!\u001b;fe\u0006A\u0011\u000e^3s?\u0012*\u0017\u000f\u0006\u0003\u00022\te\u0003\u0002\u0003B.M\u0005\u0005\t\u0019\u0001#\u0002\u0007a$\u0013'A\u0003ji\u0016\u0014\b%\u0001\u0004e_^{'o[\u0001\u0016GJ,\u0017\r^3U_BL7\rU1si&$\u0018n\u001c8t))\u0011)Ga\u001e\u0003z\tu$\u0011\u0011\t\u0007\u0003\u0003\u00119Ga\u001b\n\t\t%\u00141\u0003\u0002\u0004'\u0016$\b\u0003\u0002B7\u0005gj!Aa\u001c\u000b\t\tE\u00141]\u0001\u0007G>lWn\u001c8\n\t\tU$q\u000e\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o\u0011\u0019\ty,\u000ba\u0001\u007f\"1!1P\u0015A\u0002\u0011\u000bQB\\;n!\u0006\u0014H/\u001b;j_:\u001c\bB\u0002B@S\u0001\u0007A)A\tsKBd\u0017nY1uS>tg)Y2u_JD\u0011Ba!*!\u0003\u0005\rA!\"\u0002\u0017Q|\u0007/[2D_:4\u0017n\u001a\t\u0005\u0005\u000f\u0013I)D\u0001[\u0013\r\u0011YI\u0017\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\u0018aH2sK\u0006$X\rV8qS\u000e\u0004\u0016M\u001d;ji&|gn\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!\u0011\u0013\u0016\u0005\u0005\u000b\u000bY\"\u0001\u0007qe>$WoY3s'\u0016tG\r\u0006\u0006\u00022\t]%Q\u0015BT\u0005SCqA!',\u0001\u0004\u0011Y*\u0001\u0005qe>$WoY3s!!\u0011iJ!)\u0002n\u00065XB\u0001BP\u0015\u0011\u0011I*a8\n\t\t\r&q\u0014\u0002\u000e\u0017\u000647.\u0019)s_\u0012,8-\u001a:\t\r\u0005\u00055\u00061\u0001E\u0011!\tyl\u000bI\u0001\u0002\u0004y\b\"\u0003B>WA\u0005\t\u0019\u0001BV!\u0011)%q\u0006#\u0002-A\u0014x\u000eZ;dKJ\u001cVM\u001c3%I\u00164\u0017-\u001e7uIM\na\u0003\u001d:pIV\u001cWM]*f]\u0012$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005gSCAa+\u0002\u001c\u0001")
public class ConsumerBounceTest
extends AbstractConsumerTest {
    private final int maxGroupSize;
    private final Some<Object> gracefulCloseTimeMs = new Some((Object)BoxesRunTime.boxToLong((long)1000L));
    private final ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
    private final Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);

    public int maxGroupSize() {
        return this.maxGroupSize;
    }

    public Some<Object> gracefulCloseTimeMs() {
        return this.gracefulCloseTimeMs;
    }

    public ScheduledExecutorService executor() {
        return this.executor;
    }

    public Buffer<AbstractConsumerTest.ConsumerAssignmentPoller> consumerPollers() {
        return this.consumerPollers;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return this.generateKafkaConfigs(this.generateKafkaConfigs$default$1());
    }

    private Seq<KafkaConfig> generateKafkaConfigs(String maxGroupSize) {
        Properties properties = new Properties();
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicReplicationFactorProp(), "3");
        properties.put(KafkaConfig$.MODULE$.OffsetsTopicPartitionsProp(), "1");
        properties.put(KafkaConfig$.MODULE$.GroupMinSessionTimeoutMsProp(), "10");
        properties.put(KafkaConfig$.MODULE$.GroupInitialRebalanceDelayMsProp(), "0");
        properties.put(KafkaConfig$.MODULE$.GroupMaxSizeProp(), maxGroupSize);
        properties.put(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp(), "true");
        properties.put(KafkaConfig$.MODULE$.AutoCreateTopicsEnableProp(), "false");
        return (Seq)FixedPortTestUtils$.MODULE$.createBrokerConfigs(this.brokerCount(), this.zkConnect(), false, false).map((Function1 & Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, properties));
    }

    private String generateKafkaConfigs$default$1() {
        return Integer.toString(this.maxGroupSize());
    }

    @Override
    @AfterEach
    public void tearDown() {
        try {
            this.consumerPollers().foreach((Function1 & Serializable)x$2 -> {
                x$2.shutdown();
                return BoxedUnit.UNIT;
            });
            this.executor().shutdownNow();
            Assertions.assertTrue((boolean)this.executor().awaitTermination(5000L, TimeUnit.MILLISECONDS), (String)"Executor did not terminate");
        }
        finally {
            super.tearDown();
        }
    }

    @Test
    @Disabled
    public void testConsumptionWithBrokerFailures() {
        this.consumeWithBrokerFailures(10);
    }

    public void consumeWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.producerSend(producer, numRecords, this.topic(), (Option<Object>)None$.MODULE$);
        LongRef consumed = LongRef.create((long)0L);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(Collections.singletonList(this.topic()));
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            Iterable records = CollectionConverters$.MODULE$.IterableHasAsScala((java.lang.Iterable)consumer.poll(100L)).asScala();
            Assertions.assertEquals((Object)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()})), (Object)CollectionConverters$.MODULE$.SetHasAsScala(consumer.assignment()).asScala());
            records.foreach((Function1 & Serializable)record -> {
                ConsumerBounceTest.$anonfun$consumeWithBrokerFailures$1(consumed, record);
                return BoxedUnit.UNIT;
            });
            if (!records.nonEmpty()) continue;
            consumer.commitSync();
            Assertions.assertEquals((long)consumer.position(this.tp()), (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
            if (consumer.position(this.tp()) != (long)numRecords) continue;
            consumer.seekToBeginning(Collections.emptyList());
            consumed.elem = 0L;
        }
        scheduler.shutdown();
    }

    @Test
    public void testSeekAndCommitWithBrokerFailures() {
        this.seekAndCommitWithBrokerFailures(5);
    }

    public void seekAndCommitWithBrokerFailures(int numIters) {
        int numRecords = 1000;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.producerSend(producer, numRecords, this.topic(), (Option<Object>)None$.MODULE$);
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.assign(Collections.singletonList(this.tp()));
        consumer.seek(this.tp(), 0L);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$seekAndCommitWithBrokerFailures$1(this, numRecords)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Failed to update high watermark for followers after timeout");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        BounceBrokerScheduler scheduler = new BounceBrokerScheduler(this, numIters);
        scheduler.start();
        while (scheduler.isRunning()) {
            int coin = TestUtils$.MODULE$.random().nextInt(3);
            if (coin == 0) {
                this.info((Function0<String>)(Function0 & Serializable)() -> "Seeking to end of log");
                consumer.seekToEnd(Collections.emptyList());
                Assertions.assertEquals((long)numRecords, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin == 1) {
                long pos = TestUtils$.MODULE$.random().nextInt(numRecords);
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(11).append("Seeking to ").append(pos).toString());
                consumer.seek(this.tp(), pos);
                Assertions.assertEquals((long)pos, (long)consumer.position(this.tp()));
                continue;
            }
            if (coin != 2) continue;
            this.info((Function0<String>)(Function0 & Serializable)() -> "Committing offset.");
            consumer.commitSync();
            Assertions.assertEquals((long)consumer.position(this.tp()), (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        }
    }

    @Test
    public void testSubscribeWhenTopicUnavailable() {
        int numRecords = 1000;
        String newtopic = "newtopic";
        KafkaConsumer consumer = this.createConsumer(this.createConsumer$default$1(), this.createConsumer$default$2(), this.createConsumer$default$3(), this.createConsumer$default$4());
        consumer.subscribe(Collections.singleton(newtopic));
        this.executor().schedule(new Runnable(this, newtopic){
            private final /* synthetic */ ConsumerBounceTest $outer;
            private final String newtopic$1;

            public void run() {
                this.$outer.createTopic(this.newtopic$1, this.$outer.brokerCount(), this.$outer.brokerCount(), this.$outer.createTopic$default$4());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.newtopic$1 = newtopic$1;
            }
        }, 2L, TimeUnit.SECONDS);
        consumer.poll(Duration.ZERO);
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        AbstractConsumerTest.ConsumerAssignmentPoller poller = new AbstractConsumerTest.ConsumerAssignmentPoller((AbstractConsumerTest)this, (Consumer<byte[], byte[]>)consumer, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{newtopic}))));
        this.consumerPollers().$plus$eq((Object)poller);
        poller.start();
        this.sendRecords$1(numRecords, newtopic, producer);
        this.receiveExactRecords(poller, numRecords, 10000L);
        poller.shutdown();
        this.servers().foreach((Function1 & Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        Thread.sleep(500L);
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        AbstractConsumerTest.ConsumerAssignmentPoller poller2 = new AbstractConsumerTest.ConsumerAssignmentPoller((AbstractConsumerTest)this, (Consumer<byte[], byte[]>)consumer, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{newtopic}))));
        this.consumerPollers().$plus$eq((Object)poller2);
        poller2.start();
        this.sendRecords$1(numRecords, newtopic, producer);
        this.receiveExactRecords(poller, numRecords, 10000L);
    }

    @Test
    public void testClose() {
        int numRecords = 10;
        KafkaProducer producer = this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3());
        this.producerSend(producer, numRecords, this.topic(), (Option<Object>)None$.MODULE$);
        this.checkCloseGoodPath(numRecords, "group1");
        this.checkCloseWithCoordinatorFailure(numRecords, "group2", "group3");
        this.checkCloseWithClusterFailure(numRecords, "group4", "group5");
    }

    private void checkCloseGoodPath(int numRecords, String groupId) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerAndReceive(groupId, false, numRecords);
        this.submitCloseAndValidate(consumer, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs()).get();
        this.checkClosedState(groupId, numRecords);
    }

    private void checkCloseWithCoordinatorFailure(int numRecords, String dynamicGroup, String manualGroup) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(dynamicGroup, false, numRecords);
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(manualGroup, true, numRecords);
        this.killBroker(this.findCoordinator(dynamicGroup));
        this.killBroker(this.findCoordinator(manualGroup));
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs());
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs());
        future1.get();
        future2.get();
        this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        this.checkClosedState(dynamicGroup, 0);
        this.checkClosedState(manualGroup, numRecords);
    }

    private int findCoordinator(String group) {
        int n;
        FindCoordinatorRequest request = (FindCoordinatorRequest)new FindCoordinatorRequest.Builder(new FindCoordinatorRequestData().setKeyType(FindCoordinatorRequest.CoordinatorType.GROUP.id()).setCoordinatorKeys(Collections.singletonList(group))).build();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (true) {
            FindCoordinatorResponse $anonfun$findCoordinator$1_response = (FindCoordinatorResponse)this.connectAndReceive((AbstractRequest)request, this.connectAndReceive$default$2(), this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FindCoordinatorResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
            n = $anonfun$findCoordinator$1_response.node().id();
            Errors errors = $anonfun$findCoordinator$1_response.error();
            Errors errors2 = Errors.NONE;
            boolean bl = !(errors != null ? !errors.equals(errors2) : errors2 != null);
            Object var9_6 = null;
            errors2 = null;
            if (bl) break;
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)ConsumerBounceTest.$anonfun$findCoordinator$2(group));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        return n;
    }

    private void checkCloseWithClusterFailure(int numRecords, String group1, String group2) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerAndReceive(group1, false, numRecords);
        int requestTimeout = 6000;
        this.consumerConfig().setProperty("session.timeout.ms", "5000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("request.timeout.ms", Integer.toString(requestTimeout));
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerAndReceive(group2, true, numRecords);
        this.servers().foreach((Function1 & Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        int closeTimeout = 2000;
        Future<Object> future1 = this.submitCloseAndValidate(consumer1, closeTimeout, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)closeTimeout)));
        Future<Object> future2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)requestTimeout)));
        future1.get();
        future2.get();
    }

    @Test
    public void testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup() {
        String group = "group-max-size-test";
        String topic = "group-max-size-test";
        int maxGroupSize = 2;
        int consumerCount = maxGroupSize + 1;
        int partitionCount = consumerCount * 2;
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        scala.collection.immutable.Set<TopicPartition> partitions = this.createTopicPartitions(topic, partitionCount, this.brokerCount(), new Properties());
        this.addConsumersToGroupAndWaitForGroupAssignment(consumerCount, (Buffer<KafkaConsumer<byte[], byte[]>>)((Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), this.consumerPollers(), (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), partitions, group);
        Seq<KafkaConfig> newConfigs = this.generateKafkaConfigs(Integer.toString(maxGroupSize));
        this.servers().indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)serverIdx -> {
            void createServer_time;
            this.killBroker(serverIdx);
            KafkaConfig config = (KafkaConfig)newConfigs.apply(serverIdx);
            Time time = this.brokerTime(config.brokerId());
            TestUtils$ createServer_this = TestUtils$.MODULE$;
            None$ createServer_createServer_threadNamePrefix = None$.MODULE$;
            Object var6_6 = null;
            Object var4_5 = null;
            time = null;
            this.servers().update(serverIdx, (Object)createServer_this.createServer(config, (Time)createServer_time, (Option<String>)createServer_createServer_threadNamePrefix, false));
            this.restartDeadBrokers(this.restartDeadBrokers$default$1());
        });
        long l = 100L;
        long waitUntilTrue_waitTimeMs = 10000L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$3(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"The remaining consumers in the group could not fetch the expected records");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l));
        }
        Assertions.assertEquals((int)1, (int)this.raisedExceptions$1().size());
        Assertions.assertTrue((boolean)(this.raisedExceptions$1().head() instanceof GroupMaxSizeReachedException));
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize() {
        void var5_5;
        String group = "fatal-exception-test";
        String topic = "fatal-exception-test";
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        scala.collection.immutable.Set<TopicPartition> partitions = this.createTopicPartitions(topic, this.maxGroupSize(), this.brokerCount(), new Properties());
        this.addConsumersToGroupAndWaitForGroupAssignment(this.maxGroupSize(), (Buffer<KafkaConsumer<byte[], byte[]>>)((Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), this.consumerPollers(), (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), partitions, group);
        Tuple2<Buffer<KafkaConsumer<byte[], byte[]>>, Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>> tuple2 = this.addConsumersToGroup(1, (Buffer<KafkaConsumer<byte[], byte[]>>)((Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (Buffer<AbstractConsumerTest.ConsumerAssignmentPoller>)((Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), partitions, group);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Buffer rejectedConsumerPollers = (Buffer)tuple2._2();
        AbstractConsumerTest.ConsumerAssignmentPoller rejectedConsumer = (AbstractConsumerTest.ConsumerAssignmentPoller)((Object)var5_5.head());
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$1(rejectedConsumer)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Extra consumer did not throw an exception");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        Assertions.assertTrue((boolean)(rejectedConsumer.thrownException().get() instanceof GroupMaxSizeReachedException));
        this.producerSend(this.createProducer(this.createProducer$default$1(), this.createProducer$default$2(), this.createProducer$default$3()), this.maxGroupSize() * 100, topic, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)partitions.size())));
        long l3 = 100L;
        long waitUntilTrue_waitTimeMs = 10000L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$3(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + waitUntilTrue_waitTimeMs) {
                Assertions.fail((String)"The consumers in the group could not fetch the expected records");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(waitUntilTrue_waitTimeMs), l3));
        }
    }

    @Test
    public void testCloseDuringRebalance() {
        String topic = "closetest";
        this.createTopic(topic, 10, this.brokerCount(), this.createTopic$default$4());
        this.consumerConfig().setProperty("max.poll.interval.ms", "60000");
        this.consumerConfig().setProperty("heartbeat.interval.ms", "1000");
        this.consumerConfig().setProperty("enable.auto.commit", "false");
        this.checkCloseDuringRebalance("group1", topic, this.executor(), true);
    }

    private void checkCloseDuringRebalance(String groupId, String topic, ExecutorService executor, boolean brokersAvailableDuringClose) {
        KafkaConsumer<byte[], byte[]> consumer1 = this.createConsumerWithGroupId(groupId);
        ConsumerBounceTest.waitForRebalance$1(2000L, ConsumerBounceTest.subscribeAndPoll$1(consumer1, (Option)None$.MODULE$, executor, topic), (scala.collection.immutable.Seq)Nil$.MODULE$);
        KafkaConsumer<byte[], byte[]> consumer2 = this.createConsumerWithGroupId(groupId);
        ConsumerBounceTest.waitForRebalance$1(2000L, ConsumerBounceTest.subscribeAndPoll$1(consumer2, (Option)None$.MODULE$, executor, topic), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer1}));
        Future rebalanceFuture = this.createConsumerToRebalance$1(groupId, executor, topic);
        Future<Object> closeFuture1 = this.submitCloseAndValidate(consumer1, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)this.gracefulCloseTimeMs());
        ConsumerBounceTest.waitForRebalance$1(2000L, rebalanceFuture, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new KafkaConsumer[]{consumer2}));
        this.createConsumerToRebalance$1(groupId, executor, topic);
        this.servers().foreach((Function1 & Serializable)server -> {
            this.killBroker(server.config().brokerId());
            return BoxedUnit.UNIT;
        });
        Future<Object> closeFuture2 = this.submitCloseAndValidate(consumer2, Long.MAX_VALUE, (Option<Object>)None$.MODULE$, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)0L)));
        closeFuture1.get(2000L, TimeUnit.MILLISECONDS);
        closeFuture2.get(2000L, TimeUnit.MILLISECONDS);
    }

    private KafkaConsumer<byte[], byte[]> createConsumerAndReceive(String groupId, boolean manualAssign, int numRecords) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId);
        AbstractConsumerTest.ConsumerAssignmentPoller consumerPoller = manualAssign ? this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)Nil$.MODULE$)), (scala.collection.immutable.Set<TopicPartition>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()})))) : this.subscribeConsumerAndStartPolling((Consumer<byte[], byte[]>)consumer, (List<String>)((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}))), this.subscribeConsumerAndStartPolling$default$3());
        this.receiveExactRecords(consumerPoller, numRecords, 60000L);
        consumerPoller.shutdown();
        return consumer;
    }

    private void receiveExactRecords(AbstractConsumerTest.ConsumerAssignmentPoller consumer, int numRecords, long timeoutMs) {
        long l = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$receiveExactRecords$1(consumer, numRecords)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + timeoutMs) {
                Assertions.fail((String)ConsumerBounceTest.$anonfun$receiveExactRecords$2(numRecords, consumer));
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(timeoutMs), l));
        }
    }

    private long receiveExactRecords$default$3() {
        return 60000L;
    }

    private Future<Object> submitCloseAndValidate(KafkaConsumer<byte[], byte[]> consumer, long closeTimeoutMs, Option<Object> minCloseTimeMs, Option<Object> maxCloseTimeMs) {
        return this.executor().submit(() -> {
            int closeGraceTimeMs = 2000;
            long startMs = System.currentTimeMillis();
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("Closing consumer with timeout ").append(closeTimeoutMs).append(" ms.").toString());
            consumer.close(Duration.ofMillis(closeTimeoutMs));
            long timeTakenMs = System.currentTimeMillis() - startMs;
            maxCloseTimeMs.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)ms -> Assertions.assertTrue((timeTakenMs < ms + (long)closeGraceTimeMs ? 1 : 0) != 0, (String)new StringBuilder(20).append("Close took too long ").append(timeTakenMs).toString()));
            minCloseTimeMs.foreach((Function1)(JFunction1.mcVJ.sp & Serializable)ms -> Assertions.assertTrue((timeTakenMs >= ms ? 1 : 0) != 0, (String)new StringBuilder(27).append("Close finished too quickly ").append(timeTakenMs).toString()));
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(34).append("consumer.close() completed in ").append(timeTakenMs).append(" ms.").toString());
        }, BoxesRunTime.boxToInteger((int)0));
    }

    private void checkClosedState(String groupId, int committedRecords) {
        Semaphore assignSemaphore = new Semaphore(0);
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId);
        consumer.subscribe(Collections.singletonList(this.topic()), new ConsumerRebalanceListener(null, assignSemaphore){
            private final Semaphore assignSemaphore$1;

            public void onPartitionsLost(Collection<TopicPartition> x$1) {
                super.onPartitionsLost(x$1);
            }

            public void onPartitionsAssigned(Collection<TopicPartition> partitions) {
                this.assignSemaphore$1.release();
            }

            public void onPartitionsRevoked(Collection<TopicPartition> partitions) {
            }
            {
                this.assignSemaphore$1 = assignSemaphore$1;
            }
        });
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ConsumerBounceTest.$anonfun$checkClosedState$1(consumer, assignSemaphore)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                Assertions.fail((String)"Assignment did not complete on time");
            }
            Thread.sleep(RichLong$.MODULE$.min$extension(Predef$.MODULE$.longWrapper(l), l2));
        }
        if (committedRecords > 0) {
            Assertions.assertEquals((long)committedRecords, (long)((OffsetAndMetadata)consumer.committed(CollectionConverters$.MODULE$.SetHasAsJava((Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{this.tp()}))).asJava()).get(this.tp())).offset());
        }
        consumer.close();
    }

    private scala.collection.immutable.Set<TopicPartition> createTopicPartitions(String topic, int numPartitions, int replicationFactor, Properties topicConfig) {
        this.createTopic(topic, numPartitions, replicationFactor, topicConfig);
        return package$.MODULE$.Range().apply(0, numPartitions).map((Function1 & Serializable)part -> ConsumerBounceTest.$anonfun$createTopicPartitions$1(topic, BoxesRunTime.unboxToInt((Object)part))).toSet();
    }

    private Properties createTopicPartitions$default$4() {
        return new Properties();
    }

    private void producerSend(KafkaProducer<byte[], byte[]> producer, int numRecords, String topic, Option<Object> numPartitions) {
        IntRef partitionIndex = IntRef.create((int)0);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), numRecords).map((Function1 & Serializable)i -> ConsumerBounceTest.$anonfun$producerSend$1(this, producer, topic, numPartitions, partitionIndex, BoxesRunTime.unboxToInt((Object)i))).map((Function1 & Serializable)x$4 -> (RecordMetadata)x$4.get());
    }

    private String producerSend$default$3() {
        return this.topic();
    }

    private Option<Object> producerSend$default$4() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ void $anonfun$consumeWithBrokerFailures$1(LongRef consumed$1, ConsumerRecord record) {
        Assertions.assertEquals((long)consumed$1.elem, (long)record.offset());
        ++consumed$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$seekAndCommitWithBrokerFailures$2(ConsumerBounceTest $this, int numRecords$1, KafkaServer server) {
        return ((Log)server.replicaManager().localLog($this.tp()).get()).highWatermark() == (long)numRecords$1;
    }

    public static final /* synthetic */ boolean $anonfun$seekAndCommitWithBrokerFailures$1(ConsumerBounceTest $this, int numRecords$1) {
        return $this.servers().forall((Function1 & Serializable)server -> BoxesRunTime.boxToBoolean((boolean)ConsumerBounceTest.$anonfun$seekAndCommitWithBrokerFailures$2($this, numRecords$1, server)));
    }

    public static final /* synthetic */ String $anonfun$seekAndCommitWithBrokerFailures$3() {
        return "Failed to update high watermark for followers after timeout";
    }

    public static final /* synthetic */ void $anonfun$testSubscribeWhenTopicUnavailable$2(IntRef remainingRecords$1, Future future) {
        try {
            future.get();
            --remainingRecords$1.elem;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private final void sendRecords$1(int numRecords, String topic, KafkaProducer producer$1) {
        IntRef remainingRecords = IntRef.create((int)numRecords);
        long endTimeMs = System.currentTimeMillis() + 20000L;
        while (remainingRecords.elem > 0 && System.currentTimeMillis() < endTimeMs) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), remainingRecords.elem).map((Function1 & Serializable)i -> producer$1.send(new ProducerRecord(topic, Predef$.MODULE$.int2Integer(this.part()), (Object)Integer.toString(BoxesRunTime.unboxToInt((Object)i)).getBytes(), (Object)Integer.toString(BoxesRunTime.unboxToInt((Object)i)).getBytes()))).map((Function1 & Serializable)future -> {
                ConsumerBounceTest.$anonfun$testSubscribeWhenTopicUnavailable$2(remainingRecords, future);
                return BoxedUnit.UNIT;
            });
        }
        Assertions.assertEquals((int)0, (int)remainingRecords.elem);
    }

    public static final /* synthetic */ boolean $anonfun$findCoordinator$1(ConsumerBounceTest $this, FindCoordinatorRequest request$1, IntRef nodeId$1) {
        FindCoordinatorResponse response = (FindCoordinatorResponse)$this.connectAndReceive((AbstractRequest)request$1, $this.connectAndReceive$default$2(), $this.connectAndReceive$default$3(), ClassTag$.MODULE$.apply(FindCoordinatorResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()));
        nodeId$1.elem = response.node().id();
        Errors errors = response.error();
        Errors errors2 = Errors.NONE;
        return !(errors != null ? !errors.equals(errors2) : errors2 != null);
    }

    public static final /* synthetic */ String $anonfun$findCoordinator$2(String group$1) {
        return new StringBuilder(37).append("Failed to find coordinator for group ").append(group$1).toString();
    }

    private final Seq raisedExceptions$1() {
        return (Seq)this.consumerPollers().flatten((Function1 & Serializable)x$3 -> x$3.thrownException());
    }

    public static final /* synthetic */ boolean $anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$3(ConsumerBounceTest $this) {
        return $this.raisedExceptions$1().nonEmpty();
    }

    public static final /* synthetic */ String $anonfun$testRollingBrokerRestartsWithSmallerMaxGroupSizeConfigDisruptsBigGroup$4() {
        return "The remaining consumers in the group could not fetch the expected records";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$1(AbstractConsumerTest.ConsumerAssignmentPoller rejectedConsumer$1) {
        return rejectedConsumer$1.thrownException().isDefined();
    }

    public static final /* synthetic */ String $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$2() {
        return "Extra consumer did not throw an exception";
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$4(AbstractConsumerTest.ConsumerAssignmentPoller p) {
        return p.receivedMessages() >= 100;
    }

    public static final /* synthetic */ boolean $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$3(ConsumerBounceTest $this) {
        return $this.consumerPollers().forall((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)ConsumerBounceTest.$anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$4(p)));
    }

    public static final /* synthetic */ String $anonfun$testConsumerReceivesFatalExceptionWhenGroupPassesMaxSize$5() {
        return "The consumers in the group could not fetch the expected records";
    }

    private static final Future subscribeAndPoll$1(KafkaConsumer consumer, Option revokeSemaphore, ExecutorService executor$1, String topic$2) {
        return executor$1.submit(() -> {
            consumer.subscribe(Collections.singletonList(topic$2));
            revokeSemaphore.foreach((Function1 & Serializable)s -> {
                s.release();
                return BoxedUnit.UNIT;
            });
            consumer.poll(0L);
        }, BoxesRunTime.boxToInteger((int)0));
    }

    private static final Option subscribeAndPoll$default$2$1() {
        return None$.MODULE$;
    }

    private static final void waitForRebalance$1(long timeoutMs, Future future, scala.collection.immutable.Seq otherConsumers) {
        long startMs = System.currentTimeMillis();
        while (System.currentTimeMillis() < startMs + timeoutMs && !future.isDone()) {
            otherConsumers.foreach((Function1 & Serializable)consumer -> consumer.poll(Duration.ofMillis(100L)));
        }
        Assertions.assertTrue((boolean)future.isDone(), (String)"Rebalance did not complete in time");
    }

    private final Future createConsumerToRebalance$1(String groupId$1, ExecutorService executor$1, String topic$2) {
        KafkaConsumer<byte[], byte[]> consumer = this.createConsumerWithGroupId(groupId$1);
        Semaphore rebalanceSemaphore = new Semaphore(0);
        Future future = ConsumerBounceTest.subscribeAndPoll$1(consumer, (Option)new Some((Object)rebalanceSemaphore), executor$1, topic$2);
        Assertions.assertTrue((boolean)rebalanceSemaphore.tryAcquire(2000L, TimeUnit.MILLISECONDS), (String)"Rebalance not triggered");
        Assertions.assertFalse((boolean)future.isDone(), (String)"Rebalance completed too early");
        return future;
    }

    public static final /* synthetic */ boolean $anonfun$receiveExactRecords$1(AbstractConsumerTest.ConsumerAssignmentPoller consumer$2, int numRecords$2) {
        return consumer$2.receivedMessages() == numRecords$2;
    }

    public static final /* synthetic */ String $anonfun$receiveExactRecords$2(int numRecords$2, AbstractConsumerTest.ConsumerAssignmentPoller consumer$2) {
        return new StringBuilder(48).append("Consumer did not receive expected ").append(numRecords$2).append(". It received ").append(consumer$2.receivedMessages()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$checkClosedState$1(KafkaConsumer consumer$4, Semaphore assignSemaphore$1) {
        consumer$4.poll(Duration.ofMillis(100L));
        return assignSemaphore$1.tryAcquire();
    }

    public static final /* synthetic */ String $anonfun$checkClosedState$2() {
        return "Assignment did not complete on time";
    }

    public static final /* synthetic */ TopicPartition $anonfun$createTopicPartitions$1(String topic$3, int part) {
        return new TopicPartition(topic$3, part);
    }

    private final int getPartition$1(Option numPartitions$1, IntRef partitionIndex$1) {
        int n;
        if (numPartitions$1 instanceof Some) {
            int partitions = BoxesRunTime.unboxToInt((Object)((Some)numPartitions$1).value());
            int nextPart = partitionIndex$1.elem % partitions;
            ++partitionIndex$1.elem;
            n = nextPart;
        } else if (None$.MODULE$.equals(numPartitions$1)) {
            n = this.part();
        } else {
            throw new MatchError((Object)numPartitions$1);
        }
        return n;
    }

    public static final /* synthetic */ Future $anonfun$producerSend$1(ConsumerBounceTest $this, KafkaProducer producer$2, String topic$4, Option numPartitions$1, IntRef partitionIndex$1, int i) {
        int n;
        if (numPartitions$1 instanceof Some) {
            int getPartition$1_partitions = BoxesRunTime.unboxToInt((Object)((Some)numPartitions$1).value());
            int getPartition$1_nextPart = partitionIndex$1.elem % getPartition$1_partitions;
            ++partitionIndex$1.elem;
            n = getPartition$1_nextPart;
        } else if (None$.MODULE$.equals(numPartitions$1)) {
            n = $this.part();
        } else {
            throw new MatchError((Object)numPartitions$1);
        }
        return producer$2.send(new ProducerRecord(topic$4, Predef$.MODULE$.int2Integer(n), (Object)Integer.toString(i).getBytes(), (Object)Integer.toString(i).getBytes()));
    }

    public ConsumerBounceTest() {
        this.maxGroupSize = 5;
        this.consumerConfig().setProperty("enable.auto.commit", "true");
    }

    private class BounceBrokerScheduler
    extends ShutdownableThread {
        private final int numIters;
        private int iter;
        public final /* synthetic */ ConsumerBounceTest $outer;

        public int numIters() {
            return this.numIters;
        }

        public int iter() {
            return this.iter;
        }

        public void iter_$eq(int x$1) {
            this.iter = x$1;
        }

        public void doWork() {
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().killRandomBroker();
            Thread.sleep(500L);
            this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().restartDeadBrokers(this.kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer().restartDeadBrokers$default$1());
            this.iter_$eq(this.iter() + 1);
            if (this.iter() == this.numIters()) {
                this.initiateShutdown();
                return;
            }
            Thread.sleep(500L);
        }

        public /* synthetic */ ConsumerBounceTest kafka$api$ConsumerBounceTest$BounceBrokerScheduler$$$outer() {
            return this.$outer;
        }

        public BounceBrokerScheduler(ConsumerBounceTest $outer, int numIters) {
            this.numIters = numIters;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            super("daemon-bounce-broker", false);
            this.iter = 0;
        }
    }
}

