/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.net.Socket;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.server.BaseRequestTest;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaMetricReporterExceptionHandlingTest$;
import kafka.utils.Logging;
import kafka.utils.NotNothing$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricsContext;
import org.apache.kafka.common.metrics.MetricsReporter;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ListGroupsRequest;
import org.apache.kafka.common.requests.ListGroupsResponse;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import scala.$less$colon$less$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005ud\u0001\u0002\u000e\u001c\u0001\u0001BQ!\n\u0001\u0005\u0002\u0019BQ\u0001\u000b\u0001\u0005B%BQ\u0001\r\u0001\u0005BEBQa\u0010\u0001\u0005B\u0001CQA\u0014\u0001\u0005B\u0001CQa\u0015\u0001\u0005\u0002\u0001;Q\u0001W\u000e\t\u0002e3QAG\u000e\t\u0002iCQ!\n\u0005\u0005\u0002yCqa\u0018\u0005A\u0002\u0013\u0005\u0001\rC\u0004j\u0011\u0001\u0007I\u0011\u00016\t\r5D\u0001\u0015)\u0003b\u0011\u001dq\u0007\u00021A\u0005\u0002\u0001Dqa\u001c\u0005A\u0002\u0013\u0005\u0001\u000f\u0003\u0004s\u0011\u0001\u0006K!\u0019\u0004\u0005g\"\u0001A\u000f\u0003\u0004&!\u0011\u0005\u0011Q\u0002\u0005\b\u0003'\u0001B\u0011AA\u000b\u0011\u001d\ty\u0005\u0005C\u0001\u0003#Bq!!\u0019\u0011\t\u0003\t\u0019\u0007C\u0004\u0002jA!\t!a\u001b\t\r\u0005=\u0004\u0003\"\u0001A\r\u0019\t\t\b\u0003\u0001\u0002t!1Qe\u0006C\u0001\u0003kBq!!\u0019\u0018\t\u0003\nIH\u0001\u0015LC\u001a\\\u0017-T3ue&\u001c'+\u001a9peR,'/\u0012=dKB$\u0018n\u001c8IC:$G.\u001b8h)\u0016\u001cHO\u0003\u0002\u001d;\u000511/\u001a:wKJT\u0011AH\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0011\u0005\u0005\u0002#G5\t1$\u0003\u0002%7\ty!)Y:f%\u0016\fX/Z:u)\u0016\u001cH/\u0001\u0004=S:LGO\u0010\u000b\u0002OA\u0011!\u0005A\u0001\fEJ|7.\u001a:D_VtG/F\u0001+!\tYc&D\u0001-\u0015\u0005i\u0013!B:dC2\f\u0017BA\u0018-\u0005\rIe\u000e^\u0001\u0018EJ|7.\u001a:Qe>\u0004XM\u001d;z\u001fZ,'O]5eKN$\"AM\u001b\u0011\u0005-\u001a\u0014B\u0001\u001b-\u0005\u0011)f.\u001b;\t\u000bY\u001a\u0001\u0019A\u001c\u0002\u0015A\u0014x\u000e]3si&,7\u000f\u0005\u00029{5\t\u0011H\u0003\u0002;w\u0005!Q\u000f^5m\u0015\u0005a\u0014\u0001\u00026bm\u0006L!AP\u001d\u0003\u0015A\u0013x\u000e]3si&,7/A\u0003tKR,\u0006\u000fF\u00013Q\t!!\t\u0005\u0002D\u00196\tAI\u0003\u0002F\r\u0006\u0019\u0011\r]5\u000b\u0005\u001dC\u0015a\u00026va&$XM\u001d\u0006\u0003\u0013*\u000bQA[;oSRT\u0011aS\u0001\u0004_J<\u0017BA'E\u0005)\u0011UMZ8sK\u0016\u000b7\r[\u0001\ti\u0016\f'\u000fR8x]\"\u0012Q\u0001\u0015\t\u0003\u0007FK!A\u0015#\u0003\u0013\u00053G/\u001a:FC\u000eD\u0017a\u0007;fgR\u0014u\u000e\u001e5SKB|'\u000f^3sg\u0006\u0013X-\u00138w_.,G\r\u000b\u0002\u0007+B\u00111IV\u0005\u0003/\u0012\u0013A\u0001V3ti\u0006A3*\u00194lC6+GO]5d%\u0016\u0004xN\u001d;fe\u0016C8-\u001a9uS>t\u0007*\u00198eY&tw\rV3tiB\u0011!\u0005C\n\u0003\u0011m\u0003\"a\u000b/\n\u0005uc#AB!osJ+g\rF\u0001Z\u0003Y9wn\u001c3SKB|'\u000f^3s%\u0016<\u0017n\u001d;fe\u0016$W#A1\u0011\u0005\t<W\"A2\u000b\u0005\u0011,\u0017AB1u_6L7M\u0003\u0002gs\u0005Q1m\u001c8dkJ\u0014XM\u001c;\n\u0005!\u001c'!D!u_6L7-\u00138uK\u001e,'/\u0001\u000eh_>$'+\u001a9peR,'OU3hSN$XM]3e?\u0012*\u0017\u000f\u0006\u00023W\"9AnCA\u0001\u0002\u0004\t\u0017a\u0001=%c\u00059rm\\8e%\u0016\u0004xN\u001d;feJ+w-[:uKJ,G\rI\u0001\u0016E\u0006$'+\u001a9peR,'OU3hSN$XM]3e\u0003e\u0011\u0017\r\u001a*fa>\u0014H/\u001a:SK\u001eL7\u000f^3sK\u0012|F%Z9\u0015\u0005I\n\bb\u00027\u000f\u0003\u0003\u0005\r!Y\u0001\u0017E\u0006$'+\u001a9peR,'OU3hSN$XM]3eA\taqi\\8e%\u0016\u0004xN\u001d;feN\u0019\u0001#^>\u0011\u0005YLX\"A<\u000b\u0005a\\\u0014\u0001\u00027b]\u001eL!A_<\u0003\r=\u0013'.Z2u!\ra\u0018\u0011B\u0007\u0002{*\u0011ap`\u0001\b[\u0016$(/[2t\u0015\u0011\t\t!a\u0001\u0002\r\r|W.\\8o\u0015\rq\u0012Q\u0001\u0006\u0004\u0003\u000fQ\u0015AB1qC\u000eDW-C\u0002\u0002\fu\u0014q\"T3ue&\u001c7OU3q_J$XM\u001d\u000b\u0003\u0003\u001f\u00012!!\u0005\u0011\u001b\u0005A\u0011!C2p]\u001aLw-\u001e:f)\r\u0011\u0014q\u0003\u0005\b\u00033\u0011\u0002\u0019AA\u000e\u0003\u001d\u0019wN\u001c4jON\u0004D!!\b\u0002>A9\u0001(a\b\u0002$\u0005e\u0012bAA\u0011s\t\u0019Q*\u00199\u0011\t\u0005\u0015\u00121\u0007\b\u0005\u0003O\ty\u0003E\u0002\u0002*1j!!a\u000b\u000b\u0007\u00055r$\u0001\u0004=e>|GOP\u0005\u0004\u0003ca\u0013A\u0002)sK\u0012,g-\u0003\u0003\u00026\u0005]\"AB*ue&twMC\u0002\u000221\u0002B!a\u000f\u0002>1\u0001A\u0001DA \u0003/\t\t\u0011!A\u0003\u0002\u0005\u0005#aA0%cE!\u00111IA%!\rY\u0013QI\u0005\u0004\u0003\u000fb#a\u0002(pi\"Lgn\u001a\t\u0004W\u0005-\u0013bAA'Y\t\u0019\u0011I\\=\u0002\t%t\u0017\u000e\u001e\u000b\u0004e\u0005M\u0003B\u0002@\u0014\u0001\u0004\t)\u0006E\u00039\u0003/\nY&C\u0002\u0002Ze\u0012A\u0001T5tiB\u0019A0!\u0018\n\u0007\u0005}SPA\u0006LC\u001a\\\u0017-T3ue&\u001c\u0017\u0001D7fiJL7m\u00115b]\u001e,Gc\u0001\u001a\u0002f!9\u0011q\r\u000bA\u0002\u0005m\u0013AB7fiJL7-A\u0007nKR\u0014\u0018n\u0019*f[>4\u0018\r\u001c\u000b\u0004e\u00055\u0004bBA4+\u0001\u0007\u00111L\u0001\u0006G2|7/\u001a\u0002\f\u0005\u0006$'+\u001a9peR,'oE\u0002\u0018\u0003\u001f!\"!a\u001e\u0011\u0007\u0005Eq\u0003F\u00023\u0003wBq!a\u001a\u001a\u0001\u0004\tY\u0006")
public class KafkaMetricReporterExceptionHandlingTest
extends BaseRequestTest {
    public static void badReporterRegistered_$eq(AtomicInteger x$1) {
        KafkaMetricReporterExceptionHandlingTest$.MODULE$.badReporterRegistered_$eq(x$1);
    }

    public static AtomicInteger badReporterRegistered() {
        return KafkaMetricReporterExceptionHandlingTest$.MODULE$.badReporterRegistered();
    }

    public static void goodReporterRegistered_$eq(AtomicInteger x$1) {
        KafkaMetricReporterExceptionHandlingTest$.MODULE$.goodReporterRegistered_$eq(x$1);
    }

    public static AtomicInteger goodReporterRegistered() {
        return KafkaMetricReporterExceptionHandlingTest$.MODULE$.goodReporterRegistered();
    }

    @Override
    public int brokerCount() {
        return 1;
    }

    @Override
    public void brokerPropertyOverrides(Properties properties) {
        properties.put(KafkaConfig$.MODULE$.MetricReporterClassesProp(), new StringBuilder(1).append(BadReporter.class.getName()).append(",").append(GoodReporter.class.getName()).toString());
    }

    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        Properties quotaProps = new Properties();
        quotaProps.put("request_percentage", "0.1");
        this.adminZkClient().changeClientIdConfig("<default>", quotaProps);
    }

    @Override
    @AfterEach
    public void tearDown() {
        KafkaMetricReporterExceptionHandlingTest$.MODULE$.goodReporterRegistered().set(0);
        KafkaMetricReporterExceptionHandlingTest$.MODULE$.badReporterRegistered().set(0);
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testBothReportersAreInvoked() {
        int port = this.anySocketServer().boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
        socket.setSoTimeout(10000);
        try (Socket socket = new Socket("localhost", port);){
            long l = 10000L;
            TestUtils$ retry_this = TestUtils$.MODULE$;
            long l2 = 1L;
            long retry_startTime = System.currentTimeMillis();
            while (true) {
                try {
                    KafkaMetricReporterExceptionHandlingTest.$anonfun$testBothReportersAreInvoked$1(this, socket);
                }
                catch (AssertionError retry_e) {
                    void retry_maxWaitMs;
                    if (System.currentTimeMillis() - retry_startTime > retry_maxWaitMs) {
                        throw retry_e;
                    }
                    if (retry_this.logger().underlying().isInfoEnabled()) {
                        String string;
                        String string2 = string = new StringBuilder(49).append("Attempt failed, sleeping for ").append(l2).append(", and then retrying.").toString();
                        string = null;
                        String msgWithLogIdent_msg = string2;
                        Object var10_9 = null;
                        retry_this.logger().underlying().info(Logging.msgWithLogIdent$((Logging)retry_this, (String)msgWithLogIdent_msg));
                    }
                    Thread.sleep(l2);
                    l2 += package$.MODULE$.min(l2, 1000L);
                    continue;
                }
                break;
            }
            Object var4_4 = null;
            Object var9_8 = null;
        }
    }

    public static final /* synthetic */ void $anonfun$testBothReportersAreInvoked$1(KafkaMetricReporterExceptionHandlingTest $this, Socket socket$1) {
        ListGroupsRequest listGroupsRequest = (ListGroupsRequest)new ListGroupsRequest.Builder(new ListGroupsRequestData()).build();
        Map errors = ((ListGroupsResponse)$this.sendAndReceive((AbstractRequest)listGroupsRequest, socket$1, $this.sendAndReceive$default$3(), $this.sendAndReceive$default$4(), ClassTag$.MODULE$.apply(ListGroupsResponse.class), NotNothing$.MODULE$.notNothingEvidence($less$colon$less$.MODULE$.refl()))).errorCounts();
        Assertions.assertEquals(Collections.singletonMap(Errors.NONE, BoxesRunTime.boxToInteger((int)1)), (Object)errors);
        Assertions.assertEquals((int)KafkaMetricReporterExceptionHandlingTest$.MODULE$.goodReporterRegistered().get(), (int)KafkaMetricReporterExceptionHandlingTest$.MODULE$.badReporterRegistered().get());
        Assertions.assertTrue((KafkaMetricReporterExceptionHandlingTest$.MODULE$.goodReporterRegistered().get() > 0 ? 1 : 0) != 0);
    }

    public static class BadReporter
    extends GoodReporter {
        @Override
        public void metricChange(KafkaMetric metric) {
            String string = metric.metricName().group();
            String string2 = "Request";
            if (string == null) {
                return;
            }
            if (string.equals(string2)) {
                KafkaMetricReporterExceptionHandlingTest$.MODULE$.badReporterRegistered().incrementAndGet();
                throw new RuntimeException(metric.metricName().toString());
            }
        }
    }

    public static class GoodReporter
    implements MetricsReporter {
        public Set<String> reconfigurableConfigs() {
            return super.reconfigurableConfigs();
        }

        public void validateReconfiguration(Map<String, ?> x$1) throws ConfigException {
            super.validateReconfiguration(x$1);
        }

        public void reconfigure(Map<String, ?> x$1) {
            super.reconfigure(x$1);
        }

        @InterfaceStability.Evolving
        public void contextChange(MetricsContext x$1) {
            super.contextChange(x$1);
        }

        public void configure(Map<String, ?> configs) {
        }

        public void init(List<KafkaMetric> metrics) {
        }

        public void metricChange(KafkaMetric metric) {
            String string = metric.metricName().group();
            String string2 = "Request";
            if (string == null) {
                return;
            }
            if (string.equals(string2)) {
                KafkaMetricReporterExceptionHandlingTest$.MODULE$.goodReporterRegistered().incrementAndGet();
            }
        }

        public void metricRemoval(KafkaMetric metric) {
        }

        public void close() {
        }
    }
}

