/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Dead$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.InitProducerIdResult;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionCoordinator$;
import kafka.coordinator.transaction.TransactionMarkerChannelManager;
import kafka.coordinator.transaction.TransactionMarkerChannelManager$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.server.KafkaConfig;
import kafka.server.MetadataCache;
import kafka.server.ReplicaManager;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.utils.Logging;
import kafka.utils.Scheduler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.message.DescribeTransactionsResponseData;
import org.apache.kafka.common.message.ListTransactionsResponseData;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.ProducerIdAndEpoch;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function4;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Set;
import scala.collection.mutable.Set$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.java8.JFunction0;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0005\rus!\u0002\u0017.\u0011\u0003!d!\u0002\u001c.\u0011\u00039\u0004\"\u0002 \u0002\t\u0003y\u0004\"\u0002!\u0002\t\u0003\t\u0005bBB)\u0003\u0011%11\u000b\u0005\b\u0007/\nA\u0011BB-\r\u00111T\u0006A\"\t\u0011)3!\u0011!Q\u0001\n-C\u0001B\u0014\u0004\u0003\u0002\u0003\u0006Ia\u0014\u0005\t%\u001a\u0011\t\u0011)A\u0005'\"AaK\u0002B\u0001B\u0003%q\u000b\u0003\u0005^\r\t\u0005\t\u0015!\u0003_\u0011!\tgA!A!\u0002\u0013\u0011\u0007\u0002C3\u0007\u0005\u0003\u0005\u000b\u0011\u00024\t\u0011I4!\u0011!Q\u0001\nMDQA\u0010\u0004\u0005\u0002Y,Qa \u0004\u0001\u0003\u0003)a!a\u0005\u0007\u0001\u0005UQABA\u0012\r\u0001\t)\"\u0002\u0004\u0002&\u0019\u0001\u0011q\u0005\u0005\n\u0003/2!\u0019!C\u0005\u00033B\u0001\"a\u001d\u0007A\u0003%\u00111\f\u0005\n\u0003k2!\u0019!C\u0001\u0003oBq!!\u001f\u0007A\u0003%!\fC\u0004\u0002|\u0019!\t!! \t\u0013\u0005}f!%A\u0005\u0002\u0005\u0005\u0007bBAl\r\u0011%\u0011\u0011\u001c\u0005\b\u0003{4A\u0011AA\u0000\u0011\u001d\u0011\u0019C\u0002C\u0001\u0005KAqAa\u000e\u0007\t\u0003\u0011I\u0004C\u0005\u0003h\u0019\t\n\u0011\"\u0001\u0002B\"9!\u0011\u000e\u0004\u0005\u0002\t-\u0004b\u0002B:\r\u0011\u0005!Q\u000f\u0005\b\u0005{2A\u0011\u0002B@\u0011\u001d\u0011)K\u0002C\u0001\u0005OC\u0011B!/\u0007#\u0003%\t!!1\t\u000f\tmf\u0001\"\u0003\u0003>\"9!Q\u001b\u0004\u0005\u0002\t]\u0007b\u0002Bq\r\u0011\u0005!1\u001d\u0005\b\u0005O4A\u0011\u0002Bu\u0011!\u0011YP\u0002C\u0001[\tu\bbBB\u0003\r\u0011\u00051q\u0001\u0005\n\u0007'1\u0011\u0013!C\u0001\u0007+Aqa!\u0007\u0007\t\u0003\u0019Y\"\u0001\fUe\u0006t7/Y2uS>t7i\\8sI&t\u0017\r^8s\u0015\tqs&A\u0006ue\u0006t7/Y2uS>t'B\u0001\u00192\u0003-\u0019wn\u001c:eS:\fGo\u001c:\u000b\u0003I\nQa[1gW\u0006\u001c\u0001\u0001\u0005\u00026\u00035\tQF\u0001\fUe\u0006t7/Y2uS>t7i\\8sI&t\u0017\r^8s'\t\t\u0001\b\u0005\u0002:y5\t!HC\u0001<\u0003\u0015\u00198-\u00197b\u0013\ti$H\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Q\nQ!\u00199qYf$rBQB\u000f\u0007O\u0019\tda\r\u00048\r\u00153q\n\t\u0003k\u0019\u00192A\u0002\u001dE!\t)\u0005*D\u0001G\u0015\t9\u0015'A\u0003vi&d7/\u0003\u0002J\r\n9Aj\\4hS:<\u0017\u0001\u00032s_.,'/\u00133\u0011\u0005eb\u0015BA';\u0005\rIe\u000e^\u0001\nibt7i\u001c8gS\u001e\u0004\"!\u000e)\n\u0005Ek#!\u0005+sC:\u001c\u0018m\u0019;j_:\u001cuN\u001c4jO\u0006I1o\u00195fIVdWM\u001d\t\u0003\u000bRK!!\u0016$\u0003\u0013M\u001b\u0007.\u001a3vY\u0016\u0014\u0018aF2sK\u0006$X\r\u0015:pIV\u001cWM]%e\u001b\u0006t\u0017mZ3s!\rI\u0004LW\u0005\u00033j\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u0005UZ\u0016B\u0001/.\u0005E\u0001&o\u001c3vG\u0016\u0014\u0018\nZ'b]\u0006<WM]\u0001\u000bibtW*\u00198bO\u0016\u0014\bCA\u001b`\u0013\t\u0001WFA\fUe\u0006t7/Y2uS>t7\u000b^1uK6\u000bg.Y4fe\u00069B\u000f\u001f8NCJ\\WM]\"iC:tW\r\\'b]\u0006<WM\u001d\t\u0003k\rL!\u0001Z\u0017\u0003?Q\u0013\u0018M\\:bGRLwN\\'be.,'o\u00115b]:,G.T1oC\u001e,'/\u0001\u0003uS6,\u0007CA4q\u001b\u0005A'BA$j\u0015\tQ7.\u0001\u0004d_6lwN\u001c\u0006\u0003e1T!!\u001c8\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0017aA8sO&\u0011\u0011\u000f\u001b\u0002\u0005)&lW-\u0001\u0006m_\u001e\u001cuN\u001c;fqR\u0004\"a\u001a;\n\u0005UD'A\u0003'pO\u000e{g\u000e^3yiRI!i\u001e=zundXP \u0005\u0006\u0015>\u0001\ra\u0013\u0005\u0006\u001d>\u0001\ra\u0014\u0005\u0006%>\u0001\ra\u0015\u0005\u0006->\u0001\ra\u0016\u0005\u0006;>\u0001\rA\u0018\u0005\u0006C>\u0001\rA\u0019\u0005\u0006K>\u0001\rA\u001a\u0005\u0006e>\u0001\ra\u001d\u0002\u0017\u0013:LG\u000f\u0015:pIV\u001cWM]%e\u0007\u0006dGNY1dWB9\u0011(a\u0001\u0002\b\u00055\u0011bAA\u0003u\tIa)\u001e8di&|g.\r\t\u0004k\u0005%\u0011bAA\u0006[\t!\u0012J\\5u!J|G-^2fe&#'+Z:vYR\u00042!OA\b\u0013\r\t\tB\u000f\u0002\u0005+:LGOA\u000bBI\u0012\u0004\u0016M\u001d;ji&|gn]\"bY2\u0014\u0017mY6\u0011\u000fe\n\u0019!a\u0006\u0002\u000eA!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001e%\f\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0005\u0003C\tYB\u0001\u0004FeJ|'o\u001d\u0002\u000f\u000b:$G\u000b\u001f8DC2d'-Y2l\u0005%\t\u0005/\u001b*fgVdG/\u0006\u0003\u0002*\u0005\u0015\u0003\u0003CA\u0016\u0003w\t9\"!\u0011\u000f\t\u00055\u0012q\u0007\b\u0005\u0003_\t)$\u0004\u0002\u00022)\u0019\u00111G\u001a\u0002\rq\u0012xn\u001c;?\u0013\u0005Y\u0014bAA\u001du\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u001f\u0003\u007f\u0011a!R5uQ\u0016\u0014(bAA\u001duA!\u00111IA#\u0019\u0001!q!a\u0012\u0014\u0005\u0004\tIEA\u0001U#\u0011\tY%!\u0015\u0011\u0007e\ni%C\u0002\u0002Pi\u0012qAT8uQ&tw\rE\u0002:\u0003'J1!!\u0016;\u0005\r\te._\u0001\tSN\f5\r^5wKV\u0011\u00111\f\t\u0005\u0003;\ny'\u0004\u0002\u0002`)!\u0011\u0011MA2\u0003\u0019\tGo\\7jG*!\u0011QMA4\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0005\u0003S\nY'\u0001\u0003vi&d'BAA7\u0003\u0011Q\u0017M^1\n\t\u0005E\u0014q\f\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u0013%\u001c\u0018i\u0019;jm\u0016\u0004\u0013!\u00059s_\u0012,8-\u001a:JI6\u000bg.Y4feV\t!,\u0001\nqe>$WoY3s\u0013\u0012l\u0015M\\1hKJ\u0004\u0013\u0001\u00065b]\u0012dW-\u00138jiB\u0013x\u000eZ;dKJLE\r\u0006\u0007\u0002\u000e\u0005}\u00141SAL\u0003O\u000by\u000bC\u0004\u0002\u0002b\u0001\r!a!\u0002\u001fQ\u0014\u0018M\\:bGRLwN\\1m\u0013\u0012\u0004B!!\"\u0002\u000e:!\u0011qQAE!\r\tyCO\u0005\u0004\u0003\u0017S\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0010\u0006E%AB*ue&twMC\u0002\u0002\fjBa!!&\u0019\u0001\u0004Y\u0015\u0001\u0006;sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRl5\u000fC\u0004\u0002\u001ab\u0001\r!a'\u00025\u0015D\b/Z2uK\u0012\u0004&o\u001c3vG\u0016\u0014\u0018\nZ!oI\u0016\u0003xn\u00195\u0011\u000be\ni*!)\n\u0007\u0005}%H\u0001\u0004PaRLwN\u001c\t\u0004O\u0006\r\u0016bAASQ\n\u0011\u0002K]8ek\u000e,'/\u00133B]\u0012,\u0005o\\2i\u0011\u001d\tI\u000b\u0007a\u0001\u0003W\u000b\u0001C]3ta>t7/Z\"bY2\u0014\u0017mY6\u0011\u0007\u00055\u0006#D\u0001\u0007\u0011%\t\t\f\u0007I\u0001\u0002\u0004\t\u0019,\u0001\u0007sKF,Xm\u001d;M_\u000e\fG\u000e\u0005\u0003\u00026\u0006mVBAA\\\u0015\r\tI,M\u0001\u0007g\u0016\u0014h/\u001a:\n\t\u0005u\u0016q\u0017\u0002\r%\u0016\fX/Z:u\u0019>\u001c\u0017\r\\\u0001\u001fQ\u0006tG\r\\3J]&$\bK]8ek\u000e,'/\u00133%I\u00164\u0017-\u001e7uIU*\"!a1+\t\u0005M\u0016QY\u0016\u0003\u0003\u000f\u0004B!!3\u0002T6\u0011\u00111\u001a\u0006\u0005\u0003\u001b\fy-A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\u001b\u001e\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002V\u0006-'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006a\u0002O]3qCJ,\u0017J\\5u!J|G-^2fe&#GK]1og&$H\u0003DAn\u0003S\fY/!<\u0002r\u0006m\b#BAW'\u0005u\u0007CB\u001d\u0002`.\u000b\u0019/C\u0002\u0002bj\u0012a\u0001V;qY\u0016\u0014\u0004cA\u001b\u0002f&\u0019\u0011q]\u0017\u0003%QCh\u000e\u0016:b]NLG/T3uC\u0012\fG/\u0019\u0005\b\u0003\u0003S\u0002\u0019AAB\u0011\u0019\t)J\u0007a\u0001\u0017\"1\u0011q\u001e\u000eA\u0002-\u000b\u0001cY8pe\u0012Lg.\u0019;pe\u0016\u0003xn\u00195\t\u000f\u0005M(\u00041\u0001\u0002v\u0006YA\u000f\u001f8NKR\fG-\u0019;b!\r)\u0014q_\u0005\u0004\u0003sl#a\u0005+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f\u0007bBAM5\u0001\u0007\u00111T\u0001\u0017Q\u0006tG\r\\3MSN$HK]1og\u0006\u001cG/[8ogR1!\u0011\u0001B\u0007\u0005;\u0001BAa\u0001\u0003\n5\u0011!Q\u0001\u0006\u0004\u0005\u000fI\u0017aB7fgN\fw-Z\u0005\u0005\u0005\u0017\u0011)A\u0001\u000fMSN$HK]1og\u0006\u001cG/[8ogJ+7\u000f]8og\u0016$\u0015\r^1\t\u000f\t=1\u00041\u0001\u0003\u0012\u0005\u0019b-\u001b7uKJ,G\r\u0015:pIV\u001cWM]%egB1\u0011Q\u0011B\n\u0005/IAA!\u0006\u0002\u0012\n\u00191+\u001a;\u0011\u0007e\u0012I\"C\u0002\u0003\u001ci\u0012A\u0001T8oO\"9!qD\u000eA\u0002\t\u0005\u0012A\u00044jYR,'/\u001a3Ti\u0006$Xm\u001d\t\u0007\u0003\u000b\u0013\u0019\"a!\u00025!\fg\u000e\u001a7f\t\u0016\u001c8M]5cKR\u0013\u0018M\\:bGRLwN\\:\u0015\t\t\u001d\"Q\u0007\t\u0005\u0005S\u0011yC\u0004\u0003\u0003\u0004\t-\u0012\u0002\u0002B\u0017\u0005\u000b\t\u0001\u0005R3tGJL'-\u001a+sC:\u001c\u0018m\u0019;j_:\u001c(+Z:q_:\u001cX\rR1uC&!!\u0011\u0007B\u001a\u0005A!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$XM\u0003\u0003\u0003.\t\u0015\u0001bBAA9\u0001\u0007\u00111Q\u0001!Q\u0006tG\r\\3BI\u0012\u0004\u0016M\u001d;ji&|gn\u001d+p)J\fgn]1di&|g\u000e\u0006\b\u0002\u000e\tm\"Q\bB!\u0005\u0017\u0012\tG!\u001a\t\u000f\u0005\u0005U\u00041\u0001\u0002\u0004\"9!qH\u000fA\u0002\t]\u0011A\u00039s_\u0012,8-\u001a:JI\"9!1I\u000fA\u0002\t\u0015\u0013!\u00049s_\u0012,8-\u001a:Fa>\u001c\u0007\u000eE\u0002:\u0005\u000fJ1A!\u0013;\u0005\u0015\u0019\u0006n\u001c:u\u0011\u001d\u0011i%\ba\u0001\u0005\u001f\n!\u0002]1si&$\u0018n\u001c8t!\u0019\u0011\tFa\u0016\u0003Z5\u0011!1\u000b\u0006\u0004\u0005+R\u0014AC2pY2,7\r^5p]&!!Q\u0003B*!\u0011\u0011YF!\u0018\u000e\u0003%L1Aa\u0018j\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Dq!!+\u001e\u0001\u0004\u0011\u0019\u0007E\u0002\u0002.FA\u0011\"!-\u001e!\u0003\u0005\r!a-\u0002U!\fg\u000e\u001a7f\u0003\u0012$\u0007+\u0019:uSRLwN\\:U_R\u0013\u0018M\\:bGRLwN\u001c\u0013eK\u001a\fW\u000f\u001c;%m\u0005QqN\\#mK\u000e$\u0018n\u001c8\u0015\r\u00055!Q\u000eB9\u0011\u0019\u0011yg\ba\u0001\u0017\u0006\u0019B\u000f\u001f8U_BL7\rU1si&$\u0018n\u001c8JI\"1\u0011q^\u0010A\u0002-\u000bQb\u001c8SKNLwM\\1uS>tGCBA\u0007\u0005o\u0012I\b\u0003\u0004\u0003p\u0001\u0002\ra\u0013\u0005\b\u0003_\u0004\u0003\u0019\u0001B>!\u0011I\u0014QT&\u0002O1|w-\u00138wC2LGm\u0015;bi\u0016$&/\u00198tSRLwN\\!oIJ+G/\u001e:o\u000bJ\u0014xN\u001d\u000b\t\u0005\u0003\u0013YI!$\u0003\u0016BA!1\u0011BD\u0003/\tY%\u0004\u0002\u0003\u0006*\u0019\u0011\u0011\u000e\u001e\n\t\t%%Q\u0011\u0002\u0005\u0019\u00164G\u000fC\u0004\u0002\u0002\u0006\u0002\r!a!\t\u000f\t=\u0015\u00051\u0001\u0003\u0012\u0006\u0001BO]1og\u0006\u001cG/[8o'R\fG/\u001a\t\u0004k\tM\u0015b\u0001B\u0019[!9!qS\u0011A\u0002\te\u0015!\u0005;sC:\u001c\u0018m\u0019;j_:\u0014Vm];miB!!1\u0014BQ\u001b\t\u0011iJC\u0002\u0003 &\f\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0005G\u0013iJA\tUe\u0006t7/Y2uS>t'+Z:vYR\fA\u0003[1oI2,WI\u001c3Ue\u0006t7/Y2uS>tGCDA\u0007\u0005S\u0013YK!,\u00030\nM&q\u0017\u0005\b\u0003\u0003\u0013\u0003\u0019AAB\u0011\u001d\u0011yD\ta\u0001\u0005/AqAa\u0011#\u0001\u0004\u0011)\u0005C\u0004\u00032\n\u0002\rA!'\u0002\u001fQDh.T1sW\u0016\u0014(+Z:vYRDq!!+#\u0001\u0004\u0011)\fE\u0002\u0002.JA\u0011\"!-#!\u0003\u0005\r!a-\u0002=!\fg\u000e\u001a7f\u000b:$GK]1og\u0006\u001cG/[8oI\u0011,g-Y;mi\u00122\u0014AD3oIR\u0013\u0018M\\:bGRLwN\u001c\u000b\u0011\u0003\u001b\u0011yL!1\u0003D\n\u0015'q\u0019Bi\u0005'Dq!!!%\u0001\u0004\t\u0019\tC\u0004\u0003@\u0011\u0002\rAa\u0006\t\u000f\t\rC\u00051\u0001\u0003F!9!\u0011\u0017\u0013A\u0002\te\u0005b\u0002BeI\u0001\u0007!1Z\u0001\rSN4%o\\7DY&,g\u000e\u001e\t\u0004s\t5\u0017b\u0001Bhu\t9!i\\8mK\u0006t\u0007bBAUI\u0001\u0007!Q\u0017\u0005\b\u0003c#\u0003\u0019AAZ\u0003]!(/\u00198tC\u000e$\u0018n\u001c8U_BL7mQ8oM&<7/\u0006\u0002\u0003ZB!!1\u001cBo\u001b\t\t9'\u0003\u0003\u0003`\u0006\u001d$A\u0003)s_B,'\u000f^5fg\u0006a\u0001/\u0019:uSRLwN\u001c$peR\u00191J!:\t\u000f\u0005\u0005e\u00051\u0001\u0002\u0004\u0006ArN\\#oIR\u0013\u0018M\\:bGRLwN\\\"p[BdW\r^3\u0015\t\t-(\u0011\u001f\u000b\u0005\u0003\u001b\u0011i\u000fC\u0004\u0003p\u001e\u0002\r!a\u0006\u0002\u000b\u0015\u0014(o\u001c:\t\u000f\tMx\u00051\u0001\u0003v\u0006\u0001B\u000f\u001f8JI\u0006sG\rU5e\u000bB|7\r\u001b\t\u0004k\t]\u0018b\u0001B}[\t\tCK]1og\u0006\u001cG/[8oC2LE-\u00118e!J|G-^2fe&#W\t]8dQ\u0006I\u0012MY8siRKW.\u001a3PkR$&/\u00198tC\u000e$\u0018n\u001c8t)\u0011\tiAa@\t\u000f\r\u0005\u0001\u00061\u0001\u0004\u0004\u0005QqN\\\"p[BdW\r^3\u0011\u000fe\n\u0019A!>\u00036\u000691\u000f^1siV\u0004HCBA\u0007\u0007\u0013\u0019y\u0001C\u0004\u0004\f%\u0002\ra!\u0004\u0002MI,GO]5fm\u0016$&/\u00198tC\u000e$\u0018n\u001c8U_BL7\rU1si&$\u0018n\u001c8D_VtG\u000fE\u0002:1.C\u0011b!\u0005*!\u0003\u0005\rAa3\u0002?\u0015t\u0017M\u00197f)J\fgn]1di&|g.\u00197JI\u0016C\b/\u001b:bi&|g.A\tti\u0006\u0014H/\u001e9%I\u00164\u0017-\u001e7uII*\"aa\u0006+\t\t-\u0017QY\u0001\tg\",H\u000fZ8x]R\u0011\u0011Q\u0002\u0005\b\u0007?\u0019\u0001\u0019AB\u0011\u0003\u0019\u0019wN\u001c4jOB!\u0011QWB\u0012\u0013\u0011\u0019)#a.\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\b\u0007S\u0019\u0001\u0019AB\u0016\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJ\u0004B!!.\u0004.%!1qFA\\\u00059\u0011V\r\u001d7jG\u0006l\u0015M\\1hKJDQAU\u0002A\u0002MCaa!\u000e\u0004\u0001\u00049\u0016!G2sK\u0006$X\r\u0015:pIV\u001cWM]%e\u000f\u0016tWM]1u_JDqa!\u000f\u0004\u0001\u0004\u0019Y$A\u0004nKR\u0014\u0018nY:\u0011\t\ru2\u0011I\u0007\u0003\u0007\u007fQ1a!\u000fj\u0013\u0011\u0019\u0019ea\u0010\u0003\u000f5+GO]5dg\"91qI\u0002A\u0002\r%\u0013!D7fi\u0006$\u0017\r^1DC\u000eDW\r\u0005\u0003\u00026\u000e-\u0013\u0002BB'\u0003o\u0013Q\"T3uC\u0012\fG/Y\"bG\",\u0007\"B3\u0004\u0001\u00041\u0017\u0001F5oSR$&/\u00198tC\u000e$\u0018n\u001c8FeJ|'\u000f\u0006\u0003\u0002\b\rU\u0003b\u0002Bx\t\u0001\u0007\u0011qC\u0001\u0018S:LG\u000f\u0016:b]N\f7\r^5p]6+G/\u00193bi\u0006$B!a\u0002\u0004\\!9\u00111_\u0003A\u0002\u0005\r\b")
public class TransactionCoordinator
implements Logging {
    private final TransactionConfig txnConfig;
    private final Scheduler scheduler;
    private final TransactionStateManager txnManager;
    private final TransactionMarkerChannelManager txnMarkerChannelManager;
    private final Time time;
    private final AtomicBoolean isActive;
    private final ProducerIdManager producerIdManager;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static TransactionCoordinator apply(KafkaConfig config, ReplicaManager replicaManager, Scheduler scheduler, Function0<ProducerIdManager> createProducerIdGenerator, Metrics metrics, MetadataCache metadataCache, Time time) {
        TransactionConfig apply_txnConfig = new TransactionConfig(Predef$.MODULE$.Integer2int(config.transactionalIdExpirationMs()), Predef$.MODULE$.Integer2int(config.transactionMaxTimeoutMs()), Predef$.MODULE$.Integer2int(config.transactionTopicPartitions()), Predef$.MODULE$.Short2short(config.transactionTopicReplicationFactor()), Predef$.MODULE$.Integer2int(config.transactionTopicSegmentBytes()), Predef$.MODULE$.Integer2int(config.transactionsLoadBufferSize()), Predef$.MODULE$.Integer2int(config.transactionTopicMinISR()), Predef$.MODULE$.Integer2int(config.transactionAbortTimedOutTransactionCleanupIntervalMs()), Predef$.MODULE$.Integer2int(config.transactionRemoveExpiredTransactionalIdCleanupIntervalMs()), Predef$.MODULE$.Integer2int(config.requestTimeoutMs()));
        TransactionStateManager apply_txnStateManager = new TransactionStateManager(config.brokerId(), scheduler, replicaManager, apply_txnConfig, time, metrics);
        LogContext apply_logContext = new LogContext(new StringBuilder(29).append("[TransactionCoordinator id=").append(config.brokerId()).append("] ").toString());
        TransactionMarkerChannelManager apply_txnMarkerChannelManager = TransactionMarkerChannelManager$.MODULE$.apply(config, metrics, metadataCache, apply_txnStateManager, time, apply_logContext);
        return new TransactionCoordinator(config.brokerId(), apply_txnConfig, scheduler, createProducerIdGenerator, apply_txnStateManager, apply_txnMarkerChannelManager, time, apply_logContext);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private AtomicBoolean isActive() {
        return this.isActive;
    }

    public ProducerIdManager producerIdManager() {
        return this.producerIdManager;
    }

    /*
     * WARNING - void declaration
     */
    public void handleInitProducerId(String transactionalId, int transactionTimeoutMs, Option<ProducerIdAndEpoch> expectedProducerIdAndEpoch, Function1<InitProducerIdResult, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Tuple2 tuple2;
        if (transactionalId == null) {
            long producerId = this.producerIdManager().generateProducerId();
            responseCallback.apply((Object)new InitProducerIdResult(producerId, 0, Errors.NONE));
            return;
        }
        if (transactionalId.isEmpty()) {
            Errors kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError_error = Errors.INVALID_REQUEST;
            Object var30_7 = null;
            responseCallback.apply((Object)new InitProducerIdResult(-1L, -1, kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError_error));
            return;
        }
        if (!this.txnManager.validateTransactionTimeoutMs(transactionTimeoutMs)) {
            Errors kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError_error = Errors.INVALID_TRANSACTION_TIMEOUT;
            Object var31_8 = null;
            responseCallback.apply((Object)new InitProducerIdResult(-1L, -1, kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError_error));
            return;
        }
        Either result = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable)x0$1 -> {
            Either<Errors, CoordinatorEpochAndTxnMetadata> either;
            if (None$.MODULE$.equals(x0$1)) {
                long producerId = this.producerIdManager().generateProducerId();
                Empty$ x$7 = Empty$.MODULE$;
                scala.collection.mutable.Set x$8 = (scala.collection.mutable.Set)Set$.MODULE$.empty();
                long x$9 = $this.time.milliseconds();
                long l = -1L;
                TransactionMetadata createdMetadata = new TransactionMetadata(transactionalId, producerId, -1L, -1, -1, transactionTimeoutMs, x$7, (scala.collection.mutable.Set<TopicPartition>)x$8, l, x$9);
                either = $this.txnManager.putTransactionStateIfNotExists(createdMetadata);
            } else if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                either = package$.MODULE$.Right().apply((Object)epochAndTxnMetadata);
            } else {
                throw new MatchError(x0$1);
            }
            return either;
        }).flatMap((Function1 & Serializable)existingEpochAndMetadata -> {
            int coordinatorEpoch = existingEpochAndMetadata.coordinatorEpoch();
            TransactionMetadata txnMetadata = existingEpochAndMetadata.transactionMetadata();
            return (Either)txnMetadata.inLock((Function0 & Serializable)() -> this.prepareInitProducerIdTransit(transactionalId, transactionTimeoutMs, coordinatorEpoch, txnMetadata, expectedProducerIdAndEpoch));
        });
        if (result instanceof Left) {
            Errors error2 = (Errors)((Left)result).value();
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)new InitProducerIdResult(-1L, -1, error2));
            return;
        }
        if (result instanceof Right && (tuple2 = (Tuple2)((Right)result).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            TransactionState transactionState = newMetadata.txnState();
            PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
            if (transactionState != null && transactionState.equals(prepareEpochFence$)) {
                Tuple2 tuple22;
                void endTransaction_txnMarkerResult;
                void endTransaction_producerEpoch;
                void endTransaction_isFromClient;
                Function1 & Serializable intersect = (Function1 & Serializable)error -> {
                    TransactionCoordinator.sendRetriableErrorCallback$1(error, responseCallback);
                    return BoxedUnit.UNIT;
                };
                boolean bl = false;
                TransactionResult transactionResult = TransactionResult.ABORT;
                short s = newMetadata.producerEpoch();
                long endTransaction_producerId = newMetadata.producerId();
                BooleanRef endTransaction_isEpochFence = BooleanRef.create((boolean)false);
                if (transactionalId.isEmpty()) {
                    Errors errors;
                    Errors errors2 = errors = Errors.INVALID_REQUEST;
                    Errors errors3 = Errors.NONE;
                    if (errors2 == null ? errors3 != null : !errors2.equals(errors3)) {
                        responseCallback.apply((Object)new InitProducerIdResult(-1L, -1, errors));
                        return;
                    }
                    Errors sendRetriableErrorCallback$1_kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError_error = Errors.CONCURRENT_TRANSACTIONS;
                    Object var34_24 = null;
                    responseCallback.apply((Object)new InitProducerIdResult(-1L, -1, sendRetriableErrorCallback$1_kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError_error));
                    return;
                }
                Either endTransaction_preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap(arg_0 -> TransactionCoordinator.$anonfun$endTransaction$1(this, endTransaction_producerId, (boolean)endTransaction_isFromClient, (short)endTransaction_producerEpoch, (TransactionResult)endTransaction_txnMarkerResult, endTransaction_isEpochFence, transactionalId, arg_0));
                if (endTransaction_preAppendResult instanceof Left) {
                    Errors errors;
                    Errors endTransaction_err = (Errors)((Left)endTransaction_preAppendResult).value();
                    this.debug((Function0<String>)((Function0 & Serializable)() -> TransactionCoordinator.$anonfun$endTransaction$4((TransactionResult)endTransaction_txnMarkerResult, endTransaction_err, transactionalId)));
                    Errors errors4 = errors = endTransaction_err;
                    Errors errors5 = Errors.NONE;
                    if (errors4 == null ? errors5 != null : !errors4.equals(errors5)) {
                        responseCallback.apply((Object)new InitProducerIdResult(-1L, -1, errors));
                        return;
                    }
                    Errors sendRetriableErrorCallback$1_kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError_error = Errors.CONCURRENT_TRANSACTIONS;
                    Object var36_28 = null;
                    responseCallback.apply((Object)new InitProducerIdResult(-1L, -1, sendRetriableErrorCallback$1_kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError_error));
                    return;
                }
                if (endTransaction_preAppendResult instanceof Right && (tuple22 = (Tuple2)((Right)endTransaction_preAppendResult).value()) != null) {
                    void endTransaction_responseCallback;
                    int endTransaction_coordinatorEpoch = tuple22._1$mcI$sp();
                    TxnTransitMetadata endTransaction_newMetadata = (TxnTransitMetadata)tuple22._2();
                    Function1 & Serializable endTransaction_x$4 = arg_0 -> TransactionCoordinator.$anonfun$endTransaction$15$adapted(this, transactionalId, endTransaction_coordinatorEpoch, endTransaction_producerId, (short)endTransaction_producerEpoch, (TransactionResult)endTransaction_txnMarkerResult, (Function1)endTransaction_responseCallback, endTransaction_newMetadata, endTransaction_isEpochFence, arg_0);
                    Function1<Errors, Object> endTransaction_x$6 = this.txnManager.appendTransactionToLog$default$5();
                    this.txnManager.appendTransactionToLog(transactionalId, endTransaction_coordinatorEpoch, endTransaction_newMetadata, (Function1<Errors, BoxedUnit>)endTransaction_x$4, endTransaction_x$6, requestLocal);
                    return;
                }
                throw new MatchError((Object)endTransaction_preAppendResult);
            }
            Function1 & Serializable x$14 = (Function1 & Serializable)error -> {
                this.sendPidResponseCallback$1(error, transactionalId, newMetadata, responseCallback);
                return BoxedUnit.UNIT;
            };
            Function1<Errors, Object> x$16 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)x$14, x$16, requestLocal);
            return;
        }
        throw new MatchError((Object)result);
    }

    public RequestLocal handleInitProducerId$default$5() {
        return RequestLocal$.MODULE$.NoCaching();
    }

    private Either<Errors, Tuple2<Object, TxnTransitMetadata>> prepareInitProducerIdTransit(String transactionalId, int transactionTimeoutMs, int coordinatorEpoch, TransactionMetadata txnMetadata, Option<ProducerIdAndEpoch> expectedProducerIdAndEpoch) {
        Left left;
        if (txnMetadata.pendingTransitionInProgress()) {
            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
        }
        if (!expectedProducerIdAndEpoch.forall((Function1 & Serializable)producerIdAndEpoch -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.isValidProducerId$1(producerIdAndEpoch, txnMetadata)))) {
            return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
        }
        TransactionState transactionState = txnMetadata.state();
        boolean bl = PrepareAbort$.MODULE$.equals(transactionState) ? true : PrepareCommit$.MODULE$.equals(transactionState);
        if (bl) {
            left = package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
        } else {
            boolean bl2 = CompleteAbort$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : Empty$.MODULE$.equals(transactionState));
            if (bl2) {
                Left left2;
                Right transitMetadataResult;
                Right right;
                if (txnMetadata.isProducerEpochExhausted() && expectedProducerIdAndEpoch.forall((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.$anonfun$prepareInitProducerIdTransit$2(txnMetadata, x$1)))) {
                    long newProducerId = this.producerIdManager().generateProducerId();
                    right = package$.MODULE$.Right().apply((Object)txnMetadata.prepareProducerIdRotation(newProducerId, transactionTimeoutMs, this.time.milliseconds(), expectedProducerIdAndEpoch.isDefined()));
                } else {
                    right = transitMetadataResult = txnMetadata.prepareIncrementProducerEpoch(transactionTimeoutMs, (Option<Object>)expectedProducerIdAndEpoch.map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToShort((short)x$2.epoch)), this.time.milliseconds());
                }
                if (transitMetadataResult instanceof Right) {
                    TxnTransitMetadata transitMetadata = (TxnTransitMetadata)((Right)transitMetadataResult).value();
                    left2 = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)transitMetadata));
                } else if (transitMetadataResult instanceof Left) {
                    Errors err = (Errors)((Left)transitMetadataResult).value();
                    left2 = package$.MODULE$.Left().apply((Object)err);
                } else {
                    throw new MatchError(transitMetadataResult);
                }
                left = left2;
            } else if (Ongoing$.MODULE$.equals(transactionState)) {
                left = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareFenceProducerEpoch()));
            } else {
                boolean bl3 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                if (bl3) {
                    String errorMsg = new StringBuilder(0).append(new StringBuilder(36).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").toString()).append("This is illegal as we should never have transitioned to this state.").toString();
                    this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                throw new MatchError((Object)transactionState);
            }
        }
        return left;
    }

    public ListTransactionsResponseData handleListTransactions(scala.collection.immutable.Set<Object> filteredProducerIds, scala.collection.immutable.Set<String> filteredStates) {
        if (!this.isActive().get()) {
            return new ListTransactionsResponseData().setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code());
        }
        return this.txnManager.listTransactionStates(filteredProducerIds, filteredStates);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DescribeTransactionsResponseData.TransactionState handleDescribeTransactions(String transactionalId) {
        if (transactionalId == null) {
            throw new IllegalArgumentException("Invalid null transactionalId");
        }
        DescribeTransactionsResponseData.TransactionState transactionState = new DescribeTransactionsResponseData.TransactionState().setTransactionalId(transactionalId);
        if (!this.isActive().get()) {
            return transactionState.setErrorCode(Errors.COORDINATOR_NOT_AVAILABLE.code());
        }
        if (transactionalId.isEmpty()) {
            return transactionState.setErrorCode(Errors.INVALID_REQUEST.code());
        }
        boolean bl = false;
        Right right = null;
        Either<Errors, Option<CoordinatorEpochAndTxnMetadata>> either = this.txnManager.getTransactionState(transactionalId);
        if (either instanceof Left) {
            Errors error = (Errors)((Left)either).value();
            return transactionState.setErrorCode(error.code());
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option = (Option)right.value();
            if (None$.MODULE$.equals(option)) {
                return transactionState.setErrorCode(Errors.TRANSACTIONAL_ID_NOT_FOUND.code());
            }
        }
        if (!bl) throw new MatchError(either);
        Option option = (Option)right.value();
        if (!(option instanceof Some)) throw new MatchError(either);
        TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)option).value()).transactionMetadata();
        return (DescribeTransactionsResponseData.TransactionState)txnMetadata.inLock((Function0 & Serializable)() -> {
            TransactionState transactionState = txnMetadata.state();
            Dead$ dead$ = Dead$.MODULE$;
            if (transactionState != null && transactionState.equals(dead$)) {
                return transactionState.setErrorCode(Errors.TRANSACTIONAL_ID_NOT_FOUND.code());
            }
            txnMetadata.topicPartitions().foreach((Function1 & Serializable)topicPartition -> BoxesRunTime.boxToBoolean((boolean)TransactionCoordinator.$anonfun$handleDescribeTransactions$2(transactionState, topicPartition)));
            return transactionState.setErrorCode(Errors.NONE.code()).setProducerId(txnMetadata.producerId()).setProducerEpoch(txnMetadata.producerEpoch()).setTransactionState(txnMetadata.state().name()).setTransactionTimeoutMs(txnMetadata.txnTimeoutMs()).setTransactionStartTimeMs(txnMetadata.txnStartTimestamp());
        });
    }

    public void handleAddPartitionsToTransaction(String transactionalId, long producerId, short producerEpoch, Set<TopicPartition> partitions, Function1<Errors, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Tuple2 tuple2;
        if (transactionalId == null || transactionalId.isEmpty()) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("Returning ").append(Errors.INVALID_REQUEST).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request").toString());
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either result = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable)x0$1 -> {
            Left left;
            if (None$.MODULE$.equals(x0$1)) {
                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            } else if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                int coordinatorEpoch = epochAndMetadata.coordinatorEpoch();
                TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                left = (Either)txnMetadata.inLock((Function0 & Serializable)() -> {
                    block8: {
                        block7: {
                            if (txnMetadata.producerId() != producerId) {
                                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch) {
                                return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                            }
                            if (txnMetadata.pendingTransitionInProgress()) {
                                return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            PrepareCommit$ prepareCommit$ = PrepareCommit$.MODULE$;
                            if (transactionState != null && transactionState.equals(prepareCommit$)) break block7;
                            TransactionState transactionState2 = txnMetadata.state();
                            PrepareAbort$ prepareAbort$ = PrepareAbort$.MODULE$;
                            if (transactionState2 == null || !transactionState2.equals(prepareAbort$)) break block8;
                        }
                        return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                    }
                    TransactionState transactionState = txnMetadata.state();
                    Ongoing$ ongoing$ = Ongoing$.MODULE$;
                    if (transactionState != null && transactionState.equals(ongoing$) && partitions.subsetOf(txnMetadata.topicPartitions())) {
                        return package$.MODULE$.Left().apply((Object)Errors.NONE);
                    }
                    return package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAddPartitions((scala.collection.immutable.Set<TopicPartition>)partitions.toSet(), $this.time.milliseconds())));
                });
            } else {
                throw new MatchError(x0$1);
            }
            return left;
        });
        if (result instanceof Left) {
            Errors err = (Errors)((Left)result).value();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("Returning ").append(err).append(" error code to client for ").append(transactionalId).append("'s AddPartitions request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)err);
            return;
        }
        if (result instanceof Right && (tuple2 = (Tuple2)((Right)result).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            Function1<Errors, Object> x$6 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, responseCallback, x$6, requestLocal);
            return;
        }
        throw new MatchError((Object)result);
    }

    public RequestLocal handleAddPartitionsToTransaction$default$6() {
        return RequestLocal$.MODULE$.NoCaching();
    }

    public void onElection(int txnTopicPartitionId, int coordinatorEpoch2) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Elected as the txn coordinator for partition ").append(txnTopicPartitionId).append(" at epoch ").append(coordinatorEpoch2).toString());
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
        this.txnManager.loadTransactionsForTxnTopicPartition(txnTopicPartitionId, coordinatorEpoch2, (Function4<Object, TransactionResult, TransactionMetadata, TxnTransitMetadata, BoxedUnit>)(Function4 & Serializable)(coordinatorEpoch, txnResult, txnMetadata, newMetadata) -> {
            this.txnMarkerChannelManager.addTxnMarkersToSend(BoxesRunTime.unboxToInt((Object)coordinatorEpoch), txnResult, txnMetadata, newMetadata);
            return BoxedUnit.UNIT;
        });
    }

    public void onResignation(int txnTopicPartitionId, Option<Object> coordinatorEpoch) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(56).append("Resigned as the txn coordinator for partition ").append(txnTopicPartitionId).append(" at epoch ").append(coordinatorEpoch).toString());
        if (coordinatorEpoch instanceof Some) {
            int epoch = BoxesRunTime.unboxToInt((Object)((Some)coordinatorEpoch).value());
            this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId, epoch);
        } else if (None$.MODULE$.equals(coordinatorEpoch)) {
            this.txnManager.removeTransactionsForTxnTopicPartition(txnTopicPartitionId);
        } else {
            throw new MatchError(coordinatorEpoch);
        }
        this.txnMarkerChannelManager.removeMarkersForTxnTopicPartition(txnTopicPartitionId);
    }

    private Left<Errors, Nothing$> logInvalidStateTransitionAndReturnError(String transactionalId, TransactionState transactionState, TransactionResult transactionResult) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(56).append("TransactionalId: ").append(transactionalId).append("'s state is ").append(transactionState).append(", but received transaction ").toString()).append(new StringBuilder(23).append("marker result to send: ").append(transactionResult).toString()).toString());
        return package$.MODULE$.Left().apply((Object)Errors.INVALID_TXN_STATE);
    }

    public void handleEndTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, Function1<Errors, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Tuple2 tuple2;
        boolean endTransaction_isFromClient = true;
        BooleanRef endTransaction_isEpochFence = BooleanRef.create((boolean)false);
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either endTransaction_preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable)x0$1 -> {
            Left left;
            if (None$.MODULE$.equals(x0$1)) {
                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            } else if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
                int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
                left = (Either)txnMetadata.inLock((Function0 & Serializable)() -> {
                    Right right;
                    TransactionState transactionState;
                    if (txnMetadata.producerId() != producerId) {
                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                    }
                    if (endTransaction_isFromClient && producerEpoch != txnMetadata.producerEpoch() || producerEpoch < txnMetadata.producerEpoch()) {
                        return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        Object object = txnMetadata.pendingState().get();
                        PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                        if (object == null || !object.equals(prepareEpochFence$)) {
                            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                    }
                    if (Ongoing$.MODULE$.equals(transactionState = txnMetadata.state())) {
                        Product nextState;
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                        Product product = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? PrepareCommit$.MODULE$ : (nextState = PrepareAbort$.MODULE$);
                        if (nextState.equals(PrepareAbort$.MODULE$) && txnMetadata.pendingState().contains((Object)PrepareEpochFence$.MODULE$)) {
                            isEpochFence$1.elem = true;
                            txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                            txnMetadata.producerEpoch_$eq(producerEpoch);
                            txnMetadata.lastProducerEpoch_$eq((short)-1);
                        }
                        right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAbortOrCommit((TransactionState)nextState, $this.time.milliseconds())));
                    } else if (CompleteCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult3 = TransactionResult.COMMIT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (CompleteAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult4 = TransactionResult.ABORT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult5 = TransactionResult.COMMIT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult6 = TransactionResult.ABORT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (Empty$.MODULE$.equals(transactionState)) {
                        right = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else {
                        boolean bl = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                        if (bl) {
                            String errorMsg = new StringBuilder(0).append(new StringBuilder(36).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").toString()).append("This is illegal as we should never have transitioned to this state.").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        throw new MatchError((Object)transactionState);
                    }
                    return right;
                });
            } else {
                throw new MatchError(x0$1);
            }
            return left;
        });
        if (endTransaction_preAppendResult instanceof Left) {
            Errors endTransaction_err = (Errors)((Left)endTransaction_preAppendResult).value();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(116).append("Aborting append of ").append(txnMarkerResult).append(" to transaction log with coordinator and returning ").append(endTransaction_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)endTransaction_err);
            return;
        }
        if (endTransaction_preAppendResult instanceof Right && (tuple2 = (Tuple2)((Right)endTransaction_preAppendResult).value()) != null) {
            int endTransaction_coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata endTransaction_newMetadata = (TxnTransitMetadata)tuple2._2();
            Function1 & Serializable endTransaction_x$4 = (Function1 & Serializable)error -> {
                this.sendTxnMarkersCallback$1(error, transactionalId, endTransaction_coordinatorEpoch, producerId, producerEpoch, txnMarkerResult, responseCallback, endTransaction_newMetadata, endTransaction_isEpochFence);
                return BoxedUnit.UNIT;
            };
            Function1<Errors, Object> endTransaction_x$6 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, endTransaction_coordinatorEpoch, endTransaction_newMetadata, (Function1<Errors, BoxedUnit>)endTransaction_x$4, endTransaction_x$6, requestLocal);
            return;
        }
        throw new MatchError((Object)endTransaction_preAppendResult);
    }

    public RequestLocal handleEndTransaction$default$6() {
        return RequestLocal$.MODULE$.NoCaching();
    }

    private void endTransaction(String transactionalId, long producerId, short producerEpoch, TransactionResult txnMarkerResult, boolean isFromClient, Function1<Errors, BoxedUnit> responseCallback, RequestLocal requestLocal) {
        Tuple2 tuple2;
        BooleanRef isEpochFence = BooleanRef.create((boolean)false);
        if (transactionalId == null || transactionalId.isEmpty()) {
            responseCallback.apply((Object)Errors.INVALID_REQUEST);
            return;
        }
        Either preAppendResult = this.txnManager.getTransactionState(transactionalId).flatMap((Function1 & Serializable)x0$1 -> {
            Left left;
            if (None$.MODULE$.equals(x0$1)) {
                left = package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
            } else if (x0$1 instanceof Some) {
                CoordinatorEpochAndTxnMetadata epochAndTxnMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                TransactionMetadata txnMetadata = epochAndTxnMetadata.transactionMetadata();
                int coordinatorEpoch = epochAndTxnMetadata.coordinatorEpoch();
                left = (Either)txnMetadata.inLock((Function0 & Serializable)() -> {
                    Right right;
                    TransactionState transactionState;
                    if (txnMetadata.producerId() != producerId) {
                        return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                    }
                    if (endTransaction_isFromClient && producerEpoch != txnMetadata.producerEpoch() || producerEpoch < txnMetadata.producerEpoch()) {
                        return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                    }
                    if (txnMetadata.pendingTransitionInProgress()) {
                        Object object = txnMetadata.pendingState().get();
                        PrepareEpochFence$ prepareEpochFence$ = PrepareEpochFence$.MODULE$;
                        if (object == null || !object.equals(prepareEpochFence$)) {
                            return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                        }
                    }
                    if (Ongoing$.MODULE$.equals(transactionState = txnMetadata.state())) {
                        Product nextState;
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult2 = TransactionResult.COMMIT;
                        Product product = !(transactionResult != null ? !transactionResult.equals(transactionResult2) : transactionResult2 != null) ? PrepareCommit$.MODULE$ : (nextState = PrepareAbort$.MODULE$);
                        if (nextState.equals(PrepareAbort$.MODULE$) && txnMetadata.pendingState().contains((Object)PrepareEpochFence$.MODULE$)) {
                            isEpochFence$1.elem = true;
                            txnMetadata.pendingState_$eq((Option<TransactionState>)None$.MODULE$);
                            txnMetadata.producerEpoch_$eq(producerEpoch);
                            txnMetadata.lastProducerEpoch_$eq((short)-1);
                        }
                        right = package$.MODULE$.Right().apply((Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)coordinatorEpoch), (Object)txnMetadata.prepareAbortOrCommit((TransactionState)nextState, $this.time.milliseconds())));
                    } else if (CompleteCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult3 = TransactionResult.COMMIT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult3) : transactionResult3 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (CompleteAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult4 = TransactionResult.ABORT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult4) : transactionResult4 != null) ? package$.MODULE$.Left().apply((Object)Errors.NONE) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult5 = TransactionResult.COMMIT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult5) : transactionResult5 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                        TransactionResult transactionResult = txnMarkerResult;
                        TransactionResult transactionResult6 = TransactionResult.ABORT;
                        right = !(transactionResult != null ? !transactionResult.equals(transactionResult6) : transactionResult6 != null) ? package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS) : this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else if (Empty$.MODULE$.equals(transactionState)) {
                        right = this.logInvalidStateTransitionAndReturnError(transactionalId, txnMetadata.state(), txnMarkerResult);
                    } else {
                        boolean bl = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                        if (bl) {
                            String errorMsg = new StringBuilder(0).append(new StringBuilder(36).append("Found transactionalId ").append(transactionalId).append(" with state ").append(txnMetadata.state()).append(". ").toString()).append("This is illegal as we should never have transitioned to this state.").toString();
                            this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
                            throw new IllegalStateException(errorMsg);
                        }
                        throw new MatchError((Object)transactionState);
                    }
                    return right;
                });
            } else {
                throw new MatchError(x0$1);
            }
            return left;
        });
        if (preAppendResult instanceof Left) {
            Errors err = (Errors)((Left)preAppendResult).value();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(116).append("Aborting append of ").append(txnMarkerResult).append(" to transaction log with coordinator and returning ").append(endTransaction_err).append(" error to client for ").append(transactionalId).append("'s EndTransaction request").toString());
            BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback.apply((Object)err);
            return;
        }
        if (preAppendResult instanceof Right && (tuple2 = (Tuple2)((Right)preAppendResult).value()) != null) {
            int coordinatorEpoch = tuple2._1$mcI$sp();
            TxnTransitMetadata newMetadata = (TxnTransitMetadata)tuple2._2();
            Function1 & Serializable x$4 = (Function1 & Serializable)error -> {
                this.sendTxnMarkersCallback$1(error, transactionalId, endTransaction_coordinatorEpoch, producerId, producerEpoch, txnMarkerResult, responseCallback, endTransaction_newMetadata, endTransaction_isEpochFence);
                return BoxedUnit.UNIT;
            };
            Function1<Errors, Object> x$6 = this.txnManager.appendTransactionToLog$default$5();
            this.txnManager.appendTransactionToLog(transactionalId, coordinatorEpoch, newMetadata, (Function1<Errors, BoxedUnit>)x$4, x$6, requestLocal);
            return;
        }
        throw new MatchError((Object)preAppendResult);
    }

    public Properties transactionTopicConfigs() {
        return this.txnManager.transactionTopicConfigs();
    }

    public int partitionFor(String transactionalId) {
        return this.txnManager.partitionFor(transactionalId);
    }

    private void onEndTransactionComplete(TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch, Errors error) {
        if (Errors.NONE.equals(error)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Completed rollback of ongoing transaction for transactionalId ").append(new StringBuilder(15).append(txnIdAndPidEpoch.transactionalId()).append(" due to timeout").toString()).toString());
            return;
        }
        boolean bl = Errors.INVALID_PRODUCER_ID_MAPPING.equals(error) ? true : (Errors.PRODUCER_FENCED.equals(error) ? true : Errors.CONCURRENT_TRANSACTIONS.equals(error));
        if (bl) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(53).append("Rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" ").toString()).append(new StringBuilder(32).append("has been cancelled due to error ").append(error).toString()).toString());
            return;
        }
        this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(53).append("Rollback of ongoing transaction for transactionalId ").append(txnIdAndPidEpoch.transactionalId()).append(" ").toString()).append(new StringBuilder(20).append("failed due to error ").append(error).toString()).toString());
    }

    public void abortTimedOutTransactions(Function1<TransactionalIdAndProducerIdEpoch, Function1<Errors, BoxedUnit>> onComplete) {
        this.txnManager.timedOutTransactions().foreach((Function1 & Serializable)txnIdAndPidEpoch -> {
            TransactionCoordinator.$anonfun$abortTimedOutTransactions$1(this, onComplete, txnIdAndPidEpoch);
            return BoxedUnit.UNIT;
        });
    }

    public void startup(Function0<Object> retrieveTransactionTopicPartitionCount, boolean enableTransactionalIdExpiration) {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Starting up.");
        this.scheduler.startup();
        this.scheduler.schedule("transaction-abort", (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> this.abortTimedOutTransactions((Function1<TransactionalIdAndProducerIdEpoch, Function1<Errors, BoxedUnit>>)(Function1 & Serializable)txnIdAndPidEpoch -> (Function1 & Serializable)error -> {
            this.onEndTransactionComplete(txnIdAndPidEpoch, error);
            return BoxedUnit.UNIT;
        }), this.txnConfig.abortTimedOutTransactionsIntervalMs(), this.txnConfig.abortTimedOutTransactionsIntervalMs(), this.scheduler.schedule$default$5());
        this.txnManager.startup(retrieveTransactionTopicPartitionCount, enableTransactionalIdExpiration);
        this.txnMarkerChannelManager.start();
        this.isActive().set(true);
        this.info((Function0<String>)(Function0 & Serializable)() -> "Startup complete.");
    }

    public boolean startup$default$2() {
        return true;
    }

    public void shutdown() {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down.");
        this.isActive().set(false);
        this.scheduler.shutdown();
        this.producerIdManager().shutdown();
        this.txnManager.shutdown();
        this.txnMarkerChannelManager.shutdown();
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutdown complete.");
    }

    private static final void sendRetriableErrorCallback$1(Errors error, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (errors == null ? errors2 != null : !errors.equals(errors2)) {
            responseCallback$1.apply((Object)new InitProducerIdResult(-1L, -1, error));
            return;
        }
        Errors kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError_error = Errors.CONCURRENT_TRANSACTIONS;
        Object var3_3 = null;
        responseCallback$1.apply((Object)new InitProducerIdResult(-1L, -1, kafka$coordinator$transaction$TransactionCoordinator$$initTransactionError_error));
    }

    private final void sendPidResponseCallback$1(Errors error, String transactionalId$1, TxnTransitMetadata newMetadata$1, Function1 responseCallback$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(59).append("Initialized transactionalId ").append(transactionalId$1).append(" with producerId ").append(newMetadata$1.producerId()).append(" and producer ").toString()).append(new StringBuilder(20).append("epoch ").append(newMetadata$1.producerEpoch()).append(" on partition ").toString()).append(new StringBuilder(20).append("__transaction_state").append("-").append($this.txnManager.partitionFor(transactionalId$1)).toString()).toString());
            responseCallback$1.apply((Object)TransactionCoordinator$.MODULE$.kafka$coordinator$transaction$TransactionCoordinator$$initTransactionMetadata(newMetadata$1));
            return;
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(61).append("Returning ").append(error).append(" error code to client for ").append(transactionalId$1).append("'s InitProducerId request").toString());
        responseCallback$1.apply((Object)new InitProducerIdResult(-1L, -1, error));
    }

    private static final boolean isValidProducerId$1(ProducerIdAndEpoch producerIdAndEpoch, TransactionMetadata txnMetadata$2) {
        return txnMetadata$2.producerEpoch() == -1 || producerIdAndEpoch.producerId == txnMetadata$2.producerId() || producerIdAndEpoch.producerId == txnMetadata$2.lastProducerId() && TransactionMetadata$.MODULE$.isEpochExhausted(producerIdAndEpoch.epoch);
    }

    public static final /* synthetic */ boolean $anonfun$prepareInitProducerIdTransit$2(TransactionMetadata txnMetadata$2, ProducerIdAndEpoch x$1) {
        return x$1.epoch == txnMetadata$2.producerEpoch();
    }

    public static final /* synthetic */ boolean $anonfun$handleDescribeTransactions$2(DescribeTransactionsResponseData.TransactionState transactionState$1, TopicPartition topicPartition) {
        DescribeTransactionsResponseData.TopicData topicData = transactionState$1.topics().find(topicPartition.topic());
        if (topicData == null) {
            topicData = new DescribeTransactionsResponseData.TopicData().setTopic(topicPartition.topic());
            transactionState$1.topics().add((ImplicitLinkedHashCollection.Element)topicData);
        }
        return topicData.partitions().add(Predef$.MODULE$.int2Integer(topicPartition.partition()));
    }

    public static final /* synthetic */ void $anonfun$endTransaction$12(TransactionCoordinator $this, String transactionalId$4, int coordinatorEpoch$6, Errors error$2, TxnTransitMetadata newMetadata$2, Option x0$2) {
        if (None$.MODULE$.equals(x0$2)) {
            $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(72).append("The coordinator still owns the transaction partition for ").append(transactionalId$4).append(", but there is ").toString()).append("no metadata in the cache; this is not expected").toString());
            return;
        }
        if (x0$2 instanceof Some) {
            CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$2).value();
            if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch$6) {
                epochAndMetadata.transactionMetadata().hasFailedEpochFence_$eq(true);
                $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(95).append("The coordinator failed to write an epoch fence transition for producer ").append(transactionalId$4).append(" to the transaction log ").toString()).append(new StringBuilder(71).append("with error ").append(error$2).append(". The epoch was increased to ").append(newMetadata$2.producerEpoch()).append(" but not returned to the client").toString()).toString());
                return;
            }
        } else {
            throw new MatchError((Object)x0$2);
        }
    }

    private final void sendTxnMarkersCallback$1(Errors error, String transactionalId$4, int coordinatorEpoch$6, long producerId$2, short producerEpoch$2, TransactionResult txnMarkerResult$1, Function1 responseCallback$2, TxnTransitMetadata newMetadata$2, BooleanRef isEpochFence$1) {
        Errors errors = error;
        Errors errors2 = Errors.NONE;
        if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
            Tuple2 tuple2;
            Either preSendResult = this.txnManager.getTransactionState(transactionalId$4).flatMap((Function1 & Serializable)x0$1 -> {
                Left left;
                if (None$.MODULE$.equals(x0$1)) {
                    String errorMsg = new StringBuilder(0).append(new StringBuilder(72).append("The coordinator still owns the transaction partition for ").append(transactionalId$4).append(", but there is ").toString()).append("no metadata in the cache; this is not expected").toString();
                    this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
                    throw new IllegalStateException(errorMsg);
                }
                if (x0$1 instanceof Some) {
                    CoordinatorEpochAndTxnMetadata epochAndMetadata = (CoordinatorEpochAndTxnMetadata)((Some)x0$1).value();
                    if (epochAndMetadata.coordinatorEpoch() == coordinatorEpoch$6) {
                        TransactionMetadata txnMetadata = epochAndMetadata.transactionMetadata();
                        left = (Either)txnMetadata.inLock((Function0 & Serializable)() -> {
                            Left<Errors, Nothing$> left;
                            if (txnMetadata.producerId() != producerId$2) {
                                return package$.MODULE$.Left().apply((Object)Errors.INVALID_PRODUCER_ID_MAPPING);
                            }
                            if (txnMetadata.producerEpoch() != producerEpoch$2) {
                                return package$.MODULE$.Left().apply((Object)Errors.PRODUCER_FENCED);
                            }
                            if (txnMetadata.pendingTransitionInProgress()) {
                                return package$.MODULE$.Left().apply((Object)Errors.CONCURRENT_TRANSACTIONS);
                            }
                            TransactionState transactionState = txnMetadata.state();
                            boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (Ongoing$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState)));
                            if (bl) {
                                left = this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1);
                            } else if (PrepareCommit$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult$1;
                                TransactionResult transactionResult2 = TransactionResult.COMMIT;
                                left = (transactionResult == null ? transactionResult2 != null : !transactionResult.equals(transactionResult2)) ? this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            } else if (PrepareAbort$.MODULE$.equals(transactionState)) {
                                TransactionResult transactionResult = txnMarkerResult$1;
                                TransactionResult transactionResult3 = TransactionResult.ABORT;
                                left = (transactionResult == null ? transactionResult3 != null : !transactionResult.equals(transactionResult3)) ? this.logInvalidStateTransitionAndReturnError(transactionalId$4, txnMetadata.state(), txnMarkerResult$1) : package$.MODULE$.Right().apply((Object)new Tuple2((Object)txnMetadata, (Object)txnMetadata.prepareComplete($this.time.milliseconds())));
                            } else {
                                boolean bl2 = Dead$.MODULE$.equals(transactionState) ? true : PrepareEpochFence$.MODULE$.equals(transactionState);
                                if (bl2) {
                                    String errorMsg = new StringBuilder(0).append(new StringBuilder(36).append("Found transactionalId ").append(transactionalId$4).append(" with state ").append(txnMetadata.state()).append(". ").toString()).append("This is illegal as we should never have transitioned to this state.").toString();
                                    this.fatal((Function0<String>)(Function0 & Serializable)() -> errorMsg);
                                    throw new IllegalStateException(errorMsg);
                                }
                                throw new MatchError((Object)transactionState);
                            }
                            return left;
                        });
                    } else {
                        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(61).append("The transaction coordinator epoch has changed to ").append(epochAndMetadata.coordinatorEpoch()).append(" after ").append(txnMarkerResult$1).append(" was ").toString()).append(new StringBuilder(53).append("successfully appended to the log for ").append(transactionalId$4).append(" with old epoch ").append(coordinatorEpoch$6).toString()).toString());
                        left = package$.MODULE$.Left().apply((Object)Errors.NOT_COORDINATOR);
                    }
                } else {
                    throw new MatchError(x0$1);
                }
                Left left2 = left;
                return left2;
            });
            if (preSendResult instanceof Left) {
                Errors err = (Errors)((Left)preSendResult).value();
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(135).append("Aborting sending of transaction markers after appended ").append(txnMarkerResult$1).append(" to transaction log and returning ").append(err).append(" error to client for ").append(transactionalId$4).append("'s EndTransaction request").toString());
                BoxedUnit cfr_ignored_0 = (BoxedUnit)responseCallback$2.apply((Object)err);
                return;
            }
            if (preSendResult instanceof Right && (tuple2 = (Tuple2)((Right)preSendResult).value()) != null) {
                TransactionMetadata txnMetadata = (TransactionMetadata)tuple2._1();
                TxnTransitMetadata newPreSendMetadata = (TxnTransitMetadata)tuple2._2();
                responseCallback$2.apply((Object)Errors.NONE);
                this.txnMarkerChannelManager.addTxnMarkersToSend(coordinatorEpoch$6, txnMarkerResult$1, txnMetadata, newPreSendMetadata);
                return;
            }
            throw new MatchError((Object)preSendResult);
        }
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(106).append("Aborting sending of transaction markers and returning ").append(error).append(" error to client for ").append(transactionalId$4).append("'s EndTransaction request of ").append(txnMarkerResult$1).append(", ").toString()).append(new StringBuilder(66).append("since appending ").append(newMetadata$2).append(" to transaction log with coordinator epoch ").append(coordinatorEpoch$6).append(" failed").toString()).toString());
        if (isEpochFence$1.elem) {
            this.txnManager.getTransactionState(transactionalId$4).foreach((Function1 & Serializable)x0$2 -> {
                TransactionCoordinator.$anonfun$endTransaction$12(this, transactionalId$4, coordinatorEpoch$6, error, newMetadata$2, x0$2);
                return BoxedUnit.UNIT;
            });
        }
        responseCallback$2.apply((Object)error);
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$2(TransactionCoordinator $this, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch$2, Function1 onComplete$1, Option x0$1) {
        if (None$.MODULE$.equals(x0$1)) {
            $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Could not find transaction metadata when trying to timeout transaction for ").append(txnIdAndPidEpoch$2).toString());
            return;
        }
        if (x0$1 instanceof Some) {
            TransactionMetadata txnMetadata = ((CoordinatorEpochAndTxnMetadata)((Some)x0$1).value()).transactionMetadata();
            ((Option)txnMetadata.inLock((Function0 & Serializable)() -> {
                if (txnMetadata.producerId() != txnIdAndPidEpoch$2.producerId()) {
                    $this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(60).append("Found incorrect producerId when expiring transactionalId: ").append(txnIdAndPidEpoch$2.transactionalId()).append(". ").toString()).append(new StringBuilder(41).append("Expected producerId: ").append(txnIdAndPidEpoch$2.producerId()).append(". Found producerId: ").toString()).append(String.valueOf(BoxesRunTime.boxToLong((long)txnMetadata.producerId()))).toString());
                    return None$.MODULE$;
                }
                if (txnMetadata.pendingTransitionInProgress()) {
                    $this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(24).append(new StringBuilder(58).append("Skipping abort of timed out transaction ").append(txnIdAndPidEpoch$2).append(" since there is a ").toString()).append("pending state transition").toString());
                    return None$.MODULE$;
                }
                return new Some((Object)txnMetadata.prepareFenceProducerEpoch());
            })).foreach((Function1 & Serializable)txnTransitMetadata -> {
                $this.endTransaction(txnMetadata.transactionalId(), txnTransitMetadata.producerId(), txnTransitMetadata.producerEpoch(), TransactionResult.ABORT, false, (Function1<Errors, BoxedUnit>)((Function1)onComplete$1.apply((Object)txnIdAndPidEpoch$2)), RequestLocal$.MODULE$.NoCaching());
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ void $anonfun$abortTimedOutTransactions$1(TransactionCoordinator $this, Function1 onComplete$1, TransactionalIdAndProducerIdEpoch txnIdAndPidEpoch) {
        $this.txnManager.getTransactionState(txnIdAndPidEpoch.transactionalId()).foreach((Function1 & Serializable)x0$1 -> {
            TransactionCoordinator.$anonfun$abortTimedOutTransactions$2($this, txnIdAndPidEpoch, onComplete$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public TransactionCoordinator(int brokerId, TransactionConfig txnConfig, Scheduler scheduler, Function0<ProducerIdManager> createProducerIdManager, TransactionStateManager txnManager, TransactionMarkerChannelManager txnMarkerChannelManager, Time time, LogContext logContext) {
        this.txnConfig = txnConfig;
        this.scheduler = scheduler;
        this.txnManager = txnManager;
        this.txnMarkerChannelManager = txnMarkerChannelManager;
        this.time = time;
        this.logIdent_$eq(logContext.logPrefix());
        this.isActive = new AtomicBoolean(false);
        this.producerIdManager = (ProducerIdManager)createProducerIdManager.apply();
    }
}

