/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import kafka.controller.KafkaController;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.server.ConfigHandler;
import kafka.server.Constants$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.QuotaFactory;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ThrottledReplicaListValidator$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0005\u0005Ea\u0001\u0002\u0007\u000e\u0001IA\u0001b\t\u0001\u0003\u0006\u0004%I\u0001\n\u0005\tW\u0001\u0011\t\u0011)A\u0005K!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u00051\u0001\t\u0015\r\u0011\"\u00012\u0011!\u0001\u0005A!A!\u0002\u0013\u0011\u0004\u0002C!\u0001\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u000b-\u0003A\u0011\u0001'\t\u000bI\u0003A\u0011B*\t\u000bA\u0004A\u0011A9\t\u000bQ\u0004A\u0011A;\t\u000f\u0005%\u0001\u0001\"\u0001\u0002\f\t\u0011Bk\u001c9jG\u000e{gNZ5h\u0011\u0006tG\r\\3s\u0015\tqq\"\u0001\u0004tKJ4XM\u001d\u0006\u0002!\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\u00143u\u0001\"\u0001F\f\u000e\u0003UQ\u0011AF\u0001\u0006g\u000e\fG.Y\u0005\u00031U\u0011a!\u00118z%\u00164\u0007C\u0001\u000e\u001c\u001b\u0005i\u0011B\u0001\u000f\u000e\u00055\u0019uN\u001c4jO\"\u000bg\u000e\u001a7feB\u0011a$I\u0007\u0002?)\u0011\u0001eD\u0001\u0006kRLGn]\u0005\u0003E}\u0011q\u0001T8hO&tw-\u0001\u0006m_\u001el\u0015M\\1hKJ,\u0012!\n\t\u0003M%j\u0011a\n\u0006\u0003Q=\t1\u0001\\8h\u0013\tQsE\u0001\u0006M_\u001el\u0015M\\1hKJ\f1\u0002\\8h\u001b\u0006t\u0017mZ3sA\u0005Y1.\u00194lC\u000e{gNZ5h!\tQb&\u0003\u00020\u001b\tY1*\u00194lC\u000e{gNZ5h\u0003\u0019\tXo\u001c;bgV\t!\u0007\u0005\u00024{9\u0011Ag\u000f\b\u0003kir!AN\u001d\u000e\u0003]R!\u0001O\t\u0002\rq\u0012xn\u001c;?\u0013\u0005\u0001\u0012B\u0001\b\u0010\u0013\taT\"\u0001\u0007Rk>$\u0018MR1di>\u0014\u00180\u0003\u0002?\u007f\ti\u0011+^8uC6\u000bg.Y4feNT!\u0001P\u0007\u0002\u000fE,x\u000e^1tA\u0005y1.\u00194lC\u000e{g\u000e\u001e:pY2,'\u000fE\u0002\u0015\u0007\u0016K!\u0001R\u000b\u0003\r=\u0003H/[8o!\t1\u0015*D\u0001H\u0015\tAu\"\u0001\u0006d_:$(o\u001c7mKJL!AS$\u0003\u001f-\u000bgm[1D_:$(o\u001c7mKJ\fa\u0001P5oSRtD#B'O\u001fB\u000b\u0006C\u0001\u000e\u0001\u0011\u0015\u0019s\u00011\u0001&\u0011\u0015as\u00011\u0001.\u0011\u0015\u0001t\u00011\u00013\u0011\u0015\tu\u00011\u0001C\u0003=)\b\u000fZ1uK2{wmQ8oM&<G\u0003\u0002+XC.\u0004\"\u0001F+\n\u0005Y+\"\u0001B+oSRDQ\u0001\u0017\u0005A\u0002e\u000bQ\u0001^8qS\u000e\u0004\"A\u00170\u000f\u0005mc\u0006C\u0001\u001c\u0016\u0013\tiV#\u0001\u0004Qe\u0016$WMZ\u0005\u0003?\u0002\u0014aa\u0015;sS:<'BA/\u0016\u0011\u0015\u0011\u0007\u00021\u0001d\u0003-!x\u000e]5d\u0007>tg-[4\u0011\u0005\u0011LW\"A3\u000b\u0005\u0019<\u0017\u0001B;uS2T\u0011\u0001[\u0001\u0005U\u00064\u0018-\u0003\u0002kK\nQ\u0001K]8qKJ$\u0018.Z:\t\u000b1D\u0001\u0019A7\u0002)\r|gNZ5h\u001d\u0006lWm\u001d+p\u000bb\u001cG.\u001e3f!\rQf.W\u0005\u0003_\u0002\u00141aU3u\u0003Q\u0001(o\\2fgN\u001cuN\u001c4jO\u000eC\u0017M\\4fgR\u0019AK]:\t\u000baK\u0001\u0019A-\t\u000b\tL\u0001\u0019A2\u00021A\f'o]3UQJ|G\u000f\u001e7fIB\u000b'\u000f^5uS>t7\u000f\u0006\u0004w\u007f\u0006\u0005\u0011Q\u0001\t\u0004ojdX\"\u0001=\u000b\u0005e,\u0012AC2pY2,7\r^5p]&\u00111\u0010\u001f\u0002\u0004'\u0016\f\bC\u0001\u000b~\u0013\tqXCA\u0002J]RDQA\u0019\u0006A\u0002\rDa!a\u0001\u000b\u0001\u0004a\u0018\u0001\u00032s_.,'/\u00133\t\r\u0005\u001d!\u00021\u0001Z\u0003\u0011\u0001(o\u001c9\u0002\u001f\u0015D8\r\\;eK\u0012\u001cuN\u001c4jON$R!\\A\u0007\u0003\u001fAQ\u0001W\u0006A\u0002eCQAY\u0006A\u0002\r\u0004")
public class TopicConfigHandler
implements ConfigHandler,
Logging {
    private final LogManager logManager;
    private final KafkaConfig kafkaConfig;
    private final QuotaFactory.QuotaManagers quotas;
    private final Option<KafkaController> kafkaController;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private LogManager logManager() {
        return this.logManager;
    }

    public QuotaFactory.QuotaManagers quotas() {
        return this.quotas;
    }

    private void updateLogConfig(String topic, Properties topicConfig, Set<String> configNamesToExclude) {
        this.logManager().topicConfigUpdated(topic);
        Seq<Log> logs = this.logManager().logsByTopic(topic);
        if (logs.nonEmpty()) {
            Properties props = new Properties();
            CollectionConverters$.MODULE$.PropertiesHasAsScala(topicConfig).asScala().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(key, value) -> {
                if (!configNamesToExclude.contains(key)) {
                    return props.put(key, value);
                }
                return BoxedUnit.UNIT;
            }, arg_0, arg_1));
            LogConfig logConfig = LogConfig$.MODULE$.fromProps(this.logManager().currentDefaultConfig().originals(), props);
            logs.foreach((Function1 & Serializable)x$1 -> {
                x$1.updateConfig(logConfig);
                return BoxedUnit.UNIT;
            });
        }
    }

    @Override
    public void processConfigChanges(String topic, Properties topicConfig) {
        Set<String> configNamesToExclude = this.excludedConfigs(topic, topicConfig);
        this.updateLogConfig(topic, topicConfig, configNamesToExclude);
        this.updateThrottledList$1(LogConfig$.MODULE$.LeaderReplicationThrottledReplicasProp(), this.quotas().leader(), topicConfig, topic);
        this.updateThrottledList$1(LogConfig$.MODULE$.FollowerReplicationThrottledReplicasProp(), this.quotas().follower(), topicConfig, topic);
        if (BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(topicConfig.getProperty(KafkaConfig$.MODULE$.UncleanLeaderElectionEnableProp())))).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable)() -> false))) {
            this.kafkaController.foreach((Function1 & Serializable)x$2 -> {
                x$2.enableTopicUncleanLeaderElection(topic);
                return BoxedUnit.UNIT;
            });
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Seq<Object> parseThrottledPartitions(Properties topicConfig, int brokerId, String prop) {
        String configValue = topicConfig.get(prop).toString().trim();
        ThrottledReplicaListValidator$.MODULE$.ensureValidString(prop, configValue);
        switch (configValue == null ? 0 : configValue.hashCode()) {
            case 0: {
                if (!"".equals(configValue)) return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])configValue.trim().split(",")), (Function1 & Serializable)x$3 -> x$3.split(":"), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TopicConfigHandler.$anonfun$parseThrottledPartitions$2(brokerId, x$4)))), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$5[0]))), (ClassTag)ClassTag$.MODULE$.Int())));
                return Nil$.MODULE$;
            }
            case 42: {
                if (!"*".equals(configValue)) return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])configValue.trim().split(",")), (Function1 & Serializable)x$3 -> x$3.split(":"), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TopicConfigHandler.$anonfun$parseThrottledPartitions$2(brokerId, x$4)))), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$5[0]))), (ClassTag)ClassTag$.MODULE$.Int())));
                return Constants$.MODULE$.AllReplicas();
            }
            default: {
                return ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.intArrayOps((int[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])configValue.trim().split(",")), (Function1 & Serializable)x$3 -> x$3.split(":"), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)))), (Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TopicConfigHandler.$anonfun$parseThrottledPartitions$2(brokerId, x$4)))), (Function1 & Serializable)x$5 -> BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$5[0]))), (ClassTag)ClassTag$.MODULE$.Int())));
            }
        }
    }

    public Set<String> excludedConfigs(String topic, Properties topicConfig) {
        return Option$.MODULE$.option2Iterable(Option$.MODULE$.apply((Object)topicConfig.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())).flatMap((Function1 & Serializable)versionString -> {
            LogConfig.MessageFormatVersion messageFormatVersion = new LogConfig.MessageFormatVersion((String)versionString, $this.kafkaConfig.interBrokerProtocolVersion().version());
            if (messageFormatVersion.shouldIgnore()) {
                if (messageFormatVersion.shouldWarn()) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> messageFormatVersion.topicWarningMessage(topic));
                }
                return new Some((Object)LogConfig$.MODULE$.MessageFormatVersionProp());
            }
            if ($this.kafkaConfig.interBrokerProtocolVersion().$less(messageFormatVersion.messageFormatVersion())) {
                this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(0).append(new StringBuilder(50).append("Topic configuration ").append(LogConfig$.MODULE$.MessageFormatVersionProp()).append(" is ignored for `").append(topic).append("` because `").append((String)versionString).append("` ").toString()).append(new StringBuilder(70).append("is higher than what is allowed by the inter-broker protocol version `").append($this.kafkaConfig.interBrokerProtocolVersionString()).append("`").toString()).toString());
                return new Some((Object)LogConfig$.MODULE$.MessageFormatVersionProp());
            }
            return None$.MODULE$;
        })).toSet();
    }

    private final void updateThrottledList$1(String prop, ReplicationQuotaManager quotaManager, Properties topicConfig$1, String topic$1) {
        if (topicConfig$1.containsKey(prop) && topicConfig$1.getProperty(prop).length() > 0) {
            Seq<Object> partitions = this.parseThrottledPartitions(topicConfig$1, this.kafkaConfig.brokerId(), prop);
            quotaManager.markThrottled(topic$1, partitions);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(47).append("Setting ").append(prop).append(" on broker ").append($this.kafkaConfig.brokerId()).append(" for topic: ").append(topic$1).append(" and partitions ").append(partitions).toString());
            return;
        }
        quotaManager.removeThrottle(topic$1);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(33).append("Removing ").append(prop).append(" from broker ").append($this.kafkaConfig.brokerId()).append(" for topic ").append(topic$1).toString());
    }

    public static final /* synthetic */ boolean $anonfun$parseThrottledPartitions$2(int brokerId$1, String[] x$4) {
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(x$4[1])) == brokerId$1;
    }

    public TopicConfigHandler(LogManager logManager, KafkaConfig kafkaConfig, QuotaFactory.QuotaManagers quotas, Option<KafkaController> kafkaController) {
        this.logManager = logManager;
        this.kafkaConfig = kafkaConfig;
        this.quotas = quotas;
        this.kafkaController = kafkaController;
    }
}

