/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.ReliabilityStrategy;
import org.apache.logging.log4j.core.filter.CompositeFilter;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.SimpleMessage;
import org.apache.logging.log4j.spi.AbstractLogger;
import org.apache.logging.log4j.util.Supplier;

public class Logger
extends AbstractLogger
implements Supplier<LoggerConfig> {
    private static final long serialVersionUID = 1L;
    protected volatile PrivateConfig privateConfig;
    private final LoggerContext context;

    protected Logger(LoggerContext context, String name, MessageFactory messageFactory) {
        super(name, messageFactory);
        this.context = context;
        this.privateConfig = new PrivateConfig(context.getConfiguration(), this);
    }

    public Logger getParent() {
        LoggerConfig lc;
        LoggerConfig loggerConfig = lc = this.privateConfig.loggerConfig.getName().equals(this.getName()) ? this.privateConfig.loggerConfig.getParent() : this.privateConfig.loggerConfig;
        if (lc == null) {
            return null;
        }
        if (this.context.hasLogger(lc.getName())) {
            return this.context.getLogger(lc.getName(), this.getMessageFactory());
        }
        return new Logger(this.context, lc.getName(), this.getMessageFactory());
    }

    public LoggerContext getContext() {
        return this.context;
    }

    public synchronized void setLevel(Level level) {
        Logger parent;
        if (level == this.getLevel()) {
            return;
        }
        Level actualLevel = level != null ? level : ((parent = this.getParent()) != null ? parent.getLevel() : this.privateConfig.level);
        this.privateConfig = new PrivateConfig(this.privateConfig, actualLevel);
    }

    public LoggerConfig get() {
        return this.privateConfig.loggerConfig;
    }

    public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable t) {
        Message msg = message == null ? new SimpleMessage("") : message;
        this.privateConfig.config.getConfigurationMonitor().checkConfiguration();
        ReliabilityStrategy strategy = this.privateConfig.loggerConfig.getReliabilityStrategy();
        strategy.log(this, this.getName(), fqcn, marker, level, msg, t);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Throwable t) {
        return this.privateConfig.filter(level, marker, message, t);
    }

    public boolean isEnabled(Level level, Marker marker, String message) {
        return this.privateConfig.filter(level, marker, message);
    }

    public boolean isEnabled(Level level, Marker marker, String message, Object ... params) {
        return this.privateConfig.filter(level, marker, message, params);
    }

    public boolean isEnabled(Level level, Marker marker, Object message, Throwable t) {
        return this.privateConfig.filter(level, marker, message, t);
    }

    public boolean isEnabled(Level level, Marker marker, Message message, Throwable t) {
        return this.privateConfig.filter(level, marker, message, t);
    }

    public void addAppender(Appender appender) {
        this.privateConfig.config.addLoggerAppender(this, appender);
    }

    public void removeAppender(Appender appender) {
        this.privateConfig.loggerConfig.removeAppender(appender.getName());
    }

    public Map<String, Appender> getAppenders() {
        return this.privateConfig.loggerConfig.getAppenders();
    }

    public Iterator<Filter> getFilters() {
        Filter filter = this.privateConfig.loggerConfig.getFilter();
        if (filter == null) {
            return new ArrayList().iterator();
        }
        if (filter instanceof CompositeFilter) {
            return ((CompositeFilter)filter).iterator();
        }
        ArrayList<Filter> filters = new ArrayList<Filter>();
        filters.add(filter);
        return filters.iterator();
    }

    public Level getLevel() {
        return this.privateConfig.level;
    }

    public int filterCount() {
        Filter filter = this.privateConfig.loggerConfig.getFilter();
        if (filter == null) {
            return 0;
        }
        if (filter instanceof CompositeFilter) {
            return ((CompositeFilter)filter).size();
        }
        return 1;
    }

    public void addFilter(Filter filter) {
        this.privateConfig.config.addLoggerFilter(this, filter);
    }

    public boolean isAdditive() {
        return this.privateConfig.loggerConfig.isAdditive();
    }

    public void setAdditive(boolean additive) {
        this.privateConfig.config.setLoggerAdditive(this, additive);
    }

    protected void updateConfiguration(Configuration newConfig) {
        this.privateConfig = new PrivateConfig(newConfig, this);
    }

    public String toString() {
        String nameLevel = "" + this.getName() + ':' + this.getLevel();
        if (this.context == null) {
            return nameLevel;
        }
        String contextName = this.context.getName();
        return contextName == null ? nameLevel : nameLevel + " in " + contextName;
    }

    protected class PrivateConfig
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public final LoggerConfig loggerConfig;
        public final Configuration config;
        private final Level level;
        private final int intLevel;
        private final Logger logger;

        public PrivateConfig(Configuration config, Logger logger2) {
            this.config = config;
            this.loggerConfig = config.getLoggerConfig(Logger.this.getName());
            this.level = this.loggerConfig.getLevel();
            this.intLevel = this.level.intLevel();
            this.logger = logger2;
        }

        public PrivateConfig(PrivateConfig pc, Level level) {
            this.config = pc.config;
            this.loggerConfig = pc.loggerConfig;
            this.level = level;
            this.intLevel = this.level.intLevel();
            this.logger = pc.logger;
        }

        public PrivateConfig(PrivateConfig pc, LoggerConfig lc) {
            this.config = pc.config;
            this.loggerConfig = lc;
            this.level = lc.getLevel();
            this.intLevel = this.level.intLevel();
            this.logger = pc.logger;
        }

        public void logEvent(LogEvent event) {
            this.config.getConfigurationMonitor().checkConfiguration();
            this.loggerConfig.log(event);
        }

        boolean filter(Level level, Marker marker, String msg) {
            Filter.Result r;
            this.config.getConfigurationMonitor().checkConfiguration();
            Filter filter = this.config.getFilter();
            if (filter != null && (r = filter.filter(this.logger, level, marker, msg, new Object[0])) != Filter.Result.NEUTRAL) {
                return r == Filter.Result.ACCEPT;
            }
            return level != null && this.intLevel >= level.intLevel();
        }

        boolean filter(Level level, Marker marker, String msg, Throwable t) {
            Filter.Result r;
            this.config.getConfigurationMonitor().checkConfiguration();
            Filter filter = this.config.getFilter();
            if (filter != null && (r = filter.filter(this.logger, level, marker, (Object)msg, t)) != Filter.Result.NEUTRAL) {
                return r == Filter.Result.ACCEPT;
            }
            return level != null && this.intLevel >= level.intLevel();
        }

        boolean filter(Level level, Marker marker, String msg, Object ... p1) {
            Filter.Result r;
            this.config.getConfigurationMonitor().checkConfiguration();
            Filter filter = this.config.getFilter();
            if (filter != null && (r = filter.filter(this.logger, level, marker, msg, p1)) != Filter.Result.NEUTRAL) {
                return r == Filter.Result.ACCEPT;
            }
            return level != null && this.intLevel >= level.intLevel();
        }

        boolean filter(Level level, Marker marker, Object msg, Throwable t) {
            Filter.Result r;
            this.config.getConfigurationMonitor().checkConfiguration();
            Filter filter = this.config.getFilter();
            if (filter != null && (r = filter.filter(this.logger, level, marker, msg, t)) != Filter.Result.NEUTRAL) {
                return r == Filter.Result.ACCEPT;
            }
            return level != null && this.intLevel >= level.intLevel();
        }

        boolean filter(Level level, Marker marker, Message msg, Throwable t) {
            Filter.Result r;
            this.config.getConfigurationMonitor().checkConfiguration();
            Filter filter = this.config.getFilter();
            if (filter != null && (r = filter.filter(this.logger, level, marker, msg, t)) != Filter.Result.NEUTRAL) {
                return r == Filter.Result.ACCEPT;
            }
            return level != null && this.intLevel >= level.intLevel();
        }
    }
}

