/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.nio.charset.Charset;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.ManagerFactory;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginBuilderFactory;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.config.plugins.validation.constraints.Required;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.util.PropertiesUtil;

@Plugin(name="Console", category="Core", elementType="appender", printObject=true)
public final class ConsoleAppender
extends AbstractOutputStreamAppender<OutputStreamManager> {
    private static final long serialVersionUID = 1L;
    private static final String JANSI_CLASS = "org.fusesource.jansi.WindowsAnsiOutputStream";
    private static ConsoleManagerFactory factory = new ConsoleManagerFactory();
    private static final Target DEFAULT_TARGET = Target.SYSTEM_OUT;

    private ConsoleAppender(String name, Layout<? extends Serializable> layout, Filter filter, OutputStreamManager manager, boolean ignoreExceptions) {
        super(name, layout, filter, ignoreExceptions, true, manager);
    }

    @PluginFactory
    public static ConsoleAppender createAppender(@PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="target", defaultString="SYSTEM_OUT") String targetStr, @PluginAttribute(value="name") String name, @PluginAttribute(value="follow", defaultBoolean=false) String follow, @PluginAttribute(value="ignoreExceptions", defaultBoolean=true) String ignore) {
        if (name == null) {
            LOGGER.error("No name provided for ConsoleAppender");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        boolean isFollow = Boolean.parseBoolean(follow);
        boolean ignoreExceptions = Booleans.parseBoolean(ignore, true);
        Target target = targetStr == null ? DEFAULT_TARGET : Target.valueOf(targetStr);
        return new ConsoleAppender(name, layout, filter, ConsoleAppender.getManager(target, isFollow, layout), ignoreExceptions);
    }

    public static ConsoleAppender createDefaultAppenderForLayout(Layout<? extends Serializable> layout) {
        return new ConsoleAppender("Console", layout, null, ConsoleAppender.getManager(DEFAULT_TARGET, false, layout), true);
    }

    @PluginBuilderFactory
    public static Builder newBuilder() {
        return new Builder();
    }

    private static OutputStreamManager getManager(Target target, boolean follow, Layout<? extends Serializable> layout) {
        OutputStream os = ConsoleAppender.getOutputStream(follow, target);
        String managerName = target.name() + '.' + follow;
        return OutputStreamManager.getManager(managerName, new FactoryData(os, managerName, layout), factory);
    }

    private static OutputStream getOutputStream(boolean follow, Target target) {
        String enc = Charset.defaultCharset().name();
        OutputStream outputStream = null;
        try {
            outputStream = target == Target.SYSTEM_OUT ? (follow ? new PrintStream((OutputStream)new SystemOutStream(), true, enc) : System.out) : (follow ? new PrintStream((OutputStream)new SystemErrStream(), true, enc) : System.err);
            outputStream = new CloseShieldOutputStream(outputStream);
        }
        catch (UnsupportedEncodingException ex) {
            throw new IllegalStateException("Unsupported default encoding " + enc, ex);
        }
        PropertiesUtil propsUtil = PropertiesUtil.getProperties();
        if (!propsUtil.getStringProperty("os.name").startsWith("Windows") || propsUtil.getBooleanProperty("log4j.skipJansi")) {
            return outputStream;
        }
        try {
            Class<?> clazz = Loader.loadClass(JANSI_CLASS);
            Constructor<?> constructor = clazz.getConstructor(OutputStream.class);
            return new CloseShieldOutputStream((OutputStream)constructor.newInstance(outputStream));
        }
        catch (ClassNotFoundException cnfe) {
            LOGGER.debug("Jansi is not installed, cannot find {}", new Object[]{JANSI_CLASS});
        }
        catch (NoSuchMethodException nsme) {
            LOGGER.warn("{} is missing the proper constructor", new Object[]{JANSI_CLASS});
        }
        catch (Exception ex) {
            LOGGER.warn("Unable to instantiate {}", new Object[]{JANSI_CLASS});
        }
        return outputStream;
    }

    static /* synthetic */ Target access$100() {
        return DEFAULT_TARGET;
    }

    private static class ConsoleManagerFactory
    implements ManagerFactory<OutputStreamManager, FactoryData> {
        private ConsoleManagerFactory() {
        }

        @Override
        public OutputStreamManager createManager(String name, FactoryData data) {
            return new OutputStreamManager(data.os, data.type, data.layout, true);
        }
    }

    private static class FactoryData {
        private final OutputStream os;
        private final String type;
        private final Layout<? extends Serializable> layout;

        public FactoryData(OutputStream os, String type, Layout<? extends Serializable> layout) {
            this.os = os;
            this.type = type;
            this.layout = layout;
        }
    }

    private static class CloseShieldOutputStream
    extends OutputStream {
        private final OutputStream delegate;

        public CloseShieldOutputStream(OutputStream delegate) {
            this.delegate = delegate;
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() throws IOException {
            this.delegate.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.delegate.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.delegate.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            this.delegate.write(b);
        }
    }

    private static class SystemOutStream
    extends OutputStream {
        @Override
        public void close() {
        }

        @Override
        public void flush() {
            System.out.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            System.out.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            System.out.write(b, off, len);
        }

        @Override
        public void write(int b) throws IOException {
            System.out.write(b);
        }
    }

    private static class SystemErrStream
    extends OutputStream {
        @Override
        public void close() {
        }

        @Override
        public void flush() {
            System.err.flush();
        }

        @Override
        public void write(byte[] b) throws IOException {
            System.err.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            System.err.write(b, off, len);
        }

        @Override
        public void write(int b) {
            System.err.write(b);
        }
    }

    public static class Builder
    implements org.apache.logging.log4j.core.util.Builder<ConsoleAppender> {
        @PluginElement(value="Layout")
        @Required
        private Layout<? extends Serializable> layout = PatternLayout.createDefaultLayout();
        @PluginElement(value="Filter")
        private Filter filter;
        @PluginBuilderAttribute
        @Required
        private Target target = ConsoleAppender.access$100();
        @PluginBuilderAttribute
        @Required
        private String name;
        @PluginBuilderAttribute
        private boolean follow = false;
        @PluginBuilderAttribute
        private boolean ignoreExceptions = true;

        public Builder setLayout(Layout<? extends Serializable> layout) {
            this.layout = layout;
            return this;
        }

        public Builder setFilter(Filter filter) {
            this.filter = filter;
            return this;
        }

        public Builder setTarget(Target target) {
            this.target = target;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setFollow(boolean follow) {
            this.follow = follow;
            return this;
        }

        public Builder setIgnoreExceptions(boolean ignoreExceptions) {
            this.ignoreExceptions = ignoreExceptions;
            return this;
        }

        @Override
        public ConsoleAppender build() {
            return new ConsoleAppender(this.name, this.layout, this.filter, ConsoleAppender.getManager(this.target, this.follow, this.layout), this.ignoreExceptions);
        }
    }

    public static enum Target {
        SYSTEM_OUT,
        SYSTEM_ERR;

    }
}

