/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.async;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventFactory;
import com.lmax.disruptor.EventHandler;
import com.lmax.disruptor.EventTranslator;
import com.lmax.disruptor.ExceptionHandler;
import com.lmax.disruptor.RingBuffer;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.async.DaemonThreadFactory;
import org.apache.logging.log4j.core.async.RingBufferLogEvent;
import org.apache.logging.log4j.core.async.RingBufferLogEventHandler;
import org.apache.logging.log4j.core.async.RingBufferLogEventTranslator;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.ReliabilityStrategy;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.core.jmx.RingBufferAdmin;
import org.apache.logging.log4j.core.util.Clock;
import org.apache.logging.log4j.core.util.ClockFactory;
import org.apache.logging.log4j.core.util.DummyNanoClock;
import org.apache.logging.log4j.core.util.Integers;
import org.apache.logging.log4j.core.util.Loader;
import org.apache.logging.log4j.core.util.NanoClock;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFactory;
import org.apache.logging.log4j.message.TimestampMessage;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;

public class AsyncLogger
extends Logger {
    private static final long serialVersionUID = 1L;
    private static final int SLEEP_MILLIS_BETWEEN_DRAIN_ATTEMPTS = 50;
    private static final int MAX_DRAIN_ATTEMPTS_BEFORE_SHUTDOWN = 200;
    private static final int RINGBUFFER_MIN_SIZE = 128;
    private static final int RINGBUFFER_DEFAULT_SIZE = 262144;
    private static final StatusLogger LOGGER = StatusLogger.getLogger();
    private static final ThreadNameStrategy THREAD_NAME_STRATEGY = ThreadNameStrategy.create();
    private static volatile Disruptor<RingBufferLogEvent> disruptor;
    private static final Clock CLOCK;
    private static volatile NanoClock nanoClock;
    private static final ExecutorService executor;

    private static int calculateRingBufferSize() {
        int ringBufferSize = 262144;
        String userPreferredRBSize = PropertiesUtil.getProperties().getStringProperty("AsyncLogger.RingBufferSize", String.valueOf(ringBufferSize));
        try {
            int size = Integer.parseInt(userPreferredRBSize);
            if (size < 128) {
                size = 128;
                LOGGER.warn("Invalid RingBufferSize {}, using minimum size {}.", new Object[]{userPreferredRBSize, 128});
            }
            ringBufferSize = size;
        }
        catch (Exception ex) {
            LOGGER.warn("Invalid RingBufferSize {}, using default size {}.", new Object[]{userPreferredRBSize, ringBufferSize});
        }
        return Integers.ceilingNextPowerOfTwo(ringBufferSize);
    }

    private static void initInfoForExecutorThread() {
        executor.submit(new Runnable(){

            @Override
            public void run() {
                boolean isAppenderThread = true;
                Info info = new Info(new RingBufferLogEventTranslator(), Thread.currentThread().getName(), true);
                Info.threadlocalInfo.set(info);
            }
        });
    }

    private static WaitStrategy createWaitStrategy() {
        String strategy = PropertiesUtil.getProperties().getStringProperty("AsyncLogger.WaitStrategy");
        LOGGER.debug("property AsyncLogger.WaitStrategy={}", new Object[]{strategy});
        if ("Sleep".equals(strategy)) {
            return new SleepingWaitStrategy();
        }
        if ("Yield".equals(strategy)) {
            return new YieldingWaitStrategy();
        }
        if ("Block".equals(strategy)) {
            return new BlockingWaitStrategy();
        }
        LOGGER.debug("disruptor event handler uses BlockingWaitStrategy");
        return new BlockingWaitStrategy();
    }

    private static ExceptionHandler<RingBufferLogEvent> getExceptionHandler() {
        String cls = PropertiesUtil.getProperties().getStringProperty("AsyncLogger.ExceptionHandler");
        if (cls == null) {
            LOGGER.debug("No AsyncLogger.ExceptionHandler specified");
            return null;
        }
        try {
            ExceptionHandler result = Loader.newCheckedInstanceOf(cls, ExceptionHandler.class);
            LOGGER.debug("AsyncLogger.ExceptionHandler={}", new Object[]{result});
            return result;
        }
        catch (Exception ignored) {
            LOGGER.debug("AsyncLogger.ExceptionHandler not set: error creating " + cls + ": ", (Throwable)ignored);
            return null;
        }
    }

    public AsyncLogger(LoggerContext context, String name, MessageFactory messageFactory) {
        super(context, name, messageFactory);
    }

    @Override
    public void logMessage(String fqcn, Level level, Marker marker, Message message, Throwable thrown) {
        Disruptor<RingBufferLogEvent> temp = disruptor;
        if (temp == null) {
            LOGGER.fatal("Ignoring log event after log4j was shut down");
        } else {
            this.logMessage0(temp, fqcn, level, marker, message, thrown);
        }
    }

    private void logMessage0(Disruptor<RingBufferLogEvent> theDisruptor, String fqcn, Level level, Marker marker, Message message, Throwable thrown) {
        Info info = (Info)Info.threadlocalInfo.get();
        this.logMessageInAppropriateThread(info, theDisruptor, fqcn, level, marker, message, thrown);
    }

    private void logMessageInAppropriateThread(Info info, Disruptor<RingBufferLogEvent> theDisruptor, String fqcn, Level level, Marker marker, Message message, Throwable thrown) {
        if (!this.logMessageInCurrentThread(info, theDisruptor, fqcn, level, marker, message, thrown)) {
            this.logMessageInBackgroundThread(info, fqcn, level, marker, message, thrown);
        }
    }

    private boolean logMessageInCurrentThread(Info info, Disruptor<RingBufferLogEvent> theDisruptor, String fqcn, Level level, Marker marker, Message message, Throwable thrown) {
        if (info.isAppenderThread && theDisruptor.getRingBuffer().remainingCapacity() == 0L) {
            ReliabilityStrategy strategy = this.privateConfig.loggerConfig.getReliabilityStrategy();
            strategy.log(this, this.getName(), fqcn, marker, level, message, thrown);
            return true;
        }
        return false;
    }

    private void logMessageInBackgroundThread(Info info, String fqcn, Level level, Marker marker, Message message, Throwable thrown) {
        message.getFormattedMessage();
        this.initLogMessageInfo(info, fqcn, level, marker, message, thrown);
        this.enqueueLogMessageInfo(info);
    }

    private void initLogMessageInfo(Info info, String fqcn, Level level, Marker marker, Message message, Throwable thrown) {
        info.translator.setValues(this, this.getName(), marker, fqcn, level, message, thrown, ThreadContext.getImmutableContext(), ThreadContext.getImmutableStack(), info.threadName(), this.calcLocationIfRequested(fqcn), this.eventTimeMillis(message), nanoClock.nanoTime());
    }

    private long eventTimeMillis(Message message) {
        return message instanceof TimestampMessage ? ((TimestampMessage)message).getTimestamp() : CLOCK.currentTimeMillis();
    }

    private StackTraceElement calcLocationIfRequested(String fqcn) {
        boolean includeLocation = this.privateConfig.loggerConfig.isIncludeLocation();
        return includeLocation ? AsyncLogger.location(fqcn) : null;
    }

    private void enqueueLogMessageInfo(Info info) {
        try {
            disruptor.publishEvent((EventTranslator)info.translator);
        }
        catch (NullPointerException npe) {
            LOGGER.fatal("Ignoring log event after log4j was shut down.");
        }
    }

    private static StackTraceElement location(String fqcnOfLogger) {
        return Log4jLogEvent.calcLocation(fqcnOfLogger);
    }

    public void actualAsyncLog(RingBufferLogEvent event) {
        Map<Property, Boolean> properties = this.privateConfig.loggerConfig.getProperties();
        event.mergePropertiesIntoContextMap(properties, this.privateConfig.config.getStrSubstitutor());
        ReliabilityStrategy strategy = this.privateConfig.loggerConfig.getReliabilityStrategy();
        strategy.log(this, event);
    }

    public static void stop() {
        Disruptor<RingBufferLogEvent> temp = disruptor;
        disruptor = null;
        if (temp == null) {
            return;
        }
        for (int i = 0; AsyncLogger.hasBacklog(temp) && i < 200; ++i) {
            try {
                Thread.sleep(50L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        temp.shutdown();
        executor.shutdown();
        Info.threadlocalInfo.remove();
    }

    private static boolean hasBacklog(Disruptor<?> disruptor) {
        RingBuffer ringBuffer = disruptor.getRingBuffer();
        return !ringBuffer.hasAvailableCapacity(ringBuffer.getBufferSize());
    }

    public static RingBufferAdmin createRingBufferAdmin(String contextName) {
        return RingBufferAdmin.forAsyncLogger(disruptor.getRingBuffer(), contextName);
    }

    public static NanoClock getNanoClock() {
        return nanoClock;
    }

    public static void setNanoClock(NanoClock nanoClock) {
        AsyncLogger.nanoClock = Objects.requireNonNull(nanoClock, "NanoClock must be non-null");
    }

    static {
        CLOCK = ClockFactory.getClock();
        nanoClock = new DummyNanoClock();
        executor = Executors.newSingleThreadExecutor(new DaemonThreadFactory("AsyncLogger-"));
        AsyncLogger.initInfoForExecutorThread();
        LOGGER.debug("AsyncLogger.ThreadNameStrategy={}", new Object[]{THREAD_NAME_STRATEGY});
        int ringBufferSize = AsyncLogger.calculateRingBufferSize();
        WaitStrategy waitStrategy = AsyncLogger.createWaitStrategy();
        disruptor = new Disruptor((EventFactory)RingBufferLogEvent.FACTORY, ringBufferSize, (Executor)executor, ProducerType.MULTI, waitStrategy);
        disruptor.handleExceptionsWith(AsyncLogger.getExceptionHandler());
        disruptor.handleEventsWith(new EventHandler[]{new RingBufferLogEventHandler()});
        LOGGER.debug("Starting AsyncLogger disruptor with ringbuffer size {}...", new Object[]{disruptor.getRingBuffer().getBufferSize()});
        disruptor.start();
    }

    static class Info {
        private static final ThreadLocal<Info> threadlocalInfo = new ThreadLocal<Info>(){

            @Override
            protected Info initialValue() {
                return new Info(new RingBufferLogEventTranslator(), Thread.currentThread().getName(), false);
            }
        };
        private final RingBufferLogEventTranslator translator;
        private final String cachedThreadName;
        private final boolean isAppenderThread;

        public Info(RingBufferLogEventTranslator translator, String threadName, boolean appenderThread) {
            this.translator = translator;
            this.cachedThreadName = threadName;
            this.isAppenderThread = appenderThread;
        }

        private String threadName() {
            return THREAD_NAME_STRATEGY.getThreadName(this);
        }
    }

    static enum ThreadNameStrategy {
        CACHED{

            @Override
            public String getThreadName(Info info) {
                return info.cachedThreadName;
            }
        }
        ,
        UNCACHED{

            @Override
            public String getThreadName(Info info) {
                return Thread.currentThread().getName();
            }
        };


        abstract String getThreadName(Info var1);

        static ThreadNameStrategy create() {
            String name = PropertiesUtil.getProperties().getStringProperty("AsyncLogger.ThreadNameStrategy", CACHED.name());
            try {
                return ThreadNameStrategy.valueOf(name);
            }
            catch (Exception ex) {
                LOGGER.debug("Using AsyncLogger.ThreadNameStrategy.CACHED: '{}' not valid: {}", new Object[]{name, ex.toString()});
                return CACHED;
            }
        }
    }
}

