/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.layout;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.AbstractStringLayout;
import org.apache.logging.log4j.core.net.Severity;
import org.apache.logging.log4j.core.util.KeyValuePair;
import org.apache.logging.log4j.status.StatusLogger;

@Plugin(name="GelfLayout", category="Core", elementType="layout", printObject=true)
public final class GelfLayout
extends AbstractStringLayout {
    private static final char C = ',';
    private static final int COMPRESSION_THRESHOLD = 1024;
    private static final char Q = '\"';
    private static final String QC = "\",";
    private static final String QU = "\"_";
    private static final long serialVersionUID = 1L;
    private static final BigDecimal TIME_DIVISOR = new BigDecimal(1000);
    private final KeyValuePair[] additionalFields;
    private final int compressionThreshold;
    private final CompressionType compressionType;
    private final String host;

    @PluginFactory
    public static GelfLayout createLayout(@PluginAttribute(value="host") String host, @PluginElement(value="AdditionalField") KeyValuePair[] additionalFields, @PluginAttribute(value="compressionType", defaultString="GZIP") CompressionType compressionType, @PluginAttribute(value="compressionThreshold", defaultInt=1024) int compressionThreshold) {
        return new GelfLayout(host, additionalFields, compressionType, compressionThreshold);
    }

    static int formatLevel(Level level) {
        return Severity.getSeverity(level).getCode();
    }

    static String formatThrowable(Throwable throwable) {
        StringWriter sw = new StringWriter(2048);
        PrintWriter pw = new PrintWriter(sw);
        throwable.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    static String formatTimestamp(long timeMillis) {
        return new BigDecimal(timeMillis).divide(TIME_DIVISOR).toPlainString();
    }

    public GelfLayout(String host, KeyValuePair[] additionalFields, CompressionType compressionType, int compressionThreshold) {
        super(StandardCharsets.UTF_8);
        this.host = host;
        this.additionalFields = additionalFields;
        this.compressionType = compressionType;
        this.compressionThreshold = compressionThreshold;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] compress(byte[] bytes) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.compressionThreshold / 8);
            try (DeflaterOutputStream stream = this.compressionType.createDeflaterOutputStream(baos);){
                if (stream == null) {
                    byte[] byArray = bytes;
                    return byArray;
                }
                stream.write(bytes);
                stream.finish();
                return baos.toByteArray();
            }
        }
        catch (IOException e) {
            StatusLogger.getLogger().error((Object)e);
            return bytes;
        }
    }

    @Override
    public Map<String, String> getContentFormat() {
        return Collections.emptyMap();
    }

    @Override
    public String getContentType() {
        return "application/json; charset=" + this.getCharset();
    }

    @Override
    public byte[] toByteArray(LogEvent event) {
        byte[] bytes = this.getBytes(this.toSerializable(event));
        return bytes.length > this.compressionThreshold ? this.compress(bytes) : bytes;
    }

    @Override
    public String toSerializable(LogEvent event) {
        StringBuilder builder = new StringBuilder(256);
        JsonStringEncoder jsonEncoder = JsonStringEncoder.getInstance();
        builder.append('{');
        builder.append("\"version\":\"1.1\",");
        builder.append("\"host\":\"").append(jsonEncoder.quoteAsString(this.toNullSafeString(this.host))).append(QC);
        builder.append("\"timestamp\":").append(GelfLayout.formatTimestamp(event.getTimeMillis())).append(',');
        builder.append("\"level\":").append(GelfLayout.formatLevel(event.getLevel())).append(',');
        if (event.getThreadName() != null) {
            builder.append("\"_thread\":\"").append(jsonEncoder.quoteAsString(event.getThreadName())).append(QC);
        }
        if (event.getLoggerName() != null) {
            builder.append("\"_logger\":\"").append(jsonEncoder.quoteAsString(event.getLoggerName())).append(QC);
        }
        for (KeyValuePair additionalField : this.additionalFields) {
            builder.append(QU).append(jsonEncoder.quoteAsString(additionalField.getKey())).append("\":\"").append(jsonEncoder.quoteAsString(this.toNullSafeString(additionalField.getValue()))).append(QC);
        }
        for (Map.Entry<String, String> entry : event.getContextMap().entrySet()) {
            builder.append(QU).append(jsonEncoder.quoteAsString(entry.getKey())).append("\":\"").append(jsonEncoder.quoteAsString(this.toNullSafeString(entry.getValue()))).append(QC);
        }
        if (event.getThrown() != null) {
            builder.append("\"full_message\":\"").append(jsonEncoder.quoteAsString(GelfLayout.formatThrowable(event.getThrown()))).append(QC);
        }
        builder.append("\"short_message\":\"").append(jsonEncoder.quoteAsString(this.toNullSafeString(event.getMessage().getFormattedMessage()))).append('\"');
        builder.append('}');
        return builder.toString();
    }

    private String toNullSafeString(String s) {
        return s == null ? "" : s;
    }

    public static enum CompressionType {
        GZIP{

            @Override
            public DeflaterOutputStream createDeflaterOutputStream(OutputStream os) throws IOException {
                return new GZIPOutputStream(os);
            }
        }
        ,
        ZLIB{

            @Override
            public DeflaterOutputStream createDeflaterOutputStream(OutputStream os) throws IOException {
                return new DeflaterOutputStream(os);
            }
        }
        ,
        OFF{

            @Override
            public DeflaterOutputStream createDeflaterOutputStream(OutputStream os) throws IOException {
                return null;
            }
        };


        public abstract DeflaterOutputStream createDeflaterOutputStream(OutputStream var1) throws IOException;
    }
}

