/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.HashSet;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.plugins.enforcer.utils.ArtifactUtils;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilder;
import org.apache.maven.shared.dependency.graph.DependencyGraphBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public abstract class AbstractBanDependencies
extends AbstractNonCacheableEnforcerRule {
    private boolean searchTransitive = true;
    private transient DependencyGraphBuilder graphBuilder;

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        MavenSession session;
        MavenProject project;
        try {
            project = (MavenProject)helper.evaluate("${project}");
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleException("Unable to retrieve the MavenProject: ", (Exception)((Object)eee));
        }
        try {
            session = (MavenSession)helper.evaluate("${session}");
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleException("Unable to retrieve the reactor MavenProject: ", (Exception)((Object)eee));
        }
        try {
            this.graphBuilder = (DependencyGraphBuilder)helper.getComponent(DependencyGraphBuilder.class);
        }
        catch (ComponentLookupException e) {
            throw new EnforcerRuleException("Unable to lookup DependencyGraphBuilder: ", (Exception)((Object)e));
        }
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
        buildingRequest.setProject(project);
        Set<Artifact> dependencies = this.getDependenciesToCheck(helper, (ProjectBuildingRequest)buildingRequest);
        Set<Artifact> foundExcludes = this.checkDependencies(dependencies, helper.getLog());
        if (foundExcludes != null && !foundExcludes.isEmpty()) {
            String message = this.getMessage();
            StringBuilder buf = new StringBuilder();
            if (message != null) {
                buf.append(message + System.lineSeparator());
            }
            for (Artifact artifact : foundExcludes) {
                buf.append(this.getErrorMessage(artifact));
            }
            message = buf.toString() + "Use 'mvn dependency:tree' to locate the source of the banned dependencies.";
            throw new EnforcerRuleException(message);
        }
    }

    protected CharSequence getErrorMessage(Artifact artifact) {
        return "Found Banned Dependency: " + artifact.getId() + System.lineSeparator();
    }

    private Set<Artifact> getDependenciesToCheck(EnforcerRuleHelper helper, ProjectBuildingRequest buildingRequest) {
        String cacheKey = buildingRequest.getProject().getId() + "_" + this.searchTransitive;
        Set dependencies = (Set)helper.getCache(cacheKey, () -> this.getDependenciesToCheck(buildingRequest));
        return dependencies;
    }

    protected Set<Artifact> getDependenciesToCheck(ProjectBuildingRequest buildingRequest) {
        Set<Artifact> dependencies = null;
        try {
            DependencyNode node = this.graphBuilder.buildDependencyGraph(buildingRequest, null);
            if (this.searchTransitive) {
                dependencies = ArtifactUtils.getAllDescendants(node);
            } else if (node.getChildren() != null) {
                dependencies = new HashSet<Artifact>();
                for (DependencyNode depNode : node.getChildren()) {
                    dependencies.add(depNode.getArtifact());
                }
            }
        }
        catch (DependencyGraphBuilderException e) {
            throw new RuntimeException(e);
        }
        return dependencies;
    }

    protected abstract Set<Artifact> checkDependencies(Set<Artifact> var1, Log var2) throws EnforcerRuleException;

    public boolean isSearchTransitive() {
        return this.searchTransitive;
    }

    public void setSearchTransitive(boolean theSearchTransitive) {
        this.searchTransitive = theSearchTransitive;
    }
}

