/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.enforcer.rule.api.EnforcerRule;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.enforcer.utils.DependencyVersionMap;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.dependency.graph.DependencyCollectorBuilder;
import org.apache.maven.shared.dependency.graph.DependencyCollectorBuilderException;
import org.apache.maven.shared.dependency.graph.DependencyNode;
import org.apache.maven.shared.dependency.graph.traversal.DependencyNodeVisitor;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class DependencyConvergence
implements EnforcerRule {
    private static Log log;
    private boolean uniqueVersions;

    public void setUniqueVersions(boolean uniqueVersions) {
        this.uniqueVersions = uniqueVersions;
    }

    private DependencyNode getNode(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            MavenProject project = (MavenProject)helper.evaluate("${project}");
            MavenSession session = (MavenSession)helper.evaluate("${session}");
            DependencyCollectorBuilder dependencyCollectorBuilder = (DependencyCollectorBuilder)helper.getComponent(DependencyCollectorBuilder.class);
            ArtifactRepository repository = (ArtifactRepository)helper.evaluate("${localRepository}");
            DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(session.getProjectBuildingRequest());
            buildingRequest.setProject(project);
            buildingRequest.setLocalRepository(repository);
            ArtifactFilter filter = a -> ("compile".equalsIgnoreCase(a.getScope()) || "runtime".equalsIgnoreCase(a.getScope())) && !a.isOptional();
            return dependencyCollectorBuilder.collectDependencyGraph((ProjectBuildingRequest)buildingRequest, filter);
        }
        catch (ExpressionEvaluationException | ComponentLookupException e) {
            throw new EnforcerRuleException("Unable to lookup a component " + e.getLocalizedMessage(), (Exception)e);
        }
        catch (DependencyCollectorBuilderException e) {
            throw new EnforcerRuleException("Could not build dependency tree " + e.getLocalizedMessage(), (Exception)((Object)e));
        }
    }

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        if (log == null) {
            log = helper.getLog();
        }
        try {
            DependencyNode node = this.getNode(helper);
            DependencyVersionMap visitor = new DependencyVersionMap(log);
            visitor.setUniqueVersions(this.uniqueVersions);
            node.accept((DependencyNodeVisitor)visitor);
            ArrayList<String> errorMsgs = new ArrayList<String>();
            errorMsgs.addAll(this.getConvergenceErrorMsgs(visitor.getConflictedVersionNumbers()));
            for (CharSequence charSequence : errorMsgs) {
                log.warn(charSequence);
            }
            if (errorMsgs.size() > 0) {
                throw new EnforcerRuleException("Failed while enforcing releasability. See above detailed error message.");
            }
        }
        catch (Exception e) {
            throw new EnforcerRuleException(e.getLocalizedMessage(), e);
        }
    }

    private StringBuilder buildTreeString(DependencyNode node) {
        ArrayList<String> loc = new ArrayList<String>();
        for (DependencyNode currentNode = node; currentNode != null; currentNode = currentNode.getParent()) {
            loc.add(currentNode.getArtifact().toString());
        }
        Collections.reverse(loc);
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < loc.size(); ++i) {
            for (int j = 0; j < i; ++j) {
                builder.append("  ");
            }
            builder.append("+-" + (String)loc.get(i));
            builder.append(System.lineSeparator());
        }
        return builder;
    }

    private List<String> getConvergenceErrorMsgs(List<List<DependencyNode>> errors) {
        ArrayList<String> errorMsgs = new ArrayList<String>();
        for (List<DependencyNode> nodeList : errors) {
            errorMsgs.add(this.buildConvergenceErrorMsg(nodeList));
        }
        return errorMsgs;
    }

    private String buildConvergenceErrorMsg(List<DependencyNode> nodeList) {
        StringBuilder builder = new StringBuilder();
        builder.append(System.lineSeparator() + "Dependency convergence error for " + nodeList.get(0).getArtifact().toString() + " paths to dependency are:" + System.lineSeparator());
        if (nodeList.size() > 0) {
            builder.append((CharSequence)this.buildTreeString(nodeList.get(0)));
        }
        for (DependencyNode node : nodeList.subList(1, nodeList.size())) {
            builder.append("and" + System.lineSeparator());
            builder.append((CharSequence)this.buildTreeString(node));
        }
        return builder.toString();
    }

    public String getCacheId() {
        return "";
    }

    public boolean isCacheable() {
        return false;
    }

    public boolean isResultValid(EnforcerRule rule) {
        return false;
    }
}

