/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class RequireReleaseVersion
extends AbstractNonCacheableEnforcerRule {
    private boolean failWhenParentIsSnapshot = true;

    public void execute(EnforcerRuleHelper theHelper) throws EnforcerRuleException {
        Artifact parentArtifact;
        MavenProject project = this.getProject(theHelper);
        if (project.getArtifact().isSnapshot()) {
            String message = this.getMessage();
            StringBuilder buf = new StringBuilder();
            if (message != null) {
                buf.append(message).append(System.lineSeparator());
            }
            buf.append("This project cannot be a snapshot:").append(project.getArtifact().getId());
            throw new EnforcerRuleException(buf.toString());
        }
        if (this.failWhenParentIsSnapshot && (parentArtifact = project.getParentArtifact()) != null && parentArtifact.isSnapshot()) {
            throw new EnforcerRuleException("Parent Cannot be a snapshot: " + parentArtifact.getId());
        }
    }

    private MavenProject getProject(EnforcerRuleHelper helper) throws EnforcerRuleException {
        try {
            return (MavenProject)helper.evaluate("${project}");
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleException("Unable to retrieve the MavenProject: ", (Exception)((Object)eee));
        }
    }

    public final boolean isFailWhenParentIsSnapshot() {
        return this.failWhenParentIsSnapshot;
    }

    public final void setFailWhenParentIsSnapshot(boolean failWhenParentIsSnapshot) {
        this.failWhenParentIsSnapshot = failWhenParentIsSnapshot;
    }
}

