/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.enforcer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rule.api.EnforcerRuleException;
import org.apache.maven.enforcer.rule.api.EnforcerRuleHelper;
import org.apache.maven.plugins.enforcer.AbstractNonCacheableEnforcerRule;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;

public class RequireSameVersions
extends AbstractNonCacheableEnforcerRule {
    private boolean uniqueVersions;
    private Set<String> dependencies = new HashSet<String>();
    private Set<String> plugins = new HashSet<String>();
    private Set<String> buildPlugins = new HashSet<String>();
    private Set<String> reportPlugins = new HashSet<String>();

    public void execute(EnforcerRuleHelper helper) throws EnforcerRuleException {
        MavenProject project;
        try {
            project = (MavenProject)helper.evaluate("${project}");
        }
        catch (ExpressionEvaluationException eee) {
            throw new EnforcerRuleException("Unable to retrieve the MavenProject: ", (Exception)((Object)eee));
        }
        LinkedHashMap<String, List<String>> versionMembers = new LinkedHashMap<String, List<String>>();
        HashSet<String> buildPluginSet = new HashSet<String>(this.buildPlugins);
        buildPluginSet.addAll(this.plugins);
        HashSet<String> reportPluginSet = new HashSet<String>(this.reportPlugins);
        reportPluginSet.addAll(this.plugins);
        versionMembers.putAll(this.collectVersionMembers(project.getArtifacts(), this.dependencies, " (dependency)"));
        versionMembers.putAll(this.collectVersionMembers(project.getPluginArtifacts(), this.buildPlugins, " (buildPlugin)"));
        versionMembers.putAll(this.collectVersionMembers(project.getReportArtifacts(), this.reportPlugins, " (reportPlugin)"));
        if (versionMembers.size() > 1) {
            StringBuilder builder = new StringBuilder("Found entries with different versions" + System.lineSeparator());
            for (Map.Entry entry : versionMembers.entrySet()) {
                builder.append("Entries with version ").append((String)entry.getKey()).append(System.lineSeparator());
                for (String conflictId : (List)entry.getValue()) {
                    builder.append("- ").append(conflictId).append(System.lineSeparator());
                }
            }
            throw new EnforcerRuleException(builder.toString());
        }
    }

    private Map<String, List<String>> collectVersionMembers(Set<Artifact> artifacts, Collection<String> patterns, String source) {
        LinkedHashMap<String, List<String>> versionMembers = new LinkedHashMap<String, List<String>>();
        ArrayList<Pattern> regExs = new ArrayList<Pattern>();
        for (String pattern : patterns) {
            String regex = pattern.replace(".", "\\.").replace("*", ".*").replace(":", "\\:").replace('?', '.');
            regExs.add(Pattern.compile(regex + "(\\:.+)?"));
        }
        for (Artifact artifact : artifacts) {
            for (Pattern regEx : regExs) {
                String version;
                if (!regEx.matcher(artifact.getDependencyConflictId()).matches()) continue;
                String string = version = this.uniqueVersions ? artifact.getVersion() : artifact.getBaseVersion();
                if (!versionMembers.containsKey(version)) {
                    versionMembers.put(version, new ArrayList());
                }
                ((List)versionMembers.get(version)).add(artifact.getDependencyConflictId() + source);
            }
        }
        return versionMembers;
    }
}

