/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;

public class AbstractArtifactResolutionException
extends Exception {
    private String groupId;
    private String artifactId;
    private String version;
    private String type;
    private List remoteRepositories;
    private final String originalMessage;
    private final String path;
    static final String LS = System.getProperty("line.separator");

    protected AbstractArtifactResolutionException(String message, String groupId, String artifactId, String version, String type, List remoteRepositories, List path) {
        super(AbstractArtifactResolutionException.constructMessageBase(message, groupId, artifactId, version, type, remoteRepositories, path));
        this.originalMessage = message;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.type = type;
        this.version = version;
        this.remoteRepositories = remoteRepositories;
        this.path = AbstractArtifactResolutionException.constructArtifactPath(path);
    }

    protected AbstractArtifactResolutionException(String message, String groupId, String artifactId, String version, String type, List remoteRepositories, List path, Throwable t) {
        super(AbstractArtifactResolutionException.constructMessageBase(message, groupId, artifactId, version, type, remoteRepositories, path), t);
        this.originalMessage = message;
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.type = type;
        this.version = version;
        this.remoteRepositories = remoteRepositories;
        this.path = AbstractArtifactResolutionException.constructArtifactPath(path);
    }

    protected AbstractArtifactResolutionException(String message, Artifact artifact) {
        this(message, artifact, null);
    }

    protected AbstractArtifactResolutionException(String message, Artifact artifact, List remoteRepositories) {
        this(message, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), remoteRepositories, artifact.getDependencyTrail());
    }

    protected AbstractArtifactResolutionException(String message, Artifact artifact, List remoteRepositories, Throwable t) {
        this(message, artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getType(), remoteRepositories, artifact.getDependencyTrail(), t);
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public List getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public String getOriginalMessage() {
        return this.originalMessage;
    }

    protected static String constructArtifactPath(List path) {
        StringBuffer sb = new StringBuffer();
        if (path != null) {
            sb.append(LS);
            sb.append("Path to dependency: ");
            sb.append(LS);
            int num = 1;
            Iterator i = path.iterator();
            while (i.hasNext()) {
                sb.append("\t");
                sb.append(num);
                sb.append(") ");
                sb.append(i.next());
                sb.append(LS);
                ++num;
            }
        }
        return sb.toString();
    }

    private static String constructMessageBase(String message, String groupId, String artifactId, String version, String type, List remoteRepositories, List path) {
        StringBuffer sb = new StringBuffer();
        sb.append(message);
        sb.append(LS);
        sb.append("  " + groupId + ":" + artifactId + ":" + version + ":" + type);
        sb.append(LS);
        if (remoteRepositories != null && !remoteRepositories.isEmpty()) {
            sb.append(LS);
            sb.append("from the specified remote repositories:");
            sb.append(LS + "  ");
            Iterator i = new HashSet(remoteRepositories).iterator();
            while (i.hasNext()) {
                ArtifactRepository remoteRepository = (ArtifactRepository)i.next();
                sb.append(remoteRepository.getId());
                sb.append(" (");
                sb.append(remoteRepository.getUrl());
                sb.append(")");
                if (!i.hasNext()) continue;
                sb.append(",\n  ");
            }
        }
        sb.append(AbstractArtifactResolutionException.constructArtifactPath(path));
        sb.append(LS);
        return sb.toString();
    }

    public String getArtifactPath() {
        return this.path;
    }
}

