/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.ui.generation;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.common.ArchetypeArtifactManager;
import org.apache.maven.archetype.exception.ArchetypeGenerationConfigurationFailure;
import org.apache.maven.archetype.exception.ArchetypeNotConfigured;
import org.apache.maven.archetype.exception.ArchetypeNotDefined;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.old.OldArchetype;
import org.apache.maven.archetype.old.descriptor.ArchetypeDescriptor;
import org.apache.maven.archetype.ui.ArchetypeConfiguration;
import org.apache.maven.archetype.ui.ArchetypeDefinition;
import org.apache.maven.archetype.ui.ArchetypeFactory;
import org.apache.maven.archetype.ui.generation.ArchetypeGenerationConfigurator;
import org.apache.maven.archetype.ui.generation.ArchetypeGenerationQueryer;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryPolicy;
import org.apache.maven.artifact.repository.MavenArtifactRepository;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.context.Context;
import org.apache.velocity.context.InternalContextAdapter;
import org.apache.velocity.context.InternalContextAdapterImpl;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.RuntimeSingleton;
import org.apache.velocity.runtime.parser.ParseException;
import org.apache.velocity.runtime.parser.node.ASTReference;
import org.apache.velocity.runtime.parser.node.ParserVisitor;
import org.apache.velocity.runtime.parser.node.SimpleNode;
import org.apache.velocity.runtime.visitor.BaseVisitor;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;

@Component(role=ArchetypeGenerationConfigurator.class, hint="default")
public class DefaultArchetypeGenerationConfigurator
extends AbstractLogEnabled
implements ArchetypeGenerationConfigurator {
    @Requirement
    OldArchetype oldArchetype;
    @Requirement
    private ArchetypeArtifactManager archetypeArtifactManager;
    @Requirement
    private ArchetypeFactory archetypeFactory;
    @Requirement
    private ArchetypeGenerationQueryer archetypeGenerationQueryer;
    @Requirement
    private ArtifactRepositoryLayout defaultArtifactRepositoryLayout;

    public void setArchetypeArtifactManager(ArchetypeArtifactManager archetypeArtifactManager) {
        this.archetypeArtifactManager = archetypeArtifactManager;
    }

    @Override
    public void configureArchetype(ArchetypeGenerationRequest request, Boolean interactiveMode, Properties executionProperties) throws ArchetypeNotDefined, UnknownArchetype, ArchetypeNotConfigured, IOException, PrompterException, ArchetypeGenerationConfigurationFailure {
        ArchetypeConfiguration archetypeConfiguration;
        org.apache.maven.archetype.metadata.ArchetypeDescriptor archetypeDescriptor;
        ArtifactRepository localRepository = request.getLocalRepository();
        ArtifactRepository archetypeRepository = null;
        ArrayList<ArtifactRepository> repositories = new ArrayList<ArtifactRepository>();
        Properties properties = new Properties(executionProperties);
        ArchetypeDefinition ad = new ArchetypeDefinition(request);
        if (!ad.isDefined()) {
            if (!interactiveMode.booleanValue()) {
                throw new ArchetypeNotDefined("No archetype was chosen");
            }
            throw new ArchetypeNotDefined("The archetype is not defined");
        }
        if (request.getArchetypeRepository() != null) {
            archetypeRepository = this.createRepository(request.getArchetypeRepository(), ad.getArtifactId() + "-repo");
            repositories.add(archetypeRepository);
        }
        if (request.getRemoteArtifactRepositories() != null) {
            repositories.addAll(request.getRemoteArtifactRepositories());
        }
        if (!this.archetypeArtifactManager.exists(ad.getGroupId(), ad.getArtifactId(), ad.getVersion(), archetypeRepository, localRepository, repositories, request.getProjectBuildingRequest())) {
            throw new UnknownArchetype("The desired archetype does not exist (" + ad.getGroupId() + ":" + ad.getArtifactId() + ":" + ad.getVersion() + ")");
        }
        request.setArchetypeVersion(ad.getVersion());
        if (this.archetypeArtifactManager.isFileSetArchetype(ad.getGroupId(), ad.getArtifactId(), ad.getVersion(), archetypeRepository, localRepository, repositories, request.getProjectBuildingRequest())) {
            archetypeDescriptor = this.archetypeArtifactManager.getFileSetArchetypeDescriptor(ad.getGroupId(), ad.getArtifactId(), ad.getVersion(), archetypeRepository, localRepository, repositories, request.getProjectBuildingRequest());
            archetypeConfiguration = this.archetypeFactory.createArchetypeConfiguration(archetypeDescriptor, properties);
        } else if (this.archetypeArtifactManager.isOldArchetype(ad.getGroupId(), ad.getArtifactId(), ad.getVersion(), archetypeRepository, localRepository, repositories, request.getProjectBuildingRequest())) {
            archetypeDescriptor = this.archetypeArtifactManager.getOldArchetypeDescriptor(ad.getGroupId(), ad.getArtifactId(), ad.getVersion(), archetypeRepository, localRepository, repositories, request.getProjectBuildingRequest());
            archetypeConfiguration = this.archetypeFactory.createArchetypeConfiguration((ArchetypeDescriptor)archetypeDescriptor, properties);
        } else {
            throw new ArchetypeGenerationConfigurationFailure("The defined artifact is not an archetype");
        }
        List<String> propertiesRequired = archetypeConfiguration.getRequiredProperties();
        Collections.sort(propertiesRequired, new RequiredPropertyComparator(archetypeConfiguration));
        VelocityContext context = new VelocityContext();
        if (interactiveMode.booleanValue()) {
            boolean confirmed = false;
            context.put("groupId", (Object)ad.getGroupId());
            context.put("artifactId", (Object)ad.getArtifactId());
            context.put("version", (Object)ad.getVersion());
            while (!confirmed) {
                if (archetypeConfiguration.isConfigured()) {
                    for (String requiredProperty : propertiesRequired) {
                        this.getLogger().info("Using property: " + requiredProperty + " = " + archetypeConfiguration.getProperty(requiredProperty));
                    }
                } else {
                    for (String requiredProperty : propertiesRequired) {
                        String value;
                        if (archetypeConfiguration.isConfigured(requiredProperty) && !request.isAskForDefaultPropertyValues()) {
                            this.getLogger().info("Using property: " + requiredProperty + " = " + archetypeConfiguration.getProperty(requiredProperty));
                            value = archetypeConfiguration.getProperty(requiredProperty);
                        } else {
                            String defaultValue = archetypeConfiguration.getDefaultValue(requiredProperty);
                            if ("package".equals(requiredProperty) && StringUtils.isEmpty((String)defaultValue)) {
                                defaultValue = archetypeConfiguration.getProperty("groupId");
                            }
                            value = this.archetypeGenerationQueryer.getPropertyValue(requiredProperty, DefaultArchetypeGenerationConfigurator.expandEmbeddedTemplateExpressions(defaultValue, requiredProperty, (Context)context), archetypeConfiguration.getPropertyValidationRegex(requiredProperty));
                        }
                        archetypeConfiguration.setProperty(requiredProperty, value);
                        context.put(requiredProperty, (Object)value);
                    }
                }
                if (!archetypeConfiguration.isConfigured()) {
                    this.getLogger().warn("Archetype is not fully configured");
                    continue;
                }
                if (!this.archetypeGenerationQueryer.confirmConfiguration(archetypeConfiguration)) {
                    this.getLogger().debug("Archetype generation configuration not confirmed");
                    archetypeConfiguration.reset();
                    this.restoreCommandLineProperties(archetypeConfiguration, executionProperties);
                    continue;
                }
                this.getLogger().debug("Archetype generation configuration confirmed");
                confirmed = true;
            }
        } else if (!archetypeConfiguration.isConfigured()) {
            for (String requiredProperty : propertiesRequired) {
                if (archetypeConfiguration.isConfigured(requiredProperty)) {
                    context.put(requiredProperty, (Object)archetypeConfiguration.getProperty(requiredProperty));
                    continue;
                }
                String defaultValue = archetypeConfiguration.getDefaultValue(requiredProperty);
                if (defaultValue == null) continue;
                String value = DefaultArchetypeGenerationConfigurator.expandEmbeddedTemplateExpressions(defaultValue, requiredProperty, (Context)context);
                archetypeConfiguration.setProperty(requiredProperty, value);
                context.put(requiredProperty, (Object)value);
            }
            if (!archetypeConfiguration.isConfigured()) {
                StringBuilder exceptionMessage = new StringBuilder();
                exceptionMessage.append("Archetype ");
                exceptionMessage.append(request.getArchetypeGroupId());
                exceptionMessage.append(":");
                exceptionMessage.append(request.getArchetypeArtifactId());
                exceptionMessage.append(":");
                exceptionMessage.append(request.getArchetypeVersion());
                exceptionMessage.append(" is not configured");
                ArrayList<String> missingProperties = new ArrayList<String>(0);
                for (String requiredProperty : archetypeConfiguration.getRequiredProperties()) {
                    if (archetypeConfiguration.isConfigured(requiredProperty)) continue;
                    exceptionMessage.append("\n\tProperty ");
                    exceptionMessage.append(requiredProperty);
                    missingProperties.add(requiredProperty);
                    exceptionMessage.append(" is missing.");
                    this.getLogger().warn("Property " + requiredProperty + " is missing. Add -D" + requiredProperty + "=someValue");
                }
                throw new ArchetypeNotConfigured(exceptionMessage.toString(), missingProperties);
            }
        }
        request.setGroupId(archetypeConfiguration.getProperty("groupId"));
        request.setArtifactId(archetypeConfiguration.getProperty("artifactId"));
        request.setVersion(archetypeConfiguration.getProperty("version"));
        request.setPackage(archetypeConfiguration.getProperty("package"));
        properties = archetypeConfiguration.getProperties();
        request.setProperties(properties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String expandEmbeddedTemplateExpressions(String originalText, String textDescription, Context context) {
        if (!StringUtils.contains((String)originalText, (String)"${")) return originalText;
        try (StringWriter target = new StringWriter();){
            Velocity.evaluate((Context)context, (Writer)target, (String)textDescription, (String)originalText);
            String string = target.toString();
            return string;
        }
        catch (IOException ex) {
            throw new RuntimeException("Exception closing StringWriter", ex);
        }
    }

    private void restoreCommandLineProperties(ArchetypeConfiguration archetypeConfiguration, Properties executionProperties) {
        this.getLogger().debug("Restoring command line properties");
        for (String property : archetypeConfiguration.getRequiredProperties()) {
            if (!executionProperties.containsKey(property)) continue;
            archetypeConfiguration.setProperty(property, executionProperties.getProperty(property));
            this.getLogger().debug("Restored " + property + "=" + archetypeConfiguration.getProperty(property));
        }
    }

    void setArchetypeGenerationQueryer(ArchetypeGenerationQueryer archetypeGenerationQueryer) {
        this.archetypeGenerationQueryer = archetypeGenerationQueryer;
    }

    private ArtifactRepository createRepository(String url, String repositoryId) {
        String updatePolicyFlag = "always";
        String checksumPolicyFlag = "warn";
        ArtifactRepositoryPolicy snapshotsPolicy = new ArtifactRepositoryPolicy(true, updatePolicyFlag, checksumPolicyFlag);
        ArtifactRepositoryPolicy releasesPolicy = new ArtifactRepositoryPolicy(true, updatePolicyFlag, checksumPolicyFlag);
        return new MavenArtifactRepository(repositoryId, url, this.defaultArtifactRepositoryLayout, snapshotsPolicy, releasesPolicy);
    }

    public static class RequiredPropertyComparator
    implements Comparator<String> {
        private final ArchetypeConfiguration archetypeConfiguration;
        private Map<String, Set<String>> propertyReferenceMap;

        public RequiredPropertyComparator(ArchetypeConfiguration archetypeConfiguration) {
            this.archetypeConfiguration = archetypeConfiguration;
            this.propertyReferenceMap = this.computePropertyReferences();
        }

        @Override
        public int compare(String left, String right) {
            if (this.references(right, left)) {
                return 1;
            }
            if (this.references(left, right)) {
                return -1;
            }
            return Integer.compare(this.propertyReferenceMap.get(left).size(), this.propertyReferenceMap.get(right).size());
        }

        private Map<String, Set<String>> computePropertyReferences() {
            HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
            List<String> requiredProperties = this.archetypeConfiguration.getRequiredProperties();
            InternalContextAdapterImpl velocityContextAdapter = new InternalContextAdapterImpl((Context)new VelocityContext());
            RuntimeServices velocityRuntime = RuntimeSingleton.getRuntimeServices();
            for (String propertyName : requiredProperties) {
                final LinkedHashSet referencedPropertyNames = new LinkedHashSet();
                String defaultValue = this.archetypeConfiguration.getDefaultValue(propertyName);
                if (StringUtils.contains((String)defaultValue, (String)"${")) {
                    try {
                        boolean dumpNamespace = false;
                        SimpleNode node = RuntimeSingleton.parse((Reader)new StringReader(defaultValue), (String)(propertyName + ".default"), (boolean)false);
                        node.init((InternalContextAdapter)velocityContextAdapter, (Object)velocityRuntime);
                        node.jjtAccept((ParserVisitor)new BaseVisitor(){

                            public Object visit(ASTReference node, Object data) {
                                referencedPropertyNames.add(node.getRootString());
                                return super.visit(node, data);
                            }
                        }, (Object)velocityRuntime);
                    }
                    catch (ParseException e) {
                        throw new IllegalStateException("Unparsable default value for property " + propertyName, e);
                    }
                }
                referencedPropertyNames.retainAll(this.archetypeConfiguration.getRequiredProperties());
                referencedPropertyNames.remove(propertyName);
                result.put(propertyName, referencedPropertyNames);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean references(String targetProperty, String sourceProperty) {
            if (targetProperty.equals(sourceProperty)) {
                return false;
            }
            RequiredPropertyComparator requiredPropertyComparator = this;
            synchronized (requiredPropertyComparator) {
                if (!this.propertyReferenceMap.containsKey(sourceProperty)) {
                    this.propertyReferenceMap = this.computePropertyReferences();
                }
            }
            Set<String> referencedProperties = this.propertyReferenceMap.get(sourceProperty);
            if (referencedProperties.contains(targetProperty)) {
                return true;
            }
            for (String referencedProperty : referencedProperties) {
                if (!this.references(targetProperty, referencedProperty)) continue;
                return true;
            }
            return false;
        }
    }
}

