/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.ui.generation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.ui.ArchetypeDefinition;
import org.apache.maven.archetype.ui.generation.ArchetypeSelectionQueryer;
import org.apache.maven.archetype.ui.generation.ArchetypeSelectorUtils;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.components.interactivity.Prompter;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=ArchetypeSelectionQueryer.class, hint="default")
public class DefaultArchetypeSelectionQueryer
extends AbstractLogEnabled
implements ArchetypeSelectionQueryer {
    @Requirement(hint="archetype")
    private Prompter prompter;

    @Override
    public boolean confirmSelection(ArchetypeDefinition archetypeDefinition) throws PrompterException {
        String query = "Confirm archetype selection: \n" + archetypeDefinition.getGroupId() + "/" + archetypeDefinition.getName() + "\n";
        String answer = this.prompter.prompt(query, Arrays.asList("Y", "N"), "Y");
        return "Y".equalsIgnoreCase(answer);
    }

    @Override
    public Archetype selectArchetype(Map<String, List<Archetype>> catalogs) throws PrompterException {
        return this.selectArchetype(catalogs, null);
    }

    @Override
    public Archetype selectArchetype(Map<String, List<Archetype>> catalogs, ArchetypeDefinition defaultDefinition) throws PrompterException {
        Archetype selection = null;
        Map<String, List<Archetype>> filteredCatalogs = catalogs;
        do {
            StringBuilder query = new StringBuilder("Choose archetype:\n");
            HashSet<String> archetypeKeys = new HashSet<String>();
            ArrayList<String> answers = new ArrayList<String>();
            HashMap<String, Archetype> archetypeAnswerMap = new HashMap<String, Archetype>();
            int counter = 0;
            int defaultSelection = 0;
            for (Map.Entry<String, List<Archetype>> entry : filteredCatalogs.entrySet()) {
                String catalog = entry.getKey();
                for (Archetype archetype : entry.getValue()) {
                    String archetypeKey = archetype.getGroupId() + ":" + archetype.getArtifactId();
                    if (!archetypeKeys.add(archetypeKey)) continue;
                    ++counter;
                    String description = archetype.getDescription();
                    if (description == null) {
                        description = "-";
                    }
                    String answer = String.valueOf(counter);
                    query.append(answer + ": " + catalog + " -> " + archetype.getGroupId() + ":" + archetype.getArtifactId() + " (" + description + ")\n");
                    answers.add(answer);
                    archetypeAnswerMap.put(answer, archetype);
                    if (defaultDefinition == null || !archetype.getGroupId().equals(defaultDefinition.getGroupId()) || !archetype.getArtifactId().equals(defaultDefinition.getArtifactId())) continue;
                    defaultSelection = counter;
                }
            }
            if (counter == 0) {
                query.append("   Your filter doesn't match any archetype (hint: enter to return to initial list)\n");
            }
            query.append("Choose a number or apply filter (format: [groupId:]artifactId, case sensitive contains): ");
            String answer = defaultSelection == 0 ? this.prompter.prompt(query.toString()) : this.prompter.prompt(query.toString(), Integer.toString(defaultSelection));
            if (NumberUtils.isNumber((String)answer)) {
                selection = (Archetype)archetypeAnswerMap.get(answer);
                continue;
            }
            filteredCatalogs = ArchetypeSelectorUtils.getFilteredArchetypesByCatalog(catalogs, answer);
        } while (selection == null);
        return this.selectVersion(catalogs, selection.getGroupId(), selection.getArtifactId());
    }

    private Archetype selectVersion(Map<String, List<Archetype>> catalogs, String groupId, String artifactId) throws PrompterException {
        String answer;
        TreeMap<DefaultArtifactVersion, Archetype> archetypeVersionsMap = new TreeMap<DefaultArtifactVersion, Archetype>();
        for (Map.Entry<String, List<Archetype>> entry : catalogs.entrySet()) {
            for (Archetype archetype : entry.getValue()) {
                DefaultArtifactVersion version;
                if (!groupId.equals(archetype.getGroupId()) || !artifactId.equals(archetype.getArtifactId()) || archetypeVersionsMap.containsKey(version = new DefaultArtifactVersion(archetype.getVersion()))) continue;
                archetypeVersionsMap.put(version, archetype);
            }
        }
        if (archetypeVersionsMap.size() == 1) {
            return (Archetype)archetypeVersionsMap.values().iterator().next();
        }
        StringBuilder query = new StringBuilder("Choose " + groupId + ":" + artifactId + " version: \n");
        ArrayList<String> answers = new ArrayList<String>();
        HashMap<String, Archetype> answerMap = new HashMap<String, Archetype>();
        int counter = 1;
        String mapKey = null;
        for (Map.Entry entry : archetypeVersionsMap.entrySet()) {
            ArtifactVersion version = (ArtifactVersion)entry.getKey();
            Archetype archetype = (Archetype)entry.getValue();
            mapKey = String.valueOf(counter);
            query.append(mapKey + ": " + version + "\n");
            answers.add(mapKey);
            answerMap.put(mapKey, archetype);
            ++counter;
        }
        query.append("Choose a number: ");
        Archetype archetype = null;
        while ((archetype = (Archetype)answerMap.get(answer = this.prompter.prompt(query.toString(), answers, mapKey))) == null) {
        }
        return archetype;
    }

    public void setPrompter(Prompter prompter) {
        this.prompter = prompter;
    }
}

