/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.archetype.ui.generation;

import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.ArchetypeManager;
import org.apache.maven.archetype.catalog.Archetype;
import org.apache.maven.archetype.exception.ArchetypeNotDefined;
import org.apache.maven.archetype.exception.ArchetypeSelectionFailure;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.archetype.exception.UnknownGroup;
import org.apache.maven.archetype.ui.ArchetypeDefinition;
import org.apache.maven.archetype.ui.generation.ArchetypeSelectionQueryer;
import org.apache.maven.archetype.ui.generation.ArchetypeSelector;
import org.apache.maven.archetype.ui.generation.ArchetypeSelectorUtils;
import org.apache.maven.project.ProjectBuildingRequest;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.components.interactivity.PrompterException;
import org.codehaus.plexus.logging.AbstractLogEnabled;

@Component(role=ArchetypeSelector.class, hint="default")
public class DefaultArchetypeSelector
extends AbstractLogEnabled
implements ArchetypeSelector {
    static final String DEFAULT_ARCHETYPE_GROUPID = "org.apache.maven.archetypes";
    static final String DEFAULT_ARCHETYPE_VERSION = "1.0";
    static final String DEFAULT_ARCHETYPE_ARTIFACTID = "maven-archetype-quickstart";
    @Requirement
    private ArchetypeSelectionQueryer archetypeSelectionQueryer;
    @Requirement
    private ArchetypeManager archetypeManager;

    @Override
    public void selectArchetype(ArchetypeGenerationRequest request, Boolean interactiveMode, String catalogs) throws ArchetypeNotDefined, UnknownArchetype, UnknownGroup, IOException, PrompterException, ArchetypeSelectionFailure {
        Map.Entry<String, Archetype> found;
        ArchetypeDefinition definition = new ArchetypeDefinition(request);
        if (definition.isDefined() && StringUtils.isNotEmpty((CharSequence)request.getArchetypeRepository())) {
            this.getLogger().info("Archetype defined by properties");
            return;
        }
        Map<String, List<Archetype>> archetypes = this.getArchetypesByCatalog(request.getProjectBuildingRequest(), catalogs);
        if (StringUtils.isNotBlank((CharSequence)request.getFilter()) && (archetypes = ArchetypeSelectorUtils.getFilteredArchetypesByCatalog(archetypes, request.getFilter())).isEmpty()) {
            this.getLogger().info("Your filter doesn't match any archetype, so try again with another value.");
            return;
        }
        if (definition.isDefined()) {
            found = this.findArchetype(archetypes, request.getArchetypeGroupId(), request.getArchetypeArtifactId());
            if (found != null) {
                String catalogKey = found.getKey();
                Archetype archetype = found.getValue();
                this.updateRepository(definition, archetype);
                this.getLogger().info("Archetype repository not defined. Using the one from " + archetype + " found in catalog " + catalogKey);
            } else {
                this.getLogger().warn("Archetype not found in any catalog. Falling back to central repository.");
                this.getLogger().warn("Add a repository with id 'archetype' in your settings.xml if archetype's repository is elsewhere.");
            }
        } else if (definition.isPartiallyDefined()) {
            found = this.findArchetype(archetypes, request.getArchetypeGroupId(), request.getArchetypeArtifactId());
            if (found != null) {
                String catalogKey = found.getKey();
                Archetype archetype = found.getValue();
                this.updateDefinition(definition, archetype);
                this.getLogger().info("Archetype " + archetype + " found in catalog " + catalogKey);
            } else {
                this.getLogger().warn("Specified archetype not found.");
                if (interactiveMode.booleanValue()) {
                    definition.setVersion(null);
                    definition.setGroupId(null);
                    definition.setArtifactId(null);
                }
            }
        }
        if (definition.getGroupId() == null) {
            definition.setGroupId(DEFAULT_ARCHETYPE_GROUPID);
        }
        if (definition.getVersion() == null) {
            definition.setVersion(DEFAULT_ARCHETYPE_VERSION);
        }
        if (!definition.isPartiallyDefined()) {
            if (definition.getArtifactId() == null) {
                this.getLogger().info("No archetype defined. Using maven-archetype-quickstart (" + definition.getGroupId() + ":" + DEFAULT_ARCHETYPE_ARTIFACTID + ":" + definition.getVersion() + ")");
                definition.setArtifactId(DEFAULT_ARCHETYPE_ARTIFACTID);
            }
            if (interactiveMode.booleanValue() && archetypes.size() > 0) {
                Archetype selectedArchetype = this.archetypeSelectionQueryer.selectArchetype(archetypes, definition);
                this.updateDefinition(definition, selectedArchetype);
            }
            if (!definition.isPartiallyDefined()) {
                throw new ArchetypeSelectionFailure("No valid archetypes could be found to choose.");
            }
        }
        definition.updateRequest(request);
    }

    private Map<String, List<Archetype>> getArchetypesByCatalog(ProjectBuildingRequest buildingRequest, String catalogs) {
        if (catalogs == null) {
            throw new NullPointerException("Catalogs cannot be null");
        }
        LinkedHashMap<String, List<Archetype>> archetypes = new LinkedHashMap<String, List<Archetype>>();
        for (String catalog : StringUtils.split((String)catalogs, (String)",")) {
            if ("internal".equalsIgnoreCase(catalog)) {
                archetypes.put("internal", this.archetypeManager.getInternalCatalog().getArchetypes());
                continue;
            }
            if ("local".equalsIgnoreCase(catalog)) {
                archetypes.put("local", this.archetypeManager.getLocalCatalog(buildingRequest).getArchetypes());
                continue;
            }
            if ("remote".equalsIgnoreCase(catalog)) {
                List archetypesFromRemote = this.archetypeManager.getRemoteCatalog(buildingRequest).getArchetypes();
                if (archetypesFromRemote.size() > 0) {
                    archetypes.put("remote", archetypesFromRemote);
                    continue;
                }
                this.getLogger().warn("No archetype found in remote catalog. Defaulting to internal catalog");
                archetypes.put("internal", this.archetypeManager.getInternalCatalog().getArchetypes());
                continue;
            }
            throw new IllegalArgumentException("archetypeCatalog '" + catalog + "' is not supported anymore. Please read the plugin documentation for details.");
        }
        if (archetypes.size() == 0) {
            this.getLogger().info("No catalog defined. Using internal catalog");
            archetypes.put("internal", this.archetypeManager.getInternalCatalog().getArchetypes());
        }
        return archetypes;
    }

    private void updateRepository(ArchetypeDefinition definition, Archetype archetype) {
        String repository = archetype.getRepository();
        if (StringUtils.isNotEmpty((CharSequence)repository)) {
            definition.setRepository(repository);
        }
    }

    private void updateDefinition(ArchetypeDefinition definition, Archetype archetype) {
        definition.setGroupId(archetype.getGroupId());
        definition.setArtifactId(archetype.getArtifactId());
        definition.setVersion(archetype.getVersion());
        definition.setName(archetype.getArtifactId());
        this.updateRepository(definition, archetype);
        definition.setGoals(StringUtils.join(archetype.getGoals().iterator(), (String)","));
    }

    public void setArchetypeSelectionQueryer(ArchetypeSelectionQueryer archetypeSelectionQueryer) {
        this.archetypeSelectionQueryer = archetypeSelectionQueryer;
    }

    private Map.Entry<String, Archetype> findArchetype(Map<String, List<Archetype>> archetypes, String groupId, String artifactId) {
        Archetype example = new Archetype();
        example.setGroupId(groupId);
        example.setArtifactId(artifactId);
        for (Map.Entry<String, List<Archetype>> entry : archetypes.entrySet()) {
            List<Archetype> catalog = entry.getValue();
            if (!catalog.contains(example)) continue;
            Archetype archetype = catalog.get(catalog.indexOf(example));
            return DefaultArchetypeSelector.newMapEntry(entry.getKey(), archetype);
        }
        return null;
    }

    private static <K, V> Map.Entry<K, V> newMapEntry(K key, V value) {
        HashMap<K, V> map = new HashMap<K, V>(1);
        map.put(key, value);
        return map.entrySet().iterator().next();
    }
}

