/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.reporting.exec;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.lifecycle.LifecycleExecutor;
import org.apache.maven.model.Build;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoNotFoundException;
import org.apache.maven.plugin.PluginConfigurationException;
import org.apache.maven.plugin.PluginContainerException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.version.DefaultPluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionRequest;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.plugin.version.PluginVersionResolver;
import org.apache.maven.plugin.version.PluginVersionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.exec.MavenPluginManagerHelper;
import org.apache.maven.reporting.exec.MavenReportExecution;
import org.apache.maven.reporting.exec.MavenReportExecutor;
import org.apache.maven.reporting.exec.MavenReportExecutorRequest;
import org.apache.maven.reporting.exec.ReportPlugin;
import org.apache.maven.reporting.exec.ReportSet;
import org.apache.maven.shared.utils.StringUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomUtils;

@Component(role=MavenReportExecutor.class)
public class DefaultMavenReportExecutor
implements MavenReportExecutor {
    @Requirement
    private Logger logger;
    @Requirement
    protected MavenPluginManager mavenPluginManager;
    @Requirement
    protected MavenPluginManagerHelper mavenPluginManagerHelper;
    @Requirement
    protected LifecycleExecutor lifecycleExecutor;
    @Requirement
    protected PluginVersionResolver pluginVersionResolver;
    private static final List<String> IMPORTS = Arrays.asList("org.apache.maven.reporting.MavenReport", "org.apache.maven.reporting.MavenMultiPageReport", "org.apache.maven.doxia.siterenderer.Renderer", "org.apache.maven.doxia.sink.SinkFactory", "org.codehaus.doxia.sink.Sink", "org.apache.maven.doxia.sink.Sink", "org.apache.maven.doxia.sink.SinkEventAttributes", "org.apache.maven.doxia.logging.LogEnabled", "org.apache.maven.doxia.logging.Log");
    private static final List<String> EXCLUDES = Arrays.asList("doxia-site-renderer", "doxia-sink-api", "maven-reporting-api");

    @Override
    public List<MavenReportExecution> buildMavenReports(MavenReportExecutorRequest mavenReportExecutorRequest) throws MojoExecutionException {
        if (mavenReportExecutorRequest.getReportPlugins() == null) {
            return Collections.emptyList();
        }
        this.getLog().debug("DefaultMavenReportExecutor.buildMavenReports()");
        HashSet<String> reportPluginKeys = new HashSet<String>();
        ArrayList<MavenReportExecution> reportExecutions = new ArrayList<MavenReportExecution>();
        String pluginKey = "";
        try {
            for (ReportPlugin reportPlugin : mavenReportExecutorRequest.getReportPlugins()) {
                pluginKey = reportPlugin.getGroupId() + ':' + reportPlugin.getArtifactId();
                if (!reportPluginKeys.add(pluginKey)) {
                    this.logger.info("plugin " + pluginKey + " will be executed more than one time");
                }
                reportExecutions.addAll(this.buildReportPlugin(mavenReportExecutorRequest, reportPlugin));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("failed to get report for " + pluginKey, e);
        }
        return reportExecutions;
    }

    protected List<MavenReportExecution> buildReportPlugin(MavenReportExecutorRequest mavenReportExecutorRequest, ReportPlugin reportPlugin) throws Exception {
        Plugin plugin = new Plugin();
        plugin.setGroupId(reportPlugin.getGroupId());
        plugin.setArtifactId(reportPlugin.getArtifactId());
        plugin.setVersion(this.resolvePluginVersion(reportPlugin, mavenReportExecutorRequest));
        this.logger.info("configuring report plugin " + plugin.getId());
        this.mergePluginToReportPlugin(mavenReportExecutorRequest, plugin, reportPlugin);
        PluginDescriptor pluginDescriptor = this.mavenPluginManagerHelper.getPluginDescriptor(plugin, mavenReportExecutorRequest.getMavenSession());
        ArrayList<GoalWithConf> goalsWithConfiguration = new ArrayList<GoalWithConf>();
        boolean hasUserDefinedReports = this.prepareGoals(reportPlugin, pluginDescriptor, goalsWithConfiguration);
        ArrayList<MavenReportExecution> reports = new ArrayList<MavenReportExecution>();
        for (GoalWithConf report : goalsWithConfiguration) {
            MavenReportExecution mavenReportExecution = this.prepareReportExecution(mavenReportExecutorRequest, report, hasUserDefinedReports);
            if (mavenReportExecution == null) continue;
            reports.add(mavenReportExecution);
        }
        if (!reports.isEmpty()) {
            StringBuilder buff = new StringBuilder();
            for (MavenReportExecution mre : reports) {
                if (buff.length() > 0) {
                    buff.append(", ");
                }
                buff.append(mre.getGoal());
            }
            this.logger.info(reports.size() + " report" + (reports.size() > 1 ? "s" : "") + " " + (hasUserDefinedReports ? "configured" : "detected") + " for " + plugin.getArtifactId() + ":" + plugin.getVersion() + ": " + buff);
        }
        return reports;
    }

    private boolean prepareGoals(ReportPlugin reportPlugin, PluginDescriptor pluginDescriptor, List<GoalWithConf> goalsWithConfiguration) {
        if (reportPlugin.getReportSets().isEmpty() && reportPlugin.getReports().isEmpty()) {
            List mojoDescriptors = pluginDescriptor.getMojos();
            for (MojoDescriptor mojoDescriptor : mojoDescriptors) {
                goalsWithConfiguration.add(new GoalWithConf(reportPlugin, pluginDescriptor, mojoDescriptor.getGoal(), mojoDescriptor.getConfiguration()));
            }
            return false;
        }
        HashSet<String> goals = new HashSet<String>();
        for (String report : reportPlugin.getReports()) {
            if (goals.add(report)) {
                goalsWithConfiguration.add(new GoalWithConf(reportPlugin, pluginDescriptor, report, reportPlugin.getConfiguration()));
                continue;
            }
            this.logger.warn(report + " report is declared twice in default reports");
        }
        for (ReportSet reportSet : reportPlugin.getReportSets()) {
            goals = new HashSet();
            for (String report : reportSet.getReports()) {
                if (goals.add(report)) {
                    goalsWithConfiguration.add(new GoalWithConf(reportPlugin, pluginDescriptor, report, reportSet.getConfiguration()));
                    continue;
                }
                this.logger.warn(report + " report is declared twice in " + reportSet.getId() + " reportSet");
            }
        }
        return true;
    }

    private MavenReportExecution prepareReportExecution(MavenReportExecutorRequest mavenReportExecutorRequest, GoalWithConf report, boolean hasUserDefinedReports) throws Exception {
        Plugin pluginMgmt;
        ReportPlugin reportPlugin = report.getReportPlugin();
        PluginDescriptor pluginDescriptor = report.getPluginDescriptor();
        MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(report.getGoal());
        if (mojoDescriptor == null) {
            throw new MojoNotFoundException(report.getGoal(), pluginDescriptor);
        }
        MavenProject project = mavenReportExecutorRequest.getProject();
        if (!hasUserDefinedReports && mojoDescriptor.isAggregator() && !this.canAggregate(project)) {
            return null;
        }
        MojoExecution mojoExecution = new MojoExecution(pluginDescriptor.getPlugin(), report.getGoal(), null);
        mojoExecution.setMojoDescriptor(mojoDescriptor);
        this.mavenPluginManagerHelper.setupPluginRealm(pluginDescriptor, mavenReportExecutorRequest.getMavenSession(), Thread.currentThread().getContextClassLoader(), IMPORTS, EXCLUDES);
        if (!this.isMavenReport(mojoExecution, pluginDescriptor)) {
            if (hasUserDefinedReports) {
                this.logger.warn("ignoring " + mojoExecution.getPlugin().getId() + ':' + report.getGoal() + " goal since it is not a report: should be removed from reporting configuration in POM");
            }
            return null;
        }
        Xpp3Dom pluginMgmtConfiguration = null;
        if (project.getBuild() != null && project.getBuild().getPluginManagement() != null && (pluginMgmt = this.find(reportPlugin, project.getBuild().getPluginManagement().getPlugins())) != null) {
            pluginMgmtConfiguration = (Xpp3Dom)pluginMgmt.getConfiguration();
        }
        mojoExecution.setConfiguration(this.mergeConfiguration(mojoDescriptor.getMojoConfiguration(), pluginMgmtConfiguration, reportPlugin.getConfiguration(), report.getConfiguration(), mojoDescriptor.getParameterMap().keySet()));
        MavenReport mavenReport = this.getConfiguredMavenReport(mojoExecution, pluginDescriptor, mavenReportExecutorRequest);
        MavenReportExecution mavenReportExecution = new MavenReportExecution(report.getGoal(), mojoExecution.getPlugin(), mavenReport, (ClassLoader)pluginDescriptor.getClassRealm());
        this.lifecycleExecutor.calculateForkedExecutions(mojoExecution, mavenReportExecutorRequest.getMavenSession());
        if (!mojoExecution.getForkedExecutions().isEmpty()) {
            String reportDescription = pluginDescriptor.getArtifactId() + ":" + report.getGoal() + " report";
            String execution = StringUtils.isNotEmpty((String)mojoDescriptor.getExecutePhase()) ? "'" + (StringUtils.isEmpty((String)mojoDescriptor.getExecuteLifecycle()) ? "" : '[' + mojoDescriptor.getExecuteLifecycle() + ']') + mojoDescriptor.getExecutePhase() + "' forked phase execution" : "'" + mojoDescriptor.getExecuteGoal() + "' forked goal execution";
            this.logger.info("preparing " + reportDescription + " requires " + execution);
            this.lifecycleExecutor.executeForkedExecutions(mojoExecution, mavenReportExecutorRequest.getMavenSession());
            this.logger.info(execution + " for " + reportDescription + " preparation done");
        }
        return mavenReportExecution;
    }

    private boolean canAggregate(MavenProject project) {
        return project.isExecutionRoot() && "pom".equals(project.getPackaging()) && project.getModules() != null && !project.getModules().isEmpty();
    }

    private MavenReport getConfiguredMavenReport(MojoExecution mojoExecution, PluginDescriptor pluginDescriptor, MavenReportExecutorRequest mavenReportExecutorRequest) throws PluginContainerException, PluginConfigurationException {
        try {
            Mojo mojo = (Mojo)this.mavenPluginManager.getConfiguredMojo(Mojo.class, mavenReportExecutorRequest.getMavenSession(), mojoExecution);
            return (MavenReport)mojo;
        }
        catch (ClassCastException e) {
            this.getLog().warn("skip ClassCastException " + e.getMessage());
            return null;
        }
        catch (PluginContainerException e) {
            if (e.getCause() != null && e.getCause() instanceof NoClassDefFoundError && e.getMessage().contains("PluginRegistry")) {
                this.getLog().warn("skip NoClassDefFoundError with PluginRegistry ");
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug(e.getMessage(), (Throwable)e);
                }
                return null;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMavenReport(MojoExecution mojoExecution, PluginDescriptor pluginDescriptor) {
        Class mojoClass;
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)mojoExecution.getMojoDescriptor().getRealm());
            mojoClass = pluginDescriptor.getClassRealm().loadClass(mojoExecution.getMojoDescriptor().getImplementation());
        }
        catch (ClassNotFoundException e) {
            this.getLog().warn("skip ClassNotFoundException mojoExecution.goal '" + mojoExecution.getGoal() + "': " + e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)mojoExecution.getMojoDescriptor().getRealm());
            MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(mojoExecution.getGoal());
            boolean isMavenReport = MavenReport.class.isAssignableFrom(mojoClass);
            if (this.getLog().isDebugEnabled()) {
                if (mojoDescriptor != null && mojoDescriptor.getImplementationClass() != null) {
                    this.getLog().debug("class " + mojoDescriptor.getImplementationClass().getName() + " isMavenReport: " + isMavenReport);
                }
                if (!isMavenReport) {
                    this.getLog().debug("skip non MavenReport " + mojoExecution.getMojoDescriptor().getId());
                }
            }
            boolean bl = isMavenReport;
            return bl;
        }
        catch (LinkageError e) {
            this.getLog().warn("skip LinkageError mojoExecution.goal '" + mojoExecution.getGoal() + "': " + e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private Xpp3Dom mergeConfiguration(PlexusConfiguration mojoConf, Xpp3Dom pluginMgmtConfig, PlexusConfiguration pluginConf, PlexusConfiguration reportSetConf, Set<String> parameters) {
        Xpp3Dom mojoConfig;
        Xpp3Dom xpp3Dom = mojoConfig = mojoConf != null ? this.convert(mojoConf) : new Xpp3Dom("configuration");
        if (pluginMgmtConfig != null || pluginConf != null || reportSetConf != null) {
            Xpp3Dom pluginConfig = pluginConf == null ? new Xpp3Dom("fake") : this.convert(pluginConf);
            Xpp3Dom mergedConfig = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)this.convert(reportSetConf), (Xpp3Dom)pluginConfig);
            mergedConfig = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)mergedConfig, (Xpp3Dom)pluginMgmtConfig);
            mergedConfig = Xpp3DomUtils.mergeXpp3Dom((Xpp3Dom)mergedConfig, (Xpp3Dom)mojoConfig);
            Xpp3Dom cleanedConfig = new Xpp3Dom("configuration");
            if (mergedConfig.getChildren() != null) {
                for (Xpp3Dom parameter : mergedConfig.getChildren()) {
                    if (!parameters.contains(parameter.getName())) continue;
                    cleanedConfig.addChild(parameter);
                }
            }
            mojoConfig = cleanedConfig;
        }
        return mojoConfig;
    }

    private Xpp3Dom convert(PlexusConfiguration config) {
        if (config == null) {
            return null;
        }
        Xpp3Dom dom = new Xpp3Dom(config.getName());
        dom.setValue(config.getValue(null));
        for (String attrib : config.getAttributeNames()) {
            dom.setAttribute(attrib, config.getAttribute(attrib, null));
        }
        int n = config.getChildCount();
        for (int i = 0; i < n; ++i) {
            dom.addChild(this.convert(config.getChild(i)));
        }
        return dom;
    }

    private Logger getLog() {
        return this.logger;
    }

    protected String resolvePluginVersion(ReportPlugin reportPlugin, MavenReportExecutorRequest mavenReportExecutorRequest) throws PluginVersionResolutionException {
        Plugin plugin;
        String reportPluginKey = reportPlugin.getGroupId() + ':' + reportPlugin.getArtifactId();
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("resolving version for " + reportPluginKey);
        }
        if (reportPlugin.getVersion() != null) {
            if (this.getLog().isDebugEnabled()) {
                this.logger.debug("resolved " + reportPluginKey + " version from the reporting.plugins section: " + reportPlugin.getVersion());
            }
            return reportPlugin.getVersion();
        }
        MavenProject project = mavenReportExecutorRequest.getProject();
        if (project.getBuild() != null && (plugin = this.find(reportPlugin, project.getBuild().getPlugins())) != null && plugin.getVersion() != null) {
            if (this.getLog().isDebugEnabled()) {
                this.logger.debug("resolved " + reportPluginKey + " version from the build.plugins section: " + plugin.getVersion());
            }
            return plugin.getVersion();
        }
        if (project.getBuild() != null && project.getBuild().getPluginManagement() != null && (plugin = this.find(reportPlugin, project.getBuild().getPluginManagement().getPlugins())) != null && plugin.getVersion() != null) {
            if (this.getLog().isDebugEnabled()) {
                this.logger.debug("resolved " + reportPluginKey + " version from the build.pluginManagement.plugins section: " + plugin.getVersion());
            }
            return plugin.getVersion();
        }
        this.logger.warn("Report plugin " + reportPluginKey + " has an empty version.");
        this.logger.warn("");
        this.logger.warn("It is highly recommended to fix these problems because they threaten the stability of your build.");
        this.logger.warn("");
        this.logger.warn("For this reason, future Maven versions might no longer support building such malformed projects.");
        plugin = new Plugin();
        plugin.setGroupId(reportPlugin.getGroupId());
        plugin.setArtifactId(reportPlugin.getArtifactId());
        DefaultPluginVersionRequest pluginVersionRequest = new DefaultPluginVersionRequest(plugin, mavenReportExecutorRequest.getMavenSession());
        PluginVersionResult result = this.pluginVersionResolver.resolve((PluginVersionRequest)pluginVersionRequest);
        if (this.getLog().isDebugEnabled()) {
            this.getLog().debug("resolved " + reportPluginKey + " version from repository: " + result.getVersion());
        }
        return result.getVersion();
    }

    private Plugin find(ReportPlugin reportPlugin, List<Plugin> plugins) {
        if (plugins == null) {
            return null;
        }
        for (Plugin plugin : plugins) {
            if (!StringUtils.equals((String)plugin.getArtifactId(), (String)reportPlugin.getArtifactId()) || !StringUtils.equals((String)plugin.getGroupId(), (String)reportPlugin.getGroupId())) continue;
            return plugin;
        }
        return null;
    }

    private void mergePluginToReportPlugin(MavenReportExecutorRequest mavenReportExecutorRequest, Plugin buildPlugin, ReportPlugin reportPlugin) {
        Build build = mavenReportExecutorRequest.getProject().getBuild();
        Plugin configuredPlugin = this.find(reportPlugin, build.getPlugins());
        if (configuredPlugin == null && build.getPluginManagement() != null) {
            configuredPlugin = this.find(reportPlugin, build.getPluginManagement().getPlugins());
        }
        if (configuredPlugin != null && !configuredPlugin.getDependencies().isEmpty()) {
            buildPlugin.getDependencies().addAll(configuredPlugin.getDependencies());
        }
    }

    private static class GoalWithConf {
        private final String goal;
        private final PlexusConfiguration configuration;
        private final ReportPlugin reportPlugin;
        private final PluginDescriptor pluginDescriptor;

        GoalWithConf(ReportPlugin reportPlugin, PluginDescriptor pluginDescriptor, String goal, PlexusConfiguration configuration) {
            this.reportPlugin = reportPlugin;
            this.pluginDescriptor = pluginDescriptor;
            this.goal = goal;
            this.configuration = configuration;
        }

        public ReportPlugin getReportPlugin() {
            return this.reportPlugin;
        }

        public PluginDescriptor getPluginDescriptor() {
            return this.pluginDescriptor;
        }

        public String getGoal() {
            return this.goal;
        }

        public PlexusConfiguration getConfiguration() {
            return this.configuration;
        }
    }
}

