/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.dependency.analyzer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.maven.shared.dependency.analyzer.ClassFileVisitor;
import org.codehaus.plexus.util.DirectoryScanner;

public final class ClassFileVisitorUtils {
    private static final String[] CLASS_INCLUDES = new String[]{"**/*.class"};

    private ClassFileVisitorUtils() {
    }

    public static void accept(URL url, ClassFileVisitor visitor) throws IOException {
        if (url.getPath().endsWith(".jar")) {
            ClassFileVisitorUtils.acceptJar(url, visitor);
        } else if (url.getProtocol().equals("file")) {
            try {
                File file = new File(new URI(url.toString()).getPath());
                if (!file.isDirectory()) {
                    throw new IllegalArgumentException("Cannot accept visitor on URL: " + url);
                }
                ClassFileVisitorUtils.acceptDirectory(file, visitor);
            }
            catch (URISyntaxException exception) {
                IllegalArgumentException e = new IllegalArgumentException("Cannot accept visitor on URL: " + url);
                e.initCause(exception);
                throw e;
            }
        } else {
            throw new IllegalArgumentException("Cannot accept visitor on URL: " + url);
        }
    }

    private static void acceptJar(URL url, ClassFileVisitor visitor) throws IOException {
        JarInputStream in = new JarInputStream(url.openStream());
        JarEntry entry = null;
        while ((entry = in.getNextJarEntry()) != null) {
            String name = entry.getName();
            if (!name.endsWith(".class")) continue;
            ClassFileVisitorUtils.visitClass(name, in, visitor);
        }
        in.close();
    }

    private static void acceptDirectory(File directory, ClassFileVisitor visitor) throws IOException {
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("File is not a directory");
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        scanner.setIncludes(CLASS_INCLUDES);
        scanner.scan();
        String[] paths = scanner.getIncludedFiles();
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i].replace(File.separatorChar, '/');
            File file = new File(directory, path);
            FileInputStream in = new FileInputStream(file);
            ClassFileVisitorUtils.visitClass(path, in, visitor);
            in.close();
        }
    }

    private static void visitClass(String path, InputStream in, ClassFileVisitor visitor) {
        if (!path.endsWith(".class")) {
            throw new IllegalArgumentException("Path is not a class");
        }
        String className = path.substring(0, path.length() - 6);
        className = className.replace('/', '.');
        visitor.visitClass(className, in);
    }
}

