/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.surefire.SurefireReportParameters;
import org.apache.maven.surefire.cli.CommandLineOption;
import org.apache.maven.surefire.suite.RunResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SurefireHelper {
    private SurefireHelper() {
        throw new IllegalAccessError("Utility class");
    }

    public static void reportExecution(SurefireReportParameters reportParameters, RunResult result, Log log) throws MojoFailureException, MojoExecutionException {
        String msg;
        boolean timeoutOrOtherFailure = result.isFailureOrTimeout();
        if (!timeoutOrOtherFailure) {
            if (result.getCompletedCount() == 0) {
                if (reportParameters.getFailIfNoTests() == null || !reportParameters.getFailIfNoTests().booleanValue()) {
                    return;
                }
                throw new MojoFailureException("No tests were executed!  (Set -DfailIfNoTests=false to ignore this error.)");
            }
            if (result.isErrorFree()) {
                return;
            }
        }
        String string = msg = timeoutOrOtherFailure ? "There was a timeout or other error in the fork" : "There are test failures.\n\nPlease refer to " + reportParameters.getReportsDirectory() + " for the individual test results.";
        if (!reportParameters.isTestFailureIgnore()) {
            if (result.isFailure()) {
                throw new MojoExecutionException(msg);
            }
            throw new MojoFailureException(msg);
        }
        log.error((CharSequence)msg);
    }

    public static List<CommandLineOption> commandLineOptions(MavenSession session, Log log) {
        ArrayList<CommandLineOption> cli = new ArrayList<CommandLineOption>();
        if (log.isErrorEnabled()) {
            cli.add(CommandLineOption.LOGGING_LEVEL_ERROR);
        }
        if (log.isWarnEnabled()) {
            cli.add(CommandLineOption.LOGGING_LEVEL_WARN);
        }
        if (log.isInfoEnabled()) {
            cli.add(CommandLineOption.LOGGING_LEVEL_INFO);
        }
        if (log.isDebugEnabled()) {
            cli.add(CommandLineOption.LOGGING_LEVEL_DEBUG);
        }
        try {
            Method getRequestMethod = session.getClass().getMethod("getRequest", new Class[0]);
            MavenExecutionRequest request = (MavenExecutionRequest)getRequestMethod.invoke((Object)session, new Object[0]);
            String f = SurefireHelper.getFailureBehavior(request);
            if (f != null) {
                cli.add(CommandLineOption.valueOf((String)(f.startsWith("REACTOR_") ? f : "REACTOR_" + f)));
            }
            if (request.isShowErrors()) {
                cli.add(CommandLineOption.SHOW_ERRORS);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.unmodifiableList(cli);
    }

    public static void logDebugOrCliShowErrors(CharSequence s, Log log, Collection<CommandLineOption> cli) {
        if (cli.contains(CommandLineOption.LOGGING_LEVEL_DEBUG)) {
            log.debug(s);
        } else if (cli.contains(CommandLineOption.SHOW_ERRORS)) {
            if (log.isDebugEnabled()) {
                log.debug(s);
            } else {
                log.info(s);
            }
        }
    }

    private static String getFailureBehavior(MavenExecutionRequest request) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        try {
            return request.getFailureBehavior();
        }
        catch (NoSuchMethodError e) {
            return (String)request.getClass().getMethod("getReactorFailureBehavior", new Class[0]).invoke((Object)request, new Object[0]);
        }
    }
}

