/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter;

import java.io.PrintWriter;
import java.io.Writer;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class ForkingWriterStreamConsumer
implements StreamConsumer {
    private PrintWriter printWriter;
    private int standardPrefixLength;
    private int headingPrefixLength;
    private boolean showHeading;
    private int footerPrefixLength;
    private boolean showFooter;

    public ForkingWriterStreamConsumer(Writer writer, boolean showHeading, boolean showFooter) {
        this.showHeading = showHeading;
        this.showFooter = showFooter;
        this.printWriter = new PrintWriter(writer);
        this.standardPrefixLength = "@SL".length();
        this.headingPrefixLength = "@HL".length();
        this.footerPrefixLength = "@FL".length();
    }

    public void consumeLine(String line) {
        if (line.startsWith("@HL")) {
            if (this.showHeading) {
                this.printWriter.println(line.substring(this.headingPrefixLength));
            }
        } else if (line.startsWith("@SL")) {
            this.printWriter.println(line.substring(this.standardPrefixLength));
        } else if (line.startsWith("@FL")) {
            if (this.showFooter) {
                this.printWriter.println(line.substring(this.footerPrefixLength));
            }
        } else {
            this.printWriter.println(line);
        }
        this.printWriter.flush();
    }
}

