/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.http;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.InputData;
import org.apache.maven.wagon.OutputData;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamWagon;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.resource.Resource;
import org.apache.maven.wagon.shared.http.HtmlFileListParser;

public class LightweightHttpWagon
extends StreamWagon {
    private String previousProxyExclusions;
    private String previousHttpProxyHost;
    private String previousHttpProxyPort;
    private HttpURLConnection putConnection;
    private boolean useCache;
    private Properties httpHeaders;

    private String buildUrl(String path) {
        String repoUrl = this.getRepository().getUrl();
        path = path.replace(' ', '+');
        if (repoUrl.charAt(repoUrl.length() - 1) != '/') {
            return repoUrl + '/' + path;
        }
        return repoUrl + path;
    }

    public void fillInputData(InputData inputData) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        Resource resource = inputData.getResource();
        try {
            boolean isGZipped;
            URL url = new URL(this.buildUrl(resource.getName()));
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestProperty("Accept-Encoding", "gzip");
            if (!this.useCache) {
                urlConnection.setRequestProperty("Pragma", "no-cache");
            }
            this.addHeaders(urlConnection);
            int responseCode = urlConnection.getResponseCode();
            if (responseCode == 403 || responseCode == 401) {
                throw new AuthorizationException("Access denied to: " + this.buildUrl(resource.getName()));
            }
            InputStream is = urlConnection.getInputStream();
            String contentEncoding = urlConnection.getHeaderField("Content-Encoding");
            boolean bl = isGZipped = contentEncoding == null ? false : "gzip".equalsIgnoreCase(contentEncoding);
            if (isGZipped) {
                is = new GZIPInputStream(is);
            }
            inputData.setInputStream(is);
            resource.setLastModified(urlConnection.getLastModified());
            resource.setContentLength((long)urlConnection.getContentLength());
        }
        catch (MalformedURLException e) {
            throw new ResourceDoesNotExistException("Invalid repository URL", (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new ResourceDoesNotExistException("Unable to locate resource in repository", (Throwable)e);
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file: " + e.getMessage(), (Throwable)e);
        }
    }

    private void addHeaders(URLConnection urlConnection) {
        if (this.httpHeaders != null) {
            Iterator<Object> i = this.httpHeaders.keySet().iterator();
            while (i.hasNext()) {
                String header = (String)i.next();
                urlConnection.setRequestProperty(header, this.httpHeaders.getProperty(header));
            }
        }
    }

    public void fillOutputData(OutputData outputData) throws TransferFailedException {
        Resource resource = outputData.getResource();
        try {
            URL url = new URL(this.buildUrl(resource.getName()));
            this.putConnection = (HttpURLConnection)url.openConnection();
            this.addHeaders(this.putConnection);
            this.putConnection.setRequestMethod("PUT");
            this.putConnection.setDoOutput(true);
            outputData.setOutputStream(this.putConnection.getOutputStream());
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file", (Throwable)e);
        }
    }

    protected void finishPutTransfer(Resource resource, InputStream input, OutputStream output) throws TransferFailedException, AuthorizationException, ResourceDoesNotExistException {
        try {
            int statusCode = this.putConnection.getResponseCode();
            switch (statusCode) {
                case 200: 
                case 201: 
                case 202: 
                case 204: {
                    break;
                }
                case 403: {
                    throw new AuthorizationException("Access denied to: " + this.buildUrl(resource.getName()));
                }
                case 404: {
                    throw new ResourceDoesNotExistException("File: " + this.buildUrl(resource.getName()) + " does not exist");
                }
                default: {
                    throw new TransferFailedException("Failed to transfer file: " + this.buildUrl(resource.getName()) + ". Return code is: " + statusCode);
                }
            }
        }
        catch (IOException e) {
            this.fireTransferError(resource, e, 6);
            throw new TransferFailedException("Error transferring file", (Throwable)e);
        }
    }

    protected void openConnectionInternal() throws ConnectionException, AuthenticationException {
        boolean hasAuthentication;
        this.previousHttpProxyHost = System.getProperty("http.proxyHost");
        this.previousHttpProxyPort = System.getProperty("http.proxyPort");
        this.previousProxyExclusions = System.getProperty("http.nonProxyHosts");
        final ProxyInfo proxyInfo = this.getProxyInfo("http", this.getRepository().getHost());
        if (proxyInfo != null) {
            System.setProperty("http.proxyHost", proxyInfo.getHost());
            System.setProperty("http.proxyPort", String.valueOf(proxyInfo.getPort()));
            if (proxyInfo.getNonProxyHosts() != null) {
                System.setProperty("http.nonProxyHosts", proxyInfo.getNonProxyHosts());
            } else {
                System.getProperties().remove("http.nonProxyHosts");
            }
        } else {
            System.getProperties().remove("http.proxyHost");
            System.getProperties().remove("http.proxyPort");
        }
        final boolean hasProxy = proxyInfo != null && proxyInfo.getUserName() != null;
        boolean bl = hasAuthentication = this.authenticationInfo != null && this.authenticationInfo.getUserName() != null;
        if (hasProxy || hasAuthentication) {
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    if (hasProxy && this.getRequestingHost().equals(proxyInfo.getHost()) && this.getRequestingPort() == proxyInfo.getPort()) {
                        String password = "";
                        if (proxyInfo.getPassword() != null) {
                            password = proxyInfo.getPassword();
                        }
                        return new PasswordAuthentication(proxyInfo.getUserName(), password.toCharArray());
                    }
                    if (hasAuthentication) {
                        String password = "";
                        if (LightweightHttpWagon.this.authenticationInfo.getPassword() != null) {
                            password = LightweightHttpWagon.this.authenticationInfo.getPassword();
                        }
                        return new PasswordAuthentication(LightweightHttpWagon.this.authenticationInfo.getUserName(), password.toCharArray());
                    }
                    return super.getPasswordAuthentication();
                }
            });
        } else {
            Authenticator.setDefault(null);
        }
    }

    public void closeConnection() throws ConnectionException {
        if (this.putConnection != null) {
            this.putConnection.disconnect();
        }
        if (this.previousHttpProxyHost != null) {
            System.setProperty("http.proxyHost", this.previousHttpProxyHost);
        } else {
            System.getProperties().remove("http.proxyHost");
        }
        if (this.previousHttpProxyPort != null) {
            System.setProperty("http.proxyPort", this.previousHttpProxyPort);
        } else {
            System.getProperties().remove("http.proxyPort");
        }
        if (this.previousProxyExclusions != null) {
            System.setProperty("http.nonProxyHosts", this.previousProxyExclusions);
        } else {
            System.getProperties().remove("http.nonProxyHosts");
        }
    }

    public List getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        InputData inputData = new InputData();
        if (destinationDirectory.length() > 0 && !destinationDirectory.endsWith("/")) {
            destinationDirectory = destinationDirectory + "/";
        }
        String url = this.buildUrl(destinationDirectory);
        Resource resource = new Resource(destinationDirectory);
        inputData.setResource(resource);
        this.fillInputData(inputData);
        InputStream is = inputData.getInputStream();
        if (is == null) {
            throw new TransferFailedException(url + " - Could not open input stream for resource: '" + resource + "'");
        }
        return HtmlFileListParser.parseFileList((String)url, (InputStream)is);
    }

    public boolean resourceExists(String resourceName) throws TransferFailedException, AuthorizationException {
        try {
            URL url = new URL(this.buildUrl(new Resource(resourceName).getName()));
            HttpURLConnection headConnection = (HttpURLConnection)url.openConnection();
            this.addHeaders(headConnection);
            headConnection.setRequestMethod("HEAD");
            headConnection.setDoOutput(true);
            int statusCode = headConnection.getResponseCode();
            switch (statusCode) {
                case 200: {
                    return true;
                }
                case 403: {
                    throw new AuthorizationException("Access denied to: " + url);
                }
                case 404: {
                    return false;
                }
                case 401: {
                    throw new AuthorizationException("Access denied to: " + url);
                }
            }
            throw new TransferFailedException("Failed to look for file: " + this.buildUrl(resourceName) + ". Return code is: " + statusCode);
        }
        catch (IOException e) {
            throw new TransferFailedException("Error transferring file", (Throwable)e);
        }
    }

    public boolean isUseCache() {
        return this.useCache;
    }

    public void setUseCache(boolean useCache) {
        this.useCache = useCache;
    }

    public Properties getHttpHeaders() {
        return this.httpHeaders;
    }

    public void setHttpHeaders(Properties httpHeaders) {
        this.httpHeaders = httpHeaders;
    }
}

