/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.mp.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.rat.config.SourceCodeManagementSystems;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ScmIgnoreParser {
    private static List<String> COMMENT_PREFIXES = Arrays.asList("#", "##", "//", "/**", "/*");

    private ScmIgnoreParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getExcludesFromFile(Log log, File scmIgnore) {
        ArrayList<String> exclusionLines = new ArrayList<String>();
        if (scmIgnore != null && scmIgnore.exists() && scmIgnore.isFile()) {
            log.info((CharSequence)("Parsing exclusions from " + scmIgnore));
            BufferedReader reader = null;
            try {
                String line;
                reader = new BufferedReader(new FileReader(scmIgnore));
                while ((line = reader.readLine()) != null) {
                    if (ScmIgnoreParser.isComment(line)) continue;
                    exclusionLines.add(line);
                    log.debug((CharSequence)("Added " + line));
                }
            }
            catch (IOException e) {
                try {
                    log.warn((CharSequence)("Cannot parse " + scmIgnore + " for exclusions. Will skip this file."));
                    log.debug((CharSequence)("Skip parsing " + scmIgnore + " due to " + e.getMessage()));
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(reader);
                    throw throwable;
                }
                IOUtils.closeQuietly((Reader)reader);
            }
            IOUtils.closeQuietly((Reader)reader);
        }
        return exclusionLines;
    }

    public static List<String> getExclusionsFromSCM(Log log, File baseDir) {
        ArrayList<String> exclusions = new ArrayList<String>();
        for (SourceCodeManagementSystems scm : SourceCodeManagementSystems.values()) {
            if (!scm.hasIgnoreFile()) continue;
            exclusions.addAll(ScmIgnoreParser.getExcludesFromFile(log, new File(baseDir, scm.getIgnoreFile())));
        }
        return exclusions;
    }

    static boolean isComment(String line) {
        if (line == null || line.length() <= 0) {
            return false;
        }
        String trimLine = line.trim();
        for (String prefix : COMMENT_PREFIXES) {
            if (!trimLine.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

