/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.provider.natived.model.privilege.database;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.authority.model.PrivilegeType;
import org.apache.shardingsphere.authority.provider.natived.model.privilege.database.SchemaPrivileges;

public final class DatabasePrivileges {
    private final Collection<PrivilegeType> globalPrivileges = new CopyOnWriteArraySet<PrivilegeType>();
    private final Map<String, SchemaPrivileges> specificPrivileges = new ConcurrentHashMap<String, SchemaPrivileges>();

    public boolean hasPrivileges(String schema, Collection<PrivilegeType> privileges) {
        return this.hasGlobalPrivileges(privileges) || this.hasSpecificPrivileges(schema, privileges);
    }

    public boolean hasPrivileges(String schema, String table, Collection<PrivilegeType> privileges) {
        return this.hasGlobalPrivileges(privileges) || this.hasSpecificPrivileges(schema, table, privileges);
    }

    private boolean hasGlobalPrivileges(Collection<PrivilegeType> privileges) {
        return this.globalPrivileges.containsAll(privileges);
    }

    private boolean hasSpecificPrivileges(String schema, Collection<PrivilegeType> privileges) {
        return this.specificPrivileges.containsKey(schema) && this.specificPrivileges.get(schema).hasPrivileges(this.getSpecificPrivileges(privileges));
    }

    private boolean hasSpecificPrivileges(String schema, String table, Collection<PrivilegeType> privileges) {
        return this.specificPrivileges.containsKey(schema) && this.specificPrivileges.get(schema).hasPrivileges(table, this.getSpecificPrivileges(privileges));
    }

    private Collection<PrivilegeType> getSpecificPrivileges(Collection<PrivilegeType> privileges) {
        return privileges.stream().filter(each -> !this.globalPrivileges.contains(each)).collect(Collectors.toList());
    }

    @Generated
    public Collection<PrivilegeType> getGlobalPrivileges() {
        return this.globalPrivileges;
    }

    @Generated
    public Map<String, SchemaPrivileges> getSpecificPrivileges() {
        return this.specificPrivileges;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabasePrivileges)) {
            return false;
        }
        DatabasePrivileges other = (DatabasePrivileges)o;
        Collection<PrivilegeType> this$globalPrivileges = this.getGlobalPrivileges();
        Collection<PrivilegeType> other$globalPrivileges = other.getGlobalPrivileges();
        if (this$globalPrivileges == null ? other$globalPrivileges != null : !((Object)this$globalPrivileges).equals(other$globalPrivileges)) {
            return false;
        }
        Map<String, SchemaPrivileges> this$specificPrivileges = this.getSpecificPrivileges();
        Map<String, SchemaPrivileges> other$specificPrivileges = other.getSpecificPrivileges();
        return !(this$specificPrivileges == null ? other$specificPrivileges != null : !((Object)this$specificPrivileges).equals(other$specificPrivileges));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Collection<PrivilegeType> $globalPrivileges = this.getGlobalPrivileges();
        result = result * 59 + ($globalPrivileges == null ? 43 : ((Object)$globalPrivileges).hashCode());
        Map<String, SchemaPrivileges> $specificPrivileges = this.getSpecificPrivileges();
        result = result * 59 + ($specificPrivileges == null ? 43 : ((Object)$specificPrivileges).hashCode());
        return result;
    }
}

