/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster;

import com.google.common.base.Preconditions;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.config.RuleConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConverter;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.infra.metadata.resource.ShardingSphereResource;
import org.apache.shardingsphere.infra.metadata.schema.QualifiedSchema;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.metadata.schema.loader.SchemaLoader;
import org.apache.shardingsphere.infra.rule.builder.schema.SchemaRulesBuilder;
import org.apache.shardingsphere.infra.rule.event.DataSourceStatusChangedEvent;
import org.apache.shardingsphere.infra.rule.event.impl.DataSourceNameDisabledEvent;
import org.apache.shardingsphere.infra.rule.identifier.type.StatusContainedRule;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilder;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.ClusterContextManagerCoordinator;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.RegistryCenter;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.StorageNodeStatus;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsBuilder;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryConfiguration;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.typed.TypedSPIRegistry;
import org.apache.shardingsphere.transaction.ShardingSphereTransactionManagerEngine;
import org.apache.shardingsphere.transaction.context.TransactionContexts;
import org.apache.shardingsphere.transaction.rule.TransactionRule;
import org.apache.shardingsphere.transaction.rule.builder.DefaultTransactionRuleConfigurationBuilder;

public final class ClusterContextManagerBuilder
implements ContextManagerBuilder {
    private RegistryCenter registryCenter;
    private MetaDataPersistService metaDataPersistService;
    private MetaDataContexts metaDataContexts;
    private TransactionContexts transactionContexts;
    private ContextManager contextManager;

    public ContextManager build(ModeConfiguration modeConfig, Map<String, Map<String, DataSource>> dataSourcesMap, Map<String, Collection<RuleConfiguration>> schemaRuleConfigs, Collection<RuleConfiguration> globalRuleConfigs, Properties props, boolean isOverwrite, Integer port) throws SQLException {
        this.beforeBuildContextManager(modeConfig, dataSourcesMap, schemaRuleConfigs, globalRuleConfigs, props, isOverwrite, port);
        this.contextManager = new ContextManager();
        this.contextManager.init(this.metaDataContexts, this.transactionContexts);
        this.afterBuildContextManager();
        return this.contextManager;
    }

    private void beforeBuildContextManager(ModeConfiguration modeConfig, Map<String, Map<String, DataSource>> dataSourcesMap, Map<String, Collection<RuleConfiguration>> schemaRuleConfigs, Collection<RuleConfiguration> globalRuleConfigs, Properties props, boolean isOverwrite, Integer port) throws SQLException {
        ClusterPersistRepository repository = this.createClusterPersistRepository((ClusterPersistRepositoryConfiguration)modeConfig.getRepository());
        this.registryCenter = new RegistryCenter(repository, port);
        this.metaDataPersistService = new MetaDataPersistService((PersistRepository)repository);
        this.persistConfigurations(this.metaDataPersistService, dataSourcesMap, schemaRuleConfigs, globalRuleConfigs, props, isOverwrite);
        Collection schemaNames = this.metaDataPersistService.getSchemaMetaDataService().loadAllNames();
        Map<String, Map<String, DataSource>> clusterDataSources = this.loadDataSourcesMap(this.metaDataPersistService, dataSourcesMap, schemaNames);
        Map<String, Collection<RuleConfiguration>> clusterSchemaRuleConfigs = this.loadSchemaRules(this.metaDataPersistService, schemaNames);
        Properties clusterProps = this.metaDataPersistService.getPropsService().load();
        Map rules = SchemaRulesBuilder.buildRules(clusterDataSources, clusterSchemaRuleConfigs, (Properties)clusterProps);
        Map schemas = new SchemaLoader(clusterDataSources, clusterSchemaRuleConfigs, rules, clusterProps).load();
        this.persistMetaData(schemas);
        this.metaDataContexts = new MetaDataContextsBuilder(clusterDataSources, clusterSchemaRuleConfigs, this.metaDataPersistService.getGlobalRuleService().load(), schemas, rules, clusterProps).build(this.metaDataPersistService);
        this.transactionContexts = this.createTransactionContexts(this.metaDataContexts);
    }

    private void afterBuildContextManager() {
        new ClusterContextManagerCoordinator(this.metaDataPersistService, this.contextManager);
        this.disableDataSources();
        this.registryCenter.onlineInstance();
    }

    private ClusterPersistRepository createClusterPersistRepository(ClusterPersistRepositoryConfiguration config) {
        Preconditions.checkNotNull((Object)config, (Object)"Cluster persist repository configuration cannot be null.");
        ClusterPersistRepository result = (ClusterPersistRepository)TypedSPIRegistry.getRegisteredService(ClusterPersistRepository.class, (String)config.getType(), (Properties)config.getProps());
        result.init(config);
        return result;
    }

    private void persistConfigurations(MetaDataPersistService metaDataPersistService, Map<String, Map<String, DataSource>> dataSourcesMap, Map<String, Collection<RuleConfiguration>> schemaRuleConfigs, Collection<RuleConfiguration> globalRuleConfigs, Properties props, boolean overwrite) {
        if (!this.isEmptyLocalConfiguration(dataSourcesMap, schemaRuleConfigs, globalRuleConfigs, props)) {
            metaDataPersistService.persistConfigurations(this.getDataSourceConfigurations(dataSourcesMap), schemaRuleConfigs, globalRuleConfigs, props, overwrite);
        }
    }

    private boolean isEmptyLocalConfiguration(Map<String, Map<String, DataSource>> dataSourcesMap, Map<String, Collection<RuleConfiguration>> schemaRuleConfigs, Collection<RuleConfiguration> globalRuleConfigs, Properties props) {
        return this.isEmptyLocalDataSourcesMap(dataSourcesMap) && this.isEmptyLocalSchemaRuleConfigurations(schemaRuleConfigs) && globalRuleConfigs.isEmpty() && props.isEmpty();
    }

    private boolean isEmptyLocalDataSourcesMap(Map<String, Map<String, DataSource>> dataSourcesMap) {
        return dataSourcesMap.entrySet().stream().allMatch(entry -> ((Map)entry.getValue()).isEmpty());
    }

    private boolean isEmptyLocalSchemaRuleConfigurations(Map<String, Collection<RuleConfiguration>> schemaRuleConfigs) {
        return schemaRuleConfigs.entrySet().stream().allMatch(entry -> ((Collection)entry.getValue()).isEmpty());
    }

    private Map<String, Map<String, DataSourceConfiguration>> getDataSourceConfigurations(Map<String, Map<String, DataSource>> dataSourcesMap) {
        LinkedHashMap<String, Map<String, DataSourceConfiguration>> result = new LinkedHashMap<String, Map<String, DataSourceConfiguration>>(dataSourcesMap.size(), 1.0f);
        for (Map.Entry<String, Map<String, DataSource>> entry : dataSourcesMap.entrySet()) {
            result.put(entry.getKey(), DataSourceConverter.getDataSourceConfigurationMap(entry.getValue()));
        }
        return result;
    }

    private Map<String, Map<String, DataSource>> loadDataSourcesMap(MetaDataPersistService metaDataPersistService, Map<String, Map<String, DataSource>> dataSourcesMap, Collection<String> schemaNames) {
        Map<String, Map<String, DataSourceConfiguration>> loadedDataSourceConfigs = this.loadDataSourceConfigurations(metaDataPersistService, schemaNames);
        Map<String, Map<String, DataSourceConfiguration>> changedDataSourceConfigs = this.getChangedDataSourceConfigurations(dataSourcesMap, loadedDataSourceConfigs);
        LinkedHashMap<String, Map<String, DataSource>> result = new LinkedHashMap<String, Map<String, DataSource>>(dataSourcesMap);
        this.getChangedDataSources(changedDataSourceConfigs).forEach((key, value) -> {
            if (result.containsKey(key)) {
                ((Map)result.get(key)).putAll(value);
            } else {
                result.put((String)key, (Map<String, DataSource>)value);
            }
        });
        return result;
    }

    private Map<String, Map<String, DataSourceConfiguration>> loadDataSourceConfigurations(MetaDataPersistService metaDataPersistService, Collection<String> schemaNames) {
        LinkedHashMap<String, Map<String, DataSourceConfiguration>> result = new LinkedHashMap<String, Map<String, DataSourceConfiguration>>();
        for (String each : schemaNames) {
            result.put(each, metaDataPersistService.getDataSourceService().load(each));
        }
        return result;
    }

    private Map<String, Map<String, DataSourceConfiguration>> getChangedDataSourceConfigurations(Map<String, Map<String, DataSource>> configuredDataSourcesMap, Map<String, Map<String, DataSourceConfiguration>> loadedDataSourceConfigs) {
        if (this.isEmptyLocalDataSourcesMap(configuredDataSourcesMap)) {
            return loadedDataSourceConfigs;
        }
        HashMap<String, Map<String, DataSourceConfiguration>> result = new HashMap<String, Map<String, DataSourceConfiguration>>(loadedDataSourceConfigs.size(), 1.0f);
        for (Map.Entry<String, Map<String, DataSourceConfiguration>> entry : loadedDataSourceConfigs.entrySet()) {
            if (configuredDataSourcesMap.containsKey(entry.getKey())) {
                Map<String, DataSourceConfiguration> changedDataSources = this.getChangedDataSourcesConfigurations(configuredDataSourcesMap.get(entry.getKey()), entry.getValue());
                if (changedDataSources.isEmpty()) continue;
                result.put(entry.getKey(), changedDataSources);
                continue;
            }
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    private Map<String, DataSourceConfiguration> getChangedDataSourcesConfigurations(Map<String, DataSource> dataSourceMap, Map<String, DataSourceConfiguration> loadedDataSourceConfigurationMap) {
        Map dataSourceConfigurationMap = DataSourceConverter.getDataSourceConfigurationMap(dataSourceMap);
        return loadedDataSourceConfigurationMap.entrySet().stream().filter(entry -> !dataSourceConfigurationMap.containsKey(entry.getKey()) || !((DataSourceConfiguration)dataSourceConfigurationMap.get(entry.getKey())).equals(entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Map<String, Collection<RuleConfiguration>> loadSchemaRules(MetaDataPersistService metaDataPersistService, Collection<String> schemaNames) {
        return schemaNames.stream().collect(Collectors.toMap(each -> each, each -> metaDataPersistService.getSchemaRuleService().load(each), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    private TransactionContexts createTransactionContexts(MetaDataContexts metaDataContexts) {
        HashMap<String, ShardingSphereTransactionManagerEngine> engines = new HashMap<String, ShardingSphereTransactionManagerEngine>(metaDataContexts.getAllSchemaNames().size(), 1.0f);
        TransactionRule transactionRule = this.getTransactionRule(metaDataContexts);
        for (String each : metaDataContexts.getAllSchemaNames()) {
            ShardingSphereTransactionManagerEngine engine = new ShardingSphereTransactionManagerEngine();
            ShardingSphereResource resource = metaDataContexts.getMetaData(each).getResource();
            engine.init(resource.getDatabaseType(), resource.getDataSources(), transactionRule);
            engines.put(each, engine);
        }
        return new TransactionContexts(engines);
    }

    private Map<String, Map<String, DataSource>> getChangedDataSources(Map<String, Map<String, DataSourceConfiguration>> changedDataSourceConfigurations) {
        LinkedHashMap<String, Map<String, DataSource>> result = new LinkedHashMap<String, Map<String, DataSource>>(changedDataSourceConfigurations.size(), 1.0f);
        for (Map.Entry<String, Map<String, DataSourceConfiguration>> entry : changedDataSourceConfigurations.entrySet()) {
            result.put(entry.getKey(), DataSourceConverter.getDataSourceMap(entry.getValue()));
        }
        return result;
    }

    private TransactionRule getTransactionRule(MetaDataContexts metaDataContexts) {
        Optional<TransactionRule> transactionRule = metaDataContexts.getGlobalRuleMetaData().getRules().stream().filter(each -> each instanceof TransactionRule).map(each -> (TransactionRule)each).findFirst();
        return transactionRule.orElseGet(() -> new TransactionRule(new DefaultTransactionRuleConfigurationBuilder().build()));
    }

    private void disableDataSources() {
        this.metaDataContexts.getMetaDataMap().forEach((key, value) -> value.getRuleMetaData().getRules().stream().filter(each -> each instanceof StatusContainedRule).forEach(each -> this.disableDataSources((String)key, (StatusContainedRule)each)));
    }

    private void disableDataSources(String schemaName, StatusContainedRule rule) {
        Collection<String> disabledDataSources = this.registryCenter.getStorageNodeStatusService().loadStorageNodes(schemaName, StorageNodeStatus.DISABLE);
        disabledDataSources.stream().map(this::getDataSourceName).forEach(each -> rule.updateStatus((DataSourceStatusChangedEvent)new DataSourceNameDisabledEvent(each, true)));
    }

    private String getDataSourceName(String disabledDataSource) {
        return new QualifiedSchema(disabledDataSource).getDataSourceName();
    }

    private void persistMetaData(Map<String, ShardingSphereSchema> schemas) {
        schemas.forEach((key, value) -> this.metaDataPersistService.getSchemaMetaDataService().persist(key, value));
    }

    public String getType() {
        return "Cluster";
    }

    static {
        ShardingSphereServiceLoader.register(ClusterPersistRepository.class);
    }
}

