/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.service;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.ClusterInstance;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.service.LockAck;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.service.LockNode;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.ComputeNodeStatus;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.node.ComputeStatusNode;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class LockRegistryService {
    private static final int CHECK_ACK_INTERVAL_SECONDS = 1;
    private final String instanceId = ClusterInstance.getInstance().getId();
    private final ClusterPersistRepository repository;

    public LockRegistryService(ClusterPersistRepository repository) {
        this.repository = repository;
        this.initLockNode();
    }

    private void initLockNode() {
        this.repository.persist(LockNode.getLockRootNodePath(), "");
        this.repository.persist(LockNode.getLockedAckRootNodePah(), "");
    }

    public boolean tryLock(String lockName, long timeoutMilliseconds) {
        return this.repository.tryLock(LockNode.getLockNodePath(lockName), timeoutMilliseconds, TimeUnit.MILLISECONDS);
    }

    public void releaseLock(String lockName) {
        this.repository.releaseLock(LockNode.getLockNodePath(lockName));
    }

    public void ackLock(String lockName) {
        this.repository.persistEphemeral(LockNode.getLockedAckNodePath(Joiner.on((String)"-").join((Object)this.instanceId, (Object)lockName, new Object[0])), LockAck.LOCKED.name());
    }

    public void ackUnlock(String lockName) {
        this.repository.persistEphemeral(LockNode.getLockedAckNodePath(Joiner.on((String)"-").join((Object)this.instanceId, (Object)lockName, new Object[0])), LockAck.UNLOCKED.name());
    }

    public void deleteLockAck(String lockName) {
        this.repository.delete(LockNode.getLockedAckNodePath(Joiner.on((String)"-").join((Object)this.instanceId, (Object)lockName, new Object[0])));
    }

    public boolean checkLockAck(String lockName, long timeoutMilliseconds) {
        boolean result = this.checkAck(lockName, LockAck.LOCKED.name(), timeoutMilliseconds);
        if (!result) {
            this.releaseLock(lockName);
        }
        return result;
    }

    private boolean checkAck(String lockName, String ackValue, long timeoutMilliseconds) {
        long start;
        List onlineInstanceIds = this.repository.getChildrenKeys(ComputeStatusNode.getStatusPath(ComputeNodeStatus.ONLINE));
        for (long checkMilliseconds = timeoutMilliseconds; checkMilliseconds > 0L; checkMilliseconds -= System.currentTimeMillis() - start) {
            start = System.currentTimeMillis();
            if (this.check(onlineInstanceIds, lockName, ackValue)) {
                return true;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean check(Collection<String> instanceIds, String lockName, String ackValue) {
        return instanceIds.stream().allMatch(each -> ackValue.equalsIgnoreCase(this.loadLockAck((String)each, lockName)));
    }

    private String loadLockAck(String instanceId, String lockName) {
        return Strings.nullToEmpty((String)this.repository.get(LockNode.getLockedAckNodePath(Joiner.on((String)"-").join((Object)instanceId, (Object)lockName, new Object[0]))));
    }
}

