/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.cache.subscriber;

import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.yaml.config.pojo.YamlRootConfiguration;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.cache.RegistryCacheManager;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.cache.event.StartScalingEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.ClusterSwitchConfigurationEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.RuleConfigurationCachedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.ScalingTaskFinishedEvent;
import org.apache.shardingsphere.mode.metadata.persist.node.SchemaMetaDataNode;
import org.apache.shardingsphere.mode.metadata.persist.service.impl.DataSourcePersistService;
import org.apache.shardingsphere.mode.metadata.persist.service.impl.SchemaRulePersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScalingRegistrySubscriber {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ScalingRegistrySubscriber.class);
    private final ClusterPersistRepository repository;
    private final SchemaRulePersistService persistService;
    private final DataSourcePersistService dataSourcePersistService;
    private final RegistryCacheManager registryCacheManager;

    public ScalingRegistrySubscriber(ClusterPersistRepository repository) {
        this.repository = repository;
        this.persistService = new SchemaRulePersistService((PersistRepository)repository);
        this.dataSourcePersistService = new DataSourcePersistService((PersistRepository)repository);
        this.registryCacheManager = new RegistryCacheManager(repository);
        ShardingSphereEventBus.getInstance().register((Object)this);
    }

    @Subscribe
    public void ruleConfigurationCached(RuleConfigurationCachedEvent event) {
        String sourceDataSource = this.repository.get(SchemaMetaDataNode.getMetaDataDataSourcePath((String)event.getSchemaName()));
        String sourceRule = this.repository.get(SchemaMetaDataNode.getRulePath((String)event.getSchemaName()));
        String targetRule = this.registryCacheManager.loadCache(SchemaMetaDataNode.getRulePath((String)event.getSchemaName()), event.getCacheId());
        String ruleCacheId = event.getCacheId();
        StartScalingEvent startScalingEvent = new StartScalingEvent(event.getSchemaName(), sourceDataSource, sourceRule, targetRule, ruleCacheId);
        ShardingSphereEventBus.getInstance().post((Object)startScalingEvent);
    }

    @Subscribe
    public void scalingTaskFinished(ScalingTaskFinishedEvent event) {
        log.info("scalingTaskFinished, event={}", (Object)event);
        YamlRootConfiguration yamlRootConfiguration = event.getTargetRootConfig();
        Map dataSourceConfigs = yamlRootConfiguration.getDataSources().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new YamlDataSourceConfigurationSwapper().swapToDataSourceConfiguration((Map)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        Collection ruleConfigs = new YamlRuleConfigurationSwapperEngine().swapToRuleConfigurations(yamlRootConfiguration.getRules());
        ClusterSwitchConfigurationEvent switchEvent = new ClusterSwitchConfigurationEvent(event.getTargetSchemaName(), dataSourceConfigs, ruleConfigs);
        ShardingSphereEventBus.getInstance().post((Object)switchEvent);
        String ruleCacheId = event.getRuleCacheId();
        if (null != ruleCacheId) {
            log.info("start to delete cache, ruleCacheId={}", (Object)ruleCacheId);
            this.registryCacheManager.deleteCache(SchemaMetaDataNode.getRulePath((String)event.getTargetSchemaName()), ruleCacheId);
        }
    }

    @Subscribe
    public void clusterSwitchConfiguration(ClusterSwitchConfigurationEvent event) {
        String schemaName = event.getTargetSchemaName();
        log.info("clusterSwitchConfiguration, schemaName={}", (Object)schemaName);
        this.dataSourcePersistService.persist(schemaName, event.getTargetDataSourceConfigs());
        this.persistService.persist(schemaName, event.getTargetRuleConfigs());
    }
}

