/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.process.subscriber;

import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessConstants;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessContext;
import org.apache.shardingsphere.infra.executor.sql.process.model.ExecuteProcessUnit;
import org.apache.shardingsphere.infra.executor.sql.process.model.yaml.YamlExecuteProcessContext;
import org.apache.shardingsphere.infra.executor.sql.process.model.yaml.YamlExecuteProcessUnit;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.process.event.ExecuteProcessReportEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.process.event.ExecuteProcessSummaryReportEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.process.event.ExecuteProcessUnitReportEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.process.event.ShowProcessListRequestEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.process.event.ShowProcessListResponseEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.process.node.ProcessNode;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class ProcessRegistrySubscriber {
    private final ClusterPersistRepository repository;

    public ProcessRegistrySubscriber(ClusterPersistRepository repository) {
        this.repository = repository;
        ShardingSphereEventBus.getInstance().register((Object)this);
    }

    @Subscribe
    public void loadShowProcessListData(ShowProcessListRequestEvent event) {
        List childrenKeys = this.repository.getChildrenKeys(ProcessNode.getExecutionNodesPath());
        Collection processListData = childrenKeys.stream().map(key -> this.repository.get(ProcessNode.getExecutionPath(key))).collect(Collectors.toList());
        ShardingSphereEventBus.getInstance().post((Object)new ShowProcessListResponseEvent(processListData));
    }

    @Subscribe
    public void reportExecuteProcessSummary(ExecuteProcessSummaryReportEvent event) {
        ExecuteProcessContext executeProcessContext = event.getExecuteProcessContext();
        this.repository.persist(ProcessNode.getExecutionPath(executeProcessContext.getExecutionID()), YamlEngine.marshal((Object)new YamlExecuteProcessContext(executeProcessContext)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void reportExecuteProcessUnit(ExecuteProcessUnitReportEvent event) {
        String executionID;
        String string = executionID = event.getExecutionID();
        synchronized (string) {
            String executionPath = ProcessNode.getExecutionPath(executionID);
            YamlExecuteProcessContext yamlExecuteProcessContext = (YamlExecuteProcessContext)YamlEngine.unmarshal((String)this.repository.get(executionPath), YamlExecuteProcessContext.class);
            ExecuteProcessUnit executeProcessUnit = event.getExecuteProcessUnit();
            for (YamlExecuteProcessUnit unit : yamlExecuteProcessContext.getUnitStatuses()) {
                if (!unit.getUnitID().equals(executeProcessUnit.getUnitID())) continue;
                unit.setStatus(executeProcessUnit.getStatus());
            }
            this.repository.persist(executionPath, YamlEngine.marshal((Object)yamlExecuteProcessContext));
        }
    }

    @Subscribe
    public void reportExecuteProcess(ExecuteProcessReportEvent event) {
        String executionPath = ProcessNode.getExecutionPath(event.getExecutionID());
        YamlExecuteProcessContext yamlExecuteProcessContext = (YamlExecuteProcessContext)YamlEngine.unmarshal((String)this.repository.get(executionPath), YamlExecuteProcessContext.class);
        for (YamlExecuteProcessUnit unit : yamlExecuteProcessContext.getUnitStatuses()) {
            if (unit.getStatus() == ExecuteProcessConstants.EXECUTE_STATUS_DONE) continue;
            return;
        }
        this.repository.delete(executionPath);
    }
}

