/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.subscriber;

import com.google.common.eventbus.Subscribe;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.ClusterInstance;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.ComputeNodeStatus;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.ComputeNodeStatusChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.node.ComputeStatusNode;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class ComputeNodeStatusSubscriber {
    private final ClusterPersistRepository repository;

    public ComputeNodeStatusSubscriber(ClusterPersistRepository repository) {
        this.repository = repository;
        ShardingSphereEventBus.getInstance().register((Object)this);
    }

    @Subscribe
    public void update(ComputeNodeStatusChangedEvent event) {
        String computeNodePath = ComputeStatusNode.getStatusPath(ComputeNodeStatus.CIRCUIT_BREAKER, ClusterInstance.getInstance().getInstanceId(event.getIp(), event.getPort()));
        if (event.getStatus() == ComputeNodeStatus.CIRCUIT_BREAKER) {
            this.repository.persist(computeNodePath, "");
        } else {
            this.repository.delete(computeNodePath);
        }
    }
}

