/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.rule.builder;

import java.util.Collection;
import java.util.HashMap;
import javax.sql.DataSource;
import org.apache.shardingsphere.dbdiscovery.api.config.DatabaseDiscoveryRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.api.config.rule.DatabaseDiscoveryDataSourceRuleConfiguration;
import org.apache.shardingsphere.dbdiscovery.rule.DatabaseDiscoveryRule;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.builder.schema.SchemaRuleBuilder;
import org.apache.shardingsphere.infra.rule.builder.schema.SchemaRulesBuilderMaterials;

public final class DatabaseDiscoveryRuleBuilder
implements SchemaRuleBuilder<DatabaseDiscoveryRuleConfiguration> {
    public DatabaseDiscoveryRule build(SchemaRulesBuilderMaterials materials, DatabaseDiscoveryRuleConfiguration config, Collection<ShardingSphereRule> builtRules) {
        HashMap<String, DataSource> realDataSourceMap = new HashMap<String, DataSource>();
        for (DatabaseDiscoveryDataSourceRuleConfiguration each : config.getDataSources()) {
            for (String datasourceName : each.getDataSourceNames()) {
                realDataSourceMap.put(datasourceName, (DataSource)materials.getDataSourceMap().get(datasourceName));
            }
        }
        return new DatabaseDiscoveryRule(config, materials.getSchemaName(), realDataSourceMap);
    }

    public int getOrder() {
        return 30;
    }

    public Class<DatabaseDiscoveryRuleConfiguration> getTypeClass() {
        return DatabaseDiscoveryRuleConfiguration.class;
    }
}

