/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.parameter;

import java.util.Collection;
import java.util.LinkedList;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.QueryWithCipherColumnAware;
import org.apache.shardingsphere.encrypt.rewrite.parameter.impl.EncryptAssignmentParameterRewriter;
import org.apache.shardingsphere.encrypt.rewrite.parameter.impl.EncryptInsertOnDuplicateKeyUpdateValueParameterRewriter;
import org.apache.shardingsphere.encrypt.rewrite.parameter.impl.EncryptInsertValueParameterRewriter;
import org.apache.shardingsphere.encrypt.rewrite.parameter.impl.EncryptPredicateParameterRewriter;
import org.apache.shardingsphere.encrypt.rule.EncryptRule;
import org.apache.shardingsphere.encrypt.rule.aware.EncryptRuleAware;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriter;
import org.apache.shardingsphere.infra.rewrite.parameter.rewriter.ParameterRewriterBuilder;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.SchemaMetaDataAware;

public final class EncryptParameterRewriterBuilder
implements ParameterRewriterBuilder {
    private final EncryptRule encryptRule;
    private final boolean queryWithCipherColumn;

    public Collection<ParameterRewriter> getParameterRewriters(ShardingSphereSchema schema) {
        Collection<ParameterRewriter> result = this.getParameterRewriters();
        for (ParameterRewriter each : result) {
            this.setUpParameterRewriters(each, schema);
        }
        return result;
    }

    private Collection<ParameterRewriter> getParameterRewriters() {
        LinkedList<ParameterRewriter> result = new LinkedList<ParameterRewriter>();
        result.add(new EncryptAssignmentParameterRewriter());
        result.add(new EncryptPredicateParameterRewriter());
        result.add(new EncryptInsertValueParameterRewriter());
        result.add(new EncryptInsertOnDuplicateKeyUpdateValueParameterRewriter());
        return result;
    }

    private void setUpParameterRewriters(ParameterRewriter parameterRewriter, ShardingSphereSchema schema) {
        if (parameterRewriter instanceof SchemaMetaDataAware) {
            ((SchemaMetaDataAware)parameterRewriter).setSchema(schema);
        }
        if (parameterRewriter instanceof EncryptRuleAware) {
            ((EncryptRuleAware)parameterRewriter).setEncryptRule(this.encryptRule);
        }
        if (parameterRewriter instanceof QueryWithCipherColumnAware) {
            ((QueryWithCipherColumnAware)parameterRewriter).setQueryWithCipherColumn(this.queryWithCipherColumn);
        }
    }

    @Generated
    public EncryptParameterRewriterBuilder(EncryptRule encryptRule, boolean queryWithCipherColumn) {
        this.encryptRule = encryptRule;
        this.queryWithCipherColumn = queryWithCipherColumn;
    }
}

