/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.BaseEncryptSQLTokenGenerator;
import org.apache.shardingsphere.encrypt.rewrite.token.pojo.EncryptAlterTableToken;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.ddl.AlterTableStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.Substitutable;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.RemoveToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.AddColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.DropColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.alter.ModifyColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.AlterTableStatement;

public final class EncryptAlterTableTokenGenerator
extends BaseEncryptSQLTokenGenerator
implements CollectionSQLTokenGenerator<AlterTableStatementContext> {
    @Override
    protected boolean isGenerateSQLTokenForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof AlterTableStatementContext;
    }

    public Collection<SQLToken> generateSQLTokens(AlterTableStatementContext alterTableStatementContext) {
        String tableName = ((AlterTableStatement)alterTableStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        LinkedList<SQLToken> result = new LinkedList<SQLToken>(this.getAddColumnTokens(tableName, ((AlterTableStatement)alterTableStatementContext.getSqlStatement()).getAddColumnDefinitions()));
        result.addAll(this.getModifyColumnTokens(tableName, ((AlterTableStatement)alterTableStatementContext.getSqlStatement()).getModifyColumnDefinitions()));
        Collection<SQLToken> dropCollection = this.getDropColumnTokens(tableName, ((AlterTableStatement)alterTableStatementContext.getSqlStatement()).getDropColumnDefinitions());
        String databaseName = alterTableStatementContext.getDatabaseType().getName();
        if ("SQLServer".equals(databaseName)) {
            result.addAll(this.mergeDropColumnStatement(dropCollection, "", ""));
        } else if ("Oracle".equals(databaseName)) {
            result.addAll(this.mergeDropColumnStatement(dropCollection, "(", ")"));
        } else {
            result.addAll(dropCollection);
        }
        return result;
    }

    private Collection<SQLToken> mergeDropColumnStatement(Collection<SQLToken> dropCollection, String leftJoiner, String rightJoiner) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        ArrayList<String> dropColumnList = new ArrayList<String>();
        int lastStartIndex = -1;
        for (int i = 0; i < dropCollection.size(); ++i) {
            SQLToken token = (SQLToken)((List)dropCollection).get(i);
            if (token instanceof RemoveToken) {
                if (i != 0) {
                    result.add((SQLToken)new RemoveToken(lastStartIndex, ((RemoveToken)token).getStopIndex()));
                } else {
                    result.add(token);
                }
            } else {
                EncryptAlterTableToken encryptAlterTableToken = (EncryptAlterTableToken)token;
                dropColumnList.add(encryptAlterTableToken.getColumnName());
                if (i == dropCollection.size() - 1) {
                    result.add(new EncryptAlterTableToken(token.getStartIndex(), encryptAlterTableToken.getStopIndex(), leftJoiner + String.join((CharSequence)",", dropColumnList) + rightJoiner, "DROP COLUMN"));
                }
            }
            lastStartIndex = ((Substitutable)token).getStartIndex();
        }
        return result;
    }

    private Collection<SQLToken> getAddColumnTokens(String tableName, Collection<AddColumnDefinitionSegment> columnDefinitionSegments) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (AddColumnDefinitionSegment each : columnDefinitionSegments) {
            result.addAll(this.getAddColumnTokens(tableName, each));
        }
        return result;
    }

    private Collection<SQLToken> getAddColumnTokens(String tableName, AddColumnDefinitionSegment addColumnDefinitionSegment) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (ColumnDefinitionSegment each : addColumnDefinitionSegment.getColumnDefinitions()) {
            String columnName = each.getColumnName().getIdentifier().getValue();
            Optional<EncryptAlgorithm> encryptor = this.getEncryptRule().findEncryptor(tableName, columnName);
            if (!encryptor.isPresent()) continue;
            result.addAll(this.getAddColumnTokens(tableName, columnName, addColumnDefinitionSegment, each));
        }
        return result;
    }

    private Collection<SQLToken> getAddColumnTokens(String tableName, String columnName, AddColumnDefinitionSegment addColumnDefinitionSegment, ColumnDefinitionSegment columnDefinitionSegment) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        result.add((SQLToken)new RemoveToken(addColumnDefinitionSegment.getStartIndex() - 1, columnDefinitionSegment.getStopIndex() + 1));
        result.add(this.getCipherColumn(tableName, columnName, columnDefinitionSegment));
        this.getAssistedQueryColumn(tableName, columnName, columnDefinitionSegment).ifPresent(result::add);
        this.getPlainColumn(tableName, columnName, columnDefinitionSegment).ifPresent(result::add);
        return result;
    }

    private Collection<SQLToken> getModifyColumnTokens(String tableName, Collection<ModifyColumnDefinitionSegment> columnDefinitionSegments) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (ModifyColumnDefinitionSegment each : columnDefinitionSegments) {
            ColumnDefinitionSegment segment = each.getColumnDefinition();
            String columnName = segment.getColumnName().getIdentifier().getValue();
            Optional<EncryptAlgorithm> encryptor = this.getEncryptRule().findEncryptor(tableName, columnName);
            Optional<EncryptAlgorithm> encryptorPrevious = this.getEncryptRule().findEncryptor(tableName, Optional.ofNullable(each.getPreviousColumnDefinition()).map(columnDefinitionSegment -> columnDefinitionSegment.getColumnName().getIdentifier().getValue()).orElse(""));
            if (!encryptor.isPresent() && !encryptorPrevious.isPresent()) continue;
            result.addAll(this.getModifyColumnTokens(tableName, columnName, each, segment));
        }
        return result;
    }

    private Collection<SQLToken> getModifyColumnTokens(String tableName, String columnName, ModifyColumnDefinitionSegment modifyColumnDefinitionSegment, ColumnDefinitionSegment columnDefinitionSegment) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        result.add((SQLToken)new RemoveToken(modifyColumnDefinitionSegment.getStartIndex() - 1, modifyColumnDefinitionSegment.getStopIndex()));
        result.add(this.getCipherColumn(tableName, columnName, modifyColumnDefinitionSegment, columnDefinitionSegment));
        this.getAssistedQueryColumn(tableName, columnName, modifyColumnDefinitionSegment, columnDefinitionSegment).ifPresent(result::add);
        this.getPlainColumn(tableName, columnName, modifyColumnDefinitionSegment, columnDefinitionSegment).ifPresent(result::add);
        return result;
    }

    private Collection<SQLToken> getDropColumnTokens(String tableName, Collection<DropColumnDefinitionSegment> columnDefinitionSegments) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (DropColumnDefinitionSegment each : columnDefinitionSegments) {
            result.addAll(this.getDropColumnTokens(tableName, each));
        }
        return result;
    }

    private Collection<SQLToken> getDropColumnTokens(String tableName, DropColumnDefinitionSegment dropColumnDefinitionSegment) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        for (ColumnSegment each : dropColumnDefinitionSegment.getColumns()) {
            String columnName = each.getQualifiedName();
            Optional<EncryptAlgorithm> encryptor = this.getEncryptRule().findEncryptor(tableName, columnName);
            if (encryptor.isPresent()) {
                result.addAll(this.getDropColumnTokens(tableName, columnName, each, dropColumnDefinitionSegment));
                continue;
            }
            result.add((SQLToken)new RemoveToken(dropColumnDefinitionSegment.getStartIndex() - 1, each.getStopIndex()));
            result.add(new EncryptAlterTableToken(each.getStopIndex() + 1, each.getStopIndex(), columnName, "DROP COLUMN"));
        }
        return result;
    }

    private Collection<SQLToken> getDropColumnTokens(String tableName, String columnName, ColumnSegment columnSegment, DropColumnDefinitionSegment dropColumnDefinitionSegment) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        result.add((SQLToken)new RemoveToken(dropColumnDefinitionSegment.getStartIndex() - 1, columnSegment.getStopIndex()));
        result.add(this.getCipherColumn(tableName, columnName, columnSegment));
        this.getAssistedQueryColumn(tableName, columnName, columnSegment).ifPresent(result::add);
        this.getPlainColumn(tableName, columnName, columnSegment).ifPresent(result::add);
        return result;
    }

    private EncryptAlterTableToken getCipherColumn(String tableName, String columnName, ColumnDefinitionSegment columnDefinitionSegment) {
        String cipherColumn = this.getEncryptRule().getCipherColumn(tableName, columnName);
        return new EncryptAlterTableToken(columnDefinitionSegment.getStopIndex() + 1, columnDefinitionSegment.getStartIndex() + columnName.length(), cipherColumn, "ADD COLUMN");
    }

    private EncryptAlterTableToken getCipherColumn(String tableName, String columnName, ModifyColumnDefinitionSegment modifyColumnDefinitionSegment, ColumnDefinitionSegment columnDefinitionSegment) {
        String previousColumnName = Optional.ofNullable(modifyColumnDefinitionSegment.getPreviousColumnDefinition()).map(segment -> segment.getColumnName().getIdentifier().getValue()).orElse("");
        String cipherColumnPrevious = !previousColumnName.isEmpty() ? this.getEncryptRule().getCipherColumn(tableName, previousColumnName) : "";
        String encryptColumnName = cipherColumnPrevious.isEmpty() ? this.getEncryptRule().getCipherColumn(tableName, columnName) : columnDefinitionSegment.getColumnName().getQualifiedName() + "_cipher";
        String encryptCommand = cipherColumnPrevious.isEmpty() ? "MODIFY COLUMN" : "CHANGE COLUMN " + cipherColumnPrevious;
        return new EncryptAlterTableToken(modifyColumnDefinitionSegment.getStopIndex() + 1, columnDefinitionSegment.getDataType().getStartIndex() - 1, encryptColumnName, encryptCommand);
    }

    private EncryptAlterTableToken getCipherColumn(String tableName, String columnName, ColumnSegment columnSegment) {
        String cipherColumn = this.getEncryptRule().getCipherColumn(tableName, columnName);
        return new EncryptAlterTableToken(columnSegment.getStopIndex() + 1, columnSegment.getStopIndex(), cipherColumn, "DROP COLUMN");
    }

    private Optional<EncryptAlterTableToken> getAssistedQueryColumn(String tableName, String columnName, ColumnDefinitionSegment columnDefinitionSegment) {
        Optional<String> assistedQueryColumn = this.getEncryptRule().findAssistedQueryColumn(tableName, columnName);
        return assistedQueryColumn.map(optional -> new EncryptAlterTableToken(columnDefinitionSegment.getStopIndex() + 1, columnDefinitionSegment.getStartIndex() + columnName.length(), (String)optional, ", ADD COLUMN"));
    }

    private Optional<EncryptAlterTableToken> getAssistedQueryColumn(String tableName, String columnName, ModifyColumnDefinitionSegment modifyColumnDefinitionSegment, ColumnDefinitionSegment columnDefinitionSegment) {
        String previousColumnName = Optional.ofNullable(modifyColumnDefinitionSegment.getPreviousColumnDefinition()).map(segment -> segment.getColumnName().getIdentifier().getValue()).orElse("");
        Optional<String> assistedQueryColumnPrevious = !previousColumnName.isEmpty() ? this.getEncryptRule().findAssistedQueryColumn(tableName, previousColumnName) : Optional.of("");
        String encryptColumnName = assistedQueryColumnPrevious.orElse("").isEmpty() ? this.getEncryptRule().findAssistedQueryColumn(tableName, columnName).orElse("") : columnDefinitionSegment.getColumnName().getQualifiedName() + "_assisted";
        String encryptCommand = assistedQueryColumnPrevious.orElse("").isEmpty() ? ", MODIFY COLUMN" : ", CHANGE COLUMN " + assistedQueryColumnPrevious.get();
        return Optional.of(new EncryptAlterTableToken(modifyColumnDefinitionSegment.getStopIndex() + 1, columnDefinitionSegment.getDataType().getStartIndex() - 1, encryptColumnName, encryptCommand));
    }

    private Optional<EncryptAlterTableToken> getAssistedQueryColumn(String tableName, String columnName, ColumnSegment columnSegment) {
        Optional<String> assistedQueryColumn = this.getEncryptRule().findAssistedQueryColumn(tableName, columnName);
        return assistedQueryColumn.map(optional -> new EncryptAlterTableToken(columnSegment.getStopIndex() + 1, columnSegment.getStopIndex(), (String)optional, ", DROP COLUMN"));
    }

    private Optional<EncryptAlterTableToken> getPlainColumn(String tableName, String columnName, ColumnDefinitionSegment columnDefinitionSegment) {
        Optional<String> plainColumn = this.getEncryptRule().findPlainColumn(tableName, columnName);
        return plainColumn.map(optional -> new EncryptAlterTableToken(columnDefinitionSegment.getStopIndex() + 1, columnDefinitionSegment.getStartIndex() + columnName.length(), (String)optional, ", ADD COLUMN"));
    }

    private Optional<EncryptAlterTableToken> getPlainColumn(String tableName, String columnName, ModifyColumnDefinitionSegment modifyColumnDefinitionSegment, ColumnDefinitionSegment columnDefinitionSegment) {
        String previousColumnName = Optional.ofNullable(modifyColumnDefinitionSegment.getPreviousColumnDefinition()).map(segment -> segment.getColumnName().getIdentifier().getValue()).orElse("");
        Optional<String> plainColumnPrevious = !previousColumnName.isEmpty() ? this.getEncryptRule().findPlainColumn(tableName, previousColumnName) : Optional.of("");
        String encryptColumnName = plainColumnPrevious.orElse("").isEmpty() ? this.getEncryptRule().findPlainColumn(tableName, columnName).orElse("") : columnDefinitionSegment.getColumnName().getQualifiedName() + "_plain";
        String encryptCommand = plainColumnPrevious.orElse("").isEmpty() ? ", MODIFY COLUMN" : ", CHANGE COLUMN " + plainColumnPrevious.get();
        return Optional.of(new EncryptAlterTableToken(modifyColumnDefinitionSegment.getStopIndex() + 1, columnDefinitionSegment.getDataType().getStartIndex() - 1, encryptColumnName, encryptCommand));
    }

    private Optional<EncryptAlterTableToken> getPlainColumn(String tableName, String columnName, ColumnSegment columnSegment) {
        Optional<String> plainColumn = this.getEncryptRule().findPlainColumn(tableName, columnName);
        return plainColumn.map(optional -> new EncryptAlterTableToken(columnSegment.getStopIndex() + 1, columnSegment.getStopIndex(), (String)optional, ", DROP COLUMN"));
    }
}

