/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.BaseEncryptSQLTokenGenerator;
import org.apache.shardingsphere.encrypt.spi.EncryptAlgorithm;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.ddl.CreateTableStatementContext;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.SQLToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.RemoveToken;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.ddl.column.ColumnDefinitionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.ddl.CreateTableStatement;

public final class EncryptCreateTableTokenGenerator
extends BaseEncryptSQLTokenGenerator
implements CollectionSQLTokenGenerator<CreateTableStatementContext> {
    @Override
    protected boolean isGenerateSQLTokenForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof CreateTableStatementContext && !((CreateTableStatement)((CreateTableStatementContext)sqlStatementContext).getSqlStatement()).getColumnDefinitions().isEmpty();
    }

    public Collection<SQLToken> generateSQLTokens(CreateTableStatementContext createTableStatementContext) {
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        String tableName = ((CreateTableStatement)createTableStatementContext.getSqlStatement()).getTable().getTableName().getIdentifier().getValue();
        ArrayList<ColumnDefinitionSegment> columns = new ArrayList<ColumnDefinitionSegment>(((CreateTableStatement)createTableStatementContext.getSqlStatement()).getColumnDefinitions());
        for (int index = 0; index < columns.size(); ++index) {
            ColumnDefinitionSegment each = (ColumnDefinitionSegment)columns.get(index);
            String columnName = each.getColumnName().getIdentifier().getValue();
            Optional<EncryptAlgorithm> encryptor = this.getEncryptRule().findEncryptor(tableName, columnName);
            if (!encryptor.isPresent()) continue;
            result.addAll(this.getColumnTokens(tableName, columnName, each, columns, index));
        }
        return result;
    }

    private Collection<SQLToken> getColumnTokens(String tableName, String columnName, ColumnDefinitionSegment column, List<ColumnDefinitionSegment> columns, int index) {
        boolean lastColumn = columns.size() - 1 == index;
        int columnStopIndex = lastColumn ? column.getStopIndex() : columns.get(index + 1).getStartIndex() - 1;
        LinkedList<SQLToken> result = new LinkedList<SQLToken>();
        result.add((SQLToken)new RemoveToken(column.getStartIndex(), columnStopIndex));
        result.add((SQLToken)this.getCipherColumnToken(tableName, columnName, column, columnStopIndex));
        this.getAssistedQueryColumnToken(tableName, columnName, column, columnStopIndex, lastColumn).ifPresent(result::add);
        this.getPlainColumnToken(tableName, columnName, column, columnStopIndex, lastColumn).ifPresent(result::add);
        return result;
    }

    private SubstitutableColumnNameToken getCipherColumnToken(String tableName, String columnName, ColumnDefinitionSegment column, int stopIndex) {
        return new SubstitutableColumnNameToken(stopIndex + 1, column.getColumnName().getStopIndex(), this.getColumnProjections(this.getEncryptRule().getCipherColumn(tableName, columnName)));
    }

    private Optional<SubstitutableColumnNameToken> getAssistedQueryColumnToken(String tableName, String columnName, ColumnDefinitionSegment column, int stopIndex, boolean lastColumn) {
        Optional<String> assistedQueryColumn = this.getEncryptRule().findAssistedQueryColumn(tableName, columnName);
        return assistedQueryColumn.map(optional -> new SubstitutableColumnNameToken(stopIndex + 1, column.getColumnName().getStopIndex(), this.getColumnProjections((String)optional), lastColumn));
    }

    private Optional<SubstitutableColumnNameToken> getPlainColumnToken(String tableName, String columnName, ColumnDefinitionSegment column, int stopIndex, boolean lastColumn) {
        Optional<String> plainColumn = this.getEncryptRule().findPlainColumn(tableName, columnName);
        return plainColumn.map(optional -> new SubstitutableColumnNameToken(stopIndex + 1, column.getColumnName().getStopIndex(), this.getColumnProjections((String)optional), lastColumn));
    }

    private Collection<ColumnProjection> getColumnProjections(String columnName) {
        return Collections.singletonList(new ColumnProjection(null, columnName, null));
    }
}

