/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.rewrite.token.generator.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.encrypt.rewrite.aware.QueryWithCipherColumnAware;
import org.apache.shardingsphere.encrypt.rewrite.token.generator.BaseEncryptSQLTokenGenerator;
import org.apache.shardingsphere.encrypt.rule.EncryptTable;
import org.apache.shardingsphere.infra.binder.segment.select.projection.impl.ColumnProjection;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.InsertStatementContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementContext;
import org.apache.shardingsphere.infra.binder.type.WhereAvailable;
import org.apache.shardingsphere.infra.metadata.schema.ShardingSphereSchema;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.CollectionSQLTokenGenerator;
import org.apache.shardingsphere.infra.rewrite.sql.token.generator.aware.SchemaMetaDataAware;
import org.apache.shardingsphere.infra.rewrite.sql.token.pojo.generic.SubstitutableColumnNameToken;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.AndPredicate;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.predicate.WhereSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.util.ColumnExtractor;
import org.apache.shardingsphere.sql.parser.sql.common.util.ExpressionExtractUtil;
import org.apache.shardingsphere.sql.parser.sql.common.util.WhereExtractUtil;

public final class EncryptPredicateColumnTokenGenerator
extends BaseEncryptSQLTokenGenerator
implements CollectionSQLTokenGenerator,
SchemaMetaDataAware,
QueryWithCipherColumnAware {
    private ShardingSphereSchema schema;
    private boolean queryWithCipherColumn;

    @Override
    protected boolean isGenerateSQLTokenForEncrypt(SQLStatementContext sqlStatementContext) {
        return sqlStatementContext instanceof WhereAvailable && ((WhereAvailable)sqlStatementContext).getWhere().isPresent() || sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)sqlStatementContext).isContainsJoinQuery() || sqlStatementContext instanceof InsertStatementContext && null != ((InsertStatementContext)sqlStatementContext).getInsertSelectContext();
    }

    public Collection<SubstitutableColumnNameToken> generateSQLTokens(SQLStatementContext sqlStatementContext) {
        Collection<WhereSegment> whereSegments = this.getWhereSegments(sqlStatementContext);
        Collection andPredicates = whereSegments.stream().flatMap(each -> ExpressionExtractUtil.getAndPredicates((ExpressionSegment)each.getExpr()).stream()).collect(Collectors.toList());
        Map<String, String> columnTableNames = this.getColumnTableNames(sqlStatementContext, andPredicates, whereSegments);
        return andPredicates.stream().flatMap(each -> this.generateSQLTokens(each.getPredicates(), columnTableNames).stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Collection<SubstitutableColumnNameToken> generateSQLTokens(Collection<ExpressionSegment> predicates, Map<String, String> columnTableNames) {
        LinkedList<SubstitutableColumnNameToken> result = new LinkedList<SubstitutableColumnNameToken>();
        for (ExpressionSegment each : predicates) {
            for (ColumnSegment column : ColumnExtractor.extract((ExpressionSegment)each)) {
                Optional<String> plainColumn;
                Optional<EncryptTable> encryptTable = this.findEncryptTable(columnTableNames, column);
                if (!encryptTable.isPresent() || !encryptTable.get().findEncryptorName(column.getIdentifier().getValue()).isPresent()) continue;
                int startIndex = column.getOwner().isPresent() ? ((OwnerSegment)column.getOwner().get()).getStopIndex() + 2 : column.getStartIndex();
                int stopIndex = column.getStopIndex();
                EncryptTable table = encryptTable.get();
                if ((Boolean.FALSE.equals(table.getQueryWithCipherColumn()) || !this.queryWithCipherColumn) && (plainColumn = encryptTable.get().findPlainColumn(column.getIdentifier().getValue())).isPresent()) {
                    result.add(new SubstitutableColumnNameToken(startIndex, stopIndex, this.getColumnProjections(plainColumn.get())));
                    continue;
                }
                Optional<String> assistedQueryColumn = encryptTable.get().findAssistedQueryColumn(column.getIdentifier().getValue());
                SubstitutableColumnNameToken encryptColumnNameToken = assistedQueryColumn.map(columnName -> new SubstitutableColumnNameToken(startIndex, stopIndex, this.getColumnProjections((String)columnName))).orElseGet(() -> new SubstitutableColumnNameToken(startIndex, stopIndex, this.getColumnProjections(((EncryptTable)encryptTable.get()).getCipherColumn(column.getIdentifier().getValue()))));
                result.add(encryptColumnNameToken);
            }
        }
        return result;
    }

    private Collection<WhereSegment> getWhereSegments(SQLStatementContext<?> sqlStatementContext) {
        SelectStatementContext selectStatementContext;
        LinkedList<WhereSegment> result = new LinkedList<WhereSegment>();
        if (sqlStatementContext instanceof WhereAvailable && ((WhereAvailable)sqlStatementContext).getWhere().isPresent()) {
            result.add((WhereSegment)((WhereAvailable)sqlStatementContext).getWhere().get());
        }
        if (sqlStatementContext instanceof SelectStatementContext && ((SelectStatementContext)sqlStatementContext).isContainsJoinQuery()) {
            result.addAll(WhereExtractUtil.getJoinWhereSegments((SelectStatement)((SelectStatement)sqlStatementContext.getSqlStatement())));
        }
        if (sqlStatementContext instanceof InsertStatementContext && null != ((InsertStatementContext)sqlStatementContext).getInsertSelectContext().getSelectStatementContext() && (selectStatementContext = ((InsertStatementContext)sqlStatementContext).getInsertSelectContext().getSelectStatementContext()) instanceof WhereAvailable && selectStatementContext.getWhere().isPresent()) {
            result.add((WhereSegment)selectStatementContext.getWhere().get());
        }
        return result;
    }

    private Map<String, String> getColumnTableNames(SQLStatementContext<?> sqlStatementContext, Collection<AndPredicate> andPredicates, Collection<WhereSegment> whereSegments) {
        Collection columns = andPredicates.stream().flatMap(each -> each.getPredicates().stream()).flatMap(each -> ColumnExtractor.extract((ExpressionSegment)each).stream()).filter(Objects::nonNull).collect(Collectors.toList());
        columns.addAll(whereSegments.stream().flatMap(each -> ColumnExtractor.extract((ExpressionSegment)each.getExpr()).stream()).collect(Collectors.toList()));
        return sqlStatementContext.getTablesContext().findTableName(columns, this.schema);
    }

    private Optional<EncryptTable> findEncryptTable(Map<String, String> columnTableNames, ColumnSegment column) {
        return Optional.ofNullable(columnTableNames.get(column.getQualifiedName())).flatMap(tableName -> this.getEncryptRule().findEncryptTable((String)tableName));
    }

    private Collection<ColumnProjection> getColumnProjections(String columnName) {
        return Collections.singletonList(new ColumnProjection(null, columnName, null));
    }

    @Generated
    public void setSchema(ShardingSphereSchema schema) {
        this.schema = schema;
    }

    @Override
    @Generated
    public void setQueryWithCipherColumn(boolean queryWithCipherColumn) {
        this.queryWithCipherColumn = queryWithCipherColumn;
    }
}

