/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.config.datasource;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.config.datasource.JDBCParameterDecorator;
import org.apache.shardingsphere.infra.config.datasource.JDBCParameterDecoratorHelper;
import org.apache.shardingsphere.infra.config.datasource.creator.DataSourceCreatorFactory;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;

public final class DataSourceConverter {
    public static DataSource getDataSource(DataSourceConfiguration dataSourceConfiguration) {
        return JDBCParameterDecoratorHelper.decorate(DataSourceCreatorFactory.getDataSourceCreator(dataSourceConfiguration.getDataSourceClassName()).createDataSource(dataSourceConfiguration));
    }

    public static DataSourceConfiguration getDataSourceConfiguration(DataSource dataSource) {
        return DataSourceCreatorFactory.getDataSourceCreator(dataSource.getClass().getName()).createDataSourceConfiguration(dataSource);
    }

    public static Map<String, DataSource> getDataSourceMap(Map<String, DataSourceConfiguration> dataSourceConfigMap) {
        return dataSourceConfigMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DataSourceConverter.getDataSource((DataSourceConfiguration)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    public static Map<String, DataSourceConfiguration> getDataSourceConfigurationMap(Map<String, DataSource> dataSourceMap) {
        return dataSourceMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> DataSourceConverter.getDataSourceConfiguration((DataSource)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
    }

    @Generated
    private DataSourceConverter() {
    }

    static {
        ShardingSphereServiceLoader.register(JDBCParameterDecorator.class);
    }
}

