/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.config.datasource.creator.impl;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.shardingsphere.infra.config.datasource.DataSourceConfiguration;
import org.apache.shardingsphere.infra.config.datasource.creator.DataSourceCreator;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;

public abstract class AbstractDataSourceCreator
implements DataSourceCreator {
    protected static final Collection<Class<?>> GENERAL_CLASS_TYPE = Sets.newHashSet((Object[])new Class[]{Boolean.TYPE, Boolean.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, String.class, Collection.class, List.class});
    protected static final Collection<String> SKIPPED_PROPERTY_NAMES = Sets.newHashSet((Object[])new String[]{"loginTimeout"});
    private static final String GETTER_PREFIX = "get";
    private static final String SETTER_PREFIX = "set";

    protected DataSource buildDataSource(String dataSourceClassName) {
        return (DataSource)Class.forName(dataSourceClassName).getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    protected void setField(DataSource dataSource, Method[] methods, String property, Object value) {
        try {
            if (this.isSkip(property)) {
                return;
            }
            Optional<Method> setterMethod = this.findSetterMethod(methods, property);
            if (setterMethod.isPresent() && null != value) {
                this.setDataSourceField(setterMethod.get(), dataSource, value);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new ShardingSphereConfigurationException("Incorrect configuration item: the property %s of the dataSource, because %s", property, ex.getMessage());
        }
    }

    private void setDataSourceField(Method method, DataSource target, Object value) throws InvocationTargetException, IllegalAccessException {
        Class<?> paramType = method.getParameterTypes()[0];
        if (paramType == Integer.TYPE) {
            method.invoke((Object)target, Integer.parseInt(value.toString()));
        } else if (paramType == Long.TYPE) {
            method.invoke((Object)target, Long.parseLong(value.toString()));
        } else if (paramType == Boolean.TYPE || paramType == Boolean.class) {
            method.invoke((Object)target, Boolean.parseBoolean(value.toString()));
        } else if (paramType == String.class) {
            method.invoke((Object)target, value.toString());
        } else {
            method.invoke((Object)target, value);
        }
    }

    private Optional<Method> findSetterMethod(Method[] methods, String property) {
        String setterMethodName = SETTER_PREFIX + CaseFormat.LOWER_CAMEL.to(CaseFormat.UPPER_CAMEL, property);
        return Arrays.stream(methods).filter(each -> each.getName().equals(setterMethodName) && 1 == each.getParameterTypes().length).findFirst();
    }

    protected DataSourceConfiguration buildDataSourceConfig(DataSource dataSource) {
        DataSourceConfiguration result = new DataSourceConfiguration(dataSource.getClass().getName());
        result.getProps().putAll(this.findAllGetterProperties(dataSource));
        return result;
    }

    private Map<String, Object> findAllGetterProperties(Object target) {
        Collection<Method> allGetterMethods = AbstractDataSourceCreator.findAllGetterMethods(target.getClass());
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(allGetterMethods.size(), 1.0f);
        for (Method each : allGetterMethods) {
            String propertyName = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, each.getName().substring(GETTER_PREFIX.length()));
            if (!GENERAL_CLASS_TYPE.contains(each.getReturnType()) || SKIPPED_PROPERTY_NAMES.contains(propertyName)) continue;
            result.put(propertyName, each.invoke(target, new Object[0]));
        }
        return result;
    }

    private static Collection<Method> findAllGetterMethods(Class<?> clazz) {
        Method[] methods = clazz.getMethods();
        HashSet<Method> result = new HashSet<Method>(methods.length);
        for (Method each : methods) {
            if (!each.getName().startsWith(GETTER_PREFIX) || 0 != each.getParameterTypes().length) continue;
            result.add(each);
        }
        return result;
    }

    private boolean isSkip(String property) {
        return SKIPPED_PROPERTY_NAMES.contains(property);
    }
}

