/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.database.type;

import com.google.common.base.Preconditions;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeRegistry;

public final class DatabaseTypeRecognizer {
    public static DatabaseType getDatabaseType(Collection<DataSource> dataSources) {
        DatabaseType result = null;
        for (DataSource each : dataSources) {
            DatabaseType databaseType = DatabaseTypeRecognizer.getDatabaseType(each);
            Preconditions.checkState((null == result || result == databaseType ? 1 : 0) != 0, (String)"Database type inconsistent with '%s' and '%s'", result, (Object)databaseType);
            result = databaseType;
        }
        return null == result ? DatabaseTypeRegistry.getDefaultDatabaseType() : result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DatabaseType getDatabaseType(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            DatabaseType databaseType = DatabaseTypeRegistry.getDatabaseTypeByURL(connection.getMetaData().getURL());
            return databaseType;
        }
        catch (SQLException ex) {
            return null;
        }
    }

    @Generated
    private DatabaseTypeRecognizer() {
    }
}

